/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.DataPortPanel;
import com.bwanms.rb.mo.RbBsEthIfConfigEntry;
import com.bwanms.rb.mo.RbBsIfInfoEntry;
import com.bwanms.rb.mo.RbBsIpIfConfigEntry;
import com.bwanms.rb.mo.RbEthIfConfigEntry;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPortConfigForm
extends ManagedObjectsConfigForm<DataPortPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(DataPortConfigForm.class);

    public DataPortPanel initUIComponent() {
        return new DataPortPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbBsIpIfConfigEntry ipIfConfig = (RbBsIpIfConfigEntry)((Object)managedObjects.get(0));
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)ipIfConfig);
        binder.add((Binding)new JTextFieldBinding("txtIPAddressData", "ipIfConfigIpAddress", i18n.translateString("IPAddress")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkMaskData", "ipIfConfigNetworkMask", i18n.translateString("SubnetMask")));
        binder.add((Binding)new JTextFieldBinding("txtDefaultGatewayData", "ipIfConfigDefaultGateway", i18n.translateString("DefaultGateway")));
        binder.add((Binding)new JSpinnerBinding("spnrMgmtVLANId", "ipIfConfigVlanId", i18n.translateString("MgmtVLANId")));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbBsIpIfConfigEntry.class, "1"));
        ret.add(this.ctx.createRequest("BS", RbBsEthIfConfigEntry.class, "1"));
        ret.add(this.ctx.createRequest("BS", RbBsIfInfoEntry.class, "1"));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        DataPortPanel ui = (DataPortPanel)this.getUI();
        ui.getCkbxMgmtVLANId().setSelected(false);
        RbBsEthIfConfigEntry ethIfConfigEntry = (RbBsEthIfConfigEntry)((Object)managedObjects.get(1));
        RbBsIfInfoEntry ifInfoEntry = (RbBsIfInfoEntry)((Object)managedObjects.get(2));
        ui.getTxtOperationalStatus().setText(i18n.translateString(RbIfInfoEntry.toStringIfOperStatus(ifInfoEntry.getIfOperStatus())));
        String ifPhysAddress = ifInfoEntry.getIfPhysAddress();
        if (ifPhysAddress != null) {
            ((DataPortPanel)this.getUI()).getTxtMacAddress().setText(MacAddress.fromOctetString((String)ifPhysAddress).toDashedString());
        }
        ui.getTxtCrtLinkSpeed().setText(i18n.translateString(RbEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(ethIfConfigEntry.getEthConfigCurrentLinkSpeedAndDuplex())));
        ui.getTxtCrtLinkSpeed().setSelectionStart(0);
        ui.getTxtCrtLinkSpeed().setSelectionEnd(0);
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        Version softwareVersion = bs.getSoftwareVersion();
        if (RbVersions.V_4_5.isOlderOrEqualWith(softwareVersion)) {
            ui.getComboLinkSpeed().setSelectedIndex(0);
            ui.getComboLinkSpeed().setEnabled(false);
        } else if (ethIfConfigEntry.getEthConfigAutoNegotiation() == 1) {
            ui.getComboLinkSpeed().setSelectedIndex(0);
        } else {
            for (int i = 0; i < ui.getComboLinkSpeed().getItemCount(); ++i) {
                if (!((ComboItem)ui.getComboLinkSpeed().getItemAt(i)).getValue().equals(ethIfConfigEntry.getEthConfigLinkSpeedAndDuplex())) continue;
                ui.getComboLinkSpeed().setSelectedIndex(i);
                break;
            }
        }
        RbBsIpIfConfigEntry ipIfConfigEntry = (RbBsIpIfConfigEntry)((Object)managedObjects.get(0));
        ipIfConfigEntry.getChangeStrategy().acknowledge();
        ui.getCkbxMgmtVLANId().setSelected(Integer.valueOf(4095).equals(ipIfConfigEntry.getIpIfConfigVlanId()));
    }

    public void configureMOs(List<Object> managedObjects) {
        RbBsEthIfConfigEntry ethIfConfigEntry = (RbBsEthIfConfigEntry)((Object)managedObjects.get(1));
        ethIfConfigEntry.setEthConfigLinkSpeedAndDuplex((Integer)FormUtil.getSelectedValue((JComboBox)((DataPortPanel)this.getUI()).getComboLinkSpeed()));
    }

    public String getTitle() {
        return "DataPort";
    }

    public String warnApply() {
        if (((DataPortPanel)this.getUI()).getTxtNetworkMaskData().getText().equals("0.0.0.0")) {
            return i18n.translateString("InvalidNetworkMaskContinue");
        }
        return i18n.translateString("ApplyingMayCauseInability");
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.npu_data_port";
        }
        return "ngnms.rb.help.tdd_npu_data_port";
    }
}

