/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.ReadOnlyBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.binding.IdValueTranslator;
import com.bwanms.rb.gui.configuration.BsRadioParametersPanelTDD;
import com.bwanms.rb.mo.RbBsRFModeParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsRadioParametersConfigFormTDD
extends ManagedObjectsConfigForm<BsRadioParametersPanelTDD> {
    private static final Logger log = Logger.getLogger(BsRadioParametersConfigFormTDD.class);
    private boolean softwareVersionUnder41;
    private boolean softwareVersionUnder42;
    private boolean softwareVersionUnder45;
    private boolean softwareVersion41;
    private boolean ifMBS;

    protected BsRadioParametersPanelTDD initUIComponent() {
        BsRadioParametersPanelTDD panel = new BsRadioParametersPanelTDD();
        RbBaseStationEquipment RbBaseEquipment = (RbBaseStationEquipment)this.ctx.getEquipment();
        Version v = RbBaseEquipment.getSoftwareVersion();
        this.softwareVersionUnder41 = v.compareTo((Object)new DefaultVersion("4.1")) < 0;
        this.softwareVersionUnder42 = v.compareTo((Object)new DefaultVersion("4.2")) < 0;
        this.softwareVersion41 = !this.softwareVersionUnder41 && v.compareTo((Object)new DefaultVersion("4.2")) < 0;
        this.softwareVersionUnder45 = v.compareTo((Object)new DefaultVersion("4.5")) < 0;
        this.ifMBS = RbBaseEquipment instanceof RbMBS;
        if (!this.softwareVersionUnder41) {
            panel.getLblOptimalUploadRSSI().setText(BsRadioParametersPanelTDD.i18n.translateString("OptimalUplinkRSSI"));
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        int lowerLimit;
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtOperatorID", "rbBSConfiguredOperatorId", (ValueTranslator)new IdValueTranslator(3), BsRadioParametersPanelTDD.i18n.translateString("OperatorID"), BsRadioParametersPanelTDD.i18n.translateString("InvalidIDValue", new Object[]{3})));
        binder.add((Binding)new JTextFieldBinding("txtCellID", "rbBSConfiguredCellId", (ValueTranslator)new IdValueTranslator(2), BsRadioParametersPanelTDD.i18n.translateString("CellID"), BsRadioParametersPanelTDD.i18n.translateString("InvalidIDValue", new Object[]{2})));
        int n = this.softwareVersionUnder42 ? -90 : (lowerLimit = this.ifMBS && !this.softwareVersionUnder45 ? -80 : -80);
        int upperLimit = this.softwareVersionUnder42 ? -60 : (this.ifMBS && !this.softwareVersionUnder45 ? -74 : -74);
        binder.add((Binding)new JTextFieldBinding("txtOptimalUploadRSSI", "rbBsOptimalRSSI", (ValueTranslator)new ParserValueTranslator(Integer.class), BsRadioParametersPanelTDD.i18n.translateString("OptimalUplinkRSSI"), BsRadioParametersPanelTDD.i18n.translateString("GenericValueBetween", new Object[]{lowerLimit, upperLimit})));
        binder.add((Binding)new JComboBoxBinding(BsRadioParametersPanelTDD.i18n, "comboATPCSupport", "rbBsATPCSupport", BsRadioParametersPanelTDD.i18n.translateString("ATPCSupport")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JComboBoxBinding(BsRadioParametersPanelTDD.i18n, "cmbCfgDuplexMode", "rbBsRFConfiguredDuplexMode", BsRadioParametersPanelTDD.i18n.translateString("DuplexMode")));
        JComboBoxBinding bindingDuplexDLULRatio = new JComboBoxBinding(BsRadioParametersPanelTDD.i18n, "cmbCfgDuplexDLULRatio", "rbBsRFConfiguredDlUlRatio", BsRadioParametersPanelTDD.i18n.translateString("DuplexDL/ULRatio"));
        bindingDuplexDLULRatio.setIgnoreDisabled(true);
        binder.add((Binding)bindingDuplexDLULRatio);
        binders.add((Binder)binder);
        ReadOnlyBinder roBinder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
        roBinder.add((ReadOnlyBinding)new JTextFieldBinding("txtCrtDuplexMode", "rbBsRFCurrentDuplexMode", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return BsRadioParametersPanelTDD.i18n.translateString(RbBsRFModeParameters.toStringRbBsRFCurrentDuplexMode(beanValue));
            }
        }, BsRadioParametersPanelTDD.i18n.translateString("DuplexMode")));
        roBinder.add((ReadOnlyBinding)new JTextFieldBinding("txtCrtDuplexDLULRatio", "rbBsRFCurrentDlUlRatio", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return BsRadioParametersPanelTDD.i18n.translateString(RbBsRFModeParameters.toStringRbBsRFCurrentDlUlRatio(beanValue));
            }
        }, BsRadioParametersPanelTDD.i18n.translateString("DuplexDL/ULRatio")));
        binders.add((Binder)roBinder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        ret.add(this.ctx.createRequest("BS", RbBsRFModeParameters.class));
        return ret;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_general_radio_params";
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        int lowerLimit;
        RbBsRFModeParameters rf = (RbBsRFModeParameters)((Object)managedObjects.get(1));
        if (rf.getRbBsRFConfiguredDuplexMode().equals(1)) {
            rf.setRbBsRFConfiguredDlUlRatio(7);
        }
        int n = this.softwareVersionUnder42 ? -90 : (lowerLimit = this.ifMBS && !this.softwareVersionUnder45 ? -80 : -80);
        int upperLimit = this.softwareVersionUnder42 ? -60 : (this.ifMBS && !this.softwareVersionUnder45 ? -74 : -74);
        try {
            int optimalUploadRSSI = Integer.parseInt(((BsRadioParametersPanelTDD)this.getUI()).getTxtOptimalUploadRSSI().getText());
            if (optimalUploadRSSI < lowerLimit || upperLimit < optimalUploadRSSI) {
                invalidValues.add(new InvalidValue(BsRadioParametersPanelTDD.i18n.translateString("GenericValueBetween", new Object[]{lowerLimit, upperLimit}), JTextField.class, BsRadioParametersPanelTDD.i18n.translateString("OptimalUplinkRSSI"), (Object)((BsRadioParametersPanelTDD)this.getUI()).getTxtOptimalUploadRSSI().getText(), (Object)((BsRadioParametersPanelTDD)this.getUI()).getTxtOptimalUploadRSSI()));
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Optimal upload RSSI must be a valid integer");
        }
    }
}

