/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.binding.IdValueTranslator;
import com.bwanms.rb.gui.configuration.BsRadioParametersPanel;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsRadioParametersConfigForm
extends ManagedObjectsConfigForm<BsRadioParametersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(BsRadioParametersConfigForm.class);
    private static final Logger log = Logger.getLogger(BsRadioParametersConfigForm.class);
    private boolean softwareVersionUnder30;

    protected BsRadioParametersPanel initUIComponent() {
        BsRadioParametersPanel panel = new BsRadioParametersPanel();
        this.softwareVersionUnder30 = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isOlderThan((Version)new DefaultVersion("3.0"));
        if (!this.softwareVersionUnder30) {
            panel.getLblOptimalUploadRSSI().setText(i18n.translateString("OptimalUplinkRSSI"));
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtOperatorID", "rbBSConfiguredOperatorId", (ValueTranslator)new IdValueTranslator(3), i18n.translateString("OperatorID"), i18n.translateString("InvalidIDValue", new Object[]{3})));
        binder.add((Binding)new JTextFieldBinding("txtCellID", "rbBSConfiguredCellId", (ValueTranslator)new IdValueTranslator(2), i18n.translateString("CellID"), i18n.translateString("InvalidIDValue", new Object[]{2})));
        int lowerLimit = -103;
        int upperLimit = -60;
        binder.add((Binding)new JTextFieldBinding("txtOptimalUploadRSSI", "rbBsOptimalRSSI", (ValueTranslator)new ParserValueTranslator(Integer.class), i18n.translateString("OptimalUplinkRSSI"), i18n.translateString("GenericValueBetween", new Object[]{lowerLimit, upperLimit})));
        binder.add((Binding)new JComboBoxBinding(BsRadioParametersPanel.i18n, "comboATPCSupport", "rbBsATPCSupport", i18n.translateString("ATPCSupport")));
        binders.add((Binder)binder);
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        int lowerLimit = -103;
        int upperLimit = -60;
        try {
            int optimalUploadRSSI = Integer.parseInt(((BsRadioParametersPanel)this.getUI()).getTxtOptimalUploadRSSI().getText());
            if (optimalUploadRSSI < lowerLimit || upperLimit < optimalUploadRSSI) {
                invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetween", new Object[]{lowerLimit, upperLimit}), JTextField.class, i18n.translateString("OptimalUplinkRSSI"), (Object)((BsRadioParametersPanel)this.getUI()).getTxtOptimalUploadRSSI().getText(), (Object)((BsRadioParametersPanel)this.getUI()).getTxtOptimalUploadRSSI()));
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Optimal upload RSSI must be a valid integer");
        }
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        return ret;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.general_radio_parameters";
        }
        return "ngnms.rb.help.tdd_general_radio_parameters";
    }
}

