/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.util.SortedTableModel;
import com.bwanms.rb.gui.configuration.BsLicensesPanel;
import com.bwanms.rb.mo.RbLicenseBankEntry;
import com.bwanms.rb.mo.RbLicenseBankTable;
import com.bwanms.rb.mo.RbLicenseBstEntry;
import com.bwanms.rb.mo.RbLicenseBstTable;
import com.bwanms.rb.mo.RbSUGracePeriodLicenseEntry;
import com.bwanms.rb.mo.RbSUGracePeriodLicenseTable;
import com.bwanms.rb.mo.RbSUTempGracePeriodLicenseEntry;
import com.bwanms.rb.mo.RbSUTempGracePeriodLicenseTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsLicensesConfigForm
extends ManagedObjectsConfigForm<BsLicensesPanel> {
    private static final Logger logger = Logger.getLogger(BsLicensesConfigForm.class);
    private boolean swBiggerOrEquals41;

    public BsLicensesPanel initUIComponent() {
        BsLicensesPanel panel = new BsLicensesPanel();
        this.swBiggerOrEquals41 = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.1"));
        Vector<String> header = new Vector<String>();
        header.add(BsLicensesPanel.i18n.translateString("SUMACAddress"));
        header.add(BsLicensesPanel.i18n.translateString("ID"));
        header.add(BsLicensesPanel.i18n.translateString("EndDate"));
        if (this.swBiggerOrEquals41) {
            header.add(BsLicensesPanel.i18n.translateString("Status"));
        }
        DefaultTableModel dtm = new DefaultTableModel(new Vector(), header){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        SortedTableModel stm = new SortedTableModel((TableModel)dtm, panel.getTblGraceLicenses().getTableHeader());
        stm.setColumnComparator(Integer.valueOf(0), SimpleRowTableModel.MAC_ADDRESS_COMPARATOR);
        panel.getTblGraceLicenses().setModel((TableModel)stm);
        header = new Vector();
        header.add(BsLicensesPanel.i18n.translateString("ID"));
        header.add(BsLicensesPanel.i18n.translateString("Value"));
        header.add(BsLicensesPanel.i18n.translateString("Count"));
        header.add(BsLicensesPanel.i18n.translateString("Description"));
        if (this.swBiggerOrEquals41) {
            header.add(BsLicensesPanel.i18n.translateString("TotalLoaded"));
        }
        dtm = new DefaultTableModel(new Vector(), header){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 2 || columnIndex == 5) {
                    return Long.class;
                }
                return String.class;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        stm = new SortedTableModel((TableModel)dtm, panel.getTblSusLicenseBankStatus().getTableHeader());
        panel.getTblSusLicenseBankStatus().setModel((TableModel)stm);
        return panel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbLicenseBankTable.class));
        ret.add(this.ctx.createRequest("BS", RbLicenseBstTable.class));
        ret.add(this.ctx.createRequest("BS", RbSUTempGracePeriodLicenseTable.class));
        ret.add(this.ctx.createRequest("BS", RbSUGracePeriodLicenseTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        String value;
        Vector<Object> rowData;
        DefaultTableModel bstLicTblModel = (DefaultTableModel)((SortedTableModel)((BsLicensesPanel)this.getUI()).getTblBaseStationLicenses().getModel()).getTableModel();
        DefaultTableModel bankLicTblModel = (DefaultTableModel)((SortedTableModel)((BsLicensesPanel)this.getUI()).getTblSusLicenseBankStatus().getModel()).getTableModel();
        DefaultTableModel suTmpLicTblModel = (DefaultTableModel)((SortedTableModel)((BsLicensesPanel)this.getUI()).getTblTemporaryGraceLicenses().getModel()).getTableModel();
        DefaultTableModel suGraceLicTblModel = (DefaultTableModel)((SortedTableModel)((BsLicensesPanel)this.getUI()).getTblGraceLicenses().getModel()).getTableModel();
        bstLicTblModel.setRowCount(0);
        bankLicTblModel.setRowCount(0);
        suTmpLicTblModel.setRowCount(0);
        suGraceLicTblModel.setRowCount(0);
        for (RbLicenseBankEntry bankLic : ((RbLicenseBankTable)((Object)managedObjects.get(0))).getEntries()) {
            rowData = new Vector<Object>();
            rowData.add(BsLicensesPanel.i18n.translateString(RbLicenseBankEntry.toStringRbLicenseId(bankLic.getRbLicenseId())));
            value = bankLic.getRbLicenseValue() == 0L ? BsLicensesPanel.i18n.translateString("Unlimited") : bankLic.getRbLicenseValue().toString();
            rowData.add(value);
            rowData.add(bankLic.getRbLicenseCount());
            rowData.add(bankLic.getRbLicenseDescription());
            if (this.swBiggerOrEquals41) {
                rowData.add(bankLic.getRbLicenseTotal());
            }
            bankLicTblModel.addRow(rowData);
        }
        for (RbLicenseBstEntry bstLic : ((RbLicenseBstTable)((Object)managedObjects.get(1))).getEntries()) {
            value = bstLic.getRbBstLicenseValue() == 0L ? BsLicensesPanel.i18n.translateString("Unlimited") : bstLic.getRbBstLicenseValue().toString();
            bstLicTblModel.addRow(new Object[]{BsLicensesPanel.i18n.translateString(RbLicenseBstEntry.toStringRbBstLicenseId(bstLic.getRbBstLicenseId())), value, bstLic.getRbBstLicenseDescription()});
        }
        for (RbSUTempGracePeriodLicenseEntry suTmpLic : ((RbSUTempGracePeriodLicenseTable)((Object)managedObjects.get(2))).getEntries()) {
            suTmpLicTblModel.addRow(new Object[]{MacAddress.fromOctetString((String)suTmpLic.getRbSUTempGracePeriodSuMacAddr()).toString(), BsLicensesPanel.i18n.translateString(RbSUTempGracePeriodLicenseEntry.toStringRbSUTempGracePeriodLicenseId(suTmpLic.getRbSUTempGracePeriodLicenseId())), suTmpLic.getRbSUTempGracePeriodLicenseEndDate()});
        }
        for (RbSUGracePeriodLicenseEntry suGraceLic : ((RbSUGracePeriodLicenseTable)((Object)managedObjects.get(3))).getEntries()) {
            rowData = new Vector();
            rowData.add(MacAddress.fromOctetString((String)suGraceLic.getRbSUGracePeriodSuMacAddr()));
            rowData.add(BsLicensesPanel.i18n.translateString(RbSUGracePeriodLicenseEntry.toStringRbSUGracePeriodLicenseId(suGraceLic.getRbSUGracePeriodLicenseId())));
            rowData.add(suGraceLic.getRbSUGracePeriodLicenseEndDate());
            if (this.swBiggerOrEquals41) {
                rowData.add(BsLicensesPanel.i18n.translateString(RbSUGracePeriodLicenseEntry.toStringRbSUGracePeriodLicenseStatus(suGraceLic.getRbSUGracePeriodLicenseStatus())));
            }
            suGraceLicTblModel.addRow(rowData);
        }
    }

    public String getTitle() {
        return "Licenses";
    }

    public String getHelpTopic() {
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode()) {
            return "ngnms.rb.help.bs_tdd_licenses";
        }
        return "ngnms.rb.help.bs_licenses";
    }

    public boolean canApply() {
        return false;
    }
}

