/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.BsGeneralParametersPanel;
import com.bwanms.rb.mo.RbBSPmTmConfigParameters;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbSystemGroup;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsGeneralParametersConfigForm
extends ManagedObjectsConfigForm<BsGeneralParametersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(BsGeneralParametersPanel.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        boolean isNewerOrEqual4_5;
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtSysName", "systemName", i18n.translateString("SysName")));
        binder.add((Binding)new JTextFieldBinding("txtSysLocation", "systemLocation", i18n.translateString("SysLocation")));
        binder.add((Binding)new JTextFieldBinding("txtSysContact", "systemContact", i18n.translateString("SysContact")));
        binders.add((Binder)binder);
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_1_1)) {
            binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
            binder.add((Binding)new JTextFieldBinding("txtCrtServiceSwitchingMode", "rbCrtServiceSwitchingMode", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

                public String convertToUIValue(Integer beanValue) {
                    return i18n.translateString(RbBSSwitchingModeParameters.toStringRbServiceProvisioningMode(beanValue));
                }
            }, i18n.translateString("CrtServiceSwitchingMode")));
            binders.add((Binder)binder);
            if (!(this.ctx.getEquipment() instanceof RbMBS)) {
                binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
                binder.add((Binding)new JComboBoxBinding("cmbCfgServiceSwitchingMode", "rbCfgServiceSwitchingMode", i18n.translateString("CfgServiceSwitchingMode")));
                binders.add((Binder)binder);
            }
        }
        if ((isNewerOrEqual4_5 = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5)) && !(this.ctx.getEquipment() instanceof RbMBS)) {
            binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(2));
            binder.add((Binding)new JComboBoxBinding("pmtmStatusCmb", "rbBSPmTmStatus", " "));
            binders.add((Binder)binder);
            binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(2));
            binder.add((Binding)new JComboBoxBinding("pmtmModeCmb", "rbBSPmTmMode", " "));
            binders.add((Binder)binder);
        }
    }

    public BsGeneralParametersPanel initUIComponent() {
        BsGeneralParametersPanel panel = new BsGeneralParametersPanel();
        panel.getCmbCfgServiceSwitchingMode().addItem(new ComboItem((Object)RbBSSwitchingModeParameters.SWITCHING_MODE_ETHERNET_CS, i18n.translateString(RbBSSwitchingModeParameters.toStringRbServiceProvisioningMode(RbBSSwitchingModeParameters.SWITCHING_MODE_ETHERNET_CS))));
        panel.getCmbCfgServiceSwitchingMode().addItem(new ComboItem((Object)RbBSSwitchingModeParameters.SWITCHING_MODE_IP_CS, i18n.translateString(RbBSSwitchingModeParameters.toStringRbServiceProvisioningMode(RbBSSwitchingModeParameters.SWITCHING_MODE_IP_CS))));
        panel.getPmtmStatusCmb().addItem(new ComboItem((Object)1, i18n.translateString(RbBSPmTmConfigParameters.toStringRbBSPmTmStatus(1))));
        panel.getPmtmStatusCmb().addItem(new ComboItem((Object)2, i18n.translateString(RbBSPmTmConfigParameters.toStringRbBSPmTmStatus(2))));
        panel.getPmtmModeCmb().addItem(new ComboItem((Object)1, i18n.translateString(RbBSPmTmConfigParameters.toStringRbBSPmTmMode(1))));
        panel.getPmtmModeCmb().addItem(new ComboItem((Object)2, i18n.translateString(RbBSPmTmConfigParameters.toStringRbBSPmTmMode(2))));
        boolean isNewerOrEqual4_5 = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5);
        if (isNewerOrEqual4_5 && !(this.ctx.getEquipment() instanceof RbMBS)) {
            panel.getPmtmPanel().setVisible(true);
            panel.getPmtmSeparator().setVisible(true);
        } else {
            panel.getPmtmPanel().setVisible(false);
            panel.getPmtmSeparator().setVisible(false);
        }
        if (!((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode() || RbVersions.V_4_1.isNewerOrEqualWith(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion())) {
            panel.getPnlProductType().setVisible(false);
        } else if (this.ctx.getEquipment() instanceof RbMBS) {
            panel.getCmbCfgServiceSwitchingMode().setEnabled(false);
        }
        return panel;
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        boolean isNewerOrEqual4_5;
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbSystemGroup.class));
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_1_1)) {
            ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbBSSwitchingModeParameters.class));
        }
        if ((isNewerOrEqual4_5 = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5)) && !(this.ctx.getEquipment() instanceof RbMBS)) {
            ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbBSPmTmConfigParameters.class));
        }
        return ret;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_gen_mgmt_params";
        }
        return "ngnms.rb.help.bs_tdd_gen_mgmt_params";
    }
}

