/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.BsDefaultsPanel;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateTable;
import com.bwanms.rb.mo.services.RbServiceGeneralConfig;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsDefaultsConfigForm
extends ManagedObjectsConfigForm<BsDefaultsPanel> {
    private boolean onTDD = false;
    private boolean isIpCs = false;

    public BsDefaultsPanel initUIComponent() {
        BsDefaultsPanel panel = new BsDefaultsPanel();
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0) {
            this.onTDD = true;
            panel.getSeparatorDefaultSUSettings().setVisible(false);
            panel.getLblDefaultAction().setVisible(false);
            panel.getLblDefaultFile().setVisible(false);
            panel.getComboDefaultAction().setVisible(false);
            panel.getComboDefaultFile().setVisible(false);
        }
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            this.isIpCs = true;
            panel.getLblL2VoipDfltProfile().setVisible(false);
            panel.getCmbL2VoipDfltProfile().setVisible(false);
            panel.getLblPPPoEDfltProfile().setVisible(false);
            panel.getCmbPPPoEDfltProfile().setVisible(false);
        } else if (RbVersions.V_4_5.isSupersetOf(bs.getSoftwareVersion())) {
            panel.getLblL2VoipDfltProfile().setText(BsDefaultsPanel.i18n.translateString("DataDfltProfile"));
        } else if (bs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_2) >= 0) {
            panel.getLblL2VoipDfltProfile().setText(BsDefaultsPanel.i18n.translateString("L2VoiceManagedVoIPDfltProfile"));
        }
        return panel;
    }

    public String getTitle() {
        return "BSDefaults";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.def_operational_settings";
        }
        return "ngnms.rb.help.tdd_def_operational_settings";
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbServiceGeneralConfig.class));
        if (!this.isIpCs) {
            ret.add(this.ctx.createRequest("BS", RbDfltServiceTemplateTable.class));
            ret.add(this.ctx.createRequest("BS", RbServiceTemplateConfigTable.class));
            ret.add(this.ctx.createRequest("BS", RbSwUpgrade.class));
        }
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        if (this.isIpCs) {
            ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
            binder.add((Binding)new JComboBoxBinding(BsDefaultsPanel.i18n, "comboServiceWorkingMode", "RbServiceWorkingMode"));
            binders.add((Binder)binder);
        } else {
            DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
            binder.add((Binding)new JComboBoxBinding(BsDefaultsPanel.i18n, "comboServiceWorkingMode", "RbServiceWorkingMode"));
            binders.add((Binder)binder);
            binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(3));
            binder.add((Binding)new JComboBoxBinding(BsDefaultsPanel.i18n, "comboDefaultAction", "RbSwSuDefaultAction"));
            binders.add((Binder)binder);
        }
    }

    public void fillUI(List<Object> managedObjects) {
        if (!this.isIpCs) {
            RbDfltServiceTemplateTable dfltServiceTemplateTable = (RbDfltServiceTemplateTable)((Object)managedObjects.get(1));
            RbServiceTemplateConfigTable dfltServiceTemplateCfgTable = (RbServiceTemplateConfigTable)((Object)managedObjects.get(2));
            RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(3));
            RbDfltServiceTemplateEntry PPPoE = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("2");
            RbDfltServiceTemplateEntry l2 = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("1");
            RbDfltServiceTemplateEntry voip = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("3");
            RbDfltServiceTemplateEntry managedVoip = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("6");
            ((BsDefaultsPanel)this.getUI()).getCmbL2VoipDfltProfile().removeAllItems();
            ((BsDefaultsPanel)this.getUI()).getCmbPPPoEDfltProfile().removeAllItems();
            ComboItem l2VoipDfltProfile = new ComboItem((Object)"0", BsDefaultsPanel.i18n.translateString("none"));
            ComboItem PPPoEDfltProfile = new ComboItem((Object)new Long(0L), BsDefaultsPanel.i18n.translateString("none"));
            ((BsDefaultsPanel)this.getUI()).getCmbPPPoEDfltProfile().addItem(PPPoEDfltProfile);
            ((BsDefaultsPanel)this.getUI()).getCmbL2VoipDfltProfile().addItem(l2VoipDfltProfile);
            for (RbServiceTemplateConfigEntry dfltServiceTemplateCfg : dfltServiceTemplateCfgTable.getEntries()) {
                ComboItem item;
                if (dfltServiceTemplateCfg.getRbServiceTemplateType() == 2) {
                    item = new ComboItem((Object)dfltServiceTemplateCfg.getRbServiceTemplateIdx(), dfltServiceTemplateCfg.getRbServiceTemplateName() + "  (" + BsDefaultsPanel.i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(dfltServiceTemplateCfg.getRbServiceTemplateType())) + ")");
                    ((BsDefaultsPanel)this.getUI()).getCmbPPPoEDfltProfile().addItem(item);
                    if (PPPoE == null || !PPPoE.getRbDfltServiceTemplateIdx().equals(dfltServiceTemplateCfg.getRbServiceTemplateIdx())) continue;
                    PPPoEDfltProfile = item;
                    continue;
                }
                if (dfltServiceTemplateCfg.getRbServiceTemplateType() != 1 && dfltServiceTemplateCfg.getRbServiceTemplateType() != 3 && (dfltServiceTemplateCfg.getRbServiceTemplateType() != 5 && dfltServiceTemplateCfg.getRbServiceTemplateType() != 6 || !RbFeatures.isSipAwareAvailable((RbBaseStationEquipment)this.ctx.getEquipment()))) continue;
                item = new ComboItem((Object)(dfltServiceTemplateCfg.getRbServiceTemplateType() + "." + dfltServiceTemplateCfg.getRbServiceTemplateIdx()), dfltServiceTemplateCfg.getRbServiceTemplateName() + "  (" + BsDefaultsPanel.i18n.translateString(RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(dfltServiceTemplateCfg.getRbServiceTemplateType())) + ")");
                ((BsDefaultsPanel)this.getUI()).getCmbL2VoipDfltProfile().addItem(item);
                if (!(l2 != null && l2.getRbDfltServiceTemplateIdx().equals(dfltServiceTemplateCfg.getRbServiceTemplateIdx()) || voip != null && voip.getRbDfltServiceTemplateIdx().equals(dfltServiceTemplateCfg.getRbServiceTemplateIdx())) && (managedVoip == null || !managedVoip.getRbDfltServiceTemplateIdx().equals(dfltServiceTemplateCfg.getRbServiceTemplateIdx()))) continue;
                l2VoipDfltProfile = item;
            }
            ((BsDefaultsPanel)this.getUI()).getCmbPPPoEDfltProfile().setSelectedItem(PPPoEDfltProfile);
            ((BsDefaultsPanel)this.getUI()).getCmbL2VoipDfltProfile().setSelectedItem(l2VoipDfltProfile);
            String[] swFiles = swUpgrade.getRbSwSuFiles().split(";");
            ((BsDefaultsPanel)this.getUI()).getComboDefaultFile().removeAllItems();
            ((BsDefaultsPanel)this.getUI()).getComboDefaultFile().addItem(new ComboItem((Object)"", BsDefaultsPanel.i18n.translateString("none")));
            String defaultFile = swUpgrade.getRbSwSuDefaultFile();
            boolean addDefault = true;
            for (String file : swFiles) {
                if (file.equals(defaultFile)) {
                    addDefault = false;
                }
                ((BsDefaultsPanel)this.getUI()).getComboDefaultFile().addItem(new ComboItem((Object)file, file));
            }
            if (addDefault && defaultFile != null && defaultFile.trim().length() != 0) {
                ((BsDefaultsPanel)this.getUI()).getComboDefaultFile().addItem(new ComboItem((Object)defaultFile, defaultFile));
            }
            FormUtil.setSelectedValue((JComboBox)((BsDefaultsPanel)this.getUI()).getComboDefaultFile(), (Object)defaultFile);
        }
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        if (!this.isIpCs) {
            RbDfltServiceTemplateTable dfltServiceTemplateTable = (RbDfltServiceTemplateTable)((Object)managedObjects.get(1));
            RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(3));
            RbDfltServiceTemplateEntry PPPoE = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("2");
            RbDfltServiceTemplateEntry l2 = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("1");
            RbDfltServiceTemplateEntry voip = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("3");
            RbDfltServiceTemplateEntry managedVoip = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry("6");
            ComboItem item = (ComboItem)((BsDefaultsPanel)this.getUI()).getCmbPPPoEDfltProfile().getSelectedItem();
            if (PPPoE != null) {
                PPPoE.setRbDfltServiceTemplateIdx((Long)item.getValue());
            }
            if ((item = (ComboItem)((BsDefaultsPanel)this.getUI()).getCmbL2VoipDfltProfile().getSelectedItem()).getValue().equals("0")) {
                if (l2 != null) {
                    l2.setRbDfltServiceTemplateIdx(new Long(0L));
                }
                if (voip != null) {
                    voip.setRbDfltServiceTemplateIdx(new Long(0L));
                }
                if (managedVoip != null) {
                    managedVoip.setRbDfltServiceTemplateIdx(new Long(0L));
                }
            } else {
                String[] value = item.getValue().toString().split("\\.");
                RbDfltServiceTemplateEntry entry = (RbDfltServiceTemplateEntry)dfltServiceTemplateTable.findEntry(value[0]);
                entry.setRbDfltServiceTemplateIdx(Long.parseLong(value[1]));
            }
            if (!this.onTDD) {
                swUpgrade.setRbSwSuDefaultFile((String)FormUtil.getSelectedValue((JComboBox)((BsDefaultsPanel)this.getUI()).getComboDefaultFile()));
            }
        }
    }
}

