/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.rb.gui.configuration.BMAXChasisPanel;
import com.bwanms.rb.gui.inventory.chasis.AUChannel;
import com.bwanms.rb.gui.inventory.chasis.AUComponent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChannel;
import com.bwanms.rb.gui.inventory.chasis.BMAXComponent;
import com.bwanms.rb.gui.inventory.chasis.ODUComponent;
import com.bwanms.rb.gui.inventory.chasis.RCComponent;

public class BMAXChasisPanelController {
    BMAXChasisPanel form;

    public BMAXChasisPanelController(BMAXChasisPanel form) {
        this.form = form;
    }

    protected void bmaxChasisMouseClicked() {
        BMAXComponent comp = this.form.getBMAXChasis().getSelectedComponent();
        if (comp instanceof AUComponent) {
            BMAXChannel channel = comp.getSelectedChannel();
            if (channel instanceof AUChannel) {
                this.form.getOutdoorUnits().selectODU(((AUChannel)channel).getOutdoorUnitID(), true);
                this.form.getRadioClusters().selectRadioCluster(((AUChannel)channel).getRadioClusterID(), true);
            } else {
                this.form.getOutdoorUnits().selectODU(-1, true);
                this.form.getRadioClusters().selectRadioCluster(-1, true);
            }
        } else {
            this.form.getOutdoorUnits().selectODU(-1, true);
            this.form.getRadioClusters().selectRadioCluster(-1, true);
        }
    }

    protected void odusMouseClicked() {
        ODUComponent odu = this.form.getOutdoorUnits().getSelectedODU();
        if (odu != null) {
            this.form.getRadioClusters().selectRadioCluster(odu.getRadioClusterID(), true);
            this.form.getBMAXChasis().deselectSlot();
            for (int slot = 1; slot < 10; ++slot) {
                AUComponent auComp = this.form.getBMAXChasis().getAU(slot);
                if (auComp == null) continue;
                for (BMAXChannel ch : auComp.getChannels()) {
                    AUChannel auChannel;
                    auChannel.setSelected((auChannel = (AUChannel)ch).getOutdoorUnitID() == odu.getOduID());
                }
                auComp.deselectChannel();
            }
        } else {
            this.form.getRadioClusters().selectRadioCluster(-1, true);
            for (int slot = 1; slot < 10; ++slot) {
                AUComponent auComp = this.form.getBMAXChasis().getAU(slot);
                if (auComp == null) continue;
                auComp.deselectAllChannels();
            }
            this.form.getBMAXChasis().deselectSlot();
        }
    }

    protected void rcsMouseClicked() {
        RCComponent rc = this.form.getRadioClusters().getSelectedRadioCluster();
        if (rc != null) {
            this.form.getOutdoorUnits().selectODU(-1, true);
            for (int i = 0; i < this.form.getOutdoorUnits().getMaxUnits(); ++i) {
                ODUComponent odu = this.form.getOutdoorUnits().getODU(i);
                if (odu.getRadioClusterID() != rc.getRadioClusterID()) continue;
                this.form.getOutdoorUnits().selectODU(odu.getOduID(), false);
            }
            this.form.getBMAXChasis().deselectSlot();
            for (int slot = 1; slot < 10; ++slot) {
                AUComponent auComp = this.form.getBMAXChasis().getAU(slot);
                if (auComp == null) continue;
                for (BMAXChannel ch : auComp.getChannels()) {
                    AUChannel auChannel;
                    auChannel.setSelected((auChannel = (AUChannel)ch).getRadioClusterID() == rc.getRadioClusterID());
                }
                auComp.deselectChannel();
            }
        } else {
            this.form.getOutdoorUnits().selectODU(-1, true);
            for (int slot = 1; slot < 10; ++slot) {
                AUComponent auComp = this.form.getBMAXChasis().getAU(slot);
                if (auComp == null) continue;
                auComp.deselectAllChannels();
            }
            this.form.getBMAXChasis().deselectSlot();
        }
    }
}

