/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.client.gui.fault.events.OpenAlarmsView;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.model.Settings;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventQueryResult;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.gui.configuration.BMAXChasisPanel;
import com.bwanms.rb.gui.inventory.chasis.ACUComponent;
import com.bwanms.rb.gui.inventory.chasis.AUChannel;
import com.bwanms.rb.gui.inventory.chasis.AUComponent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasis;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.BMAXChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.BMAXComponent;
import com.bwanms.rb.gui.inventory.chasis.NPUComponent;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseListener;
import com.bwanms.rb.gui.inventory.chasis.PIUComponent;
import com.bwanms.rb.gui.inventory.chasis.PSUComponent;
import com.bwanms.rb.gui.inventory.chasis.RCComponent;
import com.bwanms.rb.gui.managers.RbServiceGMLManagerConfig;
import com.bwanms.rb.gui.selectors.service.RbSelfContainedSelectorDialog;
import com.bwanms.rb.mo.RbAcuConfigurationGroup;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbAuHwComponentsInfoTable;
import com.bwanms.rb.mo.RbBsIfInfoEntry;
import com.bwanms.rb.mo.RbBsIfInfoTable;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbPiuConfigEntry;
import com.bwanms.rb.mo.RbPiuConfigTable;
import com.bwanms.rb.mo.RbPsuConfigTable;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.rb.mo.RbSlotConfigTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbGUIUtil;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.fault.FilterUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMAXChasisConfigForm
extends ManagedObjectsConfigForm<BMAXChasisPanel> {
    private static final Log logger = LogFactory.getLog(BMAXChasisConfigForm.class);
    private boolean receiving = false;
    public static final List<Class> moClasses = Arrays.asList(RbPiuConfigTable.class, RbPsuConfigTable.class, RbSlotConfigTable.class, RbAuConfigTable.class, RbNpuConfigTable.class, RbBsIfInfoTable.class, RbAcuConfigurationGroup.class, RbAuHwComponentsInfoTable.class, RbOduConfigTable.class, RbRadioClusterTable.class, RbAuChannelConfigTable.class);

    public BMAXChasisPanel initUIComponent() {
        final BMAXChasisPanel chasisPanel = new BMAXChasisPanel();
        new Thread(new Runnable(){

            public void run() {
                boolean shouldStop = false;
                while (!shouldStop) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ie) {
                        logger.error((Object)ie, (Throwable)ie);
                    }
                    boolean bl = shouldStop = null == chasisPanel.getParent() || ((FormsConfigSectionView)BMAXChasisConfigForm.this.getConfigSectionView()).isShouldStop();
                    if (BMAXChasisConfigForm.this.receiving || shouldStop) continue;
                    BMAXChasisConfigForm.this.receiving = true;
                    try {
                        BMAXChasisConfigForm.this.getConfigSectionView().refresh(false);
                    }
                    catch (Throwable t) {
                        logger.error((Object)t, t);
                    }
                }
            }
        }).start();
        if (!PlatformConfiguration.isLocalPlatform()) {
            final JPopupMenu ctxMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show Services for BS");
            final JMenuItem jMenuItem2 = new JMenuItem("Show Services for AU");
            final JMenuItem jMenuItem3 = new JMenuItem("Open Alarms");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BMAXChasisConfigForm.this.showServices(false);
                }
            });
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BMAXChasisConfigForm.this.showServices(true);
                }
            });
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BMAXComponent bMAXComponent = ((BMAXChasisPanel)BMAXChasisConfigForm.this.getUI()).getBMAXChasis().getSelectedComponent();
                        if (bMAXComponent != null) {
                            int slotNr = bMAXComponent.getSlotNumber();
                            if (bMAXComponent instanceof AUComponent) {
                                FrameUtil.runView((View)new OpenAlarmsView(BMAXChasisConfigForm.this.ctx.getEquipment(), "AU.Slot#" + slotNr), (int)640, (int)480);
                            } else if (bMAXComponent instanceof NPUComponent) {
                                FrameUtil.runView((View)new OpenAlarmsView(BMAXChasisConfigForm.this.ctx.getEquipment(), "NPU.Slot#" + slotNr), (int)640, (int)480);
                            } else if (bMAXComponent instanceof PIUComponent) {
                                FrameUtil.runView((View)new OpenAlarmsView(BMAXChasisConfigForm.this.ctx.getEquipment(), "PIU#" + (slotNr - 13)), (int)640, (int)480);
                            } else if (bMAXComponent instanceof PSUComponent) {
                                FrameUtil.runView((View)new OpenAlarmsView(BMAXChasisConfigForm.this.ctx.getEquipment(), "PSU#" + (slotNr - 9)), (int)640, (int)480);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            jMenuItem2.setVisible(false);
            jMenuItem3.setVisible(false);
            ctxMenu.add(jMenuItem);
            ctxMenu.add(jMenuItem2);
            ctxMenu.add(jMenuItem3);
            chasisPanel.getBMAXChasis().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof BMAXChasis) {
                        ((BMAXChasis)component).deselectAllSlots();
                    }
                }

                public void mousePressed(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof BMAXChasis) {
                        ((BMAXChasis)component).selectSlot(-1);
                        jMenuItem3.setVisible(false);
                        jMenuItem2.setVisible(false);
                    } else {
                        jMenuItem2.setVisible(false);
                        if (component instanceof AUComponent) {
                            jMenuItem2.setVisible(true);
                            jMenuItem3.setText("Open Alarms for AU");
                            jMenuItem3.setVisible(true);
                        } else if (component instanceof PIUComponent) {
                            jMenuItem3.setText("Open Alarms for PIU");
                        } else if (component instanceof PSUComponent) {
                            jMenuItem3.setText("Open Alarms for PSU");
                        } else if (component instanceof NPUComponent) {
                            jMenuItem3.setText("Open Alarms for NPU");
                        }
                        if (component instanceof ACUComponent) {
                            jMenuItem3.setVisible(false);
                        } else {
                            jMenuItem3.setVisible(true);
                        }
                    }
                    if (e.getButton() == 3) {
                        ctxMenu.show(component, e.getX() + component.getX(), e.getY() + component.getY());
                    }
                }
            });
        }
        return chasisPanel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        for (Class clazz : moClasses) {
            ret.add(this.ctx.createRequest("BS", clazz));
        }
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.5"))) {
            ret.add(this.ctx.createRequest("BS", RbGPSInfo.class));
        }
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        Map<String, List<Event>> trapsByCategory;
        List<Event> trapList;
        RbBaseStationEquipment eq = (RbBaseStationEquipment)this.ctx.getEquipment();
        int npuSlot = 0;
        RbPiuConfigTable piuConfigTable = (RbPiuConfigTable)((Object)managedObjects.get(0));
        RbPsuConfigTable psuConfigTable = (RbPsuConfigTable)((Object)managedObjects.get(1));
        RbSlotConfigTable slotConfigTable = (RbSlotConfigTable)((Object)managedObjects.get(2));
        RbAuConfigTable auConfigTable = (RbAuConfigTable)((Object)managedObjects.get(3));
        RbNpuConfigTable npuConfigTable = (RbNpuConfigTable)((Object)managedObjects.get(4));
        RbBsIfInfoTable ifInfoTable = (RbBsIfInfoTable)((Object)managedObjects.get(5));
        RbAcuConfigurationGroup acuGroup = (RbAcuConfigurationGroup)((Object)managedObjects.get(6));
        RbAuHwComponentsInfoTable auHwTable = (RbAuHwComponentsInfoTable)((Object)managedObjects.get(7));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(8));
        RbRadioClusterTable rcTable = (RbRadioClusterTable)((Object)managedObjects.get(9));
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(10));
        RbGPSInfo GPSInfo = null;
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.5"))) {
            GPSInfo = (RbGPSInfo)((Object)managedObjects.get(11));
        }
        Vector<Integer> auSlots = new Vector<Integer>();
        boolean[][] selectedChannels = new boolean[10][4];
        for (int i = 1; i <= 9; ++i) {
            if (i == 5 || i == 6) continue;
            int channelsCount = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getAU(i) != null ? ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getAU(i).getChannels().size() : 0;
            for (int j = 0; j < channelsCount; ++j) {
                if (((BMAXChasisPanel)this.getUI()).getBMAXChasis().getChannel(i, j) == null) continue;
                selectedChannels[i][j] = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getChannel(i, j).isSelected();
            }
        }
        ((BMAXChasisPanel)this.getUI()).getBMAXChasis().removeAll();
        boolean isLocalPlatform = PlatformConfiguration.isLocalPlatform();
        List<Event> list = trapList = isLocalPlatform ? null : this.getBSAlarms();
        if (trapList == null && !isLocalPlatform) {
            logger.debug((Object)"BS Alarms query returned null!");
        }
        Map<String, List<Event>> map = trapsByCategory = trapList != null ? this.categorizeEvents(trapList) : null;
        if (oduTable != null) {
            for (Object entry : oduTable.getEntries()) {
                ((BMAXChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setRadioClusterID(entry.getRbOduAssociatedRadioClusterId());
                ((BMAXChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setStatus(entry.getRbOduOperationalStatus());
                ((BMAXChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setTxPower(entry.getRbOduTxPower());
            }
        }
        if (rcTable != null) {
            for (Object entry : rcTable.getEntries()) {
                ((BMAXChasisPanel)this.getUI()).getRadioClusters().getRadioCluster(entry.getRbRadioClusterId() - 1).setName(entry.getRbRadioClusterName());
            }
        }
        if (piuConfigTable != null) {
            for (Object entry : piuConfigTable.getEntries()) {
                String piuName = "PIU" + entry.getRbPiuNumber();
                int piuSlot = 13 + entry.getRbPiuNumber();
                if (entry.getRbPiuStatus() == 3) continue;
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addPIU(piuSlot, piuName, RbPiuConfigEntry.RbPiuModeMaster.equals(entry.getRbPiuMode()), "High Power".equals(entry.getRbPiuHwRevision()));
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getPIU(piuSlot).setToolTipText(entry.getRbPiuHwRevision());
                BMAXComponent piuComp = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(piuSlot);
                if (piuComp == null) continue;
                piuComp.setStatus(entry.getRbPiuStatus());
                if (!(piuComp instanceof PIUComponent) || trapsByCategory == null) continue;
                ((PIUComponent)piuComp).setAlarmSeverityLevel(this.getMaxSeverity(trapsByCategory.get("PIU#" + entry.getRbPiuNumber())));
            }
        }
        if (psuConfigTable != null) {
            for (Object entry : psuConfigTable.getEntries()) {
                String psuName = "PSU" + entry.getRbPsuNumber();
                int psuSlot = 9 + entry.getRbPsuNumber();
                if (entry.getRbPsuStatus() == 3) continue;
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addPSU(psuSlot, psuName);
                BMAXComponent psuComp = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(psuSlot);
                if (psuComp == null) continue;
                psuComp.setStatus(entry.getRbPsuStatus());
                if (!(psuComp instanceof PSUComponent) || trapsByCategory == null) continue;
                ((PSUComponent)psuComp).setAlarmSeverityLevel(this.getMaxSeverity(trapsByCategory.get("PSU#" + entry.getRbPsuNumber())));
            }
        }
        if (slotConfigTable != null) {
            for (Object entry : slotConfigTable.getEntries()) {
                if (entry.getRbSlotDetectedCard() == 3) {
                    int auSlot = entry.getRbSlotNumber();
                    String auName = "AU" + auSlot;
                    if (auHwTable == null) continue;
                    for (StaticTableRowMO entry2 : auHwTable.getEntries()) {
                        BMAXComponent auComp;
                        if (entry2.getRbSlotNumber() != auSlot) continue;
                        int iduType = entry2.getRbAuIduType();
                        if (iduType == 1 || iduType == 3) {
                            ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addAU(auSlot, auName, 2);
                            auSlots.add(auSlot);
                        } else if (iduType == 2 || iduType == 4 || iduType == 5) {
                            ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addAU(auSlot, auName, 4);
                            auSlots.add(auSlot);
                        }
                        if ((auComp = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(auSlot)) == null) continue;
                        auComp.setStatus(entry.getRbSlotFaultStatus());
                        if (auComp instanceof AUComponent && trapsByCategory != null) {
                            ((AUComponent)auComp).setAlarmSeverityLevel(this.getMaxSeverity(trapsByCategory.get("AU.Slot#" + auSlot)));
                        }
                        if (auConfigTable != null) {
                            for (RbAuConfigEntry entry3 : auConfigTable.getEntries()) {
                                if (entry3.getRbSlotNumber() != auSlot) continue;
                                auComp.setSerialNo(entry3.getRbAuSerialNo());
                                break;
                            }
                        }
                        if (auChannelTable == null) continue;
                        for (RbAuChannelConfigEntry entry4 : auChannelTable.getEntries()) {
                            int channelID;
                            if (entry4.getRbSlotNumber() != auSlot || (channelID = entry4.getRbAuChannelId().intValue()) > 2 && (channelID < 3 || iduType != 2 && iduType != 4 && iduType != 5)) continue;
                            AUChannel auChannel = (AUChannel)((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(auSlot).getChannel(channelID - 1);
                            auChannel.setOutdoorUnitID(entry4.getRbAuChannelAssociatedOduId());
                            auChannel.setRadioClusterID(entry4.getRbAuChannelAssociatedRadioClusterId());
                            auChannel.setChannelTxFreq(entry4.getRbAuChannelTxFrequency());
                            if (entry4.getRbAuChannelAdminStatus() == 1) {
                                Integer operStatus = entry4.getRbAuChannelOperStatus();
                                if (Integer.valueOf(1).equals(operStatus)) {
                                    auChannel.setStatus(1);
                                } else {
                                    auChannel.setStatus(2);
                                }
                            } else {
                                auChannel.setStatus(3);
                            }
                            if (auChannel.getOutdoorUnitID() <= 0) continue;
                            ((BMAXChasisPanel)this.getUI()).getOutdoorUnits().getODU(auChannel.getOutdoorUnitID() - 1).setChannelTxFreq(entry4.getRbAuChannelTxFrequency());
                        }
                    }
                    continue;
                }
                if (entry.getRbSlotDetectedCard() != 4) continue;
                npuSlot = entry.getRbSlotNumber();
                String npuName = "NPU" + npuSlot;
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addNPU(npuSlot, npuName);
                BMAXComponent npuComp = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(npuSlot);
                if (npuComp == null) continue;
                npuComp.setStatus(entry.getRbSlotFaultStatus());
                if (npuComp instanceof NPUComponent) {
                    if (trapsByCategory != null) {
                        ((NPUComponent)npuComp).setAlarmSeverityLevel(this.getMaxSeverity(trapsByCategory.get("NPU.Slot#" + npuSlot)));
                    }
                    int status = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isOlderThan((Version)new DefaultVersion("4.5")) ? -1 : (GPSInfo.getRbGPSNumberOfRxSatellites() >= 4L ? 1 : 0);
                    ((NPUComponent)npuComp).setGPSStatus(status);
                }
                if (npuConfigTable != null) {
                    for (StaticTableRowMO entry2 : npuConfigTable.getEntries()) {
                        if (entry2.getRbSlotNumber() != npuSlot) continue;
                        npuComp.setSerialNo(entry2.getRbNpuSerialNo());
                        break;
                    }
                }
                if (ifInfoTable == null) continue;
                for (RbBsIfInfoEntry entry3 : ifInfoTable.getEntries()) {
                    if (entry3.getIfType() == 117) {
                        ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(npuSlot).getChannel(0).setStatus(entry3.getIfOperStatus());
                        continue;
                    }
                    if (entry3.getIfType() != 62) continue;
                    ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(npuSlot).getChannel(1).setStatus(entry3.getIfOperStatus());
                }
            }
        }
        for (int i = 1; i <= 9; ++i) {
            int j;
            int channelsCount;
            if (i == 5 || i == 6) continue;
            int n = channelsCount = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getAU(i) != null ? ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getAU(i).getChannels().size() : 0;
            if (!auSlots.contains(new Integer(i))) {
                for (j = 0; j < 4; ++j) {
                    selectedChannels[i][j] = false;
                }
            }
            for (j = 0; j < channelsCount; ++j) {
                if (((BMAXChasisPanel)this.getUI()).getBMAXChasis().getChannel(i, j) == null) continue;
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getChannel(i, j).setSelected(selectedChannels[i][j]);
            }
        }
        if (acuGroup != null) {
            String[] acuFaultStatus = acuGroup.getRbAcuFaultStatus().split(":");
            for (int i = 0; i < acuFaultStatus.length; ++i) {
                int status = new Integer(acuFaultStatus[i]);
                int acuSlot = 16 + i;
                ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addACU(acuSlot, "ACU" + (i + 1));
                BMAXComponent acuComp = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getBMAXComponent(acuSlot);
                if (acuComp == null) continue;
                acuComp.setStatus(status);
            }
        }
        ((BMAXChasisPanel)this.getUI()).getBMAXChasis().addChasisMouseListener(new BMAXChasisMouseListener(){

            public void mouseClicked(BMAXChasisMouseEvent e) {
                if (e.getClickCount() == 2 && e.getCard() != null) {
                    String url = null;
                    if (e.isAU()) {
                        url = "bwanms://config/" + BMAXChasisConfigForm.this.ctx.getEquipment().getEUID() + "/" + "AU." + e.getSlot() + "/";
                        if (e.getChannel() >= 0) {
                            url = url + "Channels/?channelId=" + e.getChannel();
                        }
                    } else if (e.isNPU()) {
                        url = "bwanms://config/" + BMAXChasisConfigForm.this.ctx.getEquipment().getEUID() + "/" + "NPU" + "/";
                        if (e.getChannel() == 0) {
                            url = url + "DataPort/";
                        } else if (e.getChannel() == 1) {
                            url = url + "ManagementPort/";
                        }
                    }
                    if (url != null) {
                        BMAXChasisConfigForm.this.fireAction(url);
                    }
                }
            }
        });
        ((BMAXChasisPanel)this.getUI()).getOutdoorUnits().addODUMouseListener(new ODUMouseListener(){

            public void mouseClicked(ODUMouseEvent e) {
                if (e.getClickCount() == 2) {
                    String url = "bwanms://config/" + BMAXChasisConfigForm.this.ctx.getEquipment().getEUID() + "/OutdoorUnits/";
                    url = url + "/?oduId=" + e.get_selectedODU();
                    BMAXChasisConfigForm.this.fireAction(url);
                }
            }
        });
        ((BMAXChasisPanel)this.getUI()).getRadioClusters().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String url = "bwanms://config/" + BMAXChasisConfigForm.this.ctx.getEquipment().getEUID() + "/RadioClusters/";
                    if (e.getComponent() instanceof RCComponent) {
                        url = url + "?clusterId=" + ((RCComponent)e.getComponent()).getRadioClusterID();
                    }
                    BMAXChasisConfigForm.this.fireAction(url);
                }
            }
        });
        ((BMAXChasisPanel)this.getUI()).repaint();
        this.receiving = false;
    }

    private List<Event> getBSAlarms() {
        String filter = FilterUtil.formatOpenAlarmsFilter((long)this.ctx.getEquipment().getId());
        EventQueryResult evtQueryResult = null;
        try {
            evtQueryResult = ServiceRegistry.getEventManagerService().getEvents(filter, 0L);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (evtQueryResult != null) {
            return evtQueryResult.getEvents();
        }
        return null;
    }

    private Map<String, List<Event>> categorizeEvents(List<Event> events) {
        HashMap<String, List<Event>> result = new HashMap<String, List<Event>>();
        for (Event currentElement : events) {
            if (!result.keySet().contains(currentElement.getManagedObject())) {
                ArrayList<Event> list = new ArrayList<Event>();
                list.add(currentElement);
                result.put(currentElement.getManagedObject(), list);
                continue;
            }
            ((List)result.get(currentElement.getManagedObject())).add(currentElement);
        }
        return result;
    }

    private Severity getMaxSeverity(List<Event> events) {
        Event maximum = null;
        if (events != null && !events.isEmpty()) {
            maximum = Collections.max(events, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return ((Event)o1).getEventSeverity() - ((Event)o2).getEventSeverity();
                }
            });
        }
        if (maximum != null) {
            return Severity.fromValue((int)maximum.getEventSeverity());
        }
        return Severity.unexpectedValue;
    }

    private void showServices(boolean auSlotFilter) {
        Equipment equipment = this.ctx.getEquipment();
        if (equipment != null) {
            RbSelfContainedSelectorDialog dialog;
            IpAddress BSIp = new IpAddress(((RbBaseStationEquipment)equipment).getIPAddress());
            BMAXComponent bMAXComponent = ((BMAXChasisPanel)this.getUI()).getBMAXChasis().getSelectedComponent();
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            if (bMAXComponent != null && bMAXComponent instanceof AUComponent && auSlotFilter) {
                int slotNr = bMAXComponent.getSlotNumber();
                settings.setProperty("ActiveFilters:BSChassisShowServices", "2_1_0_NRConfiguration.configuration.equipment.ipAddr:2_1_0_rbServiceAUSlotNumber");
                settings.setProperty("SelectedFilterValues:BSChassisShowServices:2_1_0_NRConfiguration.configuration.equipment.ipAddr", BSIp.toString().length() + ":" + BSIp);
                settings.setProperty("SelectedFilterValues:BSChassisShowServices:2_1_0_rbServiceAUSlotNumber", (slotNr + "").length() + ":" + slotNr);
            } else {
                settings.setProperty("ActiveFilters:BSChassisShowServices", "2_1_0_NRConfiguration.configuration.equipment.ipAddr");
                settings.setProperty("SelectedFilterValues:BSChassisShowServices:2_1_0_NRConfiguration.configuration.equipment.ipAddr", BSIp.toString().length() + ":" + BSIp);
            }
            ServiceRegistry.getSettingsService().updateSettings(settings);
            RbServiceGMLManagerConfig serviceManagerConfig = new RbServiceGMLManagerConfig();
            serviceManagerConfig.setSelectorName("BSChassisShowServices");
            Window parentWindow = SwingUtilities.getWindowAncestor(this.getUI());
            if (parentWindow instanceof JFrame) {
                dialog = new RbSelfContainedSelectorDialog((JFrame)parentWindow);
            } else if (parentWindow instanceof JDialog) {
                dialog = new RbSelfContainedSelectorDialog((JDialog)parentWindow);
            } else {
                throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
            }
            EntityManagerView managerView = new EntityManagerView((EntityManagerConfig)serviceManagerConfig);
            dialog.setView((View)managerView);
            dialog.setModal(false);
            dialog.setTitle("Services for " + ((RbBaseStationEquipment)this.ctx.getEquipment()).getName());
            dialog.setPreferredSize(new Dimension(managerView.getUI().getPreferredSize().width + 10, managerView.getUI().getPreferredSize().height + 70));
            dialog.pack();
            RbGUIUtil.centerDialog((JDialog)((Object)dialog));
            dialog.setVisible(true);
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getTitle() {
        return "BMAXChasis";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.bs_manager";
        }
        return "ngnms.rb.help.bs_tdd_manager";
    }
}

