/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.AuthorizedManagersPanel;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbAuthorizedManagersTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import com.bwanms.validation.IPAddressValidator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizedManagersConfigForm
extends ManagedObjectsConfigForm<AuthorizedManagersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AuthorizedManagersConfigForm.class);
    private static final Logger logger = Logger.getLogger(AuthorizedManagersConfigForm.class);

    public AuthorizedManagersPanel initUIComponent() {
        return new AuthorizedManagersPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        AuthorizedManagersPanel cfr_ignored_0 = (AuthorizedManagersPanel)this.getUI();
        TableBinder binder = new TableBinder(AuthorizedManagersPanel.getI18n(), ((AuthorizedManagersPanel)this.getUI()).getTable2Model(), (SNMPTableMO)managedObjects.get(0));
        binder.add((Binding)new TableColumnBinding("IPAddress", "authMngrIpAddr"));
        binder.add((Binding)new TableColumnBinding("ReadCommunity", "authMngrReadCommunity"));
        binder.add((Binding)new TableColumnBinding("WriteCommunity", "authMngrWriteCommunity"));
        binder.add((Binding)new TableColumnBinding("TrapsEnabled", "authMngrTrapEnable", (ValueTranslator)new ValueTranslator<Integer, Boolean>(){

            public Boolean convertToUIValue(Integer beanValue) throws TranslateException {
                return beanValue.equals(1);
            }

            public Integer convertToBeanValue(Boolean uiBeanValue) throws TranslateException {
                return uiBeanValue != false ? 1 : 2;
            }
        }));
        binders.add((Binder)binder);
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuthorizedManagersTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        ((AuthorizedManagersPanel)this.getUI()).getBtnAdd().setEnabled(((AuthorizedManagersPanel)this.getUI()).getTable2Model().getRowCount() < 10);
        FormUtil.cancelTableEditing((JTable)((AuthorizedManagersPanel)this.getUI()).getTable2());
        ((AuthorizedManagersPanel)this.getUI()).getTable2Model().sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbAuthorizedManagersTable authorizedManagersTable = (RbAuthorizedManagersTable)((Object)managedObjects.get(0));
        SimpleRowTableModel model = ((AuthorizedManagersPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((AuthorizedManagersPanel)this.getUI()).getTable2());
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            boolean invalidCommunityWrite;
            String instance = (String)model.getValueAt(i, 0);
            if (instance == null || !new IPAddressValidator().isValid((Object)instance)) {
                invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidIPAddress", new Object[]{String.valueOf(i + 1)}), RbAuthorizedManagersEntry.class, i18n.translateString("IPAddress"), (Object)instance, (Object)((SNMPTableMO)managedObjects.get(0))));
                continue;
            }
            String communityRead = (String)model.getValueAt(i, 1);
            String communityWrite = (String)model.getValueAt(i, 2);
            boolean invalidCommunityRead = communityRead == null || communityRead.equals("") || communityRead.length() < 0 || communityRead.length() > 23;
            boolean bl = invalidCommunityWrite = communityWrite == null || communityWrite.equals("") || communityWrite.length() < 0 || communityWrite.length() > 23;
            if (invalidCommunityRead) {
                invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidReadAddress", new Object[]{String.valueOf(i + 1)}), RbAuthorizedManagersEntry.class, i18n.translateString("ReadCommunity"), (Object)instance, (Object)((SNMPTableMO)managedObjects.get(0))));
            }
            if (invalidCommunityWrite) {
                invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidWriteAddress", new Object[]{String.valueOf(i + 1)}), RbAuthorizedManagersEntry.class, i18n.translateString("WriteCommunity"), (Object)instance, (Object)((SNMPTableMO)managedObjects.get(0))));
            }
            if (invalidCommunityRead || invalidCommunityWrite) continue;
            logger.debug((Object)("Instance is :" + instance));
            switch (model.getRowState(i)) {
                case 3: {
                    RbAuthorizedManagersEntry entry = (RbAuthorizedManagersEntry)authorizedManagersTable.findEntry(instance);
                    entry.setAuthMngrReadCommunity((String)model.getValueAt(i, 1));
                    entry.setAuthMngrWriteCommunity((String)model.getValueAt(i, 2));
                    entry.setAuthMngrTrapEnable((Boolean)model.getValueAt(i, 3) != false ? 1 : 2);
                    continue block5;
                }
                case 1: {
                    authorizedManagersTable.removeEntry(instance);
                    continue block5;
                }
                case 2: {
                    RbAuthorizedManagersEntry entry;
                    String ip = (String)model.getValueAt(i, 0);
                    boolean found = false;
                    for (RbAuthorizedManagersEntry authMgr : authorizedManagersTable.getEntries()) {
                        if (!ip.equals(authMgr.getAuthMngrIpAddr())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        entry = new RbAuthorizedManagersEntry();
                        entry.setAuthMngrIpAddr((String)model.getValueAt(i, 0));
                        entry.setAuthMngrReadCommunity((String)model.getValueAt(i, 1));
                        entry.setAuthMngrWriteCommunity((String)model.getValueAt(i, 2));
                        entry.setAuthMngrTrapEnable(model.getValueAt(i, 3) == null || (Boolean)model.getValueAt(i, 3) == false ? 2 : 1);
                        if (!invalidValues.isEmpty()) continue block5;
                        authorizedManagersTable.addEntry((TableRowMO)entry);
                        continue block5;
                    }
                    invalidValues.add(new InvalidValue(i18n.translateString("UniqueValue"), RbAuthorizedManagersEntry.class, "authMngrIpAddr", (Object)ip, null));
                }
            }
        }
    }

    public String getTitle() {
        return "AuthorizedManagers";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.authorized_managers";
        }
        return "ngnms.rb.help.tdd_authorized_managers";
    }

    public boolean forceRefresh() {
        RbBaseStationEquipment bsEq = (RbBaseStationEquipment)this.ctx.getEquipment();
        return null == bsEq || bsEq.getSoftwareVersion().isOlderThan((Version)new DefaultVersion("3.0"));
    }
}

