/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbAuCommand;
import com.bwanms.rb.gui.configuration.AuUnitControlPanel;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.model.RbBS;
import com.bwanms.security.Security;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuUnitControlConfigForm
extends ManagedObjectsConfigForm<AuUnitControlPanel> {
    private static final Log log = LogFactory.getLog(AuUnitControlConfigForm.class);
    private RbAuConfigTable cfgTbl;

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest(this.ctx.getEquipment().getId(), "BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest(this.ctx.getEquipment().getId(), "BS", RbAuConfigTable.class));
        return ret;
    }

    protected AuUnitControlPanel initUIComponent() {
        return new AuUnitControlPanel(this);
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
        if (!auEntry.isConnected()) {
            return;
        }
        RbAuConfigTable cfgTbl = (RbAuConfigTable)((Object)managedObjects.get(1));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)cfgTbl.findEntry(auEntry.getRbSlotNumber().toString()));
        binder.add((Binding)new JTextFieldBinding("txtRuningSwVersion", "runingSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtMainSwVersion", "rbAuOperSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtShadowSwVersion", "rbAuShadowSwVersion"));
        binders.add((Binder)binder);
    }

    public void reset() {
        this.fireCommand(RbAuCommand.createResetCommand((RbBS)this.ctx.getEquipment(), (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"))));
    }

    public void perform() {
        RbAuConfigEntry rbAuAttribute = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
        RbAuConfigEntry rbAuConfigEntry = (RbAuConfigEntry)this.cfgTbl.findEntry(rbAuAttribute.getRowKey());
        int cmd = (Integer)((ComboItem)((AuUnitControlPanel)this.getUI()).getCmbAction().getSelectedItem()).getValue();
        String fileName = (String)FormUtil.getSelectedValue((JComboBox)((AuUnitControlPanel)this.getUI()).getCmbFileName());
        if (cmd == 3) {
            if (rbAuConfigEntry != null && fileName.equals(rbAuConfigEntry.getRbAuOperSwFileName())) {
                MessageBox.Info.showOption((Component)this.getUI(), AuUnitControlPanel.i18n.translateString("CannotLoadVersionToShadow") + "\n" + AuUnitControlPanel.i18n.translateString("VersionIsAlreadyPresentAsMain"));
                return;
            }
            if (fileName.equalsIgnoreCase("")) {
                MessageBox.Info.showOption((Component)this.getUI(), AuUnitControlPanel.i18n.translateString("CannotLoadVersionToShadow") + "\n" + AuUnitControlPanel.i18n.translateString("VersionIsEmpty"));
                return;
            }
        }
        if (cmd == 4 && fileName.equals("")) {
            fileName = rbAuConfigEntry.getRbAuShadowSwFileName();
        }
        if (cmd == 5 && fileName.equals("")) {
            fileName = rbAuConfigEntry.getRbAuShadowSwFileName();
        }
        this.fireCommand(RbAuCommand.createCommand((RbBS)this.ctx.getEquipment(), rbAuConfigEntry, cmd, fileName));
    }

    public void loadFactoryDflt() {
        RbAuConfigEntry rbAuConfigEntry = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
        if (rbAuConfigEntry != null) {
            this.fireCommand(RbAuCommand.createLoadFactoryDfltCommand((RbBS)this.ctx.getEquipment(), rbAuConfigEntry));
        }
    }

    public void fillUI(List<Object> managedObjects) {
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        this.cfgTbl = (RbAuConfigTable)((Object)managedObjects.get(1));
        RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
        auEntry = (RbAuConfigEntry)this.cfgTbl.findEntry(auEntry.getRbSlotNumber().toString());
        int oldSelectedIndex = ((AuUnitControlPanel)this.getUI()).getCmbFileName().getSelectedIndex();
        ((AuUnitControlPanel)this.getUI()).getCmbFileName().removeAllItems();
        ((AuUnitControlPanel)this.getUI()).getCmbFileName().addItem(new ComboItem((Object)"", AuUnitControlPanel.i18n.translateString("none")));
        if (swUpgrade != null && swUpgrade.getRbSwAuFiles().trim().length() > 0) {
            String[] fileNames;
            for (String fileName : fileNames = swUpgrade.getRbSwAuFiles().trim().split(";")) {
                ((AuUnitControlPanel)this.getUI()).getCmbFileName().addItem(new ComboItem((Object)fileName, fileName));
            }
        }
        if (oldSelectedIndex != -1) {
            ((AuUnitControlPanel)this.getUI()).getCmbFileName().setSelectedIndex(oldSelectedIndex);
        }
        if (!auEntry.isConnected()) {
            this.enableForm(false);
        } else {
            this.enableForm(true);
            String status = RbAuConfigEntry.toStringRbAuFaultStatus(auEntry.getRbAuFaultStatus());
            status = auEntry.isConnected() ? String.format("%s (%s)", AuUnitControlPanel.i18n.translateString("connected"), AuUnitControlPanel.i18n.translateString(status)) : AuUnitControlPanel.i18n.translateString(status);
            ((AuUnitControlPanel)this.getUI()).getTxtStatus().setText(status);
        }
    }

    private void enableForm(boolean enabled) {
        ((AuUnitControlPanel)this.getUI()).getTxtStatus().setText(AuUnitControlPanel.i18n.translateString("disconnected"));
        if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "write")) {
            ((AuUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(false);
            ((AuUnitControlPanel)this.getUI()).getBtnReset().setEnabled(false);
            ((AuUnitControlPanel)this.getUI()).getBtnPerform().setEnabled(false);
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_unit_control";
        }
        return "ngnms.rb.help.au_tdd_unit_control";
    }
}

