/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.AUSummaryPanelSW30;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbAuHwComponentsInfoEntry;
import com.bwanms.rb.mo.RbAuHwComponentsInfoTable;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUSummaryConfigFormSW30
extends ManagedObjectsConfigForm<AUSummaryPanelSW30> {
    private static final Logger log = Logger.getLogger(AUSummaryConfigFormSW30.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUSummaryConfigFormSW30.class);

    public AUSummaryPanelSW30 initUIComponent() {
        return new AUSummaryPanelSW30();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        final RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
        RbAuConfigTable cfgTbl = (RbAuConfigTable)((Object)managedObjects.get(0));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)cfgTbl.findEntry(key));
        binder.add((Binding)new JTextFieldBinding("txtTemperature", "rbAuIduTemperature", (ValueTranslator)new ParserValueTranslator(Integer.class), i18n.translateString("Temperature")));
        binder.add((Binding)new JTextFieldBinding("txtAirInterfaceType", "rbAuAirInterfaceType", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return i18n.translateString(RbAuConfigEntry.toStringRbAuAirInterfaceType(beanValue));
            }
        }, i18n.translateString("AirInterfaceType")));
        binder.add((Binding)new JTextFieldBinding("txtDiversityMode", "rbAuDiversityMode", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                if (bs.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1")) >= 0) {
                    return i18n.translateString(RbAuConfigEntry.toStringRbAuDiversityModeSw41(beanValue));
                }
                return i18n.translateString(RbAuConfigEntry.toStringRbAuDiversityMode(beanValue), new Object[]{beanValue});
            }
        }, i18n.translateString("DiversityMode")));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbAuConfigTable.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMacParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbAuHwComponentsInfoTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbAuConfigTable auConfigTable = (RbAuConfigTable)((Object)managedObjects.get(0));
        RbAuMacParametersGroup mac = (RbAuMacParametersGroup)((Object)managedObjects.get(1));
        RbAuHwComponentsInfoTable auHWTable = (RbAuHwComponentsInfoTable)((Object)managedObjects.get(2));
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
        RbAuConfigEntry auConfig = (RbAuConfigEntry)auConfigTable.findEntry(key);
        ((AUSummaryPanelSW30)this.getUI()).getTxtAuSlotId().setText(key);
        if (auConfig.isConnected()) {
            String crtBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuBaseStationId());
            RbAuHwComponentsInfoEntry auHWentry = (RbAuHwComponentsInfoEntry)auHWTable.findEntry(key);
            ((AUSummaryPanelSW30)this.getUI()).getTxtBSId().setText(crtBaseID);
            ((AUSummaryPanelSW30)this.getUI()).getTxtBSId().setSelectionStart(0);
            ((AUSummaryPanelSW30)this.getUI()).getTxtBSId().setSelectionEnd(0);
            ((AUSummaryPanelSW30)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(RbAuConfigEntry.toStringRbAuFaultStatus(auConfig.getRbAuFaultStatus())));
            ((AUSummaryPanelSW30)this.getUI()).getTxtRunningSw().setText(i18n.translateString(auConfig.toStringRbAuRunningSoftware(auConfig.getRbAuRunningSoftware())));
            ((AUSummaryPanelSW30)this.getUI()).getTxtOperationalSwVersion().setText(auConfig.getRbAuOperSwVersion());
            ((AUSummaryPanelSW30)this.getUI()).getTxtShadowSwVersion().setText(auConfig.getRbAuShadowSwVersion());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUSerialNumber().setText(auConfig.getRbAuSerialNo());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUBootVersion().setText(auHWentry.getRbAuIduBootVersion());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUIFCardHWConfig().setText(auHWentry.getRbAuIduIfCardConfiguration());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUIFCardHWRevision().setText(auHWentry.getRbAuIduIfCardRevision());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUMainCardHWConfig().setText(auConfig.getRbAuIduHwConfigDescription());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUMainCardHWRevision().setText(auConfig.getRbAuIduHwRevision());
            ((AUSummaryPanelSW30)this.getUI()).getTxtCumulativePowerOnTime().setText(auConfig.getRbAuCumulativePowerOnTime().toString());
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUType().setText(i18n.translateString(RbAuHwComponentsInfoEntry.toStringRbAuIduType(auHWentry.getRbAuIduType())));
        } else {
            ((AUSummaryPanelSW30)this.getUI()).getTxtBSId().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(RbAuConfigEntry.toStringRbAuFaultStatus(5)));
            ((AUSummaryPanelSW30)this.getUI()).getTxtRunningSw().setText(i18n.translateString("NA"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtOperationalSwVersion().setText(i18n.translateString("NA"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtShadowSwVersion().setText(i18n.translateString("NA"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUSerialNumber().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUBootVersion().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUIFCardHWConfig().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUIFCardHWRevision().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUMainCardHWConfig().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUMainCardHWRevision().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtCumulativePowerOnTime().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtIDUType().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanelSW30)this.getUI()).getTxtTemperature().setText(i18n.translateString("NAAu"));
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_view";
        }
        return "ngnms.rb.help.au_tdd_view";
    }
}

