/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.AUSummaryPanel;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbAuHwComponentsInfoEntry;
import com.bwanms.rb.mo.RbAuHwComponentsInfoTable;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUSummaryConfigForm
extends ManagedObjectsConfigForm<AUSummaryPanel> {
    private static final Logger log = Logger.getLogger(AUSummaryConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUSummaryConfigForm.class);

    public AUSummaryPanel initUIComponent() {
        return new AUSummaryPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbAuConfigTable.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMacParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbAuHwComponentsInfoTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbAuConfigTable auConfigTable = (RbAuConfigTable)((Object)managedObjects.get(0));
        RbAuMacParametersGroup mac = (RbAuMacParametersGroup)((Object)managedObjects.get(1));
        RbAuHwComponentsInfoTable auHWTable = (RbAuHwComponentsInfoTable)((Object)managedObjects.get(2));
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
        RbAuConfigEntry auConfig = (RbAuConfigEntry)auConfigTable.findEntry(key);
        ((AUSummaryPanel)this.getUI()).getTxtAuSlotId().setText(key);
        if (auConfig.isConnected()) {
            String crtBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuBaseStationId());
            RbAuHwComponentsInfoEntry auHWentry = (RbAuHwComponentsInfoEntry)auHWTable.findEntry(key);
            ((AUSummaryPanel)this.getUI()).getTxtBSId().setText(crtBaseID);
            ((AUSummaryPanel)this.getUI()).getTxtBSId().setSelectionStart(0);
            ((AUSummaryPanel)this.getUI()).getTxtBSId().setSelectionEnd(0);
            ((AUSummaryPanel)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(RbAuConfigEntry.toStringRbAuFaultStatus(auConfig.getRbAuFaultStatus())));
            ((AUSummaryPanel)this.getUI()).getTxtRunningSw().setText(i18n.translateString(auConfig.toStringRbAuRunningSoftware(auConfig.getRbAuRunningSoftware())));
            ((AUSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setText(auConfig.getRbAuOperSwVersion());
            ((AUSummaryPanel)this.getUI()).getTxtShadowSwVersion().setText(auConfig.getRbAuShadowSwVersion());
            ((AUSummaryPanel)this.getUI()).getTxtIDUSerialNumber().setText(auConfig.getRbAuSerialNo());
            ((AUSummaryPanel)this.getUI()).getTxtIDUBootVersion().setText(auHWentry.getRbAuIduBootVersion());
            ((AUSummaryPanel)this.getUI()).getTxtIDUIFCardHWConfig().setText(auHWentry.getRbAuIduIfCardConfiguration());
            ((AUSummaryPanel)this.getUI()).getTxtIDUIFCardHWRevision().setText(auHWentry.getRbAuIduIfCardRevision());
            ((AUSummaryPanel)this.getUI()).getTxtIDUMainCardHWConfig().setText(auConfig.getRbAuIduHwConfigDescription());
            ((AUSummaryPanel)this.getUI()).getTxtIDUMainCardHWRevision().setText(auConfig.getRbAuIduHwRevision());
            ((AUSummaryPanel)this.getUI()).getTxtCumulativePowerOnTime().setText(auConfig.getRbAuCumulativePowerOnTime().toString());
            ((AUSummaryPanel)this.getUI()).getTxtIDUType().setText(i18n.translateString(RbAuHwComponentsInfoEntry.toStringRbAuIduType(auHWentry.getRbAuIduType())));
        } else {
            ((AUSummaryPanel)this.getUI()).getTxtBSId().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(RbAuConfigEntry.toStringRbAuFaultStatus(5)));
            ((AUSummaryPanel)this.getUI()).getTxtRunningSw().setText(i18n.translateString("NA"));
            ((AUSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setText(i18n.translateString("NA"));
            ((AUSummaryPanel)this.getUI()).getTxtShadowSwVersion().setText(i18n.translateString("NA"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUSerialNumber().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUBootVersion().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUIFCardHWConfig().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUIFCardHWRevision().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUMainCardHWConfig().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUMainCardHWRevision().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtCumulativePowerOnTime().setText(i18n.translateString("NAAu"));
            ((AUSummaryPanel)this.getUI()).getTxtIDUType().setText(i18n.translateString("NAAu"));
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_view";
        }
        return "ngnms.rb.help.au_tdd_view";
    }
}

