/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AUSpectrumAnalysisPanel
extends JPanel {
    private static final long serialVersionUID = -75888455343223L;
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(AUSpectrumAnalysisPanel.class);
    public static final String SCAN_CHANNEL_4 = "ScanChannel4";
    public static final String SCAN_CHANNEL_3 = "ScanChannel3";
    public static final String SCAN_CHANNEL_2 = "ScanChannel2";
    public static final String SCAN_CHANNEL_1 = "ScanChannel1";
    public static final String[] SCAN_CHANNELS = new String[]{"ScanChannel1", "ScanChannel2", "ScanChannel3", "ScanChannel4"};
    public static final String RESULTS_NUMBER = i18n.translateString("ResultsNumber");
    public static final String RESULTS_FREQUENCY = i18n.translateString("ResultsFrequency");
    public static final String RESULTS_AVERAGE_RSSI = i18n.translateString("ResultsAverageRSSI");
    public static final String RESULTS_MAX_HOLD_FREQ = i18n.translateString("ResultsMaxHoldFreq");
    public static final String RESULTS_MAX_HOLD_RSSI = i18n.translateString("ResultsMaxHoldRSSI");
    public static final int CHANNEL_4 = 4;
    public static final int CHANNEL_3 = 3;
    public static final int CHANNEL_2 = 2;
    public static final int CHANNEL_1 = 1;
    public static final String SCAN_STEP_5 = "5";
    public static final String SCAN_STEP_3_5 = "3.5";
    public static final String SCAN_STEP_2_5 = "2.5";
    public static final String SCAN_STEP_1_75 = "1.75";
    public static final int COL_NUMBER = 5;
    public static final int NUMBER_COL_WIDTH = 35;
    public static final int NUMBER_COL = 0;
    public static final int FREQ_COL = 1;
    public static final int AVERAGE_RSSI_COL = 2;
    public static final int MAX_HOLD_FREQ_COL = 3;
    public static final int MAX_HOLD_RSSI_COL = 4;
    private JComponent separator7;
    private JLabel channelLbl;
    private JComboBox channelCmb;
    private JButton spectrumAnalysisBtn;
    private JLabel startFrequencyLbl;
    private JTextField startFrequencyTxt;
    private JButton displayChartBtn;
    private JLabel stopFrequencyLbl;
    private JTextField stopFrequencyTxt;
    private JLabel scanStepLbl;
    private JComboBox scanStepCmb;
    private JLabel scanTimeLbl;
    private JSpinner scanTimeSpinner;
    private JLabel currentStatusLbl;
    private JTextField currentStatusTxt;
    private JComponent separator8;
    private JButton exportBtn;
    private JScrollPane scrollPane7;
    private JTable spectrumAnalysisTbl;

    public AUSpectrumAnalysisPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        this.postSpectrumAnalysisResultsTable();
        this.postCombos();
    }

    private void postCombos() {
        this.postChannelCombo();
        this.postScanStepCombo();
    }

    private void postSpectrumAnalysisResultsTable() {
        SimpleRowTableModel spectrumAnalysisTableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(RESULTS_NUMBER, Integer.class), new SimpleRowTableModel.ColumnDefinition(RESULTS_FREQUENCY, String.class), new SimpleRowTableModel.ColumnDefinition(RESULTS_AVERAGE_RSSI, Integer.class), new SimpleRowTableModel.ColumnDefinition(RESULTS_MAX_HOLD_FREQ, String.class), new SimpleRowTableModel.ColumnDefinition(RESULTS_MAX_HOLD_RSSI, Integer.class)}, this.spectrumAnalysisTbl.getTableHeader());
        new SimpleRowTable(this.spectrumAnalysisTbl, spectrumAnalysisTableModel, null);
        for (int col = 0; col <= 4; ++col) {
            spectrumAnalysisTableModel.setColumnReadonly(col, true);
        }
        TableColumn colModel = ((DefaultTableColumnModel)this.spectrumAnalysisTbl.getColumnModel()).getColumn(0);
        colModel.setMaxWidth(35);
        ListSelectionModel selectionModel = this.spectrumAnalysisTbl.getSelectionModel();
        selectionModel.setSelectionMode(0);
    }

    private void postChannelCombo() {
        ComboItem[] channelItems = new ComboItem[]{new ComboItem((Object)1, SCAN_CHANNEL_1), new ComboItem((Object)2, SCAN_CHANNEL_2), new ComboItem((Object)3, SCAN_CHANNEL_3), new ComboItem((Object)4, SCAN_CHANNEL_4)};
        this.channelCmb.setModel(new DefaultComboBoxModel<ComboItem>(channelItems));
        i18n.getSwingInternationalizer().translateCombo(this.channelCmb);
    }

    private void postScanStepCombo() {
        ComboItem[] scanStepItems = new ComboItem[]{new ComboItem((Object)SCAN_STEP_1_75, SCAN_STEP_1_75), new ComboItem((Object)"3.500", SCAN_STEP_3_5), new ComboItem((Object)"2.500", SCAN_STEP_2_5), new ComboItem((Object)SCAN_STEP_5, SCAN_STEP_5)};
        this.scanStepCmb.setModel(new DefaultComboBoxModel<ComboItem>(scanStepItems));
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.separator7 = compFactory.createSeparator("SpectrumAnalysisParameters");
        this.channelLbl = new JLabel();
        this.channelCmb = new JComboBox();
        this.spectrumAnalysisBtn = new JButton();
        this.startFrequencyLbl = new JLabel();
        this.startFrequencyTxt = new JTextField();
        this.displayChartBtn = new JButton();
        this.stopFrequencyLbl = new JLabel();
        this.stopFrequencyTxt = new JTextField();
        this.scanStepLbl = new JLabel();
        this.scanStepCmb = new JComboBox();
        this.scanTimeLbl = new JLabel();
        this.scanTimeSpinner = new JSpinner();
        this.currentStatusLbl = new JLabel();
        this.currentStatusTxt = new JTextField();
        this.separator8 = compFactory.createSeparator("SpectrumAnalysisTable");
        this.exportBtn = new JButton();
        this.scrollPane7 = new JScrollPane();
        this.spectrumAnalysisTbl = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(Borders.createEmptyBorder((String)"5dlu, 5dlu, 5dlu, 5dlu"));
        this.setMinimumSize(new Dimension(653, 495));
        this.setPreferredSize(null);
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)30), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)90)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)70)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)20)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.dluY((int)135), 0.0)}));
        this.add((Component)this.separator7, cc.xywh(1, 1, 13, 1));
        this.channelLbl.setText("SpectrumChannel");
        this.channelLbl.setHorizontalAlignment(4);
        this.add((Component)this.channelLbl, cc.xywh(3, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.channelCmb, cc.xy(5, 3));
        this.spectrumAnalysisBtn.setText("StartSpectrumAnalysis");
        this.add((Component)this.spectrumAnalysisBtn, cc.xywh(9, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.startFrequencyLbl.setText("SpecStartFrequency");
        this.startFrequencyLbl.setLabelFor(this.startFrequencyTxt);
        this.add((Component)this.startFrequencyLbl, cc.xywh(3, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.startFrequencyTxt, cc.xy(5, 5));
        this.displayChartBtn.setText("DisplayChart");
        this.add((Component)this.displayChartBtn, cc.xy(9, 5));
        this.stopFrequencyLbl.setText("SpecStopFrequency");
        this.stopFrequencyLbl.setLabelFor(this.stopFrequencyTxt);
        this.add((Component)this.stopFrequencyLbl, cc.xywh(3, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.stopFrequencyTxt, cc.xy(5, 7));
        this.scanStepLbl.setText("ScanStep");
        this.scanStepLbl.setLabelFor(this.scanStepCmb);
        this.add((Component)this.scanStepLbl, cc.xywh(3, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.scanStepCmb, cc.xy(5, 9));
        this.scanTimeLbl.setText("ScanTime");
        this.scanTimeLbl.setLabelFor(this.scanTimeSpinner);
        this.add((Component)this.scanTimeLbl, cc.xywh(3, 11, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.scanTimeSpinner.setModel(new SpinnerNumberModel((Number)0L, null, null, (Number)1L));
        this.add((Component)this.scanTimeSpinner, cc.xy(5, 11));
        this.currentStatusLbl.setText("CurrentStatus");
        this.currentStatusLbl.setHorizontalAlignment(4);
        this.currentStatusLbl.setLabelFor(this.currentStatusTxt);
        this.add((Component)this.currentStatusLbl, cc.xywh(3, 13, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.currentStatusTxt.setEditable(false);
        this.add((Component)this.currentStatusTxt, cc.xy(5, 13));
        this.add((Component)this.separator8, cc.xywh(1, 17, 13, 1));
        this.exportBtn.setText("Export");
        this.add((Component)this.exportBtn, cc.xy(9, 19));
        this.scrollPane7.setAutoscrolls(true);
        this.spectrumAnalysisTbl.setModel(new DefaultTableModel());
        this.spectrumAnalysisTbl.setPreferredScrollableViewportSize(new Dimension(450, 80));
        this.scrollPane7.setViewportView(this.spectrumAnalysisTbl);
        this.add((Component)this.scrollPane7, cc.xywh(3, 21, 9, 1));
    }

    public JComboBox getChannelCmb() {
        return this.channelCmb;
    }

    public JComboBox getScanStepCmb() {
        return this.scanStepCmb;
    }

    public JTextField getStartFrequencyTxt() {
        return this.startFrequencyTxt;
    }

    public JSpinner getScanTimeSpinner() {
        return this.scanTimeSpinner;
    }

    public JTextField getStopFrequencyTxt() {
        return this.stopFrequencyTxt;
    }

    public JButton getSpectrumAnalysisBtn() {
        return this.spectrumAnalysisBtn;
    }

    public JTextField getCurrentStatusTxt() {
        return this.currentStatusTxt;
    }

    public JTable getSpectrumAnalysisTbl() {
        return this.spectrumAnalysisTbl;
    }

    public JButton getExportBtn() {
        return this.exportBtn;
    }

    public JButton getDisplayChartBtn() {
        return this.displayChartBtn;
    }
}

