/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.ngnms.apps.pmcollection.AvMultiGraphStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;

public class AUSpectrumAnalysisChartPanel
extends JPanel {
    private JDialog parent;
    private static final long serialVersionUID = 56454612387923218L;
    String chartName = null;
    JCChart currentChart = null;
    JCAxis xAxis = null;
    JCAxis yAxis = null;

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    public JDialog getParent() {
        return this.parent;
    }

    public AUSpectrumAnalysisChartPanel(String pChartName) {
        this.chartName = pChartName;
    }

    public void init() {
        this.setLayout(new GridLayout(1, 1));
        this.currentChart = new JCChart(0);
        this.xAxis = this.currentChart.getDataView(0).getXAxis();
        this.yAxis = this.currentChart.getDataView(0).getYAxis();
        this.currentChart.getHeader().setIsShowing(true);
        this.currentChart.getFooter().setIsShowing(true);
        this.currentChart.getLegend().setIsShowing(true);
        JScrollPane scrollPane = new JScrollPane((Component)this.currentChart);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.add(scrollPane);
        this.currentChart.getHeader().getLabel().setText("[FONT=TimesRoman-bold-16]" + this.chartName, true);
        this.currentChart.getHeader().setForeground(Color.black);
        this.currentChart.getChartArea().setBackground(Color.white);
        this.currentChart.getChartArea().setBorderType(3);
        this.currentChart.getChartArea().setBorderWidth(2);
        this.currentChart.getLegend().setBorderType(1);
        this.currentChart.getLegend().setBorderWidth(1);
        this.currentChart.getChartArea().setFont(new Font("Helvetica", 0, 12));
        this.currentChart.getLegend().setFont(new Font("Helvetica", 0, 12));
        this.currentChart.getDataView(0).setAutoLabel(true);
        this.setStyle(AvMultiGraphStyle.getDefaultStyle());
    }

    public void setStyle(String pStyle) {
        AvMultiGraphStyle style = new AvMultiGraphStyle(pStyle);
        if (style.getProperty("background-color") != null) {
            this.setBackground(AvMultiGraphStyle.getColor((String)style.getProperty("background-color")));
        }
        if (style.getProperty("chart-background-color") != null) {
            this.currentChart.getChartArea().setBackground(AvMultiGraphStyle.getColor((String)style.getProperty("chart-background-color")));
        }
        this.currentChart.getChartArea().setFont(new Font(style.getProperty("chart-font", "Helvetica"), AvMultiGraphStyle.getFontStyle((String)style.getProperty("chart-font-style", "normal")), Integer.parseInt(style.getProperty("chart-font-size", "12"))));
        this.currentChart.getChartArea().setAxisBoundingBox(false);
        this.currentChart.getChartArea().setBorderType(3);
        this.currentChart.getChartArea().setBorderWidth(2);
        if (style.getProperty("legend-background-color") != null) {
            this.currentChart.getLegend().setBackground(AvMultiGraphStyle.getColor((String)style.getProperty("legend-background-color")));
        }
        this.currentChart.getLegend().setFont(new Font(style.getProperty("legend-font", "Helvetica"), AvMultiGraphStyle.getFontStyle((String)style.getProperty("legend-font-style", "normal")), Integer.parseInt(style.getProperty("legend-font-size", "11"))));
        this.currentChart.getLegend().setForeground(AvMultiGraphStyle.getColor((String)style.getProperty("legend-foreground-color", "#000000")));
        this.currentChart.getLegend().setBorderType(1);
        this.currentChart.getLegend().setBorderWidth(1);
        this.currentChart.getLegend().setAnchor(34);
        String[] axisPrefixes = new String[]{"x-", "y-"};
        JCAxis[] axisDefs = new JCAxis[]{this.xAxis, this.yAxis};
        for (int i = 0; i < 2; ++i) {
            String prefix = axisPrefixes[i];
            JCAxis axis = axisDefs[i];
            axis.setFont(new Font(style.getProperty(prefix + "font", "Helvetica"), AvMultiGraphStyle.getFontStyle((String)style.getProperty(prefix + "font-style", "normal")), Integer.parseInt(style.getProperty(prefix + "font-size", "11"))));
            axis.setForeground(AvMultiGraphStyle.getColor((String)style.getProperty(prefix + "color", AvMultiGraphStyle.getColorString((Color)Color.lightGray.brighter()))));
            axis.setIsShowing(Boolean.valueOf(style.getProperty(prefix + "visible", "true")).booleanValue());
            axis.setGridIsShowing(Boolean.valueOf(style.getProperty(prefix + "grid-visible", "true")).booleanValue());
            Color gridColor = AvMultiGraphStyle.getColor((String)style.getProperty(prefix + "grid-color", "#C0C0C0"));
            axis.getGridStyle().setLineColor(gridColor);
            axis.getGridStyle().setLineWidth(1);
            axis.getGridStyle().setLinePattern(1);
        }
    }

    public JCChart getCurrentChart() {
        return this.currentChart;
    }
}

