/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.AUChannelPanel;
import com.bwanms.rb.gui.configuration.OutdoorUnitDetailsPanel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AUChannelPanelController
extends SimpleRowTableModelPanelController {
    private static Logger logger = Logger.getLogger(AUChannelPanelController.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUChannelPanelController.class);
    private AUChannelPanel form;
    private Map<Integer, String[]> oduDetails;

    public AUChannelPanelController(AUChannelPanel form) {
        this.form = form;
        this.oduDetails = new HashMap<Integer, String[]>();
    }

    protected JComponent getForm() {
        return this.form;
    }

    public void btnDetailsMouseClicked() {
        JLabel lblStatusMask;
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        SimpleRowTableModel model = this.getTableModel();
        Integer oduID = (Integer)model.getValueAt(row, 1);
        System.out.println("Should display details for ID " + this.getTable().getValueAt(row, 0));
        OutdoorUnitDetailsPanel detailsPanel = new OutdoorUnitDetailsPanel();
        Container topLevelParent = null;
        if (this.getForm() != null) {
            topLevelParent = this.getForm().getTopLevelAncestor();
        }
        JDialog dlg = new JDialog();
        dlg = topLevelParent instanceof Frame ? new JDialog((Frame)topLevelParent) : (topLevelParent instanceof Dialog ? new JDialog((Dialog)topLevelParent) : new JDialog());
        final JDialog dialog = dlg;
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                dialog.dispose();
                super.windowClosing(e);
            }
        });
        KeyAdapter theListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    dialog.dispose();
                }
            }
        };
        dialog.setTitle(i18n.translateString("ODUDetails"));
        dialog.setModal(true);
        dialog.add(detailsPanel);
        detailsPanel.setParent(dialog);
        FrameUtil.addKeyListenerRecursively((Component)dialog, (KeyAdapter)theListener);
        detailsPanel.getTxtCardSerialNumber().setText(this.oduDetails.get(oduID)[0]);
        detailsPanel.getTxtHWRevision().setText(this.oduDetails.get(oduID)[1]);
        detailsPanel.getTxtHWConfiguration().setText(this.oduDetails.get(oduID)[2]);
        detailsPanel.getTxtHC08Version().setText(this.oduDetails.get(oduID)[3]);
        detailsPanel.getTxtCPLDVersion().setText(this.oduDetails.get(oduID)[4]);
        detailsPanel.getTxtTemperature().setText(this.oduDetails.get(oduID)[5]);
        detailsPanel.getTxtMaxTxPower().setText(this.oduDetails.get(oduID)[6]);
        JTextField txtStatusMask = detailsPanel.getTxtStatusMask();
        JTextField txtRxCableLoss = detailsPanel.getTxtRxCableLoss();
        try {
            txtStatusMask.setText(this.oduDetails.get(oduID)[7]);
            txtRxCableLoss.setText(this.oduDetails.get(oduID)[8]);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            logger.debug((Object)"Older version than 4.1.1.1,this parameters are not available");
            txtStatusMask.setVisible(false);
            txtRxCableLoss.setVisible(false);
            lblStatusMask = detailsPanel.getLblStatusMask();
            lblStatusMask.setVisible(false);
            JLabel lblRxCableLoss = detailsPanel.getLblRxCableLoss();
            lblRxCableLoss.setVisible(false);
        }
        catch (NullPointerException e) {
            logger.debug((Object)"Older version than 4.1.1.1,this parameters are not available");
            txtStatusMask.setVisible(false);
            txtRxCableLoss.setVisible(false);
            lblStatusMask = detailsPanel.getLblStatusMask();
            lblStatusMask.setVisible(false);
            JLabel lblRxCableLoss = detailsPanel.getLblRxCableLoss();
            lblRxCableLoss.setVisible(false);
        }
        detailsPanel.getLblChannel().setVisible(false);
        detailsPanel.getTxtChannel().setVisible(false);
        detailsPanel.getlblConnectedAUSlotNr().setVisible(false);
        detailsPanel.getTxtConnectedAUSlotNr().setVisible(false);
        int maxWidth = (int)dialog.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)dialog.getGraphicsConfiguration().getBounds().getHeight();
        dialog.setSize(320, 250);
        dialog.pack();
        dialog.setLocation((maxWidth - 320) / 2, (maxHeight - 400) / 2);
        dialog.setVisible(true);
    }

    public void controlTableButtons() {
        super.controlTableButtons();
        int row = this.getTable().getSelectedRow();
        if (row < 0 || row >= this.getTableModel().getRowCount()) {
            this.getRevertButton().setEnabled(false);
            this.getDetailsButton().setEnabled(false);
            return;
        }
        if (this.getTableModel().getRowState(row) == 0 || this.getTableModel().getRowState(row) == 3) {
            Integer oduID = (Integer)this.getTableModel().getValueAt(row, 1);
            if (oduID != null && oduID > 0) {
                this.getDetailsButton().setEnabled(true);
            } else {
                this.getDetailsButton().setEnabled(false);
            }
        } else {
            this.getDetailsButton().setEnabled(false);
        }
    }

    public void addDetails(Integer key, String[] data) {
        this.oduDetails.put(key, data);
    }

    public void resetDetails() {
        this.oduDetails.clear();
    }

    protected SimpleRowTableModel getTableModel() {
        return this.form.getTableModel();
    }

    protected JTable getTable() {
        return this.form.getTable();
    }

    protected JButton getRevertButton() {
        return this.form.getBtnRevert();
    }

    protected JButton getDetailsButton() {
        return this.form.getBtnDetails();
    }

    protected JButton getDeleteButton() {
        return new JButton();
    }
}

