/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.AUChannelPanelControllerSW30;
import com.bwanms.rb.gui.configuration.AUChannelPanelSW30;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUChannelConfigFormSW41
extends ManagedObjectsConfigForm<AUChannelPanelSW30> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUChannelConfigFormSW41.class);
    private static final Log log = LogFactory.getLog(AUChannelConfigFormSW41.class);
    private boolean applyPressed = false;
    private boolean softwareVersion45;
    private Object diversityMode;

    public AUChannelPanelSW30 initUIComponent() {
        AUChannelPanelSW30 panel = new AUChannelPanelSW30();
        panel.getCmbDiversityMode().addItem(new ComboItem((Object)3, i18n.translateString(RbAuConfigEntry.toStringRbAuDiversityModeSw41(3))));
        panel.getCmbDiversityMode().addItem(new ComboItem((Object)4, i18n.translateString(RbAuConfigEntry.toStringRbAuDiversityModeSw41(4))));
        return panel;
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuChannelConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbFrequencyBandsTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuPhyParametersGroup.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        JTable table = ((AUChannelPanelSW30)this.getUI()).getTable();
        FormUtil.cancelTableEditing((JTable)table);
        ROTableModel tableModel = ((AUChannelPanelSW30)this.getUI()).getTableModel();
        tableModel.clearTable();
        for (int i = 0; i < 4; ++i) {
            tableModel.addNewRow(null, true);
        }
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
        RbAuConfigTable auTable = (RbAuConfigTable)((Object)managedObjects.get(4));
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        bands.add(new ComboItem((Object)0, i18n.translateString("notDefined")));
        for (RbFrequencyBandsEntry entry : bandsTable.getEntries()) {
            bands.add(new ComboItem((Object)entry.getRbFrequencyBandId().intValue(), entry.getRbFrequencyBandName()));
        }
        tableModel.setValueSet(-1, 4, bands);
        tableModel.setValueSet(-1, 5, bands);
        String nrName = (String)this.ctx.getAttribute("NR");
        String slotNo = nrName.substring(nrName.indexOf(46) + 1);
        int slot = Integer.parseInt(slotNo);
        Integer diversity = ((RbAuConfigEntry)auTable.findEntry(slotNo)).getRbAuDiversityMode();
        RbAuConfigEntry auConfig = (RbAuConfigEntry)auTable.findEntry(slotNo);
        JComboBox cmbDiversityMode = ((AUChannelPanelSW30)this.getUI()).getCmbDiversityMode();
        this.diversityMode = cmbDiversityMode.getSelectedItem();
        boolean diversityOn = !diversity.equals(1);
        boolean is2ndOrder = diversity.equals(2);
        int rowCounter = 0;
        boolean firstChannelAdminStatusEnabled = false;
        for (RbAuChannelConfigEntry entry : auChannelTable.getEntries()) {
            boolean curentChannelAdminStatusEnabled;
            if (entry.getRbSlotNumber() != slot) continue;
            boolean bl = entry.getRbAuChannelAdminStatus() != null ? entry.getRbAuChannelAdminStatus() == 1 : (curentChannelAdminStatusEnabled = false);
            if (rowCounter == 0) {
                firstChannelAdminStatusEnabled = curentChannelAdminStatusEnabled;
            }
            RbOduConfigEntry oduEntry = null;
            Integer rbAuChannelAssociatedOduId = entry.getRbAuChannelAssociatedOduId();
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!e.getRbOduConfigId().equals(rbAuChannelAssociatedOduId)) continue;
                oduEntry = e;
                break;
            }
            rowCounter = entry.getRbAuChannelId() - 1;
            tableModel.setRowKey(rowCounter, entry.getRowKey());
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelId(), rowCounter, 0);
            if (entry.getRbAuChannelAssociatedOduId() > 0) {
                tableModel.setInitialValueAt((Object)entry.getRbAuChannelAssociatedOduId(), rowCounter, 1);
            }
            if (oduEntry != null) {
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduAssociatedRadioClusterId(), rowCounter, 2);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduTxPower(), rowCounter, 3);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduConfigFrequencyBand(), rowCounter, 4);
            } else {
                tableModel.setInitialValueAt((Object)0, rowCounter, 4);
            }
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelOduActualFrequencyBand(), rowCounter, 5);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelConfiguredTxFrequency(), rowCounter, 6);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelTxFrequency(), rowCounter, 7);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelRxFrequency(), rowCounter, 8);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelAdminStatus(), rowCounter, 9);
            if (!firstChannelAdminStatusEnabled) {
                if (diversityOn && rowCounter > 0) {
                    tableModel.setROCell(rowCounter, 6);
                    tableModel.setROCell(rowCounter, 9);
                }
                if (is2ndOrder && rowCounter > 1) {
                    tableModel.setROCell(rowCounter, 1);
                }
            } else if (diversityOn) {
                tableModel.setROCell(rowCounter, 1);
                tableModel.setROCell(rowCounter, 6);
                if (rowCounter > 0) {
                    tableModel.setROCell(rowCounter, 9);
                }
            }
            if (curentChannelAdminStatusEnabled) {
                tableModel.setROCell(rowCounter, 1);
                tableModel.setROCell(rowCounter, 6);
            }
            tableModel.setInitialValueAt((Object)i18n.translateString(entry.toStringRbAuChannelOperStatus(entry.getRbAuChannelOperStatus())), rowCounter, 10);
            if (oduEntry != null) {
                String[] stringsSW41 = new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString()};
                RbBS bs = (RbBS)this.ctx.getEquipment();
                Version softwareVersion = bs.getSoftwareVersion();
                AUChannelPanelControllerSW30 controller = ((AUChannelPanelSW30)this.getUI()).getController();
                if (softwareVersion.compareTo((Object)RbVersions.V_4_5) < 0) {
                    controller.addDetails(rbAuChannelAssociatedOduId, stringsSW41);
                }
                if (softwareVersion.compareTo((Object)RbVersions.V_4_5) >= 0) {
                    String[] stringsSW45 = new String[9];
                    for (int i = 0; i < 7; ++i) {
                        stringsSW45[i] = stringsSW41[i];
                    }
                    stringsSW45[7] = oduEntry.getRbOduStatusMask();
                    stringsSW45[8] = oduEntry.toStringRbOduGeneralDescription(oduEntry.getRbOduGeneralDescription());
                    controller.addDetails(rbAuChannelAssociatedOduId, stringsSW45);
                }
            }
            ++rowCounter;
        }
        TableUtil.autoResizeColumn((JTable)table, (int)0, (boolean)true);
        tableModel.sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String channelId = String.valueOf(formsConfigSectionView.getAttribute("channelId"));
        if (channelId != null) {
            try {
                int chanelIdInt = Integer.parseInt(channelId);
                ((AUChannelPanelSW30)this.getUI()).getTable().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((AUChannelPanelSW30)this.getUI()).getTable().clearSelection();
        }
        if (this.applyPressed) {
            this.applyPressed = false;
            this.getConfigSectionView().refresh(true);
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        ArrayList<RbAuChannelConfigEntry> auChannels;
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
        RbAuPhyParameters phyParams = (RbAuPhyParameters)((Object)managedObjects.get(3));
        RbAuConfigTable cfgTbl = (RbAuConfigTable)((Object)managedObjects.get(4));
        RbAuChannelConfigEntry entry = null;
        String nrName = (String)this.ctx.getAttribute("NR");
        String slotNo = nrName.substring(nrName.indexOf(46) + 1);
        RbAuConfigEntry auCfgEntry = (RbAuConfigEntry)cfgTbl.findEntry(slotNo);
        boolean is2ndOrder = auCfgEntry.getRbAuDiversityMode().equals(2);
        boolean is4thOrder = auCfgEntry.getRbAuDiversityMode() > 2;
        boolean chnlHasDiversity = is2ndOrder || is4thOrder;
        boolean oduChanged = false;
        Integer crtDiv = (Integer)((ComboItem)((AUChannelPanelSW30)this.getUI()).getCmbDiversityMode().getSelectedItem()).getValue();
        boolean entryIsDirty = false;
        double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(phyParams.getRbAuPhyConfiguredBandwidth());
        ROTableModel model = ((AUChannelPanelSW30)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((AUChannelPanelSW30)this.getUI()).getTable());
        HashSet<String> rowKeys = new HashSet<String>();
        HashMap<String, RbAuChannelConfigEntry> auChnlsByODU = new HashMap<String, RbAuChannelConfigEntry>();
        if (chnlHasDiversity) {
            rowKeys.add(model.getRowKey(model.getSortedIndexFromOriginalIndex(1)));
            if (is4thOrder || crtDiv > 2) {
                for (int j = 2; j < model.getRowCount(); ++j) {
                    rowKeys.add(model.getRowKey(model.getSortedIndexFromOriginalIndex(j)));
                }
            }
            auChannels = new ArrayList<RbAuChannelConfigEntry>();
            int sortedIndexOfRow0 = model.getSortedIndexFromOriginalIndex(0);
            for (RbAuChannelConfigEntry channel : auChannelTable.getEntries()) {
                if (rowKeys.contains(channel.getRowKey())) {
                    RbAuChannelConfigEntry cloneChnl = (RbAuChannelConfigEntry)channel.clone();
                    cloneChnl.setRbAuChannelAdminStatus((Integer)model.getValueAt(sortedIndexOfRow0, 9));
                    cloneChnl.setRbAuChannelConfiguredTxFrequency((String)model.getValueAt(sortedIndexOfRow0, 6));
                    cloneChnl.setRbAuChannelOduActualFrequencyBand((Integer)model.getValueAt(sortedIndexOfRow0, 4));
                    auChannels.add(cloneChnl);
                    auChnlsByODU.put(channel.getRowKey(), cloneChnl);
                    continue;
                }
                auChannels.add(channel);
            }
        } else {
            auChannels = auChannelTable.getEntries();
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            int unSortedI = model.modelIndex(i);
            boolean thisODUChanged = false;
            Integer oduId = (Integer)model.getValueAt(i, 1);
            if (model.getRowState(i) == 3) {
                RbFrequencyBandsEntry freqBand;
                if (null == oduId) {
                    oduId = 0;
                }
                String confTxFrequency = (String)model.getValueAt(i, 6);
                Double confTxFrequencyDouble = null;
                if (confTxFrequency == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbAuChannelConfigEntry.class, "NullConfiguredTxFrequencyError", (Object)"null", (Object)this));
                } else {
                    try {
                        confTxFrequencyDouble = Double.valueOf(confTxFrequency);
                    }
                    catch (NumberFormatException nfe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbAuChannelConfigEntry.class, i18n.translateString("NotNumberConfiguredTxFrequencyError"), (Object)confTxFrequency, (Object)this));
                    }
                }
                String rowKey = model.getRowKey(i);
                entry = (RbAuChannelConfigEntry)auChannelTable.findEntry(rowKey);
                if (!entry.getRbAuChannelAssociatedOduId().equals(oduId) && entry.getRbAuChannelId() != 1) {
                    thisODUChanged = true;
                    oduChanged = true;
                }
                if (!entry.getRbAuChannelAssociatedOduId().equals(oduId)) {
                    entryIsDirty = true;
                }
                entry.setRbAuChannelAssociatedOduId(oduId);
                if (entry.getRbAuChannelConfiguredTxFrequency() != null && !entry.getRbAuChannelConfiguredTxFrequency().equals(confTxFrequency)) {
                    entryIsDirty = true;
                }
                entry.setRbAuChannelConfiguredTxFrequency(String.format(Locale.ENGLISH, "%.3f", confTxFrequencyDouble));
                Integer adminStatus = (Integer)model.getValueAt(i, 9);
                if (!entry.getRbAuChannelAdminStatus().equals(adminStatus)) {
                    entryIsDirty = true;
                }
                entry.setRbAuChannelAdminStatus(adminStatus);
                if (oduId == 0 && Integer.valueOf(1).equals(entry.getRbAuChannelAdminStatus())) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)oduId, (Object)this));
                }
                RbOduConfigEntry oduEntry = null;
                for (RbOduConfigEntry e : oduTable.getEntries()) {
                    if (!oduId.equals(e.getRbOduConfigId())) continue;
                    oduEntry = e;
                    break;
                }
                RbFrequencyBandsEntry rbFrequencyBandsEntry = freqBand = oduEntry != null ? (RbFrequencyBandsEntry)bandsTable.findEntry(String.valueOf(oduEntry.getRbOduConfigFrequencyBand())) : null;
                if (freqBand != null && confTxFrequencyDouble != null) {
                    double startFreq = freqBand.getRbFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
                    double stopFreq = freqBand.getRbFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
                    if (model.isCellEditable(i, 6) && (confTxFrequencyDouble < startFreq || confTxFrequencyDouble > stopFreq) || (confTxFrequencyDouble - startFreq) * 1000.0 % (double)freqBand.getRbFrequencyBandStep().longValue() != 0.0) {
                        Object[] range = new Object[]{String.valueOf(startFreq), String.valueOf(stopFreq), String.valueOf(freqBand.getRbFrequencyBandStep().doubleValue() / 1000.0)};
                        invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetweenWithStep", range), RbAuChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                    }
                }
                this.checkAssocOduId(entry, auChannels, managedObjects, invalidValues, chnlHasDiversity);
                if (!model.isCellEditable(i, 6) && entryIsDirty) {
                    entry.setRbAuChannelConfiguredTxFrequency(null);
                }
                if (!model.isCellEditable(i, 9) && entryIsDirty) {
                    entry.setRbAuChannelAdminStatus(null);
                }
                if (!(!thisODUChanged || chnlHasDiversity && unSortedI != 0 || oduEntry == null || oduEntry.getRbOduConfigFrequencyBand() != null && oduEntry.getRbOduConfigFrequencyBand() != 0)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("AssocOduMustHaveConfiguredBandDefined"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entry.getRbAuChannelAssociatedOduId(), (Object)this));
                }
            } else if (chnlHasDiversity) {
                if (oduId == null && model.getValueAt(model.getSortedIndexFromOriginalIndex(0), 9).equals(1)) {
                    if (unSortedI == 1 && is2ndOrder || unSortedI > 0 && is4thOrder) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)"0", (Object)this));
                    }
                } else {
                    this.checkAssocOduId((RbAuChannelConfigEntry)((Object)auChnlsByODU.get(model.getRowKey(i))), auChannels, managedObjects, invalidValues, chnlHasDiversity);
                }
            }
            auChnlsByODU.remove(model.getRowKey(i));
        }
        this.checkOduAssoc(invalidValues, is2ndOrder, auChannelTable, slotNo);
        RbAuChannelConfigEntry firstChnl = (RbAuChannelConfigEntry)auChannelTable.findEntry(slotNo + ".1");
        if (oduChanged && chnlHasDiversity && firstChnl.getRbAuChannelAdminStatus().equals(1)) {
            invalidValues.add(new InvalidValue(i18n.translateString("FirstApplyODUChanges"), RbAuChannelConfigEntry.class, i18n.translateString("AdminStatus"), (Object)i18n.translateString("Enable"), (Object)this));
        }
    }

    private void checkOduAssoc(List<InvalidValue> invalidValues, boolean is2ndOrder, RbAuChannelConfigTable auChannelTable, String slotNo) {
        if (!is2ndOrder) {
            return;
        }
        ComboItem diversity = (ComboItem)((AUChannelPanelSW30)this.getUI()).getCmbDiversityMode().getSelectedItem();
        if ((Integer)diversity.getValue() <= 2) {
            return;
        }
        RbAuChannelConfigEntry firstChnl = (RbAuChannelConfigEntry)auChannelTable.findEntry(slotNo + ".1");
        if (firstChnl == null) {
            return;
        }
        if (!firstChnl.getRbAuChannelAdminStatus().equals(1)) {
            return;
        }
        this.checkChannel(invalidValues, (RbAuChannelConfigEntry)auChannelTable.findEntry(slotNo + ".3"));
        this.checkChannel(invalidValues, (RbAuChannelConfigEntry)auChannelTable.findEntry(slotNo + ".4"));
    }

    private void checkChannel(List<InvalidValue> invalidValues, RbAuChannelConfigEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.getRbAuChannelAssociatedOduId().equals(0)) {
            invalidValues.add(new InvalidValue(i18n.translateString("ChannelMustHaveAssocODU"), RbAuChannelConfigEntry.class, i18n.translateString("Channel"), (Object)entry.getRbAuChannelId(), (Object)this));
        }
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder tblBinder = new TableBinder(i18n, (SimpleRowTableModel)((AUChannelPanelSW30)this.getUI()).getTableModel(), (SNMPTableMO)managedObjects.get(0));
        tblBinder.add((Binding)new TableColumnBinding("AssocODU", "rbAuChannelAssociatedOduId"));
        tblBinder.add((Binding)new TableColumnBinding("AdminStatus", "rbAuChannelAdminStatus"));
        binders.add((Binder)tblBinder);
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
        RbAuConfigTable cfgTbl = (RbAuConfigTable)((Object)managedObjects.get(4));
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)cfgTbl.findEntry(key));
        JComboBoxBinding comboBoxBinding = new JComboBoxBinding(i18n, "cmbDiversityMode", "rbAuDiversityMode", i18n.translateString("DiversityMode"));
        comboBoxBinding.setIgnoreDisabled(true);
        binder.add((Binding)comboBoxBinding);
        binders.add((Binder)binder);
    }

    public String getTitle() {
        return "AUChannelConfigForm";
    }

    private void checkAssocOduId(RbAuChannelConfigEntry entry, List<RbAuChannelConfigEntry> auChannels, List<Object> managedObjects, List<InvalidValue> invalidValues, boolean chnlHasDiversity) {
        RbOduConfigEntry entryOdu;
        Integer adminStatusEnabled;
        RbOduConfigEntry odu;
        if (entry == null) {
            return;
        }
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        Integer entryOduId = entry.getRbAuChannelAssociatedOduId();
        if (entryOduId == null || entryOduId == 0) {
            return;
        }
        int[] validValues = new int[oduTable.getSize()];
        int count = 0;
        Iterator i$ = oduTable.getEntries().iterator();
        while (i$.hasNext() && !entryOduId.equals((odu = (RbOduConfigEntry)((Object)i$.next())).getRbOduConfigId())) {
            validValues[count++] = odu.getRbOduConfigId();
        }
        if (count == validValues.length) {
            Arrays.sort(validValues);
            invalidValues.add(new InvalidValue(i18n.translateString("AssocODUValidValuesAre", new Object[]{Arrays.toString(validValues)}), RbOduConfigTable.class, i18n.translateString("RowId", new Object[]{entry.getRbAuChannelId()}), (Object)entry.getRbAuChannelAssociatedOduId(), (Object)entry));
        }
        if ((adminStatusEnabled = Integer.valueOf(1)).equals(entry.getRbAuChannelAdminStatus()) && (entryOdu = (RbOduConfigEntry)oduTable.findEntry(entryOduId.toString())) != null) {
            Integer entryOduFreqBand = entryOdu.getRbOduConfigFrequencyBand();
            RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
            RbFrequencyBandsEntry currentFrequencyBandsEntry = (RbFrequencyBandsEntry)bandsTable.findEntry(entryOduFreqBand.toString());
            if (currentFrequencyBandsEntry != null) {
                ArrayList<Integer> validBandsList = new ArrayList<Integer>();
                for (RbFrequencyBandsEntry rbFrequencyBandsEntry : bandsTable.getEntries()) {
                    if (!rbFrequencyBandsEntry.getRbFrequencyBandGroupId().equals(currentFrequencyBandsEntry.getRbFrequencyBandGroupId())) continue;
                    validBandsList.add(rbFrequencyBandsEntry.getRbFrequencyBandId().intValue());
                }
                for (RbAuChannelConfigEntry channel : auChannels) {
                    Integer oduId;
                    if (!entry.getRbSlotNumber().equals(channel.getRbSlotNumber()) || !adminStatusEnabled.equals(channel.getRbAuChannelAdminStatus()) || entry.getRbAuChannelId().equals(channel.getRbAuChannelId()) || (oduId = channel.getRbAuChannelAssociatedOduId()) == null || oduId == 0) continue;
                    RbOduConfigEntry odu2 = (RbOduConfigEntry)oduTable.findEntry(oduId.toString());
                    if (chnlHasDiversity || odu2 == null || validBandsList.isEmpty() || validBandsList.contains(odu2.getRbOduConfigFrequencyBand())) continue;
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUDifferentFreqBand"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                    break;
                }
            }
        }
        if (adminStatusEnabled.equals(entry.getRbAuChannelAdminStatus())) {
            for (RbAuChannelConfigEntry channel : auChannels) {
                if (entry.getRbSlotNumber().equals(channel.getRbSlotNumber()) && entry.getRbAuChannelId().equals(channel.getRbAuChannelId()) || !entryOduId.equals(channel.getRbAuChannelAssociatedOduId()) || !adminStatusEnabled.equals(channel.getRbAuChannelAdminStatus())) continue;
                Object[] values = new Object[]{"AU" + channel.getRbSlotNumber() + " ", channel.getRbAuChannelId()};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                break;
            }
        }
    }

    public String warnApply() {
        this.applyPressed = true;
        Object o = ((AUChannelPanelSW30)this.getUI()).getCmbDiversityMode().getSelectedItem();
        if (this.diversityMode != null && !this.diversityMode.equals(o)) {
            return i18n.translateString("AutomaticallyResetOfTheAUByTheNPU");
        }
        return null;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_tdd_channels";
    }
}

