/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.AUChannelPanel;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUChannelConfigForm
extends ManagedObjectsConfigForm<AUChannelPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUChannelConfigForm.class);
    private static final Log log = LogFactory.getLog(AUChannelConfigForm.class);

    public AUChannelPanel initUIComponent() {
        return new AUChannelPanel();
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuChannelConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbFrequencyBandsTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuPhyParametersGroup.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        JTable table = ((AUChannelPanel)this.getUI()).getTable();
        FormUtil.cancelTableEditing((JTable)table);
        SimpleRowTableModel tableModel = ((AUChannelPanel)this.getUI()).getTableModel();
        tableModel.clearTable();
        for (int i = 0; i < 4; ++i) {
            tableModel.addNewRow(null, true);
        }
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        bands.add(new ComboItem((Object)0, i18n.translateString("notDefined")));
        for (RbFrequencyBandsEntry entry : bandsTable.getEntries()) {
            bands.add(new ComboItem((Object)entry.getRbFrequencyBandId().intValue(), entry.getRbFrequencyBandName()));
        }
        tableModel.setValueSet(-1, 4, bands);
        tableModel.setValueSet(-1, 5, bands);
        log.debug((Object)("+++++++++++++++++++++ ODU Table entries: " + oduTable.getSize()));
        String nrName = (String)this.ctx.getAttribute("NR");
        int slot = Integer.parseInt(nrName.substring(nrName.indexOf(46) + 1));
        int rowCounter = 0;
        for (RbAuChannelConfigEntry entry : auChannelTable.getEntries()) {
            if (entry.getRbSlotNumber() != slot) continue;
            RbOduConfigEntry oduEntry = null;
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!e.getRbOduConfigId().equals(entry.getRbAuChannelAssociatedOduId())) continue;
                oduEntry = e;
            }
            rowCounter = entry.getRbAuChannelId() - 1;
            tableModel.setRowKey(rowCounter, entry.getRowKey());
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelId(), rowCounter, 0);
            if (entry.getRbAuChannelAssociatedOduId() > 0) {
                tableModel.setInitialValueAt((Object)entry.getRbAuChannelAssociatedOduId(), rowCounter, 1);
            }
            if (oduEntry != null) {
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduAssociatedRadioClusterId(), rowCounter, 2);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduTxPower(), rowCounter, 3);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduConfigFrequencyBand(), rowCounter, 4);
            } else {
                tableModel.setInitialValueAt((Object)0, rowCounter, 4);
            }
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelOduActualFrequencyBand(), rowCounter, 5);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelConfiguredTxFrequency(), rowCounter, 6);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelTxFrequency(), rowCounter, 7);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelRxFrequency(), rowCounter, 8);
            tableModel.setInitialValueAt((Object)entry.getRbAuChannelAdminStatus(), rowCounter, 9);
            tableModel.setInitialValueAt((Object)i18n.translateString(entry.toStringRbAuChannelOperStatus(entry.getRbAuChannelOperStatus())), rowCounter, 10);
            if (oduEntry != null) {
                ((AUChannelPanel)this.getUI()).getController().addDetails(entry.getRbAuChannelAssociatedOduId(), new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString()});
            }
            ++rowCounter;
        }
        TableUtil.autoResizeColumn((JTable)table, (int)0, (boolean)true);
        tableModel.sort();
        String channelId = String.valueOf(((FormsConfigSectionView)this.getConfigSectionView()).getAttribute("channelId"));
        if (channelId != null) {
            try {
                int chanelIdInt = Integer.parseInt(channelId);
                ((AUChannelPanel)this.getUI()).getTable().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
        RbAuPhyParameters phyParams = (RbAuPhyParameters)((Object)managedObjects.get(3));
        double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(phyParams.getRbAuPhyConfiguredBandwidth());
        SimpleRowTableModel model = ((AUChannelPanel)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((AUChannelPanel)this.getUI()).getTable());
        for (int i = 0; i < model.getRowCount(); ++i) {
            RbFrequencyBandsEntry freqBand;
            if (model.getRowState(i) != 3) continue;
            Integer oduId = (Integer)model.getValueAt(i, 1);
            if (null == oduId) {
                oduId = 0;
            }
            String confTxFrequency = (String)model.getValueAt(i, 6);
            Double confTxFrequencyDouble = null;
            if (confTxFrequency == null) {
                invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbAuChannelConfigEntry.class, "NullConfiguredTxFrequencyError", (Object)"null", (Object)this));
            } else {
                try {
                    confTxFrequencyDouble = Double.valueOf(confTxFrequency);
                }
                catch (NumberFormatException nfe) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbAuChannelConfigEntry.class, i18n.translateString("NotNumberConfiguredTxFrequencyError"), (Object)confTxFrequency, (Object)this));
                }
            }
            String rowKey = model.getRowKey(i);
            RbAuChannelConfigEntry entry = (RbAuChannelConfigEntry)auChannelTable.findEntry(rowKey);
            entry.setRbAuChannelAssociatedOduId(oduId);
            entry.setRbAuChannelConfiguredTxFrequency(confTxFrequency);
            entry.setRbAuChannelAdminStatus((Integer)model.getValueAt(i, 9));
            if (oduId == 0 && Integer.valueOf(1).equals(entry.getRbAuChannelAdminStatus())) {
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbAuChannelConfigEntry.class, "rbAuChannelAssociatedOduId", (Object)oduId, (Object)this));
            }
            RbOduConfigEntry oduEntry = null;
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!oduId.equals(e.getRbOduConfigId())) continue;
                oduEntry = e;
                break;
            }
            RbFrequencyBandsEntry rbFrequencyBandsEntry = freqBand = oduEntry != null ? (RbFrequencyBandsEntry)bandsTable.findEntry(String.valueOf(oduEntry.getRbOduConfigFrequencyBand())) : null;
            if (freqBand != null && confTxFrequencyDouble != null) {
                double startFreq = freqBand.getRbFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
                double stopFreq = freqBand.getRbFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
                if (confTxFrequencyDouble < startFreq || confTxFrequencyDouble > stopFreq || (confTxFrequencyDouble - startFreq) * 1000.0 % (double)freqBand.getRbFrequencyBandStep().longValue() != 0.0) {
                    Object[] range = new Object[]{String.valueOf(startFreq), String.valueOf(stopFreq), String.valueOf(freqBand.getRbFrequencyBandStep().doubleValue() / 1000.0)};
                    invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetweenWithStep", range), RbAuChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                }
            }
            this.checkAssocOduId(entry, managedObjects, invalidValues);
        }
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, ((AUChannelPanel)this.getUI()).getTableModel(), (SNMPTableMO)managedObjects.get(0));
        binder.add((Binding)new TableColumnBinding("AssocODU", "rbAuChannelAssociatedOduId"));
        binder.add((Binding)new TableColumnBinding("AdminStatus", "rbAuChannelAdminStatus"));
        binders.add((Binder)binder);
    }

    public String getTitle() {
        return "AUChannelConfigForm";
    }

    private void checkAssocOduId(RbAuChannelConfigEntry entry, List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbOduConfigEntry entryOdu;
        Integer adminStatusEnabled;
        RbOduConfigEntry odu;
        RbAuChannelConfigTable channelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        Integer entryOduId = entry.getRbAuChannelAssociatedOduId();
        if (entryOduId == null || entryOduId == 0) {
            return;
        }
        int[] validValues = new int[oduTable.getSize()];
        int count = 0;
        Iterator i$ = oduTable.getEntries().iterator();
        while (i$.hasNext() && !entryOduId.equals((odu = (RbOduConfigEntry)((Object)i$.next())).getRbOduConfigId())) {
            validValues[count++] = odu.getRbOduConfigId();
        }
        if (count == validValues.length) {
            Arrays.sort(validValues);
            invalidValues.add(new InvalidValue(i18n.translateString("AssocODUValidValuesAre", new Object[]{Arrays.toString(validValues)}), RbOduConfigTable.class, i18n.translateString("RowId", new Object[]{entry.getRbAuChannelId()}), (Object)entry.getRbAuChannelAssociatedOduId(), (Object)entry));
        }
        if ((adminStatusEnabled = Integer.valueOf(1)).equals(entry.getRbAuChannelAdminStatus()) && (entryOdu = (RbOduConfigEntry)oduTable.findEntry(entryOduId.toString())) != null) {
            Integer entryOduFreqBand = entryOdu.getRbOduConfigFrequencyBand();
            RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
            RbFrequencyBandsEntry currentFrequencyBandsEntry = (RbFrequencyBandsEntry)bandsTable.findEntry(entryOduFreqBand.toString());
            if (currentFrequencyBandsEntry != null) {
                ArrayList<Integer> validBandsList = new ArrayList<Integer>();
                for (RbFrequencyBandsEntry rbFrequencyBandsEntry : bandsTable.getEntries()) {
                    if (!rbFrequencyBandsEntry.getRbFrequencyBandGroupId().equals(currentFrequencyBandsEntry.getRbFrequencyBandGroupId())) continue;
                    validBandsList.add(rbFrequencyBandsEntry.getRbFrequencyBandId().intValue());
                }
                for (RbAuChannelConfigEntry channel : channelTable.getEntries()) {
                    RbOduConfigEntry odu2;
                    Integer oduId;
                    if (!entry.getRbSlotNumber().equals(channel.getRbSlotNumber()) || !adminStatusEnabled.equals(channel.getRbAuChannelAdminStatus()) || entry.getRbAuChannelId().equals(channel.getRbAuChannelId()) || (oduId = channel.getRbAuChannelAssociatedOduId()) == null || (odu2 = (RbOduConfigEntry)oduTable.findEntry(oduId.toString())) == null || validBandsList.contains(odu2.getRbOduConfigFrequencyBand())) continue;
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUDifferentFreqBand"), RbAuChannelConfigEntry.class, "Associated Odu", (Object)entryOduId, (Object)this));
                    break;
                }
            }
        }
        if (adminStatusEnabled.equals(entry.getRbAuChannelAdminStatus())) {
            for (RbAuChannelConfigEntry channel : channelTable.getEntries()) {
                if (entry.getRbSlotNumber().equals(channel.getRbSlotNumber()) && entry.getRbAuChannelId().equals(channel.getRbAuChannelId()) || !entryOduId.equals(channel.getRbAuChannelAssociatedOduId()) || !adminStatusEnabled.equals(channel.getRbAuChannelAdminStatus())) continue;
                Object[] values = new Object[]{"AU" + channel.getRbSlotNumber() + " ", channel.getRbAuChannelId()};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbAuChannelConfigEntry.class, "Associated Odu", (Object)entryOduId, (Object)this));
                break;
            }
        }
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_channels";
        }
        return "ngnms.rb.help.tdd_au_channels";
    }
}

