/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.ReadOnlyBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.gui.configuration.AUAirIFPanel25TDD;
import com.bwanms.rb.mo.RbAuATPCParameters;
import com.bwanms.rb.mo.RbAuATPCParametersGroup;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuMacParameters;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParameters;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbBsRFModeParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUAirIFConfigFormTDD
extends ManagedObjectsConfigForm<AUAirIFPanel25TDD> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUAirIFConfigFormTDD.class);
    private static final Logger log = Logger.getLogger(AUAirIFConfigFormTDD.class);
    private int[] maxCellLowerLimit = new int[]{10, 10, 7, 5, 5};
    private int[][] maxCellUpperLimit = new int[][]{{110, 50}, {110, 50}, {45, 45}, {35, 35}, {35, 35}};
    private boolean warning = false;
    private Integer oldRbAuPhyConfiguredBandwidth;
    private RbAuPhyParameters phy;
    private boolean bsSwIsOlderThan41;

    public AUAirIFPanel25TDD initUIComponent() {
        final AUAirIFPanel25TDD pan = new AUAirIFPanel25TDD();
        this.bsSwIsOlderThan41 = new DefaultVersion("4.1").isNewerThan(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion());
        pan.getComboCfgBandwidth().addItem(new ComboItem((Object)RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB175, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB175))));
        pan.getComboCfgBandwidth().addItem(new ComboItem((Object)RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB35, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB35))));
        pan.getComboCfgBandwidth().addItem(new ComboItem((Object)3, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(3))));
        pan.getComboCfgBandwidth().addItem(new ComboItem((Object)4, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(4))));
        pan.getComboCfgBandwidth().addItem(new ComboItem((Object)5, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(5))));
        if (this.bsSwIsOlderThan41) {
            pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)0, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(0))));
        }
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)1, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(1))));
        if (this.bsSwIsOlderThan41) {
            pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)2, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(2))));
        }
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)3, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(3))));
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)4, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(4))));
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)5, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(5))));
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)6, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(6))));
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)7, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(7))));
        pan.getComboBasicUplinkRate().addItem(new ComboItem((Object)8, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuUlBasicRate(8))));
        if (this.bsSwIsOlderThan41) {
            pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)0, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(0))));
        }
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)1, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(1))));
        if (this.bsSwIsOlderThan41) {
            pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)2, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(2))));
        }
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)3, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(3))));
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)4, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(4))));
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)5, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(5))));
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)6, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(6))));
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)7, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(7))));
        pan.getComboBasicDownlinkRate().addItem(new ComboItem((Object)8, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuDlBasicRate(8))));
        pan.getComboCfgARQState().addItem(new ComboItem((Object)1, i18n.translateString(RbAuMacParametersGroup.toStringRbAuConfiguredARQState(1))));
        pan.getComboCfgARQState().addItem(new ComboItem((Object)2, i18n.translateString(RbAuMacParametersGroup.toStringRbAuConfiguredARQState(2))));
        pan.getComboMultirateSupport().addItem(new ComboItem((Object)1, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuMultirateSupport(1))));
        pan.getComboMultirateSupport().addItem(new ComboItem((Object)2, i18n.translateString(RbAuMultirateParametersGroup.toStringRbAuMultirateSupport(2))));
        pan.getCmbMinNumSubChannels().addItem(Integer.valueOf("1"));
        pan.getCmbMinNumSubChannels().addItem(Integer.valueOf("2"));
        pan.getCmbMinNumSubChannels().addItem(Integer.valueOf("4"));
        pan.getCmbMinNumSubChannels().addItem(Integer.valueOf("8"));
        pan.getCmbMinNumSubChannels().addItem(Integer.valueOf("16"));
        pan.getComboBasicUplinkRate().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pan.getCmbMinNumSubChannels().setEnabled(Integer.valueOf(1).equals(FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)AUAirIFConfigFormTDD.this.getUI()).getComboBasicUplinkRate())));
            }
        });
        if (!this.bsSwIsOlderThan41) {
            pan.getLblARQStateCurrent().setVisible(false);
            pan.getTxtCrtARQState().setVisible(false);
            pan.getLblARQStateConfigured().setVisible(false);
            pan.getComboCfgARQState().setVisible(false);
        }
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1.8")) < 0) {
            pan.getLblCrtMinNumSubChannels().setVisible(false);
            pan.getTxtCrtMinNumSubChannels().setVisible(false);
            pan.getTtlCnfSubchannelization().setVisible(false);
            pan.getTtlCrtSubchannelization().setVisible(false);
        }
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0.2")) < 0) {
            pan.getLblCfgMinNumSubChannels().setVisible(false);
            pan.getCmbMinNumSubChannels().setVisible(false);
            pan.getSprSubchannelization().setVisible(false);
        } else {
            try {
                RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
                Version auVersion = this.getSoftwareVersion(auEntry.getRuningSwVersion());
                if (auVersion.isOlderThan((Version)new DefaultVersion("4.1"))) {
                    pan.getCmbMinNumSubChannels().removeItemAt(0);
                    pan.getCmbMinNumSubChannels().removeItemAt(0);
                }
            }
            catch (Exception e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        return pan;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMacParametersGroup.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuPhyParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuATPCParametersGroup.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMultirateParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbAuChannelConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbBsRFModeParameters.class));
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((ReadOnlyBinding)new JTextFieldBinding("txtMaxCellRadius", "rbAuCurrentMaxCellRadius", (ValueTranslator)new ParserValueTranslator(Integer.class), i18n.translateString("MaxCellRadius")));
        binders.add((Binder)binder);
    }

    public void fillUI(List<Object> managedObjects) {
        String[] temp;
        boolean connected = true;
        RbAuConfigEntry auConfig = null;
        if (!(this.ctx.getEquipment() instanceof RbMBS)) {
            auConfig = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
            connected = auConfig.isConnected();
        }
        RbAuMacParameters mac = (RbAuMacParameters)((Object)managedObjects.get(0));
        if (connected) {
            String crtBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuBaseStationId());
            temp = crtBaseID.split("\\.");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtOperatorID().setText(temp[0] + "." + temp[1] + "." + temp[2]);
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtCellID().setText(temp[3] + "." + temp[4]);
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtSectorID().setText(temp[5]);
        } else {
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtOperatorID().setText("NA");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtCellID().setText("NA");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtSectorID().setText("NA");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtMaxCellRadius().setText("NA");
        }
        String cfgBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuConfiguredBaseStationId());
        temp = cfgBaseID.split("\\.");
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgOperatorID().setText(temp[0] + "." + temp[1] + "." + temp[2]);
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgCellID().setText(temp[3] + "." + temp[4]);
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().setText(OctetString.toDottedDecimalForm((String)mac.getRbAuConfiguredSectorId()));
        RbAuPhyParameters phy = (RbAuPhyParameters)((Object)managedObjects.get(1));
        if (connected) {
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtBandwidth().setText(i18n.translateString(RbAuPhyParametersGroup.toStringRbAuCurrentPhyBandwidth(phy.getRbAuCurrentPhyBandwidth())));
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtARQState().setText(i18n.translateString(RbAuMacParametersGroup.toStringRbAuARQState(mac.getRbAuARQState())));
        } else {
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtBandwidth().setText("NA");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtARQState().setText("NA");
        }
        if (this.bsSwIsOlderThan41) {
            FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgARQState(), (Object)mac.getRbAuConfiguredARQState());
        }
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgBandwidth(), (Object)phy.getRbAuPhyConfiguredBandwidth());
        ((AUAirIFPanel25TDD)this.getUI()).getSpnrMaxCellRadius().setValue(mac.getRbAuMaxCellRadius());
        RbBsRadioParameters bsRadio = (RbBsRadioParameters)((Object)managedObjects.get(2));
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgATPCSupport().setText(i18n.translateString(RbBsRadioParameters.toStringRbBsATPCSupport(bsRadio.getRbBsATPCSupport())));
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgOptimalUplinkRSSI().setText(bsRadio.getRbBsOptimalRSSI().toString());
        RbAuATPCParameters auATPC = (RbAuATPCParameters)((Object)managedObjects.get(3));
        if (connected) {
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtATPCSupport().setText(i18n.translateString(auATPC.toStringRbAuATPCSupport(auATPC.getRbAuATPCSupport())));
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtOptimalUplinkRSSI().setText(auATPC.getRbAuOptimalRSSI().toString());
        } else {
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtATPCSupport().setText("NA");
            ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtOptimalUplinkRSSI().setText("NA");
        }
        RbAuMultirateParameters multirate = (RbAuMultirateParameters)((Object)managedObjects.get(4));
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboBasicUplinkRate(), (Object)multirate.getRbAuUlBasicRate());
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboBasicDownlinkRate(), (Object)multirate.getRbAuDlBasicRate());
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboMultirateSupport(), (Object)multirate.getRbAuMultirateSupport());
        ((AUAirIFPanel25TDD)this.getUI()).getTxtCrtMinNumSubChannels().setText(String.valueOf(multirate.getRbAuUlCrtMinNoOfSubChannels()));
        if (((AUAirIFPanel25TDD)this.getUI()).getCmbMinNumSubChannels().isVisible()) {
            if (!Integer.valueOf(1).equals(FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboBasicUplinkRate()))) {
                ((AUAirIFPanel25TDD)this.getUI()).getCmbMinNumSubChannels().setEnabled(false);
            }
            ((AUAirIFPanel25TDD)this.getUI()).getCmbMinNumSubChannels().setSelectedItem(multirate.getRbAuUlMinNoOfSubChannels());
        }
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbAuMacParameters mac = (RbAuMacParameters)((Object)managedObjects.get(0));
        this.phy = (RbAuPhyParameters)((Object)managedObjects.get(1));
        RbAuMultirateParameters multirate = (RbAuMultirateParameters)((Object)managedObjects.get(4));
        RbBsRFModeParameters rfMode = (RbBsRFModeParameters)((Object)managedObjects.get(6));
        RbAuConfigEntry auConfig = null;
        if (this.ctx.getEquipment() instanceof RbBS) {
            auConfig = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
        }
        if (this.phy.getRbAuPhyConfiguredBandwidth().compareTo((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgBandwidth())) != 0) {
            this.oldRbAuPhyConfiguredBandwidth = this.phy.getRbAuPhyConfiguredBandwidth();
            this.phy.setRbAuPhyConfiguredBandwidth((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgBandwidth()));
            boolean bl = this.warning = !this.isChannelsAdminStatusDisable((ManagedObject)managedObjects.get(5));
        }
        if (this.bsSwIsOlderThan41) {
            mac.setRbAuConfiguredARQState((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgARQState()));
        }
        try {
            ((AUAirIFPanel25TDD)this.getUI()).getSpnrMaxCellRadius().commitEdit();
        }
        catch (ParseException e) {
            // empty catch block
        }
        Integer maxCellRadius = (Integer)((AUAirIFPanel25TDD)this.getUI()).getSpnrMaxCellRadius().getValue();
        Integer bandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboCfgBandwidth());
        int min = this.maxCellLowerLimit[bandwidth - 1];
        int max = this.maxCellUpperLimit[bandwidth - 1][rfMode.getRbBsRFConfiguredDuplexMode() - 1];
        if (min > maxCellRadius || maxCellRadius > max) {
            invalidValues.add(new InvalidValue(i18n.translateString("RangeWarning", new Object[]{min, max}), RbAuMacParameters.class, i18n.translateString("MaxCellRadius"), (Object)maxCellRadius, (Object)((AUAirIFPanel25TDD)this.getUI()).getSpnrMaxCellRadius()));
        } else {
            mac.setRbAuMaxCellRadius(maxCellRadius);
        }
        try {
            Integer.parseInt(((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText().trim());
            String octetS = OctetString.fromDottedDecimalForm((String)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText());
            if ("".equals(octetS)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{0, 255}), JTextField.class, i18n.translateString("SectorID"), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText(), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID()));
            } else if (!mac.getRbAuConfiguredSectorId().equals(Integer.toHexString(Integer.parseInt(((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText()))) && AUAirIFConfigFormTDD.isSectorIDInUse(this.ctx.getEquipment().getEUID(), ((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText())) {
                invalidValues.add(new InvalidValue(i18n.translateString("SectorIDIsUsed"), JTextField.class, i18n.translateString("SectorID"), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText(), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID()));
            } else {
                mac.setRbAuConfiguredSectorId(octetS);
            }
        }
        catch (NumberFormatException te) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{0, 255}), JTextField.class, i18n.translateString("SectorID"), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID().getText(), (Object)((AUAirIFPanel25TDD)this.getUI()).getTxtCfgSectorID()));
        }
        this.phy.setRbAuPhyConfiguredBandwidth(bandwidth);
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0 && !Integer.valueOf(RbAuPhyParameters.rbAuPhyConfiguredBandwidthB35).equals(bandwidth) && !Integer.valueOf(3).equals(bandwidth)) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidValueForSoftwareVersionUnder41"), JComboBox.class, i18n.translateString("Bandwidth"), (Object)i18n.translateString(RbSuFreqScanningEntry.toStringRbSuConfiguredBandwidth(bandwidth)), (Object)((AUAirIFPanel25TDD)this.getUI()).getComboCfgBandwidth()));
        }
        multirate.setRbAuUlBasicRate((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboBasicUplinkRate()));
        multirate.setRbAuDlBasicRate((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboBasicDownlinkRate()));
        multirate.setRbAuMultirateSupport((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel25TDD)this.getUI()).getComboMultirateSupport()));
        if (((AUAirIFPanel25TDD)this.getUI()).getCmbMinNumSubChannels().isVisible()) {
            multirate.setRbAuUlMinNoOfSubChannels((Integer)((AUAirIFPanel25TDD)this.getUI()).getCmbMinNumSubChannels().getSelectedItem());
        }
        if (auConfig != null && auConfig.isConnected()) {
            if (multirate.getRbAuDlBasicRate().equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("DownlinkBasicRate"), (Object)i18n.translateString("notDefined"), (Object)((AUAirIFPanel25TDD)this.getUI()).getComboBasicDownlinkRate()));
            }
            if (multirate.getRbAuUlBasicRate().equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("UplinkBasicRate"), (Object)i18n.translateString("notDefined"), (Object)((AUAirIFPanel25TDD)this.getUI()).getComboBasicUplinkRate()));
            }
        }
    }

    private static boolean isSectorIDInUse(final String euid, final String sectorID) {
        try {
            LightQuery<RbAuMacParametersGroup> q = new LightQuery<RbAuMacParametersGroup>(RbAuMacParametersGroup.class){

                public List<RbAuMacParametersGroup> execute() {
                    String qry = "SELECT params FROM " + RbAuMacParametersGroup.class.getName() + " AS params" + " WHERE params.NRConfiguration.configuration.equipment.EUID = :euid" + " AND params.rbAuConfiguredSectorId = :sectorid";
                    String hexSectorID = Integer.toHexString(Integer.parseInt(sectorID));
                    List ret = Datastore.session().createQuery(qry).setParameter("euid", (Object)euid).setParameter("sectorid", (Object)hexSectorID).list();
                    return ret;
                }
            };
            List pFServerList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
            if (pFServerList != null && pFServerList.size() > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            log.debug((Object)ex);
        }
        return false;
    }

    public String warnApply() {
        if (this.warning) {
            MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString(this.ctx.getEquipment() instanceof RbMBS ? "MBSTChangeFreqBandWarn" : "ChangeFreqBandWarn"));
            this.phy.setRbAuPhyConfiguredBandwidth(this.oldRbAuPhyConfiguredBandwidth);
            this.warning = false;
        }
        return null;
    }

    protected boolean isChannelsAdminStatusDisable(ManagedObject channelTable) {
        String nrName = (String)this.ctx.getAttribute("NR");
        Integer slot = Integer.parseInt(nrName.substring(nrName.indexOf(46) + 1));
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)channelTable;
        for (RbAuChannelConfigEntry entry : auChannelTable.getEntries()) {
            if (!entry.getRbSlotNumber().equals(slot) || entry.getRbAuChannelAdminStatus() == 2) continue;
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_tdd_air_interface";
    }

    public Version getSoftwareVersion(String ver) {
        if (ver.startsWith("Rel_")) {
            return VersionFactory.getInstance().createVersion(ver.substring(4), "_");
        }
        return VersionFactory.getInstance().createVersion(ver);
    }
}

