/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.ManagedObject;
import com.bwanms.rb.gui.configuration.AUAirIFPanel;
import com.bwanms.rb.mo.RbAuATPCParameters;
import com.bwanms.rb.mo.RbAuATPCParametersGroup;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuMacParameters;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParameters;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUAirIFConfigForm
extends ManagedObjectsConfigForm<AUAirIFPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUAirIFConfigForm.class);
    private static final Logger log = Logger.getLogger(AUAirIFConfigForm.class);
    private boolean warning = false;
    private Integer oldRbAuPhyConfiguredBandwidth;
    private RbAuPhyParameters phy;

    public AUAirIFPanel initUIComponent() {
        AUAirIFPanel panel = new AUAirIFPanel();
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB175, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB175))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB35, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(RbAuPhyParametersGroup.rbAuPhyConfiguredBandwidthB35))));
        if (RbVersions.V_3_5.isOlderOrEqualWith(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion())) {
            ((SpinnerNumberModel)panel.getSpnrMaxCellRadius().getModel()).setStepSize(1);
        }
        return panel;
    }

    void add7MhzBW() {
        boolean hasFourChannels = false;
        Version auVersion = null;
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs instanceof RbMBS) {
            int iduType = ((RbMBS)bs).getRbMBSTIduType() != null ? ((RbMBS)bs).getRbMBSTIduType() : 0;
            hasFourChannels = iduType == 2 || iduType == 4;
            auVersion = ((RbMBS)bs).getSoftwareVersion();
        } else {
            RbAuConfigEntry auEntry = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
            auVersion = this.getSoftwareVersion(auEntry.getRuningSwVersion());
            boolean bl = hasFourChannels = auEntry.getRbAuIduType() == 2 || auEntry.getRbAuIduType() == 4 || auEntry.getRbAuIduType() == 5;
        }
        if (RbVersions.V_3_5.isOlderOrEqualWith(auVersion) && hasFourChannels) {
            JComboBox cmbBandwidth = ((AUAirIFPanel)this.getUI()).getComboCfgBandwidth();
            boolean _7MhzAdded = false;
            for (int i = 0; i < cmbBandwidth.getItemCount(); ++i) {
                if (!((ComboItem)cmbBandwidth.getItemAt(i)).getValue().equals(4)) continue;
                _7MhzAdded = true;
                break;
            }
            if (!_7MhzAdded) {
                ((AUAirIFPanel)this.getUI()).getComboCfgBandwidth().addItem(new ComboItem((Object)4, i18n.translateString(RbAuPhyParametersGroup.toStringRbAuPhyConfiguredBandwidth(4))));
            }
        }
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMacParametersGroup.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuPhyParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuATPCParametersGroup.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbAuMultirateParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbAuChannelConfigTable.class));
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        if (!((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode()) {
            DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
            binder.add((Binding)new JSpinnerBinding("spnrMaxCellRadius", "rbAuMaxCellRadius", i18n.translateString("MaxCellRadius")));
            binders.add((Binder)binder);
        }
    }

    public void fillUI(List<Object> managedObjects) {
        String[] temp;
        boolean connected = true;
        if (!(this.ctx.getEquipment() instanceof RbMBS)) {
            RbAuConfigEntry auConfig = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"));
            connected = auConfig.isConnected();
        }
        RbAuMacParameters mac = (RbAuMacParameters)((Object)managedObjects.get(0));
        if (connected) {
            String crtBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuBaseStationId());
            temp = crtBaseID.split("\\.");
            ((AUAirIFPanel)this.getUI()).getTxtCrtOperatorID().setText(temp[0] + "." + temp[1] + "." + temp[2]);
            ((AUAirIFPanel)this.getUI()).getTxtCrtCellID().setText(temp[3] + "." + temp[4]);
            ((AUAirIFPanel)this.getUI()).getTxtCrtSectorID().setText(temp[5]);
        } else {
            ((AUAirIFPanel)this.getUI()).getTxtCrtOperatorID().setText("NA");
            ((AUAirIFPanel)this.getUI()).getTxtCrtCellID().setText("NA");
            ((AUAirIFPanel)this.getUI()).getTxtCrtSectorID().setText("NA");
        }
        String cfgBaseID = OctetString.toDottedDecimalForm((String)mac.getRbAuConfiguredBaseStationId());
        temp = cfgBaseID.split("\\.");
        ((AUAirIFPanel)this.getUI()).getTxtCfgOperatorID().setText(temp[0] + "." + temp[1] + "." + temp[2]);
        ((AUAirIFPanel)this.getUI()).getTxtCfgCellID().setText(temp[3] + "." + temp[4]);
        ((AUAirIFPanel)this.getUI()).getTxtCfgSectorID().setText(OctetString.toDottedDecimalForm((String)mac.getRbAuConfiguredSectorId()));
        RbAuPhyParameters phy = (RbAuPhyParameters)((Object)managedObjects.get(1));
        if (connected) {
            ((AUAirIFPanel)this.getUI()).getTxtCrtBandwidth().setText(i18n.translateString(RbAuPhyParametersGroup.toStringRbAuCurrentPhyBandwidth(phy.getRbAuCurrentPhyBandwidth())));
            ((AUAirIFPanel)this.getUI()).getTxtCrtARQState().setText(i18n.translateString(RbAuMacParametersGroup.toStringRbAuARQState(mac.getRbAuARQState())));
            this.add7MhzBW();
        } else {
            ((AUAirIFPanel)this.getUI()).getTxtCrtBandwidth().setText("NA");
            ((AUAirIFPanel)this.getUI()).getTxtCrtARQState().setText("NA");
        }
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboCfgBandwidth(), (Object)phy.getRbAuPhyConfiguredBandwidth());
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboCfgARQState(), (Object)mac.getRbAuConfiguredARQState());
        RbBsRadioParameters bsRadio = (RbBsRadioParameters)((Object)managedObjects.get(2));
        ((AUAirIFPanel)this.getUI()).getTxtCfgATPCSupport().setText(i18n.translateString(RbBsRadioParameters.toStringRbBsATPCSupport(bsRadio.getRbBsATPCSupport())));
        ((AUAirIFPanel)this.getUI()).getTxtCfgOptimalUplinkRSSI().setText(bsRadio.getRbBsOptimalRSSI().toString());
        RbAuATPCParameters auATPC = (RbAuATPCParameters)((Object)managedObjects.get(3));
        if (connected) {
            ((AUAirIFPanel)this.getUI()).getTxtCrtATPCSupport().setText(i18n.translateString(auATPC.toStringRbAuATPCSupport(auATPC.getRbAuATPCSupport())));
            ((AUAirIFPanel)this.getUI()).getTxtCrtOptimalUplinkRSSI().setText(auATPC.getRbAuOptimalRSSI().toString());
        } else {
            ((AUAirIFPanel)this.getUI()).getTxtCrtATPCSupport().setText("NA");
            ((AUAirIFPanel)this.getUI()).getTxtCrtOptimalUplinkRSSI().setText("NA");
        }
        RbAuMultirateParameters multirate = (RbAuMultirateParameters)((Object)managedObjects.get(4));
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboBasicUplinkRate(), (Object)multirate.getRbAuUlBasicRate());
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboBasicDownlinkRate(), (Object)multirate.getRbAuDlBasicRate());
        FormUtil.setSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboMultirateSupport(), (Object)multirate.getRbAuMultirateSupport());
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbAuConfigEntry auConfig;
        RbAuMacParameters mac = (RbAuMacParameters)((Object)managedObjects.get(0));
        this.phy = (RbAuPhyParameters)((Object)managedObjects.get(1));
        RbAuMultirateParameters multirate = (RbAuMultirateParameters)((Object)managedObjects.get(4));
        if (this.phy.getRbAuPhyConfiguredBandwidth().compareTo((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboCfgBandwidth())) != 0) {
            this.oldRbAuPhyConfiguredBandwidth = this.phy.getRbAuPhyConfiguredBandwidth();
            this.phy.setRbAuPhyConfiguredBandwidth((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboCfgBandwidth()));
            this.warning = !this.isChannelsAdminStatusDisable((ManagedObject)managedObjects.get(5));
        }
        mac.setRbAuConfiguredARQState((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboCfgARQState()));
        int rbAuMaxCellRadius = (Integer)((AUAirIFPanel)this.getUI()).getSpnrMaxCellRadius().getValue();
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode()) {
            int min = 10;
            int max = 50;
            if (rbAuMaxCellRadius < min || rbAuMaxCellRadius > max) {
                invalidValues.add(new InvalidValue(i18n.translateString("RangeWarning", new Object[]{min, max}), RbAuMacParameters.class, i18n.translateString("MaxCellRadius"), (Object)rbAuMaxCellRadius, (Object)this));
            } else {
                mac.setRbAuMaxCellRadius(rbAuMaxCellRadius);
            }
        } else {
            mac.setRbAuMaxCellRadius(rbAuMaxCellRadius);
        }
        try {
            String octetS = OctetString.fromDottedDecimalForm((String)((AUAirIFPanel)this.getUI()).getTxtCfgSectorID().getText());
            if ("".equals(octetS)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{0, 255}), JTextField.class, i18n.translateString("SectorID"), (Object)((AUAirIFPanel)this.getUI()).getTxtCfgSectorID().getText(), (Object)((AUAirIFPanel)this.getUI()).getTxtCfgSectorID()));
            } else {
                mac.setRbAuConfiguredSectorId(octetS);
            }
        }
        catch (NumberFormatException te) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{0, 255}), JTextField.class, i18n.translateString("SectorID"), (Object)((AUAirIFPanel)this.getUI()).getTxtCfgSectorID().getText(), (Object)((AUAirIFPanel)this.getUI()).getTxtCfgSectorID()));
        }
        if (!((RbBaseStationEquipment)this.ctx.getEquipment()).isTDDDuplexMode() && rbAuMaxCellRadius % 10 > 0 && RbVersions.V_3_0.isOlderThan(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion()) && RbVersions.V_3_5.isNewerThan(((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion())) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueMustBeAMultipleOf10"), RbAuMacParametersGroup.class, i18n.translateString("MaxCellRadius"), (Object)rbAuMaxCellRadius, (Object)this));
        }
        Integer ulBasicRate = (Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboBasicUplinkRate());
        Integer dlBasicRate = (Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboBasicDownlinkRate());
        multirate.setRbAuUlBasicRate(ulBasicRate);
        multirate.setRbAuDlBasicRate(dlBasicRate);
        multirate.setRbAuMultirateSupport((Integer)FormUtil.getSelectedValue((JComboBox)((AUAirIFPanel)this.getUI()).getComboMultirateSupport()));
        RbBaseStationEquipment bsEq = (RbBaseStationEquipment)this.ctx.getEquipment();
        boolean auConnected = false;
        auConnected = bsEq instanceof RbBS ? null != (auConfig = (RbAuConfigEntry)((Object)this.ctx.getAttribute("AU"))) && auConfig.isConnected() : true;
        if (auConnected) {
            if (dlBasicRate.equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("DownlinkBasicRate"), (Object)i18n.translateString("notDefined"), (Object)((AUAirIFPanel)this.getUI()).getComboBasicDownlinkRate()));
            }
            if (ulBasicRate.equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("UplinkBasicRate"), (Object)i18n.translateString("notDefined"), (Object)((AUAirIFPanel)this.getUI()).getComboBasicUplinkRate()));
            }
        }
    }

    public String warnApply() {
        if (this.warning) {
            MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString(this.ctx.getEquipment() instanceof RbMBS ? "MBSTChangeFreqBandWarn" : "ChangeFreqBandWarn"));
            this.phy.setRbAuPhyConfiguredBandwidth(this.oldRbAuPhyConfiguredBandwidth);
            this.warning = false;
        }
        return null;
    }

    protected boolean isChannelsAdminStatusDisable(ManagedObject channelTable) {
        String nrName = (String)this.ctx.getAttribute("NR");
        Integer slot = Integer.parseInt(nrName.substring(nrName.indexOf(46) + 1));
        RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)channelTable;
        for (RbAuChannelConfigEntry entry : auChannelTable.getEntries()) {
            if (!entry.getRbSlotNumber().equals(slot) || entry.getRbAuChannelAdminStatus() == 2) continue;
            return false;
        }
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.au_air_interface";
        }
        return "ngnms.rb.help.tdd_au_air_interface";
    }

    public Version getSoftwareVersion(String ver) {
        if (ver.startsWith("Rel_")) {
            return VersionFactory.getInstance().createVersion(ver.substring(4), "_");
        }
        return VersionFactory.getInstance().createVersion(ver);
    }
}

