/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.bs;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Contact;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.rb.gui.bs.RbBsEditorPanel;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBsEditorView
extends AbstractBindedEditorView<Equipment> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbBsEditorView.class);
    private RbBsEditorPanel panel = new RbBsEditorPanel();

    public void fillUI(Equipment entity) {
        if (entity.getId() > 0L) {
            this.panel.getTxtIpAddress().setEditable(false);
        }
        if (((RbBaseStationEquipment)entity).getSnmpTimeout() != null) {
            this.panel.getSpnrTimeout().setValue(((RbBaseStationEquipment)entity).getManagementInterface().getTimeout() / 1000L);
        }
        this.panel.getSelectorContact().setValue((Object)entity.getContact());
        this.panel.getSelectorLocation().setValue((Object)entity.getLocation());
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtIpAddress", "IPAddress", i18n.translateString("IPAddress"))).add((Binding)new JTextFieldBinding("TxtReadCommunity", "snmpReadCommunity", i18n.translateString("ReadCommunity"))).add((Binding)new JTextFieldBinding("TxtWriteCommunity", "snmpWriteCommunity", i18n.translateString("WriteCommunity"))).add((Binding)new JSpinnerBinding("spnrRetries", "snmpRetries")).add((Binding)new JTextFieldBinding("txtDeviceName", "name")));
        return binders;
    }

    public List<InvalidValue> configureEntity(Equipment entity) {
        Long snmpTimeout = ((Number)this.panel.getSpnrTimeout().getValue()).longValue();
        ((RbBaseStationEquipment)entity).setSnmpTimeout(1000L * snmpTimeout);
        ((RbBaseStationEquipment)entity).setSnmpPort(161);
        entity.setContact((Contact)this.panel.getSelectorContact().getValue());
        entity.setLocation((Location)this.panel.getSelectorLocation().getValue());
        return super.configureEntity((Serializable)entity);
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        String name = " " + this.entity;
        if (name.contains("RbMBS")) {
            return i18n.translateString("MBs");
        }
        if (name.contains("RbBS")) {
            return i18n.translateString("Bs");
        }
        return "";
    }

    public String getApplicationPermission() {
        return "Av:ConfigureEquipment";
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.craft_equipment_editor";
        }
        return "equipment_editor";
    }

    public RbBsEditorPanel getRbBsEditorPanel() {
        return this.panel;
    }
}

