/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.bs;

import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.DefaultAssembly;
import com.bwanms.rb.gui.services.RbServiceEntryEditorContainer;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBSNRConfiguration;
import com.bwanms.rb.model.RbBaseStationNRConfiguration;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSAssemblerFactory
implements AssemblerFactory<RbBS> {
    public Assembler<RbBS> createAssembler(Class<? extends RbBS> baseClass, final String assembler) {
        return new Assembler<RbBS>(){

            public Assembly<RbBS> getAssembly(RbBS entity) throws ServiceException {
                if ("allCards".equals(assembler)) {
                    Hibernate.initialize(entity.getManagedAUs());
                    Hibernate.initialize(entity.getManagedNPUs());
                } else if ("allCardsAndSUs".equals(assembler)) {
                    Hibernate.initialize(entity.getManagedAUs());
                    Hibernate.initialize(entity.getManagedNPUs());
                    Hibernate.initialize(entity.getManagedSUs());
                } else if (ConfigApplicationView.ASSEMBLER_NAME.equals(assembler)) {
                    RbBSNRConfiguration bsNRConfig = (RbBSNRConfiguration)entity.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
                    Hibernate.initialize((Object)((Object)bsNRConfig));
                    Hibernate.initialize(bsNRConfig.getRbSlotConfigEntries());
                    Hibernate.initialize(bsNRConfig.getRbAuConfigEntries());
                    Hibernate.initialize(bsNRConfig.getRbNpuConfigEntries());
                } else if (RbServiceEntryEditorContainer.ASSEMBLER_NAME.equals(assembler)) {
                    RbBaseStationNRConfiguration nrConfig = (RbBaseStationNRConfiguration)entity.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
                    Hibernate.initialize((Object)((Object)nrConfig));
                    Hibernate.initialize(nrConfig.getRbServiceConfigEntries());
                    Hibernate.initialize(nrConfig.getRbSubscriberEntries());
                    Hibernate.initialize(nrConfig.getRbRegisteredSuEntries());
                    Hibernate.initialize(nrConfig.getRbServiceTemplateConfigEntries());
                    Hibernate.initialize(nrConfig.getRbForwardingRuleConfigEntries());
                    Hibernate.initialize(nrConfig.getRbPolicyRuleConfigEntries());
                    Hibernate.initialize(nrConfig.getRbQoSProfileConfigEntries());
                    Hibernate.initialize(nrConfig.getRbVoiceDomainsEntries());
                    Hibernate.initialize(nrConfig.getRbServiceGroupEntries());
                }
                return new DefaultAssembly((Serializable)((Object)entity));
            }
        };
    }
}

