/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.binding;

import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.util.OctetString;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdValueTranslator
implements ValueTranslator<String, String> {
    private static final String oneToThreeDigits = "\\d{1,3}";
    private static final String point = "\\.";
    private Pattern cellIdPattern;

    public IdValueTranslator(int groupCount) {
        if (groupCount < 1) {
            throw new IllegalArgumentException("group count must be more than zero");
        }
        StringBuilder sb = new StringBuilder(oneToThreeDigits);
        for (int i = 1; i < groupCount; ++i) {
            sb.append(point);
            sb.append(oneToThreeDigits);
        }
        this.cellIdPattern = Pattern.compile(sb.toString());
    }

    public String convertToUIValue(String beanValue) throws TranslateException {
        return OctetString.toDottedDecimalForm((String)beanValue);
    }

    public String convertToBeanValue(String uiBeanValue) throws TranslateException {
        if (!this.cellIdPattern.matcher(uiBeanValue).matches()) {
            throw new TranslateException("Wrong format");
        }
        try {
            return OctetString.fromDottedDecimalForm((String)uiBeanValue);
        }
        catch (NumberFormatException nfe) {
            throw new TranslateException("Wrong format");
        }
    }
}

