/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.protocols.snmp.SNMPTrapV1;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.util.OctetString;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.6.21.1", indexColumns={"TrapEventLogSeqNum"})
public class RbTrapEventLogEntry
implements Serializable {
    private static final Logger log = Logger.getLogger(RbTrapEventLogEntry.class);
    private static final VarBind VARBIND_RbChannelId = new VarBind("RbChannelId", "1.3.6.1.4.1.12394.1.2.2.11.1.1", 2, null);
    private static final VarBind VARBIND_RbTrapAdditionalInfo = new VarBind("RbTrapAdditionalInfo", "1.3.6.1.4.1.12394.1.2.6.7", 2, null);
    private static final VarBind VARBIND_RbTrapCategory = new VarBind("RbTrapCategory", "1.3.6.1.4.1.12394.1.2.6.8", 2, null);
    private static final VarBind VARBIND_RbTrapIpAddress = new VarBind("RbTrapIpAddress", "1.3.6.1.4.1.12394.1.2.6.11", 64, null);
    private static final VarBind VARBIND_RbTrapSequenceNumber = new VarBind("RbTrapSequenceNumber", "1.3.6.1.4.1.12394.1.2.6.4", 66, null);
    private static final VarBind VARBIND_RbTrapSeverity = new VarBind("RbTrapSeverity", "1.3.6.1.4.1.12394.1.2.6.5", 2, null);
    private static final VarBind VARBIND_RbTrapSource = new VarBind("RbTrapSource", "1.3.6.1.4.1.12394.1.2.6.6", -128, null);
    private static final VarBind VARBIND_RbTrapSetFailureReason = new VarBind("RbTrapSetFailureReason", "1.3.6.1.4.1.12394.1.2.6.12", -128, null);
    private static final VarBind VARBIND_RbServiceIdx = new VarBind("RbServiceIdx", "1.3.6.1.4.1.12394.1.2.100.3.1.1.1", 66, null);
    private static final VarBind VARBIND_RbServiceName = new VarBind("RbServiceName", "1.3.6.1.4.1.12394.1.2.100.3.1.1.3", -128, null);
    private static final VarBind VARBIND_RbSubscriberIdx = new VarBind("RbSubscriberIdx", "1.3.6.1.4.1.12394.1.2.100.7.1.1.1", 66, null);
    private static final VarBind VARBIND_RbSubscriberID = new VarBind("RbSubscriberID", "1.3.6.1.4.1.12394.1.2.100.7.1.1.2", -128, null);
    private static final VarBind VARBIND_RbSuSysName = new VarBind("RbSuSysName", "1.3.6.1.4.1.12394.1.2.5.1.1.7", -128, null);
    private static final VarBind VARBIND_RbSuMacAddr = new VarBind("RbSuMacAddr", "1.3.6.1.4.1.12394.1.2.5.1.1.2", 112, null);
    private static final VarBind VARBIND_RbGPSLocalDateAndTime = new VarBind("RbGPSLocalDateAndTime", "1.3.6.1.4.1.12394.1.2.15.5", -128, null);
    private static final VarBind VARBIND_RbGPSUTCDateAndTime = new VarBind("RbGPSUTCDateAndTime", "1.3.6.1.4.1.12394.1.2.15.9", -128, null);
    private static final VarBind VARBIND_RbBSPmTmLastFileName = new VarBind("PmTmLastFileName", "1.3.6.1.4.1.12394.1.2.11.8.3", -128, null);
    private static final VarBind VARBIND_RbPMPFServerIpAddress = new VarBind("RbPMPFServerIpAddress", "1.3.6.1.4.1.12394.1.2.4.10.3.1.1", -128, null);
    private static final VarBind VARBIND_RbOduConfigId = new VarBind("OduConfigId", "1.3.6.1.4.1.12394.1.2.13.1.1.1", 2, null);
    private static final VarBind VARBIND_RbOduStatusMask = new VarBind("AuOduStatusMask", "1.3.6.1.4.1.12394.1.2.13.1.1.16", -128, null);
    private String instance;
    private Long trapEventLogSeqNum;
    private Integer trapEventLogId;
    private Integer trapEventLogSeverity;
    private Integer trapEventLogType;
    private Integer trapEventLogCategory;
    private String trapEventLogSource;
    private Integer trapEventLogVarBindNumber;
    private Integer trapEventLogVarBindSize;
    private String trapEventLogAddVarAttributes;
    private String trapEventLogDateAndTime;

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.2", type=2)
    public Integer getTrapEventLogId() {
        return this.trapEventLogId;
    }

    public void setTrapEventLogId(Integer trapEventLogId) {
        this.trapEventLogId = trapEventLogId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.3", type=2)
    public Integer getTrapEventLogSeverity() {
        return this.trapEventLogSeverity;
    }

    public void setTrapEventLogSeverity(Integer trapEventLogSeverity) {
        this.trapEventLogSeverity = trapEventLogSeverity;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.4", type=2)
    public Integer getTrapEventLogType() {
        return this.trapEventLogType;
    }

    public void setTrapEventLogType(Integer trapEventLogType) {
        this.trapEventLogType = trapEventLogType;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.5", type=2)
    public Integer getTrapEventLogCategory() {
        return this.trapEventLogCategory;
    }

    public void setTrapEventLogCategory(Integer trapEventLogCategory) {
        this.trapEventLogCategory = trapEventLogCategory;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.6", type=-128)
    public String getTrapEventLogSource() {
        return this.trapEventLogSource;
    }

    public void setTrapEventLogSource(String trapEventLogSource) {
        this.trapEventLogSource = trapEventLogSource;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.7", type=2)
    public Integer getTrapEventLogVarBindNumber() {
        return this.trapEventLogVarBindNumber;
    }

    public void setTrapEventLogVarBindNumber(Integer trapEventLogVarBindNumber) {
        this.trapEventLogVarBindNumber = trapEventLogVarBindNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.8", type=2)
    public Integer getTrapEventLogVarBindSize() {
        return this.trapEventLogVarBindSize;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.9", type=-128)
    public String getTrapEventLogAddVarAttributes() {
        return this.trapEventLogAddVarAttributes;
    }

    public void setTrapEventLogAddVarAttributes(String trapEventLogAddVarAttributes) {
        this.trapEventLogAddVarAttributes = trapEventLogAddVarAttributes;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.10", type=-128)
    public String getTrapEventLogDateAndTime() {
        return this.trapEventLogDateAndTime;
    }

    public void setTrapEventLogDateAndTime(String trapEventLogDateAndTime) {
        this.trapEventLogDateAndTime = trapEventLogDateAndTime;
    }

    public void setTrapEventLogVarBindSize(Integer trapEventLogVarBindSize) {
        this.trapEventLogVarBindSize = trapEventLogVarBindSize;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.21.1.1", type=66)
    public Long getTrapEventLogSeqNum() {
        return this.trapEventLogSeqNum;
    }

    public void setTrapEventLogSeqNum(Long trapEventLoqSeqNum) {
        this.trapEventLogSeqNum = trapEventLoqSeqNum;
    }

    private static void addToVbList(VarBindList vbList, VarBind vbConstant, Object variable) {
        VarBind vb = vbConstant.clone();
        vb.setOID(vb.getOID() + ".0");
        vb.setVariable(variable);
        vbList.add(vb);
    }

    private String[][] parseTrapEventLogAddVarAttributes(String agentIpAddress) {
        String[] partsWithLastEmptyValue;
        log.debug((Object)("Parsing " + this.trapEventLogAddVarAttributes));
        if (this.trapEventLogAddVarAttributes == null || this.trapEventLogAddVarAttributes.length() == 0) {
            return new String[0][2];
        }
        String[] parts = this.trapEventLogAddVarAttributes.split("=");
        if (this.trapEventLogAddVarAttributes.trim().endsWith("=")) {
            partsWithLastEmptyValue = new String[parts.length + 1];
            System.arraycopy(parts, 0, partsWithLastEmptyValue, 0, parts.length);
            partsWithLastEmptyValue[partsWithLastEmptyValue.length - 1] = "";
        } else {
            partsWithLastEmptyValue = parts;
        }
        if (partsWithLastEmptyValue.length > 0) {
            String[][] ret = new String[partsWithLastEmptyValue.length - 1][2];
            ret[0][0] = partsWithLastEmptyValue[0].trim();
            for (int i = 1; i < partsWithLastEmptyValue.length - 1; ++i) {
                int lastCommaIndex = partsWithLastEmptyValue[i].lastIndexOf(44);
                if (lastCommaIndex == -1) {
                    ret[i - 1][1] = partsWithLastEmptyValue[i].trim();
                    continue;
                }
                ret[i - 1][1] = partsWithLastEmptyValue[i].substring(0, lastCommaIndex).trim();
                ret[i][0] = partsWithLastEmptyValue[i].substring(lastCommaIndex + 1).trim();
            }
            ret[partsWithLastEmptyValue.length - 2][1] = partsWithLastEmptyValue[partsWithLastEmptyValue.length - 1].trim();
            return ret;
        }
        return new String[0][2];
    }

    public SNMPTrapV1AgentEvent toAgentEvent(String agentIpAddress, String enterpriseOID, boolean useDeviceTime) {
        int generic = this.getTrapEventLogType();
        int specific = this.getTrapEventLogId();
        long timestamp = 0L;
        if (useDeviceTime && null != this.trapEventLogDateAndTime && this.trapEventLogDateAndTime.length() > 0) {
            try {
                timestamp = -new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(this.trapEventLogDateAndTime).getTime();
            }
            catch (ParseException ex) {
                log.info((Object)ex);
            }
        }
        VarBindList vbList = new VarBindList();
        RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapSequenceNumber, this.getTrapEventLogSeqNum());
        RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapCategory, this.getTrapEventLogCategory());
        RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapSource, OctetString.toOctetString((byte[])this.getTrapEventLogSource().getBytes()));
        RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapSeverity, this.getTrapEventLogSeverity());
        String[][] additionalVars = this.parseTrapEventLogAddVarAttributes(agentIpAddress);
        for (int var = 0; var < additionalVars.length; ++var) {
            if ("AdditionalInfo".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapAdditionalInfo, Integer.parseInt(additionalVars[var][1]));
                continue;
            }
            if ("IpAddress".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapIpAddress, additionalVars[var][1]);
                continue;
            }
            if ("AuChannelId".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbChannelId, Integer.parseInt(additionalVars[var][1]));
                continue;
            }
            if ("ServiceIdx".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbServiceIdx, Long.parseLong(additionalVars[var][1]));
                continue;
            }
            if ("ServiceName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbServiceName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("SubscriberIdx".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSubscriberIdx, Long.parseLong(additionalVars[var][1]));
                continue;
            }
            if ("SubscriberID".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSubscriberID, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("SuSysName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuSysName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("otherSuMac".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuMacAddr, OctetString.toOctetString((byte[])additionalVars[var][1].replace('-', ':').getBytes()));
                continue;
            }
            if ("preSuSysName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuSysName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("postSuSysName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuSysName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("SuMac".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuMacAddr, additionalVars[var][1].replace('-', ':'));
                continue;
            }
            if ("SuUserName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbSuSysName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("rbGPSLocalDateAndTime".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbGPSLocalDateAndTime, OctetString.toOctetString((byte[])additionalVars[var][1].replace(",", "").getBytes()));
                continue;
            }
            if ("rbGPSUTCDateAndTime".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbGPSUTCDateAndTime, OctetString.toOctetString((byte[])additionalVars[var][1].replace(",", "").getBytes()));
                continue;
            }
            if ("PmTmLastFileName".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbBSPmTmLastFileName, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("rbPMPFServerIpAddress".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbPMPFServerIpAddress, additionalVars[var][1]);
                continue;
            }
            if ("OduConfigId".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbOduConfigId, Integer.parseInt(additionalVars[var][1]));
                continue;
            }
            if ("AuOduStatusMask".toUpperCase().equals(additionalVars[var][0].toUpperCase())) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbOduStatusMask, OctetString.toOctetString((byte[])additionalVars[var][1].getBytes()));
                continue;
            }
            if ("SetFailureReason".equals(additionalVars[var][0])) {
                RbTrapEventLogEntry.addToVbList(vbList, VARBIND_RbTrapSetFailureReason, additionalVars[var][1]);
                continue;
            }
            log.debug((Object)("[" + agentIpAddress + "] Unknown additional var: [" + additionalVars[var][0] + "]"));
        }
        SNMPTrapV1 trapV1 = new SNMPTrapV1(agentIpAddress, enterpriseOID, generic, specific, timestamp, vbList, System.currentTimeMillis());
        return new SNMPTrapV1AgentEvent(trapV1, true);
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }
}

