/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbServiceManagementHelper;
import com.bwanms.rb.ddi.RbServiceSynchronizationHelper;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.services.ServiceException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSubscriberEntryAssemblerFactory
implements AssemblerFactory<RbSubscriberEntry> {
    public Assembler<RbSubscriberEntry> createAssembler(Class<? extends RbSubscriberEntry> baseClass, String assembler) {
        return new Assembler<RbSubscriberEntry>(){

            public Assembly<RbSubscriberEntry> getAssembly(RbSubscriberEntry subscriberEntry) throws ServiceException {
                RbSubscriber subscriber;
                RbServiceSynchronizationHelper syncHelper = new RbServiceSynchronizationHelper((RbBaseStationEquipment)subscriberEntry.getNRConfiguration().getConfiguration().getEquipment());
                if (subscriberEntry.getComplexKey() == null) {
                    ArrayList<RbSubscriberEntry> list = new ArrayList<RbSubscriberEntry>();
                    list.add(subscriberEntry);
                    RbServiceSynchronizationHelper.updateComplexKeysAndAdminStatus(list);
                }
                if ((subscriber = (RbSubscriber)((Object)Datastore.session().createQuery("from " + RbSubscriber.class.getName() + " where complexKey = :complexKey").setString("complexKey", subscriberEntry.getComplexKey()).uniqueResult())) == null) {
                    subscriber = syncHelper.createSubscriber(subscriberEntry);
                    subscriber = RbServiceManagementHelper.saveNewSubscriber(Datastore.session(), subscriber, true);
                }
                return new RbSubscriberEntryAssembly(subscriberEntry, subscriber);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RbSubscriberEntryAssembly
    implements Assembly<RbSubscriberEntry> {
        private static final long serialVersionUID = 4069813018556168278L;
        private RbSubscriberEntry entity;
        private RbSubscriber subscriber;

        public RbSubscriberEntryAssembly(RbSubscriberEntry entity, RbSubscriber subscriber) {
            this.entity = entity;
            this.subscriber = subscriber;
        }

        public RbSubscriberEntry getEntity() {
            return this.entity;
        }

        public RbSubscriber getSubscriber() {
            return this.subscriber;
        }
    }
}

