/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.SessionLockHelper;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.model.RbSUEquipmentConfiguration;
import com.bwanms.util.MacAddress;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class RbSuSynchronizationHelper {
    private static final Logger logger = Logger.getLogger(RbSuSynchronizationHelper.class);
    private static String RBSUS_MGMT_GIANT_LOCK = "RbSubscriberUnitsMgmtGiantLock";
    private RbBaseStationEquipment baseStation;
    private static final String[] suTypes = new String[]{"N/A", "CPE", "CPE_PRO", "CPE_SI", "CPE_PRO_L", "CPE_SI_L", "CPE_2_PRO", "CPE_2_SI", "CPE_2_PRO_L", "CPE_2_SI_L"};

    public static void getRbSUsMgmtDBGiantLock() {
        Datastore.lock((String)RBSUS_MGMT_GIANT_LOCK);
    }

    public static void getRbSUsMgmtDBGiantLock(Session session) {
        SessionLockHelper.lock((Session)session, (String)RBSUS_MGMT_GIANT_LOCK);
    }

    private static String getSuTypeString(int suType) {
        if (suType > -1 && suType < suTypes.length) {
            return suTypes[suType];
        }
        return suTypes[0];
    }

    public RbSuSynchronizationHelper(RbBaseStationEquipment baseStation) {
        this.baseStation = baseStation;
    }

    RbSU createUnknownStateSU(RbRegisteredSuEntry suInstance) {
        RbSU su = new RbSU();
        String macAddress = MacAddress.fromOctetString((String)suInstance.getRbSuMacAddr()).toSimpleString();
        su.setEUID(macAddress);
        su.setName(suInstance.getRbSuSysName());
        su.setSerialNumber("N/A");
        su.setModel(RbSuSynchronizationHelper.getSuTypeString(0));
        su.setOperationMode(0);
        su.setMacAddress(macAddress);
        su.setRunningSoftwareVersion("N/A");
        su.setOperationalSoftwareVersion("N/A");
        su.setShadowSoftwareVersion("N/A");
        su.setLocation(this.baseStation.getLocation());
        su.setContact(this.baseStation.getContact());
        RbSUEquipmentConfiguration config = new RbSUEquipmentConfiguration();
        config.setEquipment(su);
        su.setCurrentConfiguration(config);
        config.createPrimaryNetworkResource();
        logger.debug((Object)("Created SU: " + su.getMacAddress()));
        return su;
    }

    RbSU createSU(RbRegisteredSuEntry suInstance) {
        RbSU su = new RbSU();
        String macAddress = MacAddress.fromOctetString((String)suInstance.getRbSuMacAddr()).toSimpleString();
        su.setEUID(macAddress);
        su.setName(suInstance.getRbSuSysName());
        su.setSerialNumber(suInstance.getRbSuSerialNo());
        su.setModel(RbSuSynchronizationHelper.getSuTypeString(suInstance.getRbSuType()));
        su.setOperationMode(suInstance.getRbSuAirInterfaceType() == null ? 0 : suInstance.getRbSuAirInterfaceType());
        su.setMacAddress(macAddress);
        su.setRunningSoftwareVersion(suInstance.getRuningSwVersion());
        su.setOperationalSoftwareVersion(suInstance.getRbSuOperSwVersion());
        su.setShadowSoftwareVersion(suInstance.getRbSuShadowSwVersion());
        su.setLocation(this.baseStation.getLocation());
        su.setContact(this.baseStation.getContact());
        RbSUEquipmentConfiguration config = new RbSUEquipmentConfiguration();
        config.setEquipment(su);
        su.setCurrentConfiguration(config);
        config.createPrimaryNetworkResource();
        logger.debug((Object)("Created SU: " + su.getMacAddress()));
        return su;
    }

    public void updateSU(RbSU su, RbRegisteredSuEntry suInstance) {
        su.setName(suInstance.getRbSuSysName());
        if (suInstance.isConnected()) {
            su.setSerialNumber(suInstance.getRbSuSerialNo());
            su.setModel(RbSuSynchronizationHelper.getSuTypeString(suInstance.getRbSuType()));
            su.setOperationMode(suInstance.getRbSuAirInterfaceType() == null ? 0 : suInstance.getRbSuAirInterfaceType());
            su.setRunningSoftwareVersion(suInstance.getRuningSwVersion());
            su.setOperationalSoftwareVersion(suInstance.getRbSuOperSwVersion());
            su.setShadowSoftwareVersion(suInstance.getRbSuShadowSwVersion());
            su.setHardwareRevision(suInstance.getRbSuHwRevision());
            su.setSuIduType(this.toStringRbSuIduTypeHelper(suInstance.getRbSuIduType()));
        }
        su.setServingAUId(suInstance.getRbAuId());
    }

    private String toStringRbSuIduTypeHelper(Integer rbSuIduType) {
        String result = null;
        if (rbSuIduType == null) {
            return null;
        }
        switch (rbSuIduType) {
            case 0: {
                result = "Basic";
                break;
            }
            case 4: {
                result = "Voice";
                break;
            }
            case 6: {
                result = "Voice";
                break;
            }
            case 7: {
                result = "Voice";
                break;
            }
            case 11: {
                result = "Wireless";
                break;
            }
            default: {
                result = "!!undefined(" + rbSuIduType + ")";
            }
        }
        return result;
    }

    RbSU findSU(String macAddress) {
        Query query = Datastore.session().createQuery("from " + RbSU.class.getName() + " where macAddress = :macAddress");
        query.setString("macAddress", macAddress);
        RbSU su = (RbSU)((Object)query.uniqueResult());
        return su;
    }

    void connectSU(RbSU su, int auSlotNumber) {
        this.disconnectSU(su);
        su.setManagerBS(this.baseStation);
        su.setAuSlotNumber(auSlotNumber);
        su.setManagerBSName(this.baseStation.getName());
    }

    void disconnectSU(RbSU su) {
        if (su.getManagerBS() != null) {
            su.setManagerBS(null);
            su.setAuSlotNumber(null);
        }
    }

    public boolean isConnected(RbSU su) {
        return su.getManagerBS() != null && su.getManagerBS().getId() == this.baseStation.getId();
    }
}

