/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.model.Service;
import com.bwanms.model.Subscriber;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbIPModeDataServiceProfile;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbL2Service;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEService;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.rb.model.services.RbVoIPService;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.util.MacAddress;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceSynchronizationUtil {
    public static String TRANSPARENT_FWD_RULE_NAME_PREFIX = "@@Transparent";

    public static String lookupServiceProfileClass(int serviceProfileType) {
        switch (serviceProfileType) {
            case 1: {
                return RbL2ServiceProfile.class.getName();
            }
            case 2: {
                return RbPPPoEServiceProfile.class.getName();
            }
            case 3: {
                return RbVoIPServiceProfile.class.getName();
            }
            case 4: {
                return RbIPModeDataServiceProfile.class.getName();
            }
            case 5: {
                return RbIPModeVoIPServiceProfile.class.getName();
            }
            case 6: {
                return RbManagedVoIPServiceProfile.class.getName();
            }
            case 7: {
                return RbIPModeMngVoIPServiceProfile.class.getName();
            }
        }
        throw new RuntimeException("Invalid service profile type: " + serviceProfileType);
    }

    public static int lookupServiceProfileType(RbServiceProfile serviceProfile) {
        if (serviceProfile instanceof RbL2ServiceProfile) {
            return 1;
        }
        if (serviceProfile instanceof RbPPPoEServiceProfile) {
            return 2;
        }
        if (serviceProfile instanceof RbVoIPServiceProfile) {
            return 3;
        }
        if (serviceProfile instanceof RbIPModeDataServiceProfile) {
            return 4;
        }
        if (serviceProfile instanceof RbIPModeVoIPServiceProfile) {
            return 5;
        }
        if (serviceProfile instanceof RbManagedVoIPServiceProfile) {
            return 6;
        }
        if (serviceProfile instanceof RbIPModeMngVoIPServiceProfile) {
            return 7;
        }
        throw new RuntimeException("Invalid service class: " + ((Object)((Object)serviceProfile)).getClass().getName());
    }

    public static int lookupServiceType(RbService service) {
        if (service instanceof RbL2Service) {
            return 1;
        }
        if (service instanceof RbPPPoEService) {
            return 2;
        }
        if (service instanceof RbVoIPService) {
            return 3;
        }
        throw new RuntimeException("Invalid service class: " + ((Object)((Object)service)).getClass().getName());
    }

    public static Class<? extends RbService> lookupServiceClass(int serviceType) {
        switch (serviceType) {
            case 1: {
                return RbL2Service.class;
            }
            case 2: {
                return RbPPPoEService.class;
            }
            case 3: {
                return RbVoIPService.class;
            }
        }
        throw new RuntimeException("Invalid service type: " + serviceType);
    }

    public static int toRbServiceAdminStatus(int serviceAdminStatus) {
        return serviceAdminStatus == Service.STATUS_ENABLE ? 1 : 2;
    }

    public static int toServiceAdminStatus(int rbServiceAdminStatus) {
        return rbServiceAdminStatus == 1 ? Service.STATUS_ENABLE : Service.STATUS_DISABLE;
    }

    public static boolean isCandidateEqual(RbService service, RbServiceConfigEntry serviceCfgEntry, Map<Long, RbServiceProfile> spMap, Map<Long, Subscriber> subscriberMap) {
        if (RbServiceSynchronizationUtil.vlanParamsEqual(service, serviceCfgEntry)) {
            RbServiceProfile serviceProfile = (RbServiceProfile)service.getServiceProfile();
            RbServiceProfile entryServiceProfile = spMap.get(serviceCfgEntry.getRbServiceServiceTemplateIdx());
            Subscriber subscriber = subscriberMap.get(serviceCfgEntry.getRbSubscriberIdx());
            boolean ret = null != entryServiceProfile && null != subscriber && serviceProfile == entryServiceProfile && RbServiceSynchronizationUtil.isObjectEqual(service.getSubscriber().getSubscriberId(), subscriber.getSubscriberId());
            return ret;
        }
        return false;
    }

    public static boolean isCandidateEqual(RbService service, RbServiceConfigEntry serviceCfgEntry, RbServiceProfiles serviceProfiles, RbSubscriberTable subscriberTable) {
        if (service.getSubscriberUnitEUID().equalsIgnoreCase(MacAddress.fromOctetString((String)serviceCfgEntry.getRbServiceSuMacAddress()).toSimpleString()) && RbServiceSynchronizationUtil.vlanParamsEqual(service, serviceCfgEntry)) {
            RbServiceProfile serviceProfile = (RbServiceProfile)service.getServiceProfile();
            RbServiceTemplateConfigEntry serviceTemplateCfgEntry = serviceProfiles.findServiceProfileEntryByIdx(serviceCfgEntry.getRbServiceServiceTemplateIdx());
            RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberIdx(serviceCfgEntry.getRbSubscriberIdx());
            return null != serviceTemplateCfgEntry && null != subscriberEntry && RbServiceSynchronizationUtil.isObjectEqual(RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile), serviceTemplateCfgEntry.getRbServiceTemplateType()) && RbServiceSynchronizationUtil.isObjectEqual(serviceProfile.getName(), serviceTemplateCfgEntry.getRbServiceTemplateName()) && RbServiceSynchronizationUtil.isCandidateEqual(serviceProfile, serviceTemplateCfgEntry, serviceProfiles) && RbServiceSynchronizationUtil.isObjectEqual(service.getSubscriber().getSubscriberId(), subscriberEntry.getRbSubscriberID());
        }
        return false;
    }

    private static boolean vlanParamsEqual(RbService service, RbServiceConfigEntry serviceCfgEntry) {
        Integer entryAccessVlan = null != serviceCfgEntry.getRbServiceAccessVLAN() ? serviceCfgEntry.getRbServiceAccessVLAN() : 4095;
        Integer entryVlanClassMode = null != serviceCfgEntry.getRbServiceVLANClassificationMode() ? serviceCfgEntry.getRbServiceVLANClassificationMode() : 1;
        return RbServiceSynchronizationUtil.isObjectEqual(service.getRbServiceVLANHybridMode(), serviceCfgEntry.getRbServiceVLANHybridMode()) && RbServiceSynchronizationUtil.isObjectEqual(service.getRbServiceAccessVLAN(), entryAccessVlan) && RbServiceSynchronizationUtil.isObjectEqual(service.getRbServiceVLANClassificationMode(), entryVlanClassMode) && RbServiceConfigTable.vlanListEqual(service.getRbServiceClientSiteVLANList(), service.getRbServiceClientSiteVLANListCount(), serviceCfgEntry.getRbServiceClientSiteVLANListAsString(), serviceCfgEntry.getRbServiceClientSiteVLANListCount());
    }

    public static boolean isCandidateEqual(RbServiceProfile serviceProfile, RbServiceTemplateConfigEntry serviceTemplateCfgEntry, RbServiceProfiles serviceProfiles) {
        if (RbServiceSynchronizationUtil.isCandidateSPBaseEqual(serviceProfile, serviceTemplateCfgEntry)) {
            switch (serviceTemplateCfgEntry.getRbServiceTemplateType()) {
                case 1: {
                    RbL2ServiceProfile rbL2ServiceProfile = (RbL2ServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isObjectEqual(rbL2ServiceProfile.getMaxNumberOfSimultaneousCalls(), serviceTemplateCfgEntry.getRbServiceTemplateNumberOfSimultaneousCalls()) && RbServiceSynchronizationUtil.isEqual(rbL2ServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles) && (rbL2ServiceProfile.getVLANTransparencyMode() == 1 || RbServiceSynchronizationUtil.isEqual(rbL2ServiceProfile.getForwardingRule(), serviceProfiles.findForwardingRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplateForwardingRuleIdx()), serviceProfiles));
                    return ret;
                }
                case 2: {
                    RbPPPoEServiceProfile rbPPPoEServiceProfile = (RbPPPoEServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isEqual(rbPPPoEServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles) && (rbPPPoEServiceProfile.getVLANTransparencyMode() == 1 || RbServiceSynchronizationUtil.isEqual(rbPPPoEServiceProfile.getForwardingRule(), serviceProfiles.findForwardingRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplateForwardingRuleIdx()), serviceProfiles));
                    return ret;
                }
                case 3: {
                    RbVoIPServiceProfile rbVoIPServiceProfile = (RbVoIPServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isObjectEqual(rbVoIPServiceProfile.getMaxNumberOfSimultaneousCalls(), serviceTemplateCfgEntry.getRbServiceTemplateNumberOfSimultaneousCalls()) && (rbVoIPServiceProfile.getVLANTransparencyMode() == 1 || RbServiceSynchronizationUtil.isEqual(rbVoIPServiceProfile.getForwardingRule(), serviceProfiles.findForwardingRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplateForwardingRuleIdx()), serviceProfiles));
                    return ret;
                }
                case 4: {
                    RbIPModeDataServiceProfile rbIPModeDataServiceProfile = (RbIPModeDataServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isEqual(rbIPModeDataServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles) && RbServiceSynchronizationUtil.isObjectEqual(rbIPModeDataServiceProfile.getServiceGroupName(), serviceTemplateCfgEntry.getRbServiceTemplateGroupName());
                    return ret;
                }
                case 5: {
                    RbIPModeVoIPServiceProfile rbIPModeVoIPServiceProfile = (RbIPModeVoIPServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isEqual(rbIPModeVoIPServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles);
                    return ret;
                }
                case 6: {
                    RbVoiceDomainsEntry rbVoiceDomainsEntry = serviceProfiles.findVoiceDomainEntry(serviceTemplateCfgEntry.getRbServiceTemplateVoiceDomainIdx());
                    RbManagedVoIPServiceProfile rbManagedVoIPServiceProfile = (RbManagedVoIPServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isObjectEqual(rbManagedVoIPServiceProfile.getMaxNumberOfSimultaneousCalls(), serviceTemplateCfgEntry.getRbServiceTemplateNumberOfSimultaneousCalls()) && (rbManagedVoIPServiceProfile.getVLANTransparencyMode() == 1 || RbServiceSynchronizationUtil.isEqual(rbManagedVoIPServiceProfile.getForwardingRule(), serviceProfiles.findForwardingRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplateForwardingRuleIdx()), serviceProfiles)) && RbServiceSynchronizationUtil.isEqual(rbManagedVoIPServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles) && RbServiceSynchronizationUtil.isObjectEqual(rbManagedVoIPServiceProfile.getVoiceDomainName(), rbVoiceDomainsEntry != null ? rbVoiceDomainsEntry.getRbVoiceDomainName() : null);
                    return ret;
                }
                case 7: {
                    RbVoiceDomainsEntry rbVoiceDomainsEntry = serviceProfiles.findVoiceDomainEntry(serviceTemplateCfgEntry.getRbServiceTemplateVoiceDomainIdx());
                    RbIPModeMngVoIPServiceProfile rbIPModeManagedVoIPServiceProfile = (RbIPModeMngVoIPServiceProfile)serviceProfile;
                    boolean ret = RbServiceSynchronizationUtil.isObjectEqual(rbIPModeManagedVoIPServiceProfile.getMaxNumberOfSimultaneousCalls(), serviceTemplateCfgEntry.getRbServiceTemplateNumberOfSimultaneousCalls()) && RbServiceSynchronizationUtil.isEqual(rbIPModeManagedVoIPServiceProfile.getPolicyRule(), serviceProfiles.findPolicyRuleEntry(serviceTemplateCfgEntry.getRbServiceTemplatePolicyRuleIdx()), serviceProfiles) && RbServiceSynchronizationUtil.isObjectEqual(rbIPModeManagedVoIPServiceProfile.getVoiceDomainName(), rbVoiceDomainsEntry != null ? rbVoiceDomainsEntry.getRbVoiceDomainName() : null);
                    return ret;
                }
            }
        }
        return false;
    }

    private static boolean isCandidateSPBaseEqual(RbServiceProfile serviceProfile, RbServiceTemplateConfigEntry serviceTemplateCfgEntry) {
        return Integer.valueOf(4).equals(serviceTemplateCfgEntry.getRbServiceTemplateType()) || Integer.valueOf(7).equals(serviceTemplateCfgEntry.getRbServiceTemplateType()) || Integer.valueOf(5).equals(serviceTemplateCfgEntry.getRbServiceTemplateType()) || RbServiceSynchronizationUtil.isObjectEqual(serviceProfile.getVPLId(), serviceTemplateCfgEntry.getRbServiceTemplateBaseVLAN()) && RbServiceSynchronizationUtil.isObjectEqual(serviceProfile.getVLANTransparencyMode(), serviceTemplateCfgEntry.getRbServiceTemplateVLANTransparencyMode()) && RbServiceSynchronizationUtil.isObjectEqual(serviceProfile.getPriorityMarkingMode(), serviceTemplateCfgEntry.getRbServiceTemplateQoSMarkingMode()) && (1 == serviceProfile.getPriorityMarkingMode() || RbServiceSynchronizationUtil.isObjectEqual(serviceProfile.getPriorityMarkingValue(), serviceTemplateCfgEntry.getRbServiceTemplateQoSMarkingValue()));
    }

    public static boolean isCandidateEqual(RbSubscriber subscriber, RbSubscriberEntry subscriberEntry) {
        return RbServiceSynchronizationUtil.isStringEqualOrNullAndEmpty(subscriber.getFirstName(), subscriberEntry.getRbSubscriberFirstName()) && RbServiceSynchronizationUtil.isStringEqualOrNullAndEmpty(subscriber.getLastName(), subscriberEntry.getRbSubscriberLastName()) && RbServiceSynchronizationUtil.isStringEqualOrNullAndEmpty(subscriber.getSnmpDescription(), subscriberEntry.getRbSubscriberInfo());
    }

    public static boolean isEqual(RbForwardingRule forwardingRule, RbForwardingRuleConfigEntry forwardingRuleCfgEntry, RbServiceProfiles serviceProfiles) {
        return RbServiceSynchronizationUtil.isForwardingBaseEqual(forwardingRule, forwardingRuleCfgEntry) && null != forwardingRule && !forwardingRule.isValueNull() && RbServiceSynchronizationUtil.isEqual(forwardingRule.getQoS(), serviceProfiles.findQosProfileEntry(forwardingRuleCfgEntry.getRbForwardingRuleMulticastQoSIdx()));
    }

    public static boolean isForwardingBaseEqual(RbForwardingRule forwardingRule, RbForwardingRuleConfigEntry forwardingRuleCfgEntry) {
        if (null == forwardingRule) {
            return null == forwardingRuleCfgEntry;
        }
        if (null == forwardingRuleCfgEntry) {
            return false;
        }
        if (forwardingRule.isValueNull() && forwardingRuleCfgEntry.getRbForwardingRuleName().startsWith(TRANSPARENT_FWD_RULE_NAME_PREFIX)) {
            return true;
        }
        boolean ret = RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getName(), forwardingRuleCfgEntry.getRbForwardingRuleName()) && RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getType(), forwardingRuleCfgEntry.getRbForwardingRuleType()) && (forwardingRule.getType() != 1 && forwardingRule.getType() != 6 && forwardingRule.getType() != 7 || RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getUnicastRelaying(), forwardingRuleCfgEntry.getRbForwardingRuleUnicastRelaying()) && RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getUnknownAddrPolicy(), forwardingRuleCfgEntry.getRbForwardingUnknownAddrPolicy()) && RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getMulticastRelaying(), forwardingRuleCfgEntry.getRbForwardingRuleMulticastRelaying())) && RbServiceSynchronizationUtil.isObjectEqual(forwardingRule.getMulticastVLAN(), forwardingRuleCfgEntry.getRbForwardingRuleMulticastVLAN());
        return ret;
    }

    public static boolean isEqual(RbPolicyRule policyRule, RbPolicyRuleConfigEntry policyRuleCfgEntry, RbServiceProfiles serviceProfiles) {
        return RbServiceSynchronizationUtil.isPolicyBaseEqual(policyRule, policyRuleCfgEntry) && null != policyRule && RbServiceSynchronizationUtil.isEqual(policyRule.getUpQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx1())) && RbServiceSynchronizationUtil.isEqual(policyRule.getUpQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx2())) && RbServiceSynchronizationUtil.isEqual(policyRule.getUpQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx3())) && RbServiceSynchronizationUtil.isEqual(policyRule.getUpQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx4())) && RbServiceSynchronizationUtil.isEqual(policyRule.getDownQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx1())) && RbServiceSynchronizationUtil.isEqual(policyRule.getDownQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx2())) && RbServiceSynchronizationUtil.isEqual(policyRule.getDownQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx3())) && RbServiceSynchronizationUtil.isEqual(policyRule.getDownQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx4()));
    }

    public static boolean isPolicyBaseEqual(RbPolicyRule policyRule, RbPolicyRuleConfigEntry policyRuleCfgEntry) {
        if (null == policyRule) {
            return null == policyRuleCfgEntry;
        }
        boolean ret = null != policyRuleCfgEntry && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getName(), policyRuleCfgEntry.getRbPolicyRuleName()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getPriorityType(), policyRuleCfgEntry.getRbPolicyRulePriorityType()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getUpQoSUpperLimit1(), policyRuleCfgEntry.getRbPolicyRuleUpQoSUpperLimit1()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getUpQoSUpperLimit2(), policyRuleCfgEntry.getRbPolicyRuleUpQoSUpperLimit2()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getUpQoSUpperLimit3(), policyRuleCfgEntry.getRbPolicyRuleUpQoSUpperLimit3()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getUpQoSUpperLimit4(), policyRuleCfgEntry.getRbPolicyRuleUpQoSUpperLimit4()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getDownQoSUpperLimit1(), policyRuleCfgEntry.getRbPolicyRuleDownQoSUpperLimit1()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getDownQoSUpperLimit2(), policyRuleCfgEntry.getRbPolicyRuleDownQoSUpperLimit2()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getDownQoSUpperLimit3(), policyRuleCfgEntry.getRbPolicyRuleDownQoSUpperLimit3()) && RbServiceSynchronizationUtil.isObjectEqual(policyRule.getDownQoSUpperLimit4(), policyRuleCfgEntry.getRbPolicyRuleDownQoSUpperLimit4());
        return ret;
    }

    public static boolean isEqual(RbQoSProfile qosProfile, RbQoSProfileConfigEntry qosProfileCfgEntry) {
        if (null == qosProfile || qosProfile.isValueNull()) {
            return null == qosProfileCfgEntry;
        }
        return !(null == qosProfileCfgEntry || !RbServiceSynchronizationUtil.isObjectEqual(qosProfile.getName(), qosProfileCfgEntry.getRbQoSProfileName()) || !RbServiceSynchronizationUtil.isObjectEqual(qosProfile.getType(), qosProfileCfgEntry.getRbQoSProfileType()) || 3 != qosProfile.getType() && !RbServiceSynchronizationUtil.isObjectEqual(qosProfile.getParam1(), qosProfileCfgEntry.getRbQoSProfileParam1()) || 1 != qosProfile.getType() && !RbServiceSynchronizationUtil.isObjectEqual(qosProfile.getParam2(), qosProfileCfgEntry.getRbQoSProfileParam2()) || 0 != qosProfile.getType() && !RbServiceSynchronizationUtil.isObjectEqual(qosProfile.getParamTime(), qosProfileCfgEntry.getRbQoSProfileParamTime()));
    }

    private static final boolean isObjectEqual(Object a, Object b) {
        return null == a ? null == b : a.equals(b);
    }

    private static final boolean isStringEqualOrNullAndEmpty(String a, String b) {
        return null == a || "".equals(a) ? null == b || "".equals(b) : a.equals(b);
    }
}

