/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbServiceManagementHelper;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbBSPFServerGlobal;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbIPModeDataServiceProfile;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceSynchronizationHelper {
    private static final Logger logger = Logger.getLogger(RbServiceSynchronizationHelper.class);
    private RbBaseStationEquipment baseStation;

    public RbServiceSynchronizationHelper(RbBaseStationEquipment baseStation) {
        this.baseStation = baseStation;
    }

    public void synchronizeServiceProfilesFull() throws ConfigurationNotSynchronizedException {
        long totalTime = System.currentTimeMillis();
        long time1 = System.currentTimeMillis();
        logger.debug((Object)"SynchronizationProcess - syncServiceProfiles: wait for ServicesLock...");
        RbServiceManagementHelper.getServiceProfilesMgmtDBGiantLock();
        logger.debug((Object)("SynchronizationProcess - syncServiceProfiles: got ServicesLock in: " + (System.currentTimeMillis() - time1) + " millis"));
        time1 = System.currentTimeMillis();
        StringBuffer queryStr = new StringBuffer("select entry from " + RbServiceTemplateConfigEntry.class.getName() + " as entry");
        queryStr.append(" where entry.NRConfiguration.id = :nrConfigId");
        queryStr.append(" and not exists ( select sp from " + RbServiceProfile.class.getName() + " as sp" + " where entry.complexKey1 = sp.complexKey1" + " and entry.complexKey2 = sp.complexKey2" + " and entry.complexKey3 = sp.complexKey3 )");
        Long nrConfigId = this.baseStation.findCurrentConfiguration().findNetworkResourceConfiguration("BS").getId();
        Query query = Datastore.session().createQuery(queryStr.toString()).setLong("nrConfigId", nrConfigId.longValue());
        List serviceTemplateEntries = query.list();
        logger.debug((Object)("SynchronizationProcess - syncServiceProfiles: " + serviceTemplateEntries.size() + "  time: " + (System.currentTimeMillis() - time1) + " millis"));
        if (!serviceTemplateEntries.isEmpty()) {
            time1 = System.currentTimeMillis();
            RbServiceProfiles serviceProfiles = new RbServiceProfiles(this.baseStation.findCurrentConfiguration().findNetworkResourceConfiguration("BS"));
            logger.debug((Object)("SynchronizationProcess - syncServiceProfiles: retrieve mos in: " + (System.currentTimeMillis() - time1) + " millis"));
            for (RbServiceTemplateConfigEntry entry : serviceTemplateEntries) {
                RbServiceProfile created = this.createServiceProfile(serviceProfiles, entry);
                ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)created);
            }
        }
        logger.debug((Object)("SynchronizationProcess - syncServiceProfilesFull in: " + (System.currentTimeMillis() - totalTime) + " millis"));
        Boolean debugComplexKeys = Boolean.getBoolean("com.bwanms.rb.ddi.checkSPComplexKeysForDebug");
        if (debugComplexKeys.booleanValue()) {
            try {
                RbServiceSynchronizationHelper.checkSPComplexKeysForDebug();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void checkSPComplexKeysForDebug() {
        long time = System.currentTimeMillis();
        Query query = Datastore.session().createQuery("from " + RbServiceProfile.class.getName());
        Iterator it = query.iterate();
        while (it.hasNext()) {
            RbServiceProfile sp = (RbServiceProfile)((Object)it.next());
            String currentComplexKey = sp.getComplexKey();
            String computedComplexKey = sp.computeComplexKey();
            if (computedComplexKey.equals(currentComplexKey)) continue;
            logger.error((Object)("XXYYZZ - INVALID COMPLEXKEY FOR SP: " + sp.getId() + "\nXXYYZZ - CURRENT:  [" + currentComplexKey + "]\nXXYYZZ - COMPUTED: [" + computedComplexKey + "]"));
        }
        logger.debug((Object)("SynchronizationProcess - DEBUG ServiceProfiles time: " + (System.currentTimeMillis() - time) + " millis"));
    }

    public static void updateServiceProfilesComplexKeys(RbServiceProfiles serviceProfiles) {
        for (RbQoSProfileConfigEntry qosEntry : serviceProfiles.getQosProfileConfigTable().getEntries()) {
            qosEntry.computeAndSetComplexKey();
            Datastore.session().saveOrUpdate((Object)qosEntry);
        }
        for (RbForwardingRuleConfigEntry forwardingEntry : serviceProfiles.getForwardingRuleConfigTable().getEntries()) {
            forwardingEntry.computeAndSetComplexKey(serviceProfiles, false);
            Datastore.session().saveOrUpdate((Object)forwardingEntry);
        }
        for (RbPolicyRuleConfigEntry policyEntry : serviceProfiles.getPolicyRuleConfigTable().getEntries()) {
            policyEntry.computeAndSetComplexKey(serviceProfiles, false);
            Datastore.session().saveOrUpdate((Object)policyEntry);
        }
        for (RbServiceTemplateConfigEntry serviceTemplateEntry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
            serviceTemplateEntry.computeAndSetComplexKey(serviceProfiles, false);
            Datastore.session().saveOrUpdate((Object)serviceTemplateEntry);
        }
    }

    public void synchronizeSubscribersFull() {
        long time1 = System.currentTimeMillis();
        logger.debug((Object)"SynchronizationProcess - syncSubscribers: wait for ServicesLock...");
        RbServiceManagementHelper.getSubscribersMgmtDBGiantLock();
        logger.debug((Object)("SynchronizationProcess - syncSubscribers: got ServicesLock in: " + (System.currentTimeMillis() - time1) + " millis"));
        time1 = System.currentTimeMillis();
        StringBuffer queryStr = new StringBuffer("select entry from " + RbSubscriberEntry.class.getName() + " as entry");
        queryStr.append(" where entry.NRConfiguration.id = :nrConfigId");
        queryStr.append(" and not exists ( select sub from " + RbSubscriber.class.getName() + " as sub" + " where entry.complexKey = sub.complexKey )");
        Long nrConfigId = this.baseStation.findCurrentConfiguration().findNetworkResourceConfiguration("BS").getId();
        Query query = Datastore.session().createQuery(queryStr.toString()).setLong("nrConfigId", nrConfigId.longValue());
        List subscriberEntries = query.list();
        logger.debug((Object)("SynchronizationProcess - syncSubscribers: " + subscriberEntries.size() + "  time: " + (System.currentTimeMillis() - time1) + " millis"));
        for (RbSubscriberEntry entry : subscriberEntries) {
            RbSubscriber created = this.createSubscriber(entry);
            ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)created);
        }
    }

    public static void updateComplexKeysAndAdminStatus(List<RbSubscriberEntry> subscriberEntries) {
        for (RbSubscriberEntry subEntry : subscriberEntries) {
            subEntry.computeAndSetComplexKey();
            subEntry.setAdminStatus(subEntry.getRbSubscriberAdminStatus());
        }
    }

    public static void updateServiceProfileName(List<RbServiceConfigEntry> serviceConfigEntries, List<RbServiceTemplateConfigEntry> serviceTemplateConfigEntries, Collection<String> serviceTemplateInstances) {
        for (RbServiceConfigEntry serviceCfgEntry : serviceConfigEntries) {
            Long serviceServiceTemplateIdx = serviceCfgEntry.getRbServiceServiceTemplateIdx();
            if (null == serviceServiceTemplateIdx || 0L == serviceServiceTemplateIdx || !serviceTemplateInstances.contains(String.valueOf(serviceServiceTemplateIdx))) continue;
            for (RbServiceTemplateConfigEntry stEntry : serviceTemplateConfigEntries) {
                if (!serviceServiceTemplateIdx.equals(stEntry.getRbServiceTemplateIdx())) continue;
                serviceCfgEntry.setRbServiceServiceTemplateName(stEntry.getRbServiceTemplateName());
            }
        }
    }

    public static void updateSubscriberNames(List<RbServiceConfigEntry> serviceConfigEntries, List<RbSubscriberEntry> subscriberEntries, Collection<String> subscriberInstances) {
        for (RbServiceConfigEntry serviceCfgEntry : serviceConfigEntries) {
            Long serviceEntrySubscriberIdx = serviceCfgEntry.getRbSubscriberIdx();
            if (null == serviceEntrySubscriberIdx || 0L == serviceEntrySubscriberIdx || !subscriberInstances.contains(String.valueOf(serviceEntrySubscriberIdx))) continue;
            for (RbSubscriberEntry subEntry : subscriberEntries) {
                if (!serviceEntrySubscriberIdx.equals(subEntry.getRbSubscriberIdx())) continue;
                serviceCfgEntry.setRbSubscriberID(subEntry.getRbSubscriberID());
            }
        }
    }

    public RbSubscriber createSubscriber(RbSubscriberEntry subscriberEntry) {
        RbSubscriber subscriber = new RbSubscriber();
        subscriber.setSubscriberId(subscriberEntry.getRbSubscriberID());
        subscriber.setFirstName(subscriberEntry.getRbSubscriberFirstName());
        subscriber.setLastName(subscriberEntry.getRbSubscriberLastName());
        subscriber.setSnmpDescription(subscriberEntry.getRbSubscriberInfo());
        subscriber.setComplexKey(subscriberEntry.getComplexKey());
        return subscriber;
    }

    public RbServiceProfile createServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbServiceProfile ret = null;
        switch (spInstance.getRbServiceTemplateType()) {
            case 1: {
                ret = this.createL2ServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 2: {
                ret = this.createPPPoEServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 3: {
                ret = this.createVoIPServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 4: {
                ret = this.createIPModeDataServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 5: {
                ret = this.createIPModeVoIPServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 6: {
                ret = this.createManagedVoIPServiceProfile(serviceProfiles, spInstance);
                break;
            }
            case 7: {
                ret = this.createIPModeManagedVoIPServiceProfile(serviceProfiles, spInstance);
                break;
            }
            default: {
                throw new RuntimeException("Invalid service profile type: " + spInstance.getRbServiceTemplateType());
            }
        }
        ret.setName(spInstance.getRbServiceTemplateName());
        ret.setComplexKey(spInstance.getComplexKey());
        return ret;
    }

    private RbL2ServiceProfile createL2ServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbL2ServiceProfile l2Profile = new RbL2ServiceProfile();
        this.populateServiceProfileBaseParams(l2Profile, spInstance);
        l2Profile.setMaxNumberOfSimultaneousCalls(spInstance.getRbServiceTemplateNumberOfSimultaneousCalls());
        l2Profile.setForwardingRule(l2Profile.getVLANTransparencyMode() == 1 ? new RbForwardingRule() : this.createForwardingRule(serviceProfiles, spInstance.getRbServiceTemplateForwardingRuleIdx()));
        l2Profile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        return l2Profile;
    }

    private RbPPPoEServiceProfile createPPPoEServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbPPPoEServiceProfile ppoeProfile = new RbPPPoEServiceProfile();
        this.populateServiceProfileBaseParams(ppoeProfile, spInstance);
        ppoeProfile.setForwardingRule(ppoeProfile.getVLANTransparencyMode() == 1 ? new RbForwardingRule() : this.createForwardingRule(serviceProfiles, spInstance.getRbServiceTemplateForwardingRuleIdx()));
        ppoeProfile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        return ppoeProfile;
    }

    private RbIPModeDataServiceProfile createIPModeDataServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbIPModeDataServiceProfile rbIPModeServiceProfile = new RbIPModeDataServiceProfile();
        this.populateServiceProfileBaseParams(rbIPModeServiceProfile, spInstance);
        rbIPModeServiceProfile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        rbIPModeServiceProfile.setServiceGroupName(spInstance.getRbServiceTemplateGroupName());
        return rbIPModeServiceProfile;
    }

    private RbIPModeVoIPServiceProfile createIPModeVoIPServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbIPModeVoIPServiceProfile rbIPModeVoIPServiceProfile = new RbIPModeVoIPServiceProfile();
        this.populateServiceProfileBaseParams(rbIPModeVoIPServiceProfile, spInstance);
        rbIPModeVoIPServiceProfile.setForwardingRule(rbIPModeVoIPServiceProfile.getVLANTransparencyMode() == 1 ? new RbForwardingRule() : this.createForwardingRule(serviceProfiles, spInstance.getRbServiceTemplateForwardingRuleIdx()));
        rbIPModeVoIPServiceProfile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        return rbIPModeVoIPServiceProfile;
    }

    private RbVoIPServiceProfile createVoIPServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbVoIPServiceProfile voipProfile = new RbVoIPServiceProfile();
        this.populateServiceProfileBaseParams(voipProfile, spInstance);
        voipProfile.setMaxNumberOfSimultaneousCalls(spInstance.getRbServiceTemplateNumberOfSimultaneousCalls());
        voipProfile.setForwardingRule(voipProfile.getVLANTransparencyMode() == 1 ? new RbForwardingRule() : this.createForwardingRule(serviceProfiles, spInstance.getRbServiceTemplateForwardingRuleIdx()));
        return voipProfile;
    }

    private RbManagedVoIPServiceProfile createManagedVoIPServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbManagedVoIPServiceProfile managedVoIPProfile = new RbManagedVoIPServiceProfile();
        this.populateServiceProfileBaseParams(managedVoIPProfile, spInstance);
        managedVoIPProfile.setMaxNumberOfSimultaneousCalls(spInstance.getRbServiceTemplateNumberOfSimultaneousCalls());
        managedVoIPProfile.setForwardingRule(managedVoIPProfile.getVLANTransparencyMode() == 1 ? new RbForwardingRule() : this.createForwardingRule(serviceProfiles, spInstance.getRbServiceTemplateForwardingRuleIdx()));
        managedVoIPProfile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        managedVoIPProfile.setVoiceDomainName(spInstance.getRbServiceTemplateVoiceDomainName());
        return managedVoIPProfile;
    }

    private RbIPModeMngVoIPServiceProfile createIPModeManagedVoIPServiceProfile(RbServiceProfiles serviceProfiles, RbServiceTemplateConfigEntry spInstance) throws ConfigurationNotSynchronizedException {
        RbIPModeMngVoIPServiceProfile rbIPModeMngVoIPServiceProfile = new RbIPModeMngVoIPServiceProfile();
        rbIPModeMngVoIPServiceProfile.setMaxNumberOfSimultaneousCalls(spInstance.getRbServiceTemplateNumberOfSimultaneousCalls());
        rbIPModeMngVoIPServiceProfile.setPolicyRule(this.createPolicyRule(serviceProfiles, spInstance.getRbServiceTemplatePolicyRuleIdx()));
        rbIPModeMngVoIPServiceProfile.setVoiceDomainName(spInstance.getRbServiceTemplateVoiceDomainName());
        return rbIPModeMngVoIPServiceProfile;
    }

    private void populateServiceProfileBaseParams(RbServiceProfile serviceProfile, RbServiceTemplateConfigEntry spInstance) {
        serviceProfile.setVPLId(spInstance.getRbServiceTemplateBaseVLAN());
        serviceProfile.setVLANTransparencyMode(spInstance.getRbServiceTemplateVLANTransparencyMode());
        serviceProfile.setPriorityMarkingMode(spInstance.getRbServiceTemplateQoSMarkingMode());
        if (null != serviceProfile.getPriorityMarkingMode()) {
            serviceProfile.setPriorityMarkingValue(1 == serviceProfile.getPriorityMarkingMode() ? 0 : spInstance.getRbServiceTemplateQoSMarkingValue());
        } else {
            serviceProfile.setPriorityMarkingValue(0);
        }
    }

    private RbPolicyRule createPolicyRule(RbServiceProfiles serviceProfiles, Long policyRuleIdx) throws ConfigurationNotSynchronizedException {
        if (null == policyRuleIdx) {
            throw new ConfigurationNotSynchronizedException("Policy Rules not synchronized!");
        }
        if (0L == policyRuleIdx) {
            return null;
        }
        RbPolicyRuleConfigEntry policyRuleInstance = serviceProfiles.findPolicyRuleEntry(policyRuleIdx);
        if (null == policyRuleInstance) {
            throw new ConfigurationNotSynchronizedException("Policy Rules not synchronized!");
        }
        RbPolicyRule policyRule = new RbPolicyRule();
        policyRule.setName(policyRuleInstance.getRbPolicyRuleName());
        policyRule.setPriorityType(policyRuleInstance.getRbPolicyRulePriorityType());
        policyRule.setDownQoSProfile1(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleDownQoSProfileIdx1()));
        policyRule.setDownQoSProfile2(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleDownQoSProfileIdx2()));
        policyRule.setDownQoSProfile3(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleDownQoSProfileIdx3()));
        policyRule.setDownQoSProfile4(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleDownQoSProfileIdx4()));
        policyRule.setUpQoSProfile1(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleUpQoSProfileIdx1()));
        policyRule.setUpQoSProfile2(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleUpQoSProfileIdx2()));
        policyRule.setUpQoSProfile3(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleUpQoSProfileIdx3()));
        policyRule.setUpQoSProfile4(this.createQoSProfile(serviceProfiles, policyRuleInstance.getRbPolicyRuleUpQoSProfileIdx4()));
        policyRule.setDownQoSUpperLimit1(policyRuleInstance.getRbPolicyRuleDownQoSUpperLimit1());
        policyRule.setDownQoSUpperLimit2(policyRuleInstance.getRbPolicyRuleDownQoSUpperLimit2());
        policyRule.setDownQoSUpperLimit3(policyRuleInstance.getRbPolicyRuleDownQoSUpperLimit3());
        policyRule.setDownQoSUpperLimit4(policyRuleInstance.getRbPolicyRuleDownQoSUpperLimit4());
        policyRule.setUpQoSUpperLimit1(policyRuleInstance.getRbPolicyRuleUpQoSUpperLimit1());
        policyRule.setUpQoSUpperLimit2(policyRuleInstance.getRbPolicyRuleUpQoSUpperLimit2());
        policyRule.setUpQoSUpperLimit3(policyRuleInstance.getRbPolicyRuleUpQoSUpperLimit3());
        policyRule.setUpQoSUpperLimit4(policyRuleInstance.getRbPolicyRuleUpQoSUpperLimit4());
        return policyRule;
    }

    private RbForwardingRule createForwardingRule(RbServiceProfiles serviceProfiles, Long fwRuleIdx) throws ConfigurationNotSynchronizedException {
        if (null == fwRuleIdx) {
            throw new ConfigurationNotSynchronizedException("Forwarding Rules not synchronized!");
        }
        if (0L == fwRuleIdx) {
            return null;
        }
        RbForwardingRuleConfigEntry fwRuleInstance = serviceProfiles.findForwardingRuleEntry(fwRuleIdx);
        if (null == fwRuleInstance) {
            throw new ConfigurationNotSynchronizedException("Forwarding Rules not synchronized!");
        }
        RbForwardingRule forwardingRule = new RbForwardingRule();
        forwardingRule.setName(fwRuleInstance.getRbForwardingRuleName());
        forwardingRule.setType(fwRuleInstance.getRbForwardingRuleType());
        if (Integer.valueOf(1).equals(forwardingRule.getType()) || Integer.valueOf(6).equals(forwardingRule.getType()) || Integer.valueOf(7).equals(forwardingRule.getType())) {
            forwardingRule.setUnicastRelaying(fwRuleInstance.getRbForwardingRuleUnicastRelaying());
            forwardingRule.setMulticastRelaying(fwRuleInstance.getRbForwardingRuleMulticastRelaying());
            forwardingRule.setUnknownAddrPolicy(fwRuleInstance.getRbForwardingUnknownAddrPolicy());
        }
        forwardingRule.setMulticastVLAN(fwRuleInstance.getRbForwardingRuleMulticastVLAN());
        forwardingRule.setQoS(this.createQoSProfile(serviceProfiles, fwRuleInstance.getRbForwardingRuleMulticastQoSIdx()));
        return forwardingRule;
    }

    private RbQoSProfile createQoSProfile(RbServiceProfiles serviceProfiles, Long qosProfileIdx) throws ConfigurationNotSynchronizedException {
        if (null == qosProfileIdx) {
            throw new ConfigurationNotSynchronizedException("QoS Profiles not synchronized!");
        }
        if (0L == qosProfileIdx) {
            return null;
        }
        RbQoSProfileConfigEntry qosInstance = serviceProfiles.findQosProfileEntry(qosProfileIdx);
        if (null == qosInstance) {
            throw new ConfigurationNotSynchronizedException("QoS Profiles not synchronized");
        }
        RbQoSProfile qosProfile = new RbQoSProfile();
        qosProfile.setName(qosInstance.getRbQoSProfileName());
        qosProfile.setType(qosInstance.getRbQoSProfileType());
        qosProfile.setParam1(qosInstance.getRbQoSProfileParam1());
        qosProfile.setParam2(qosInstance.getRbQoSProfileParam2());
        qosProfile.setParamTime(qosInstance.getRbQoSProfileParamTime());
        return qosProfile;
    }

    private RbVoiceDomainGlobal createVoiceDomain(RbServiceProfiles serviceProfiles, Long voiceDomainIdx) throws ConfigurationNotSynchronizedException {
        if (null == voiceDomainIdx) {
            throw new ConfigurationNotSynchronizedException("Voice Domain not synchronized!");
        }
        if (0L == voiceDomainIdx) {
            return null;
        }
        RbVoiceDomainsEntry voiceDomainInstance = serviceProfiles.findVoiceDomainEntry(voiceDomainIdx);
        if (null == voiceDomainInstance) {
            throw new ConfigurationNotSynchronizedException("Voice Domain not synchronized");
        }
        RbVoiceDomainGlobal voiceDomain = new RbVoiceDomainGlobal();
        voiceDomain.setVoiceDomainName(voiceDomainInstance.getRbVoiceDomainName());
        voiceDomain.setPrimaryPFServer(this.createPFServer(serviceProfiles, voiceDomainInstance.getRbVoiceDomainPrimaryPFIpAddress()));
        return voiceDomain;
    }

    private RbBSPFServerGlobal createPFServer(RbServiceProfiles serviceProfiles, String ipAddress) throws ConfigurationNotSynchronizedException {
        if (null == ipAddress) {
            throw new ConfigurationNotSynchronizedException("PF Server not synchronized!");
        }
        if ("".equals(ipAddress)) {
            return null;
        }
        RbBSPFServersEntry voiceDomainInstance = serviceProfiles.findPFServerEntry(ipAddress);
        if (null == voiceDomainInstance) {
            throw new ConfigurationNotSynchronizedException("PF Server not synchronized");
        }
        RbBSPFServerGlobal pfServer = new RbBSPFServerGlobal();
        pfServer.setIpAddress(voiceDomainInstance.getRbBSPFServerAddress());
        pfServer.setPortNumber(voiceDomainInstance.getRbBSPFServerPortNumber());
        pfServer.setPfVlan(voiceDomainInstance.getRbBSPFServerPFVlan());
        pfServer.setSharedString(voiceDomainInstance.getRbBSPFServerSharedString());
        return pfServer;
    }
}

