/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ServiceManagementStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Equipment;
import com.bwanms.model.Service;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Subscriber;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.ddi.RbServiceManagementHelper;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.util.ServerValidationException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceManagementStrategy
implements ServiceManagementStrategy {
    public List<Equipment> findServiceInstances(Service service) {
        ArrayList<Equipment> ret = new ArrayList<Equipment>();
        return ret;
    }

    public List<Equipment> findServiceProfileInstances(ServiceProfile serviceProfile) {
        ArrayList<Equipment> ret = new ArrayList<Equipment>();
        ret.addAll(((RbServiceProfile)serviceProfile).getSupportingEquipment());
        return ret;
    }

    public int deployServiceProfile(ServiceProfile serviceProfile, Equipment equipment) throws Exception {
        return this.deployServiceProfile((RbServiceProfile)serviceProfile, equipment, true);
    }

    public int deployServiceProfile(ServiceProfile serviceProfile, Equipment equipment, boolean overwrite) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        return helper.deployServiceProfile((RbServiceProfile)serviceProfile, overwrite);
    }

    public int undeployServiceProfile(ServiceProfile serviceProfile, Equipment equipment) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        return helper.undeployServiceProfile((RbServiceProfile)serviceProfile);
    }

    public int deployService(Service service, Equipment equipment) throws Exception {
        return this.deployService(service, equipment, true);
    }

    public int undeployService(Service service, Equipment equipment) throws Exception {
        return this.undeployService(service, equipment, false);
    }

    public int deployService(Service service, Equipment equipment, boolean mergeServiceProfiles) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        return helper.deployService((RbService)service, mergeServiceProfiles);
    }

    public int undeployService(Service service, Equipment equipment, boolean undeploySubscriber) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        int ret = helper.undeployService((RbService)service);
        if (0 == ret && undeploySubscriber) {
            ret = helper.undeploySubscriber((RbSubscriber)service.getSubscriber());
        }
        return ret;
    }

    public List<Equipment> findSubscriberInstances(Subscriber subscriber) {
        ArrayList<Equipment> ret = new ArrayList<Equipment>();
        ret.addAll(((RbSubscriber)subscriber).getSupportingEquipment());
        return ret;
    }

    public int deploySubscriber(Subscriber subscriber, Equipment equipment) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        return helper.deploySubscriber((RbSubscriber)subscriber);
    }

    public int undeploySubscriber(Subscriber subscriber, Equipment equipment) throws Exception {
        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper((RbBaseStationEquipment)equipment);
        return helper.undeploySubscriber((RbSubscriber)subscriber);
    }

    public Service updateService(Service service) throws ServerValidationException {
        return service;
    }

    public ServiceProfile updateServiceProfile(ServiceProfile serviceProfile) throws ServerValidationException {
        RbServiceProfile rbSp = (RbServiceProfile)serviceProfile;
        rbSp.setServiceTemplateEntries(null);
        RbServiceProfile ret = RbServiceManagementHelper.saveNewServiceProfile(Datastore.session(), rbSp, false);
        if (null == ret) {
            Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceManagementStrategy.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("ServiceProfileNotUnique"), RbServiceProfile.class, "", (Object)"", (Object)serviceProfile));
            throw new ServerValidationException(iValues);
        }
        return ret;
    }

    public Subscriber updateSubscriber(Subscriber subscriber) throws ServerValidationException {
        RbSubscriber ret = RbServiceManagementHelper.saveNewSubscriber(Datastore.session(), (RbSubscriber)subscriber, false);
        if (null == ret) {
            Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceManagementStrategy.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("SubscriberNotUnique"), RbSubscriber.class, "", (Object)"", (Object)subscriber));
            throw new ServerValidationException(iValues);
        }
        return ret;
    }

    public void deleteService(Service service) throws ServerValidationException {
        throw new RuntimeException("Not Implemented!");
    }

    public void deleteSubscriber(Subscriber subscriber) throws ServerValidationException {
        RbServiceManagementHelper.getSubscribersMgmtDBGiantLock();
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        if (this.findSubscriberInstances(subscriber).size() > 0) {
            iValues.add(new InvalidValue("SubscriberDeployed", Subscriber.class, "", null, null));
        }
        if (0 != iValues.size()) {
            throw new ServerValidationException(iValues);
        }
        Datastore.session().delete((Object)subscriber);
    }

    public void deleteServiceProfile(ServiceProfile serviceProfile) throws ServerValidationException {
        RbServiceManagementHelper.getServiceProfilesMgmtDBGiantLock();
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        if (this.findServiceProfileInstances(serviceProfile).size() > 0) {
            iValues.add(new InvalidValue("ServiceProfileDeployed", ServiceProfile.class, "", null, null));
        }
        if (0 != iValues.size()) {
            throw new ServerValidationException(iValues);
        }
        Datastore.session().delete((Object)serviceProfile);
    }
}

