/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.model.ManagedEntityBase;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.SessionLockHelper;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbSubscriber;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class RbServiceManagementHelper {
    private static String SERVICE_PROFILES_MGMT_GIANT_LOCK = "ServiceProfilesMgmtGiantLock";
    private static String SUBSCRIBERS_MGMT_GIANT_LOCK = "SubscribersMgmtGiantLock";

    public static void getServiceProfilesMgmtDBGiantLock() {
        Datastore.lock((String)SERVICE_PROFILES_MGMT_GIANT_LOCK);
    }

    public static void getServiceProfilesMgmtDBGiantLock(Session session) {
        SessionLockHelper.lock((Session)session, (String)SERVICE_PROFILES_MGMT_GIANT_LOCK);
    }

    public static void getSubscribersMgmtDBGiantLock() {
        Datastore.lock((String)SUBSCRIBERS_MGMT_GIANT_LOCK);
    }

    public static void getSubscribersMgmtDBGiantLock(Session session) {
        SessionLockHelper.lock((Session)session, (String)SUBSCRIBERS_MGMT_GIANT_LOCK);
    }

    public static RbServiceProfile saveNewServiceProfile(Session session, RbServiceProfile serviceProfile, boolean returnDuplicate) {
        serviceProfile.computeAndSetComplexKey();
        RbServiceManagementHelper.getServiceProfilesMgmtDBGiantLock(session);
        RbServiceProfile equalSp = RbServiceManagementHelper.findEqualServiceProfileByComplexKey(session, serviceProfile);
        if (null != equalSp) {
            if (returnDuplicate) {
                return equalSp;
            }
            return null;
        }
        if (0L == serviceProfile.getId()) {
            ManagedEntityBase.persist((Session)session, (ManagedEntityBase)serviceProfile);
        } else {
            session.update((Object)serviceProfile);
        }
        return serviceProfile;
    }

    public static RbServiceProfile findEqualServiceProfileByComplexKey(Session session, RbServiceProfile serviceProfile) {
        Query query = session.createQuery("select sp from " + ((Object)((Object)serviceProfile)).getClass().getName() + " as sp where " + "sp.complexKey1 = :complexKey1 and sp.complexKey2 = :complexKey2 and sp.complexKey3 = :complexKey3 and sp.id != :id").setString("complexKey1", serviceProfile.getComplexKey1()).setString("complexKey2", serviceProfile.getComplexKey2()).setString("complexKey3", serviceProfile.getComplexKey3()).setLong("id", serviceProfile.getId());
        List sps = query.list();
        if (sps.isEmpty()) {
            return null;
        }
        return (RbServiceProfile)((Object)sps.get(0));
    }

    public static RbSubscriber saveNewSubscriber(Session session, RbSubscriber subscriber, boolean returnDuplicate) {
        subscriber.computeAndSetComplexKey();
        RbServiceManagementHelper.getSubscribersMgmtDBGiantLock(session);
        RbSubscriber equalSubscriber = RbServiceManagementHelper.findEqualSubscriberByComplexKey(session, subscriber);
        if (null != equalSubscriber) {
            if (returnDuplicate) {
                return equalSubscriber;
            }
            return null;
        }
        if (0L == subscriber.getId()) {
            ManagedEntityBase.persist((Session)session, (ManagedEntityBase)subscriber);
        } else {
            session.update((Object)subscriber);
        }
        return subscriber;
    }

    public static RbSubscriber findEqualSubscriberByComplexKey(Session session, RbSubscriber subscriber) {
        Query query = session.createQuery("select sub from " + ((Object)((Object)subscriber)).getClass().getName() + " as sub where " + "sub.complexKey = :complexKey and sub.id != :id").setString("complexKey", subscriber.getComplexKey()).setLong("id", subscriber.getId());
        List subscribers = query.list();
        if (subscribers.isEmpty()) {
            return null;
        }
        return (RbSubscriber)((Object)subscribers.get(0));
    }
}

