/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbServiceManagementHelper;
import com.bwanms.rb.ddi.RbServiceSynchronizationHelper;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceEntryAssemblerFactory
implements AssemblerFactory<RbServiceConfigEntry> {
    public Assembler<RbServiceConfigEntry> createAssembler(Class<? extends RbServiceConfigEntry> baseClass, String assembler) {
        return new Assembler<RbServiceConfigEntry>(){

            public Assembly<RbServiceConfigEntry> getAssembly(RbServiceConfigEntry serviceEntry) throws ServiceException {
                RbSubscriber subscriber;
                serviceEntry = (RbServiceConfigEntry)((Object)Datastore.session().get(((Object)((Object)serviceEntry)).getClass(), (Serializable)Long.valueOf(serviceEntry.getId())));
                NetworkResourceConfiguration nrConfig = serviceEntry.getNRConfiguration();
                RbSubscriberTable subscriberTable = (RbSubscriberTable)nrConfig.findManagedObject(RbSubscriberTable.class);
                RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberIdx(serviceEntry.getRbSubscriberIdx());
                RbServiceSynchronizationHelper syncHelper = new RbServiceSynchronizationHelper((RbBaseStationEquipment)subscriberEntry.getNRConfiguration().getConfiguration().getEquipment());
                if (subscriberEntry.getComplexKey() == null) {
                    ArrayList<RbSubscriberEntry> list = new ArrayList<RbSubscriberEntry>();
                    list.add(subscriberEntry);
                    RbServiceSynchronizationHelper.updateComplexKeysAndAdminStatus(list);
                }
                if ((subscriber = (RbSubscriber)((Object)Datastore.session().createQuery("from " + RbSubscriber.class.getName() + " where complexKey = :complexKey").setString("complexKey", subscriberEntry.getComplexKey()).uniqueResult())) == null) {
                    subscriber = syncHelper.createSubscriber(subscriberEntry);
                    subscriber = RbServiceManagementHelper.saveNewSubscriber(Datastore.session(), subscriber, true);
                }
                return new RbServiceEntryAssembly(serviceEntry, subscriber);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RbServiceEntryAssembly
    implements Assembly<RbServiceConfigEntry> {
        private static final long serialVersionUID = 4069813018556168278L;
        private RbServiceConfigEntry entity;
        private RbSubscriber subscriber;

        public RbServiceEntryAssembly(RbServiceConfigEntry entity, RbSubscriber subscriber) {
            this.entity = entity;
            this.subscriber = subscriber;
        }

        public RbServiceConfigEntry getEntity() {
            return this.entity;
        }

        public RbSubscriber getSubscriber() {
            return this.subscriber;
        }
    }
}

