/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.mo.snmp.DynamicTableMO;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.rb.ddi.RbServiceSynchronizationUtil;
import com.bwanms.rb.gui.services.RbServiceEditorView;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigTable;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigTable;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigTable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbIPModeDataServiceProfile;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MacAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceDeploymentHelper {
    private static final Logger logger = Logger.getLogger(RbServiceDeploymentHelper.class);
    private RbBaseStationEquipment baseStation;

    public RbServiceDeploymentHelper(RbBaseStationEquipment baseStation) {
        this.baseStation = baseStation;
    }

    public int deployService(RbService service, boolean mergeServiceProfile) throws Exception {
        RbServiceTemplateConfigEntry profile;
        Class<RbServiceConfigTable> serviceTblClass = RbServiceConfigTable.class;
        DynamicTableMO serviceTable = (DynamicTableMO)this.baseStation.findCurrentConfiguration().findManagedObject("BS", serviceTblClass).clone();
        NetworkResourceConfiguration nrConfig = this.baseStation.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation);
        this.checkServiceDeployment(service, (RbServiceConfigTable)serviceTable, serviceProfiles);
        int serviceType = RbServiceSynchronizationUtil.lookupServiceType(service);
        RbServiceConfigEntry serviceCfgEntry = ((RbServiceConfigTable)serviceTable).findEntryByName(service.getName());
        if (null == serviceCfgEntry) {
            serviceCfgEntry = new RbServiceConfigEntry(this.baseStation.isTDDDuplexMode());
            serviceCfgEntry.setRbServiceIdx(-1L);
            serviceCfgEntry.setRbServiceName(service.getName());
            serviceCfgEntry.setRbServiceType(serviceType);
            RbSubscriberTable subscriberTable = (RbSubscriberTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbSubscriberTable.class);
            RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberID(service.getSubscriber().getSubscriberId());
            if (null == subscriberEntry) {
                subscriberEntry = this.deploySubscriberInternal((RbSubscriber)service.getSubscriber());
            }
            serviceCfgEntry.setRbSubscriberIdx(subscriberEntry.getRbSubscriberIdx());
            serviceTable.addEntry((TableRowMO)serviceCfgEntry);
        } else {
            List subscribers = nrConfig.retrieveManagedObjects(RbSubscriberEntry.class, "*");
            RbSubscriberTable subscriberTable = new RbSubscriberTable(subscribers);
            RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberIdx(serviceCfgEntry.getRbSubscriberIdx());
            if (null != subscriberEntry && !subscriberEntry.getRbSubscriberID().equals(service.getSubscriber().getSubscriberId())) {
                throw new ServiceManagementException("SubscriberCannotBeChangedOnExistingServices");
            }
            if (service.getAdminStatus() == RbServiceSynchronizationUtil.toServiceAdminStatus(serviceCfgEntry.getRbServiceAdminStatus()) && RbServiceSynchronizationUtil.isCandidateEqual(service, serviceCfgEntry, serviceProfiles, subscriberTable)) {
                return 2;
            }
        }
        MacAddress macAddress = MacAddress.fromSimpleString((String)service.getSubscriberUnitEUID());
        String macAddressOctetStr = macAddress.toOctetString();
        if (!this.isProvisionedSU(macAddressOctetStr)) {
            this.provisionSU(macAddressOctetStr);
        }
        serviceCfgEntry.setRbServiceSuMacAddress(macAddressOctetStr);
        if (mergeServiceProfile) {
            this.deployServiceProfile((RbServiceProfile)service.getServiceProfile(), true);
        }
        if (null == (profile = (serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation)).findServiceProfileEntry(service.getServiceProfile().getName()))) {
            throw new ServiceManagementException("ServiceProfileCouldNotBeFoundOrDeployed");
        }
        serviceCfgEntry.setRbServiceServiceTemplateIdx(profile.getRbServiceTemplateIdx());
        serviceCfgEntry.setRbServiceClientSiteVLANListAsString(service.getRbServiceClientSiteVLANList());
        serviceCfgEntry.setRbServiceClientSiteVLANListCount(service.getRbServiceClientSiteVLANListCount());
        serviceCfgEntry.setRbServiceAdminStatus(RbServiceSynchronizationUtil.toRbServiceAdminStatus(service.getAdminStatus()));
        serviceCfgEntry.setRbServiceVLANHybridMode(service.getRbServiceVLANHybridMode());
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        cfgHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)serviceTable);
        return 0;
    }

    public int undeployService(RbService service) throws Exception {
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)((RbServiceConfigTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbServiceConfigTable.class)).clone();
        RbServiceConfigEntry serviceCfgEntry = serviceTable.findEntryByName(service.getName());
        if (null != serviceCfgEntry) {
            serviceTable.removeEntry(serviceCfgEntry.getRowKey());
            ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
            cfgHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)serviceTable);
            return 0;
        }
        return 2;
    }

    public int renameService(RbService service, String targetName) throws Exception {
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbServiceConfigTable.class);
        if (null != serviceTable.findEntryByName(targetName)) {
            logger.debug((Object)(" --- renameService: Service " + targetName + " already exists!"));
            return 1;
        }
        RbServiceConfigEntry serviceCfgEntry = (serviceTable = (RbServiceConfigTable)serviceTable.clone()).findEntryByName(service.getName());
        if (null != serviceCfgEntry) {
            serviceCfgEntry.setRbServiceName(service.getName());
            ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
            cfgHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)serviceTable);
            return 0;
        }
        logger.debug((Object)(" --- renameService: Service " + service.getName() + " not found!"));
        return 2;
    }

    public int deployServiceProfile(RbServiceProfile serviceProfile, boolean overwrite) throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        RbServiceTemplateConfigEntry serviceTemplateCfgEntry = serviceProfiles.findServiceProfileEntry(serviceProfile.getName());
        boolean serviceTemplateFound = null != serviceTemplateCfgEntry;
        int serviceProfileType = RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile);
        if (serviceTemplateFound) {
            if (new Integer(2).equals(serviceTemplateCfgEntry.getRbServiceTemplateClass())) {
                throw new ServiceManagementException("GlobalServiceProfileCannotBeChanged");
            }
            if (serviceProfileType != serviceTemplateCfgEntry.getRbServiceTemplateType()) {
                throw new ServiceManagementException("AServiceProfileWithSameNameAndDifferentTypeAlreadyDeployed");
            }
            if (RbServiceSynchronizationUtil.isCandidateEqual(serviceProfile, serviceTemplateCfgEntry, serviceProfiles)) {
                return 2;
            }
            logger.debug((Object)("--- updating Service Template Entry with Idx: " + serviceTemplateCfgEntry.getRbServiceTemplateIdx()));
        } else {
            serviceTemplateCfgEntry = new RbServiceTemplateConfigEntry();
            serviceTemplateCfgEntry.setRbServiceTemplateIdx(-1L);
            serviceTemplateCfgEntry.setRbServiceTemplateName(serviceProfile.getName());
            serviceTemplateCfgEntry.setRbServiceTemplateType(serviceProfileType);
        }
        if (Integer.valueOf(4).equals(serviceTemplateCfgEntry.getRbServiceTemplateType()) || Integer.valueOf(5).equals(serviceTemplateCfgEntry.getRbServiceTemplateType())) {
            serviceTemplateCfgEntry.setRbServiceTemplateBaseVLAN(null);
        } else {
            serviceTemplateCfgEntry.setRbServiceTemplateVLANTransparencyMode(serviceProfile.getVLANTransparencyMode());
            if (serviceTemplateCfgEntry.getRbServiceTemplateVLANTransparencyMode() != null && serviceTemplateCfgEntry.getRbServiceTemplateVLANTransparencyMode() == 1) {
                serviceTemplateCfgEntry.setRbServiceTemplateBaseVLAN(4096);
            } else {
                serviceTemplateCfgEntry.setRbServiceTemplateBaseVLAN(serviceProfile.getVPLId());
            }
            serviceTemplateCfgEntry.setRbServiceTemplateQoSMarkingMode(serviceProfile.getPriorityMarkingMode());
            serviceTemplateCfgEntry.setRbServiceTemplateQoSMarkingValue(serviceProfile.getPriorityMarkingValue());
        }
        switch (serviceTemplateCfgEntry.getRbServiceTemplateType()) {
            case 1: {
                RbL2ServiceProfile rbL2ServiceProfile = (RbL2ServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(rbL2ServiceProfile.getMaxNumberOfSimultaneousCalls());
                serviceTemplateCfgEntry.setRbServiceTemplateForwardingRuleIdx(this.findOrAddForwardingRule(rbL2ServiceProfile.getForwardingRule(), serviceProfile, serviceProfiles, overwrite));
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbL2ServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                break;
            }
            case 2: {
                RbPPPoEServiceProfile rbPPPoEServiceProfile = (RbPPPoEServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplateForwardingRuleIdx(this.findOrAddForwardingRule(rbPPPoEServiceProfile.getForwardingRule(), serviceProfile, serviceProfiles, overwrite));
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbPPPoEServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(null);
                break;
            }
            case 3: {
                RbVoIPServiceProfile rbVoIPServiceProfile = (RbVoIPServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(rbVoIPServiceProfile.getMaxNumberOfSimultaneousCalls());
                serviceTemplateCfgEntry.setRbServiceTemplateForwardingRuleIdx(this.findOrAddForwardingRule(rbVoIPServiceProfile.getForwardingRule(), serviceProfile, serviceProfiles, overwrite));
                break;
            }
            case 4: {
                RbIPModeDataServiceProfile rbIPModeDataServiceProfile = (RbIPModeDataServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbIPModeDataServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                if (RbVersions.V_4_1.isSupersetOf(this.baseStation.getSoftwareVersion())) {
                    // empty if block
                }
                if (RbVersions.V_4_5.isSupersetOf(this.baseStation.getSoftwareVersion())) {
                    if (rbIPModeDataServiceProfile.getServiceGroupName().equals("")) {
                        throw new ServiceManagementException("NoServiceGroup", (Object[])new String[]{rbIPModeDataServiceProfile.getServiceGroupName()});
                    }
                    long serviceGroupIndex = this.findServiceGroup(rbIPModeDataServiceProfile.getServiceGroupName(), serviceProfiles);
                    if (serviceGroupIndex == 0L) {
                        throw new ServiceManagementException("ServiceGroupNotFound", (Object[])new String[]{rbIPModeDataServiceProfile.getServiceGroupName()});
                    }
                    serviceTemplateCfgEntry.setRbServiceTemplateGroupName(rbIPModeDataServiceProfile.getServiceGroupName());
                }
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(null);
                break;
            }
            case 5: {
                RbIPModeVoIPServiceProfile rbIPModeVoIPServiceProfile = (RbIPModeVoIPServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbIPModeVoIPServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                break;
            }
            case 6: {
                RbManagedVoIPServiceProfile rbManagedVoIPServiceProfile = (RbManagedVoIPServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(rbManagedVoIPServiceProfile.getMaxNumberOfSimultaneousCalls());
                serviceTemplateCfgEntry.setRbServiceTemplateForwardingRuleIdx(this.findOrAddForwardingRule(rbManagedVoIPServiceProfile.getForwardingRule(), serviceProfile, serviceProfiles, overwrite));
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbManagedVoIPServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                if (!RbFeatures.isSipAwareAvailable(this.baseStation)) {
                    throw new ServiceManagementException("SipAwareNotAvailableOnThisEquipment");
                }
                long voiceDomainIndex = this.findVoiceDomain(rbManagedVoIPServiceProfile.getVoiceDomainName(), serviceProfiles);
                if (voiceDomainIndex == 0L) {
                    throw new ServiceManagementException("VoiceDomainNotFound", (Object[])new String[]{rbManagedVoIPServiceProfile.getVoiceDomainName()});
                }
                serviceTemplateCfgEntry.setRbServiceTemplateVoiceDomainName(rbManagedVoIPServiceProfile.getVoiceDomainName());
                serviceTemplateCfgEntry.setRbServiceTemplateVoiceDomainIdx(voiceDomainIndex);
                break;
            }
            case 7: {
                RbIPModeMngVoIPServiceProfile rbIPModeManagedVoIPServiceProfile = (RbIPModeMngVoIPServiceProfile)serviceProfile;
                serviceTemplateCfgEntry.setRbServiceTemplateNumberOfSimultaneousCalls(rbIPModeManagedVoIPServiceProfile.getMaxNumberOfSimultaneousCalls());
                serviceTemplateCfgEntry.setRbServiceTemplateForwardingRuleIdx(null);
                serviceTemplateCfgEntry.setRbServiceTemplatePolicyRuleIdx(this.findOrAddPolicyRule(rbIPModeManagedVoIPServiceProfile.getPolicyRule(), serviceProfiles, overwrite));
                if (!RbFeatures.isSipAwareAvailable(this.baseStation)) {
                    throw new ServiceManagementException("SipAwareNotAvailableOnThisEquipment");
                }
                long voiceDomainIndex = this.findVoiceDomain(rbIPModeManagedVoIPServiceProfile.getVoiceDomainName(), serviceProfiles);
                if (voiceDomainIndex == 0L) {
                    throw new ServiceManagementException("VoiceDomainNotFound", (Object[])new String[]{rbIPModeManagedVoIPServiceProfile.getVoiceDomainName()});
                }
                serviceTemplateCfgEntry.setRbServiceTemplateVoiceDomainName(rbIPModeManagedVoIPServiceProfile.getVoiceDomainName());
                serviceTemplateCfgEntry.setRbServiceTemplateVoiceDomainIdx(voiceDomainIndex);
                serviceTemplateCfgEntry.setRbServiceTemplateQoSMarkingMode(null);
                serviceTemplateCfgEntry.setRbServiceTemplateQoSMarkingValue(null);
                serviceTemplateCfgEntry.setRbServiceTemplateBaseVLAN(null);
                serviceTemplateCfgEntry.setRbServiceTemplateVLANTransparencyMode(null);
            }
        }
        RbServiceConfigTable servicesCfgTable = (RbServiceConfigTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbServiceConfigTable.class);
        if (this.baseStation.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            RbServiceDeploymentHelper.checkServiceTemplateDeploymentVLANS(serviceTemplateCfgEntry, serviceProfiles.getServiceTemplateConfigTable(), servicesCfgTable);
        }
        if (!serviceTemplateFound) {
            serviceProfiles.getServiceTemplateConfigTable().addEntry((TableRowMO)serviceTemplateCfgEntry);
            logger.debug((Object)("--- added Service Template Entry with Idx: " + serviceTemplateCfgEntry.getRbServiceTemplateIdx()));
        }
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        serviceProfiles.commit(cfgHelper);
        return 0;
    }

    public int undeployServiceProfile(RbServiceProfile serviceProfile) throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        NetworkResourceConfiguration nrConfig = this.baseStation.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        RbServiceTemplateConfigEntry serviceTemplateCfgEntry = serviceProfiles.findServiceProfileEntry(serviceProfile.getName());
        if (null != serviceTemplateCfgEntry && RbServiceDeploymentHelper.isObjectEqual(serviceProfile.getComplexKey(), serviceTemplateCfgEntry.getComplexKey())) {
            if (new Integer(2).equals(serviceTemplateCfgEntry.getRbServiceTemplateClass())) {
                throw new ServiceManagementException("GlobalServiceProfileCannotBeChanged");
            }
            long spInstanceIdx = serviceTemplateCfgEntry.getRbServiceTemplateIdx();
            List dfltSTs = nrConfig.retrieveManagedObjects(RbDfltServiceTemplateEntry.class, "*");
            for (RbDfltServiceTemplateEntry entry : dfltSTs) {
                if (null == entry.getRbDfltServiceTemplateIdx() || 0L == entry.getRbDfltServiceTemplateIdx() || spInstanceIdx != entry.getRbDfltServiceTemplateIdx()) continue;
                logger.debug((Object)(" --- undeployServiceProfile: " + serviceProfile.getName() + "  !!! is default SP !!!"));
                throw new ServiceManagementException("ServiceProfileIsDefault");
            }
            List serviceTable = nrConfig.retrieveManagedObjects(RbServiceConfigEntry.class, "*");
            for (RbServiceConfigEntry serviceEntry : serviceTable) {
                if (spInstanceIdx != serviceEntry.getRbServiceServiceTemplateIdx()) continue;
                logger.debug((Object)(" --- undeployServiceProfile: " + serviceProfile.getName() + "  !!! is used by service " + serviceEntry.getRbServiceName()));
                throw new ServiceManagementException("ServiceProfileInUse");
            }
            serviceProfiles.getServiceTemplateConfigTable().removeEntry(serviceTemplateCfgEntry.getRowKey());
            ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
            serviceProfiles.commit(cfgHelper);
            return 0;
        }
        return 2;
    }

    public int renameServiceProfile(RbServiceProfile serviceProfile, String targetName) throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        if (null != serviceProfiles.findServiceProfileEntry(targetName)) {
            return 1;
        }
        RbServiceTemplateConfigEntry entry = serviceProfiles.findServiceProfileEntry(serviceProfile.getName());
        if (null != entry) {
            entry.setRbServiceTemplateName(targetName);
            ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
            serviceProfiles.commit(cfgHelper);
            return 0;
        }
        return 2;
    }

    public void performForwardingAndPolicyRulesCleanup() throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        this.removeUnusedForwardingRules(serviceProfiles);
        this.removeUnusedPolicyRules(serviceProfiles);
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        serviceProfiles.commit(cfgHelper);
    }

    public void performQoSProfilesCleanup() throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        this.removeUnusedQoSProfiles(serviceProfiles);
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        serviceProfiles.commit(cfgHelper);
    }

    public void performVoiceDomainAndPFServerCleanup() throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        this.removeUnusedVoiceDomain(serviceProfiles);
        this.removeUnusedPFServer(serviceProfiles);
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        serviceProfiles.commit(cfgHelper);
    }

    public void performServiceGroupCleanup() throws Exception {
        RbServiceProfiles serviceProfiles = RbServiceDeploymentHelper.getRbServiceProfiles(this.baseStation).clone();
        this.removeUnusedServiceGroup(serviceProfiles);
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        serviceProfiles.commit(cfgHelper);
    }

    public int deploySubscriber(RbSubscriber subscriber) throws Exception {
        RbSubscriberTable subscriberTable = (RbSubscriberTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbSubscriberTable.class);
        RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberID(subscriber.getSubscriberId());
        if (null != subscriberEntry) {
            return 2;
        }
        this.deploySubscriberInternal(subscriber);
        return 0;
    }

    private RbSubscriberEntry deploySubscriberInternal(RbSubscriber subscriber) throws Exception {
        RbSubscriberTable subscriberTable = (RbSubscriberTable)((RbSubscriberTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbSubscriberTable.class)).clone();
        RbSubscriberEntry subscriberEntry = new RbSubscriberEntry();
        subscriberEntry.setRbSubscriberID(subscriber.getSubscriberId());
        subscriberEntry.setRbSubscriberIdx(-1L);
        String name = subscriber.getName();
        int nameIdx = name.lastIndexOf(32);
        if (-1 != nameIdx) {
            subscriberEntry.setRbSubscriberFirstName(name.substring(0, nameIdx));
            subscriberEntry.setRbSubscriberLastName(name.substring(nameIdx + 1));
        } else {
            subscriberEntry.setRbSubscriberFirstName(name);
            subscriberEntry.setRbSubscriberLastName("");
        }
        int adminStatus = 1;
        subscriberEntry.setRbSubscriberAdminStatus(adminStatus);
        subscriberEntry.setRbSubscriberInfo(subscriber.getDescription());
        subscriberTable.addEntry((TableRowMO)subscriberEntry);
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        cfgHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)subscriberTable);
        subscriberTable = (RbSubscriberTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbSubscriberTable.class);
        return subscriberTable.findEntryBySubscriberID(subscriber.getSubscriberId());
    }

    public int undeploySubscriber(RbSubscriber subscriber) throws Exception {
        RbSubscriberTable subscriberTable = (RbSubscriberTable)((RbSubscriberTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbSubscriberTable.class)).clone();
        RbSubscriberEntry subscriberEntry = subscriberTable.findEntryBySubscriberID(subscriber.getSubscriberId());
        if (null == subscriberEntry) {
            return 2;
        }
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbServiceConfigTable.class);
        for (RbServiceConfigEntry serviceEntry : serviceTable.getEntries()) {
            if (!RbServiceDeploymentHelper.isObjectEqual(serviceEntry.getRbSubscriberIdx(), subscriberEntry.getRbSubscriberIdx())) continue;
            return 1;
        }
        subscriberTable.removeEntry(subscriberEntry.getRowKey());
        ConfigurationHelper cfgHelper = Helpers.getConfigurationHelper();
        cfgHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)subscriberTable);
        return 0;
    }

    public void checkServiceDeployment(RbService service, RbServiceConfigTable serviceCfgTable, RbServiceProfiles serviceProfiles) throws ServiceManagementException {
        RbServiceTemplateConfigTable serviceTemplatesTable = serviceProfiles.getServiceTemplateConfigTable();
        RbServiceConfigEntry serviceEntry = null;
        serviceEntry = new RbServiceConfigEntry(this.baseStation.isTDDDuplexMode());
        serviceEntry.setRbServiceName(service.getName());
        serviceEntry.setRbServiceType(RbServiceSynchronizationUtil.lookupServiceType(service));
        serviceEntry.setRbServiceSuMacAddress(MacAddress.fromSimpleString((String)service.getSubscriberUnitEUID()).toOctetString());
        serviceEntry.setRbServiceClientSiteVLANListAsString(service.getRbServiceClientSiteVLANList());
        serviceEntry.setRbServiceClientSiteVLANListCount(service.getRbServiceClientSiteVLANListCount());
        serviceEntry.setRbServiceVLANHybridMode(service.getRbServiceVLANHybridMode());
        serviceEntry.setRbServiceVLANClassificationMode(service.getRbServiceVLANClassificationMode());
        serviceEntry.setRbServiceAccessVLAN(service.getRbServiceAccessVLAN());
        RbServiceTemplateConfigEntry serviceTemplateEntry = serviceTemplatesTable.findEntryByName(((RbServiceProfile)service.getServiceProfile()).getName());
        if (null != serviceTemplateEntry) {
            serviceEntry.setRbServiceServiceTemplateIdx(serviceTemplateEntry.getRbServiceTemplateIdx());
        } else {
            RbServiceProfile serviceProfile = (RbServiceProfile)service.getServiceProfile();
            serviceTemplateEntry = new RbServiceTemplateConfigEntry();
            serviceTemplateEntry.setRbServiceTemplateName(serviceProfile.getName());
            serviceTemplateEntry.setRbServiceTemplateType(RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile));
            serviceTemplateEntry.setRbServiceTemplateBaseVLAN(serviceProfile.getVPLId());
            serviceTemplateEntry.setRbServiceTemplateVLANTransparencyMode(serviceProfile.getVLANTransparencyMode());
            serviceTemplateEntry.setRbServiceTemplateQoSMarkingMode(serviceProfile.getPriorityMarkingMode());
            serviceTemplateEntry.setRbServiceTemplateQoSMarkingValue(serviceProfile.getPriorityMarkingValue());
        }
        RbServiceDeploymentHelper.checkServiceDeployment(serviceEntry, serviceCfgTable, serviceTemplateEntry, serviceTemplatesTable);
    }

    public static void checkServiceDeployment(RbServiceConfigEntry serviceEntry, UnifiedMOSupport<RbServiceConfigEntry> serviceUnifiedSupport, Collection<RbServiceTemplateConfigEntry> serviceTemplates, boolean sipAvailable) throws ServiceManagementException {
        RbServiceTemplateConfigEntry serviceTemplateEntry = null;
        for (RbServiceTemplateConfigEntry entry : serviceTemplates) {
            if (!entry.getRbServiceTemplateIdx().equals(serviceEntry.getRbServiceServiceTemplateIdx())) continue;
            serviceTemplateEntry = entry;
            break;
        }
        RbServiceDeploymentHelper.checkServiceDeployment(serviceEntry, serviceUnifiedSupport, serviceTemplateEntry, serviceTemplates, sipAvailable);
    }

    private static void checkServiceDeployment(RbServiceConfigEntry serviceEntry, UnifiedMOSupport<RbServiceConfigEntry> serviceUnifiedSupport, RbServiceTemplateConfigEntry serviceTemplateEntry, Collection<RbServiceTemplateConfigEntry> serviceTemplatesTable, boolean sipAvalilable) throws ServiceManagementException {
        boolean vlanTransparencyModeOn;
        String serviceName = serviceEntry.getRbServiceName();
        int serviceType = serviceEntry.getRbServiceType();
        String serviceSuMacAddress = serviceEntry.getRbServiceSuMacAddress();
        logger.debug((Object)("--- checkServiceDeploy: " + serviceName + "  type: " + serviceType + "  suMacAddr: " + serviceSuMacAddress));
        int[] vlanArray = RbServiceEditorView.getVLANListFromCommaSeparated(serviceEntry.getRbServiceClientSiteVLANListAsString());
        int vlanListCount = serviceEntry.getRbServiceClientSiteVLANListCount();
        boolean hybridVlanModeOn = 1 == serviceEntry.getRbServiceVLANHybridMode();
        boolean forwardUntagged = hybridVlanModeOn || 0 == vlanListCount;
        boolean forwardOnlyUntagged = hybridVlanModeOn && 0 == vlanListCount;
        Integer accessVLAN = serviceEntry.getRbServiceAccessVLAN();
        boolean bl = vlanTransparencyModeOn = 1 == serviceTemplateEntry.getRbServiceTemplateVLANTransparencyMode();
        if (vlanListCount > 16) {
            throw new ServiceManagementException("MaximumVLANsAllowedPerSUExceeded");
        }
        if (null != accessVLAN && accessVLAN < 4095 && RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(new int[]{accessVLAN}, 1, vlanArray, vlanListCount)) {
            throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
        }
        if (vlanTransparencyModeOn && (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, new int[]{serviceTemplateEntry.getRbServiceTemplateBaseVLAN()}, 1) || null != accessVLAN && accessVLAN < 4095 && accessVLAN.equals(serviceTemplateEntry.getRbServiceTemplateBaseVLAN()))) {
            throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
        }
        HashSet<String> bsServiceVLANSet = new HashSet<String>();
        RbServiceDeploymentHelper.putVLANsInSet(serviceEntry, bsServiceVLANSet);
        for (RbServiceConfigEntry entry : serviceUnifiedSupport.getInstances()) {
            boolean entryVPLIDNone;
            int[] vplIdsArray;
            if (serviceEntry.getRowKey().equals(entry.getRowKey())) continue;
            if (serviceName.equals(entry.getRbServiceName())) {
                if (serviceType == entry.getRbServiceType()) continue;
                throw new ServiceManagementException("AServiceWithSameNameAndDifferentTypeAlreadyDeployed");
            }
            if (serviceSuMacAddress.equalsIgnoreCase(entry.getRbServiceSuMacAddress())) {
                int[] entryVlanArray = RbServiceEditorView.getVLANListFromCommaSeparated(entry.getRbServiceClientSiteVLANListAsString());
                int entryVlanListCount = entry.getRbServiceClientSiteVLANListCount();
                boolean entryHybridVlanModeOn = 1 == entry.getRbServiceVLANHybridMode();
                if ((0 == vlanListCount && !hybridVlanModeOn) ^ (0 == entryVlanListCount && !entryHybridVlanModeOn)) {
                    throw new ServiceManagementException("CantAllocateOnTheSameSUPipesWithAndWithoutVLANs");
                }
                RbServiceDeploymentHelper.putVLANsInSet(entry, bsServiceVLANSet);
                if (bsServiceVLANSet.size() > 16) {
                    throw new ServiceManagementException("MaximumVLANsAllowedPerSUExceeded");
                }
                Integer entryAccessVLAN = entry.getRbServiceAccessVLAN();
                if (null != accessVLAN && accessVLAN < 4095) {
                    if (null != entryAccessVLAN && entryAccessVLAN < 4095) {
                        if (!accessVLAN.equals(entryAccessVLAN) || RbServiceDeploymentHelper.serviceTypesCompatible(serviceEntry.getRbServiceType(), entry.getRbServiceType())) {
                            throw new ServiceManagementException("OnlyoneAccessVLANallowedperSU");
                        }
                    } else if (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(new int[]{accessVLAN}, 1, entryVlanArray, entryVlanListCount)) {
                        throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
                    }
                } else if (null != entryAccessVLAN && entryAccessVLAN < 4095 && RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, new int[]{entryAccessVLAN}, 1)) {
                    throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
                }
                if (RbServiceDeploymentHelper.serviceTypesCompatible(serviceType, entry.getRbServiceType())) {
                    boolean serviceException;
                    boolean vlanListsIntersects = RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, entryVlanArray, entryVlanListCount);
                    boolean bl2 = serviceException = vlanListsIntersects || (1 == entry.getRbServiceVLANHybridMode() || 0 == entryVlanListCount) && forwardUntagged;
                    if (serviceException) {
                        if (sipAvalilable) {
                            throw new ServiceManagementException("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2ManagedOnTheSameVLAN");
                        }
                        throw new ServiceManagementException("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN");
                    }
                }
            }
            RbServiceTemplateConfigEntry stEntry = null;
            for (RbServiceTemplateConfigEntry serviceProfileEntry : serviceTemplatesTable) {
                if (!serviceProfileEntry.getRbServiceTemplateIdx().equals(entry.getRbServiceServiceTemplateIdx())) continue;
                stEntry = serviceProfileEntry;
                break;
            }
            if (null == stEntry || stEntry.getRbServiceTemplateName().equals(serviceTemplateEntry.getRbServiceTemplateName()) || !RbServiceDeploymentHelper.serviceTypesCompatible(stEntry.getRbServiceTemplateType(), serviceTemplateEntry.getRbServiceTemplateType())) continue;
            if (vlanTransparencyModeOn && (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, vplIdsArray = new int[]{stEntry.getRbServiceTemplateBaseVLAN()}, vplIdsArray.length) || null != accessVLAN && accessVLAN < 4095 && vplIdsArray[0] == accessVLAN)) {
                throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
            }
            if (!vlanTransparencyModeOn || !forwardOnlyUntagged) continue;
            boolean entryVlanTransparencyModeOn = 1 == stEntry.getRbServiceTemplateVLANTransparencyMode();
            boolean bl3 = entryVPLIDNone = 4095 == stEntry.getRbServiceTemplateBaseVLAN();
            if (entryVlanTransparencyModeOn || !entryVPLIDNone) continue;
            throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
        }
    }

    private static void putVLANsInSet(RbServiceConfigEntry serviceEntry, Set<String> set) {
        String vlans = serviceEntry.getRbServiceClientSiteVLANListAsString();
        if (vlans != null) {
            String[] vlanStringList;
            for (String vlan : vlanStringList = vlans.split("\\,")) {
                if ("0".equals(vlan)) continue;
                set.add(vlan);
            }
        }
    }

    public static void checkServiceDeployment(RbServiceConfigEntry serviceEntry, RbServiceConfigTable serviceCfgTable, RbServiceTemplateConfigTable serviceTemplatesTable) throws ServiceManagementException {
        RbServiceTemplateConfigEntry serviceTemplateEntry = serviceTemplatesTable.findEntryByRowKey(serviceEntry.getRbServiceType(), serviceEntry.getRbServiceServiceTemplateIdx());
        RbServiceDeploymentHelper.checkServiceDeployment(serviceEntry, serviceCfgTable, serviceTemplateEntry, serviceTemplatesTable);
    }

    private static void checkServiceDeployment(RbServiceConfigEntry serviceEntry, RbServiceConfigTable serviceCfgTable, RbServiceTemplateConfigEntry serviceTemplateEntry, RbServiceTemplateConfigTable serviceTemplatesTable) throws ServiceManagementException {
        boolean vlanTransparencyModeOn;
        String serviceName = serviceEntry.getRbServiceName();
        int serviceType = serviceEntry.getRbServiceType();
        String serviceSuMacAddress = serviceEntry.getRbServiceSuMacAddress();
        logger.debug((Object)("--- checkServiceDeploy: " + serviceName + "  type: " + serviceType + "  suMacAddr: " + serviceSuMacAddress));
        int[] vlanArray = RbServiceEditorView.getVLANListFromCommaSeparated(serviceEntry.getRbServiceClientSiteVLANListAsString());
        int vlanListCount = serviceEntry.getRbServiceClientSiteVLANListCount();
        boolean hybridVlanModeOn = 1 == serviceEntry.getRbServiceVLANHybridMode();
        boolean forwardUntagged = hybridVlanModeOn || 0 == vlanListCount;
        boolean forwardOnlyUntagged = hybridVlanModeOn && 0 == vlanListCount;
        Integer accessVLAN = serviceEntry.getRbServiceAccessVLAN();
        boolean vlanCountOnSU = false;
        boolean bl = vlanTransparencyModeOn = 1 == serviceTemplateEntry.getRbServiceTemplateVLANTransparencyMode();
        if (vlanListCount > 16) {
            throw new ServiceManagementException("MaximumVLANsAllowedPerSUExceeded");
        }
        if (null != accessVLAN && accessVLAN < 4095 && RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(new int[]{accessVLAN}, 1, vlanArray, vlanListCount)) {
            throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
        }
        if (vlanTransparencyModeOn && (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, new int[]{serviceTemplateEntry.getRbServiceTemplateBaseVLAN()}, 1) || null != accessVLAN && accessVLAN < 4095 && accessVLAN.equals(serviceTemplateEntry.getRbServiceTemplateBaseVLAN()))) {
            throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
        }
        HashSet<String> bsServiceVLANSet = new HashSet<String>();
        RbServiceDeploymentHelper.putVLANsInSet(serviceEntry, bsServiceVLANSet);
        for (RbServiceConfigEntry entry : serviceCfgTable.getEntries()) {
            boolean entryVPLIDNone;
            int[] vplIdsArray;
            RbServiceTemplateConfigEntry stEntry;
            if (serviceEntry.getRowKey().equals(entry.getRowKey())) continue;
            if (serviceName.equals(entry.getRbServiceName())) {
                if (serviceType == entry.getRbServiceType()) continue;
                throw new ServiceManagementException("AServiceWithSameNameAndDifferentTypeAlreadyDeployed");
            }
            if (serviceSuMacAddress.equalsIgnoreCase(entry.getRbServiceSuMacAddress())) {
                int[] entryVlanArray = RbServiceEditorView.getVLANListFromCommaSeparated(entry.getRbServiceClientSiteVLANListAsString());
                int entryVlanListCount = entry.getRbServiceClientSiteVLANListCount();
                boolean entryHybridVlanModeOn = 1 == entry.getRbServiceVLANHybridMode();
                if ((0 == vlanListCount && !hybridVlanModeOn) ^ (0 == entryVlanListCount && !entryHybridVlanModeOn)) {
                    throw new ServiceManagementException("CantAllocateOnTheSameSUPipesWithAndWithoutVLANs");
                }
                RbServiceDeploymentHelper.putVLANsInSet(entry, bsServiceVLANSet);
                if (bsServiceVLANSet.size() > 16) {
                    throw new ServiceManagementException("MaximumVLANsAllowedPerSUExceeded");
                }
                Integer entryAccessVLAN = entry.getRbServiceAccessVLAN();
                if (null != accessVLAN && accessVLAN < 4095) {
                    if (null != entryAccessVLAN && entryAccessVLAN < 4095) {
                        if (!accessVLAN.equals(entryAccessVLAN) || RbServiceDeploymentHelper.serviceTypesCompatible(serviceEntry.getRbServiceType(), entry.getRbServiceType())) {
                            throw new ServiceManagementException("OnlyoneAccessVLANallowedperSU");
                        }
                    } else if (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(new int[]{accessVLAN}, 1, entryVlanArray, entryVlanListCount)) {
                        throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
                    }
                } else if (null != entryAccessVLAN && entryAccessVLAN < 4095 && RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, new int[]{entryAccessVLAN}, 1)) {
                    throw new ServiceManagementException("AccessVLANcantbeequaltoanyVLANintheSUVLANlist");
                }
                if (RbServiceDeploymentHelper.serviceTypesCompatible(serviceType, entry.getRbServiceType())) {
                    boolean entryForwardUntagged;
                    if (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, entryVlanArray, entryVlanListCount)) {
                        throw new ServiceManagementException("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN");
                    }
                    boolean bl2 = entryForwardUntagged = 1 == entry.getRbServiceVLANHybridMode() || 0 == entryVlanListCount;
                    if (forwardUntagged && entryForwardUntagged) {
                        throw new ServiceManagementException("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN");
                    }
                }
            }
            if (null == (stEntry = serviceTemplatesTable.findEntryByRowKey(entry.getRbServiceType(), entry.getRbServiceServiceTemplateIdx())) || stEntry.getRbServiceTemplateName().equals(serviceTemplateEntry.getRbServiceTemplateName()) || !RbServiceDeploymentHelper.serviceTypesCompatible(stEntry.getRbServiceTemplateType(), serviceTemplateEntry.getRbServiceTemplateType())) continue;
            if (vlanTransparencyModeOn && (RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(vlanArray, vlanListCount, vplIdsArray = new int[]{stEntry.getRbServiceTemplateBaseVLAN()}, vplIdsArray.length) || null != accessVLAN && accessVLAN < 4095 && vplIdsArray[0] == accessVLAN)) {
                throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
            }
            if (!vlanTransparencyModeOn || !forwardOnlyUntagged) continue;
            boolean entryVlanTransparencyModeOn = 1 == stEntry.getRbServiceTemplateVLANTransparencyMode();
            boolean bl3 = entryVPLIDNone = 4095 == stEntry.getRbServiceTemplateBaseVLAN();
            if (entryVlanTransparencyModeOn || !entryVPLIDNone) continue;
            throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
        }
    }

    public static void checkServiceTemplateDeployment(RbServiceTemplateConfigEntry serviceTemplateEntry, RbServiceTemplateConfigTable serviceTemplateCfgTable, DynamicTableMO serviceCfgTable, RbBaseStationEquipment bs) throws ServiceManagementException {
        for (RbServiceTemplateConfigEntry entry : serviceTemplateCfgTable.getEntries()) {
            if (serviceTemplateEntry.getRbServiceTemplateName().equals(entry.getRbServiceTemplateName()) || !RbServiceDeploymentHelper.isObjectEqual(serviceTemplateEntry.getRbServiceTemplateBaseVLAN(), entry.getRbServiceTemplateBaseVLAN()) || !RbServiceDeploymentHelper.serviceTypesCompatible(serviceTemplateEntry.getRbServiceTemplateType(), entry.getRbServiceTemplateType()) || RbServiceDeploymentHelper.isObjectEqual(serviceTemplateEntry.getRbServiceTemplateForwardingRuleIdx(), entry.getRbServiceTemplateForwardingRuleIdx())) continue;
            if (RbFeatures.isSipAwareAvailable(bs)) {
                throw new ServiceManagementException("ForwardingRuleNotCompatibleOnVPLIdWithManaged");
            }
            throw new ServiceManagementException("ForwardingRuleNotCompatibleOnVPLId");
        }
        RbServiceDeploymentHelper.checkServiceTemplateDeploymentVLANS(serviceTemplateEntry, serviceTemplateCfgTable, serviceCfgTable);
    }

    public static void checkServiceTemplateDeploymentVLANS(RbServiceTemplateConfigEntry serviceTemplateEntry, RbServiceTemplateConfigTable serviceTemplateCfgTable, DynamicTableMO serviceCfgTable) throws ServiceManagementException {
        int[] vplIdsArray = new int[]{serviceTemplateEntry.getRbServiceTemplateBaseVLAN()};
        for (Object entry : serviceCfgTable.getEntries()) {
            int serviceEntryVlanListCount;
            int[] serviceEntryVlanArray;
            RbServiceConfigEntry serviceEntry = (RbServiceConfigEntry)((Object)entry);
            Integer svcEntryAccessVlan = serviceEntry.getRbServiceAccessVLAN();
            if (null != svcEntryAccessVlan && 4095 > svcEntryAccessVlan && vplIdsArray[0] == svcEntryAccessVlan) {
                throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
            }
            RbServiceTemplateConfigEntry svcServiceTemplateEntry = serviceTemplateCfgTable.findEntryByRowKey(serviceEntry.getRbServiceType(), serviceEntry.getRbServiceServiceTemplateIdx());
            if (null == svcServiceTemplateEntry || 1 != svcServiceTemplateEntry.getRbServiceTemplateVLANTransparencyMode() || !RbServiceDeploymentHelper.vlanListsIntersectNo0No4095(serviceEntryVlanArray = RbServiceEditorView.getVLANListFromCommaSeparated(serviceEntry.getRbServiceClientSiteVLANListAsString()), serviceEntryVlanListCount = serviceEntry.getRbServiceClientSiteVLANListCount().intValue(), vplIdsArray, vplIdsArray.length)) continue;
            throw new ServiceManagementException("TransparentVLANIDAndVPLIDMismatch");
        }
    }

    public static Internationalizer getServiceDeploymentI18n() {
        return Internationalizer.getInternationalizer((String)"com.bwanms.ddi.serviceDeployment");
    }

    private static boolean vlanListsIntersectNo0No4095(int[] vlanArray1, int vlanListCount1, int[] vlanArray2, int vlanListCount2) {
        for (int i = 0; i < vlanListCount1; ++i) {
            for (int j = 0; j < vlanListCount2; ++j) {
                if (0 >= vlanArray1[i] || 4095 <= vlanArray1[i] || vlanArray1[i] != vlanArray2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProvisionedSU(String suMacAddress) {
        RbRegisteredSuTable registeredSUsTable = (RbRegisteredSuTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbRegisteredSuTable.class);
        return null != registeredSUsTable.findEntry(suMacAddress);
    }

    private void provisionSU(String suMacAddress) throws MediationException {
        RbRegisteredSuTable registeredSUsTable = (RbRegisteredSuTable)((RbRegisteredSuTable)this.baseStation.findCurrentConfiguration().findManagedObject("BS", RbRegisteredSuTable.class)).clone();
        if (null == registeredSUsTable.findEntry(suMacAddress)) {
            RbRegisteredSuEntry suEntry = new RbRegisteredSuEntry();
            suEntry.setRbSuMacAddr(suMacAddress);
            registeredSUsTable.addEntry((TableRowMO)suEntry);
            ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
            configHelper.updateCurrentConfiguration(this.baseStation.getId(), (ManagedObject)registeredSUsTable);
        }
    }

    private long findOrAddForwardingRule(RbForwardingRule forwardingRule, RbServiceProfile serviceProfile, RbServiceProfiles serviceProfiles, boolean overwrite) throws ServiceManagementException {
        boolean forwardingRuleFound;
        if (null == forwardingRule) {
            return 0L;
        }
        if (1 == serviceProfile.getVLANTransparencyMode()) {
            long idx = RbServiceDeploymentHelper.findTransparentForwardingRuleIdx(serviceProfiles);
            if (-1L == idx) {
                throw new ServiceManagementException("TransparentForwardingRuleNotFound");
            }
            return idx;
        }
        int VPLId = serviceProfile.getVPLId();
        int spType = RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile);
        if (forwardingRule.isValueNull()) {
            throw new ServiceManagementException("ForwardingRuleNotDefined");
        }
        if (null == forwardingRule.getType()) {
            forwardingRule.setType(spType);
        }
        for (RbServiceTemplateConfigEntry entry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
            Long fwdRuleIdx;
            if (serviceProfile.getName().equals(entry.getRbServiceTemplateName()) || VPLId != entry.getRbServiceTemplateBaseVLAN() || !RbServiceDeploymentHelper.serviceTypesCompatible(spType, entry.getRbServiceTemplateType()) || null == (fwdRuleIdx = entry.getRbServiceTemplateForwardingRuleIdx())) continue;
            if (RbServiceSynchronizationUtil.isEqual(forwardingRule, serviceProfiles.findForwardingRuleEntry(fwdRuleIdx), serviceProfiles)) {
                logger.debug((Object)("--- found FW Rule for VPLId " + VPLId + "  with Idx: " + fwdRuleIdx));
                return fwdRuleIdx;
            }
            logger.debug((Object)("--- different FW Rule for VPLId + " + VPLId + " Idx: " + fwdRuleIdx));
            if (RbFeatures.isSipAwareAvailable(this.baseStation)) {
                throw new ServiceManagementException("ForwardingRuleNotCompatibleOnVPLIdWithManaged");
            }
            throw new ServiceManagementException("ForwardingRuleNotCompatibleOnVPLId");
        }
        RbForwardingRuleConfigEntry forwardingRuleCfgEntry = serviceProfiles.findForwardingRuleEntryByName(forwardingRule.getName());
        boolean bl = forwardingRuleFound = null != forwardingRuleCfgEntry;
        if (forwardingRuleFound) {
            int forwardingRuleEntryType = forwardingRuleCfgEntry.getRbForwardingRuleType();
            if (forwardingRule.getType() != forwardingRuleEntryType) {
                throw new ServiceManagementException("AForwardingRuleWithSameNameAndDifferentTypeAlreadyDeployed");
            }
            try {
                RbServiceDeploymentHelper.checkForwardingRule(forwardingRule, forwardingRuleCfgEntry, serviceProfiles);
                logger.debug((Object)(" --- found identical FW Rule with Name: " + forwardingRuleCfgEntry.getRbForwardingRuleName() + "   Idx: " + forwardingRuleCfgEntry.getRbForwardingRuleIdx()));
                return forwardingRuleCfgEntry.getRbForwardingRuleIdx();
            }
            catch (ServiceManagementException sme) {
                if (Integer.valueOf(2).equals(((Object)((Object)forwardingRuleCfgEntry)).getClass())) {
                    throw new ServiceManagementException("GlobalForwardingRuleCannotBeChanged");
                }
                if (!overwrite) {
                    throw sme;
                }
            }
        } else {
            forwardingRuleCfgEntry = new RbForwardingRuleConfigEntry();
            forwardingRuleCfgEntry.setRbForwardingRuleName(forwardingRule.getName());
            forwardingRuleCfgEntry.setRbForwardingRuleIdx(RbServiceDeploymentHelper.findNewForwardingRuleIdx(serviceProfiles));
            forwardingRuleCfgEntry.setRbForwardingRuleType(forwardingRule.getType());
        }
        forwardingRuleCfgEntry.setRbForwardingRuleUnicastRelaying(forwardingRule.getUnicastRelaying());
        forwardingRuleCfgEntry.setRbForwardingUnknownAddrPolicy(forwardingRule.getUnknownAddrPolicy());
        forwardingRuleCfgEntry.setRbForwardingRuleMulticastVLAN(forwardingRule.getMulticastVLAN());
        forwardingRuleCfgEntry.setRbForwardingRuleMulticastRelaying(forwardingRule.getMulticastRelaying());
        forwardingRuleCfgEntry.setRbForwardingRuleMulticastQoSIdx(this.findOrAddQoSProfile(forwardingRule.getQoS(), serviceProfiles, overwrite));
        if (!forwardingRuleFound) {
            serviceProfiles.getForwardingRuleConfigTable().addEntry((TableRowMO)forwardingRuleCfgEntry);
            logger.debug((Object)("--- added FW Rule Entry with Idx: " + forwardingRuleCfgEntry.getRbForwardingRuleIdx()));
        }
        return forwardingRuleCfgEntry.getRbForwardingRuleIdx();
    }

    private static long findTransparentForwardingRuleIdx(RbServiceProfiles serviceProfiles) {
        for (RbForwardingRuleConfigEntry fwRuleEntry : serviceProfiles.getForwardingRuleConfigTable().getEntries()) {
            if (!fwRuleEntry.getRbForwardingRuleName().startsWith(RbServiceSynchronizationUtil.TRANSPARENT_FWD_RULE_NAME_PREFIX)) continue;
            return fwRuleEntry.getRbForwardingRuleIdx();
        }
        return -1L;
    }

    private static void checkForwardingRule(RbForwardingRule forwardingRule, RbForwardingRuleConfigEntry forwardingRuleCfgEntry, RbServiceProfiles serviceProfiles) throws ServiceManagementException {
        if (!RbServiceSynchronizationUtil.isForwardingBaseEqual(forwardingRule, forwardingRuleCfgEntry)) {
            throw new ServiceManagementException("DifferentForwardingRuleWithSameNameFound", new Object[]{forwardingRuleCfgEntry.getRbForwardingRuleName()});
        }
        if (null != forwardingRule && !forwardingRule.isValueNull()) {
            if (!RbServiceDeploymentHelper.isQosProfileNameEqual(forwardingRule.getQoS(), serviceProfiles.findQosProfileEntry(forwardingRuleCfgEntry.getRbForwardingRuleMulticastQoSIdx()))) {
                throw new ServiceManagementException("DifferentForwardingRuleWithSameNameFound", new Object[]{forwardingRuleCfgEntry.getRbForwardingRuleName()});
            }
            RbServiceDeploymentHelper.checkQosProfile(forwardingRule.getQoS(), serviceProfiles.findQosProfileEntry(forwardingRuleCfgEntry.getRbForwardingRuleMulticastQoSIdx()));
        }
    }

    private long findOrAddPolicyRule(RbPolicyRule policyRule, RbServiceProfiles serviceProfiles, boolean overwrite) throws ServiceManagementException {
        boolean policyRuleFound;
        if (null == policyRule) {
            return 0L;
        }
        RbPolicyRuleConfigEntry policyRuleCfgEntry = serviceProfiles.findPolicyRuleEntryByName(policyRule.getName());
        boolean bl = policyRuleFound = null != policyRuleCfgEntry;
        if (policyRuleFound) {
            try {
                RbServiceDeploymentHelper.checkPolicyRule(policyRule, policyRuleCfgEntry, serviceProfiles);
                logger.debug((Object)("--- found Policy Rule Entry with Name: " + policyRuleCfgEntry.getRbPolicyRuleName() + "   Idx: " + policyRuleCfgEntry.getRbPolicyRuleIdx()));
                return policyRuleCfgEntry.getRbPolicyRuleIdx();
            }
            catch (ServiceManagementException sme) {
                if (Integer.valueOf(2).equals(((Object)((Object)policyRuleCfgEntry)).getClass())) {
                    throw new ServiceManagementException("GlobalPolicyRuleCannotBeChanged");
                }
                if (!overwrite) {
                    throw sme;
                }
            }
        } else {
            policyRuleCfgEntry = new RbPolicyRuleConfigEntry();
            policyRuleCfgEntry.setRbPolicyRuleName(policyRule.getName());
            policyRuleCfgEntry.setRbPolicyRuleIdx(RbServiceDeploymentHelper.findNewPolicyRuleIdx(serviceProfiles));
        }
        policyRuleCfgEntry.setRbPolicyRulePriorityType(policyRule.getPriorityType());
        policyRuleCfgEntry.setRbPolicyRuleUpQoSUpperLimit1(policyRule.getUpQoSUpperLimit1());
        policyRuleCfgEntry.setRbPolicyRuleUpQoSUpperLimit2(policyRule.getUpQoSUpperLimit2());
        policyRuleCfgEntry.setRbPolicyRuleUpQoSUpperLimit3(policyRule.getUpQoSUpperLimit3());
        policyRuleCfgEntry.setRbPolicyRuleUpQoSUpperLimit4(policyRule.getUpQoSUpperLimit4());
        policyRuleCfgEntry.setRbPolicyRuleDownQoSUpperLimit1(policyRule.getDownQoSUpperLimit1());
        policyRuleCfgEntry.setRbPolicyRuleDownQoSUpperLimit2(policyRule.getDownQoSUpperLimit2());
        policyRuleCfgEntry.setRbPolicyRuleDownQoSUpperLimit3(policyRule.getDownQoSUpperLimit3());
        policyRuleCfgEntry.setRbPolicyRuleDownQoSUpperLimit4(policyRule.getDownQoSUpperLimit4());
        policyRuleCfgEntry.setRbPolicyRuleUpQoSProfileIdx1(this.findOrAddQoSProfile(policyRule.getUpQoSProfile1(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleUpQoSProfileIdx2(policyRule.getUpQoSUpperLimit2() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getUpQoSProfile2(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleUpQoSProfileIdx3(policyRule.getUpQoSUpperLimit3() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getUpQoSProfile3(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleUpQoSProfileIdx4(policyRule.getUpQoSUpperLimit4() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getUpQoSProfile4(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleDownQoSProfileIdx1(this.findOrAddQoSProfile(policyRule.getDownQoSProfile1(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleDownQoSProfileIdx2(policyRule.getDownQoSUpperLimit2() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getDownQoSProfile2(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleDownQoSProfileIdx3(policyRule.getDownQoSUpperLimit3() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getDownQoSProfile3(), serviceProfiles, overwrite));
        policyRuleCfgEntry.setRbPolicyRuleDownQoSProfileIdx4(policyRule.getDownQoSUpperLimit4() == 0L ? 0L : this.findOrAddQoSProfile(policyRule.getDownQoSProfile4(), serviceProfiles, overwrite));
        if (!policyRuleFound) {
            serviceProfiles.getPolicyRuleConfigTable().addEntry((TableRowMO)policyRuleCfgEntry);
            logger.debug((Object)(" --- added Policy Rule Entry with Idx: " + policyRuleCfgEntry.getRbPolicyRuleIdx()));
        }
        return policyRuleCfgEntry.getRbPolicyRuleIdx();
    }

    private static void checkPolicyRule(RbPolicyRule policyRule, RbPolicyRuleConfigEntry policyRuleCfgEntry, RbServiceProfiles serviceProfiles) throws ServiceManagementException {
        if (!RbServiceSynchronizationUtil.isPolicyBaseEqual(policyRule, policyRuleCfgEntry)) {
            throw new ServiceManagementException("DifferentPolicyRuleWithSameNameFound", new Object[]{policyRuleCfgEntry.getRbPolicyRuleName()});
        }
        if (null != policyRule) {
            if (!(RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getDownQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx1())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getDownQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx2())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getDownQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx3())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getDownQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx4())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getUpQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx1())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getUpQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx2())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getUpQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx3())) && RbServiceDeploymentHelper.isQosProfileNameEqual(policyRule.getUpQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx4())))) {
                throw new ServiceManagementException("DifferentPolicyRuleWithSameNameFound", new Object[]{policyRuleCfgEntry.getRbPolicyRuleName()});
            }
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getDownQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx1()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getDownQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx2()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getDownQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx3()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getDownQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleDownQoSProfileIdx4()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getUpQoSProfile1(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx1()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getUpQoSProfile2(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx2()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getUpQoSProfile3(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx3()));
            RbServiceDeploymentHelper.checkQosProfile(policyRule.getUpQoSProfile4(), serviceProfiles.findQosProfileEntry(policyRuleCfgEntry.getRbPolicyRuleUpQoSProfileIdx4()));
        }
    }

    private long findOrAddQoSProfile(RbQoSProfile qosProfile, RbServiceProfiles serviceProfiles, boolean overwrite) throws ServiceManagementException {
        boolean qosFound;
        if (null == qosProfile) {
            return 0L;
        }
        RbQoSProfileConfigEntry qosProfileCfgEntry = serviceProfiles.findQosProfileEntryByName(qosProfile.getName());
        boolean bl = qosFound = null != qosProfileCfgEntry;
        if (qosFound) {
            try {
                RbServiceDeploymentHelper.checkQosProfile(qosProfile, qosProfileCfgEntry);
                logger.debug((Object)(" --- found identical QoS Entry with Name: " + qosProfileCfgEntry.getRbQoSProfileName() + "   Idx: " + qosProfileCfgEntry.getRbQoSProfileIdx()));
                return qosProfileCfgEntry.getRbQoSProfileIdx();
            }
            catch (ServiceManagementException sme) {
                if (Integer.valueOf(2).equals(((Object)((Object)qosProfileCfgEntry)).getClass())) {
                    throw new ServiceManagementException("GlobalQoSProfileCannotBeChanged");
                }
                if (!overwrite) {
                    throw sme;
                }
            }
        } else {
            qosProfileCfgEntry = new RbQoSProfileConfigEntry();
            qosProfileCfgEntry.setRbQoSProfileName(qosProfile.getName());
            qosProfileCfgEntry.setRbQoSProfileIdx(RbServiceDeploymentHelper.findNewQoSProfileIdx(serviceProfiles));
        }
        qosProfileCfgEntry.setRbQoSProfileType(qosProfile.getType());
        qosProfileCfgEntry.setRbQoSProfileParam1(qosProfile.getParam1());
        qosProfileCfgEntry.setRbQoSProfileParam2(qosProfile.getParam2());
        qosProfileCfgEntry.setRbQoSProfileParamTime(qosProfile.getParamTime());
        if (!qosFound) {
            serviceProfiles.getQosProfileConfigTable().addEntry((TableRowMO)qosProfileCfgEntry);
            logger.debug((Object)(" --- added QoS Entry with Idx: " + qosProfileCfgEntry.getRbQoSProfileIdx()));
        }
        return qosProfileCfgEntry.getRbQoSProfileIdx();
    }

    private static void checkQosProfile(RbQoSProfile qosProfile, RbQoSProfileConfigEntry qosProfileCfgEntry) throws ServiceManagementException {
        if (!RbServiceSynchronizationUtil.isEqual(qosProfile, qosProfileCfgEntry)) {
            String qosName = null != qosProfileCfgEntry ? qosProfileCfgEntry.getRbQoSProfileName() : qosProfile.getName();
            throw new ServiceManagementException("DifferentQoSWithSameNameFound", new Object[]{qosName});
        }
    }

    private static boolean isQosProfileNameEqual(RbQoSProfile qosProfile, RbQoSProfileConfigEntry qosProfileCfgEntry) {
        return null != qosProfileCfgEntry ? RbServiceDeploymentHelper.isObjectEqual(qosProfileCfgEntry.getRbQoSProfileName(), qosProfile.getName()) : null == qosProfile.getName();
    }

    private long findVoiceDomain(String voiceDomainName, RbServiceProfiles serviceProfiles) throws ServiceManagementException {
        if (null == voiceDomainName) {
            return 0L;
        }
        RbVoiceDomainsEntry rbVoiceDomainsEntry = serviceProfiles.findVoiceDomainsEntryByName(voiceDomainName);
        return rbVoiceDomainsEntry != null ? rbVoiceDomainsEntry.getRbVoiceDomainIdx() : 0L;
    }

    private long findServiceGroup(String serviceGroupName, RbServiceProfiles serviceProfiles) throws ServiceManagementException {
        if (null == serviceGroupName) {
            return 0L;
        }
        RbServiceGroupEntry rbServiceGroupEntry = serviceProfiles.findServiceGroupEntryByName(serviceGroupName);
        return rbServiceGroupEntry != null ? rbServiceGroupEntry.getRbServiceGroupIndex() : 0L;
    }

    private void removeUnusedForwardingRules(RbServiceProfiles serviceProfiles) {
        for (RbForwardingRuleConfigEntry fwdEntry : serviceProfiles.getForwardingRuleConfigTable().getEntries()) {
            if (fwdEntry.getRbForwardingRuleName().startsWith(RbServiceSynchronizationUtil.TRANSPARENT_FWD_RULE_NAME_PREFIX)) continue;
            Long fwdRuleIdx = fwdEntry.getRbForwardingRuleIdx();
            boolean bUsed = false;
            for (RbServiceTemplateConfigEntry entry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
                if (!fwdRuleIdx.equals(entry.getRbServiceTemplateForwardingRuleIdx())) continue;
                bUsed = true;
                break;
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing Forwarding Rule: " + fwdEntry.getRowKey()));
            serviceProfiles.getForwardingRuleConfigTable().removeEntry(fwdEntry.getRowKey());
        }
    }

    private void removeUnusedPolicyRules(RbServiceProfiles serviceProfiles) {
        for (RbPolicyRuleConfigEntry policyEntry : serviceProfiles.getPolicyRuleConfigTable().getEntries()) {
            Long policyRuleIdx = policyEntry.getRbPolicyRuleIdx();
            boolean bUsed = false;
            for (RbServiceTemplateConfigEntry entry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
                if (!policyRuleIdx.equals(entry.getRbServiceTemplatePolicyRuleIdx())) continue;
                bUsed = true;
                break;
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing PolicyRule: " + policyEntry.getRowKey()));
            serviceProfiles.getPolicyRuleConfigTable().removeEntry(policyEntry.getRowKey());
        }
    }

    private void removeUnusedQoSProfiles(RbServiceProfiles serviceProfiles) {
        for (RbQoSProfileConfigEntry qosEntry : serviceProfiles.getQosProfileConfigTable().getEntries()) {
            Long qosPolicyIdx = qosEntry.getRbQoSProfileIdx();
            boolean bUsed = false;
            for (DynamicTableRowMO entry : serviceProfiles.getForwardingRuleConfigTable().getEntries()) {
                if (!qosPolicyIdx.equals(entry.getRbForwardingRuleMulticastQoSIdx())) continue;
                bUsed = true;
                break;
            }
            if (!bUsed) {
                for (DynamicTableRowMO entry : serviceProfiles.getPolicyRuleConfigTable().getEntries()) {
                    if (!qosPolicyIdx.equals(entry.getRbPolicyRuleDownQoSProfileIdx1()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleDownQoSProfileIdx2()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleDownQoSProfileIdx3()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleDownQoSProfileIdx4()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleUpQoSProfileIdx1()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleUpQoSProfileIdx2()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleUpQoSProfileIdx3()) && !qosPolicyIdx.equals(entry.getRbPolicyRuleUpQoSProfileIdx4())) continue;
                    bUsed = true;
                    break;
                }
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing QoSProfile: " + qosEntry.getRowKey()));
            serviceProfiles.getQosProfileConfigTable().removeEntry(qosEntry.getRowKey());
        }
    }

    private void removeUnusedVoiceDomain(RbServiceProfiles serviceProfiles) {
        for (RbVoiceDomainsEntry voiceDomainEntry : serviceProfiles.getVoiceDomainConfigTable().getEntries()) {
            Long voiceDomainIdx = voiceDomainEntry.getRbVoiceDomainIdx();
            boolean bUsed = false;
            for (RbServiceTemplateConfigEntry entry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
                if (!voiceDomainIdx.equals(entry.getRbServiceTemplateVoiceDomainIdx())) continue;
                bUsed = true;
                break;
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing PolicyRule: " + voiceDomainEntry.getRowKey()));
            serviceProfiles.getVoiceDomainConfigTable().removeEntry(voiceDomainEntry.getRowKey());
        }
    }

    private void removeUnusedServiceGroup(RbServiceProfiles serviceProfiles) {
        for (RbServiceGroupEntry serviceGroupEntry : serviceProfiles.getServiceGroupConfigTable().getEntries()) {
            String serviceGroupName = serviceGroupEntry.getRbServiceGroupName();
            boolean bUsed = false;
            for (RbServiceTemplateConfigEntry entry : serviceProfiles.getServiceTemplateConfigTable().getEntries()) {
                if (!serviceGroupName.equals(entry.getRbServiceTemplateGroupName())) continue;
                bUsed = true;
                break;
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing PolicyRule: " + serviceGroupEntry.getRowKey()));
            serviceProfiles.getServiceGroupConfigTable().removeEntry(serviceGroupEntry.getRowKey());
        }
    }

    private void removeUnusedPFServer(RbServiceProfiles serviceProfiles) {
        for (RbBSPFServersEntry pfServerEntry : serviceProfiles.getPFServerConfigTable().getEntries()) {
            String pfServerIPIdx = pfServerEntry.getRbBSPFServerAddress();
            boolean bUsed = false;
            for (RbVoiceDomainsEntry entry : serviceProfiles.getVoiceDomainConfigTable().getEntries()) {
                if (!pfServerIPIdx.equals(entry.getRbVoiceDomainPrimaryPFIpAddress())) continue;
                bUsed = true;
                break;
            }
            if (bUsed) continue;
            logger.debug((Object)("--- Removing PolicyRule: " + pfServerEntry.getRowKey()));
            serviceProfiles.getPFServerConfigTable().removeEntry(pfServerEntry.getRbBSPFServerAddress());
        }
    }

    private static long findNewForwardingRuleIdx(RbServiceProfiles serviceProfiles) {
        long ret = -1L;
        RbForwardingRuleConfigTable forwardingRuleConfigTable = serviceProfiles.getForwardingRuleConfigTable();
        for (RbForwardingRuleConfigEntry forwardingRuleCfgEntry : forwardingRuleConfigTable.getEntries()) {
            if (forwardingRuleCfgEntry.getRbForwardingRuleIdx() > ret) continue;
            ret = forwardingRuleCfgEntry.getRbForwardingRuleIdx() - 1L;
        }
        return ret;
    }

    private static long findNewPolicyRuleIdx(RbServiceProfiles serviceProfiles) {
        long ret = -1L;
        RbPolicyRuleConfigTable policyRuleConfigTable = serviceProfiles.getPolicyRuleConfigTable();
        for (RbPolicyRuleConfigEntry policyRuleCfgEntry : policyRuleConfigTable.getEntries()) {
            if (policyRuleCfgEntry.getRbPolicyRuleIdx() > ret) continue;
            ret = policyRuleCfgEntry.getRbPolicyRuleIdx() - 1L;
        }
        return ret;
    }

    private static long findNewQoSProfileIdx(RbServiceProfiles serviceProfiles) {
        long ret = -1L;
        RbQoSProfileConfigTable qosProfileConfigTable = serviceProfiles.getQosProfileConfigTable();
        for (RbQoSProfileConfigEntry qosProfileCfgEntry : qosProfileConfigTable.getEntries()) {
            if (qosProfileCfgEntry.getRbQoSProfileIdx() > ret) continue;
            ret = qosProfileCfgEntry.getRbQoSProfileIdx() - 1L;
        }
        return ret;
    }

    private static long findNewVoiceDomainIdx(RbServiceProfiles serviceProfiles) {
        List rbVoiceDomainsEntries = serviceProfiles.getVoiceDomainConfigTable().getEntries();
        Collections.sort(rbVoiceDomainsEntries, new Comparator<RbVoiceDomainsEntry>(){

            @Override
            public int compare(RbVoiceDomainsEntry o1, RbVoiceDomainsEntry o2) {
                return o1.getRbVoiceDomainIdx().compareTo(o2.getRbVoiceDomainIdx());
            }
        });
        if (rbVoiceDomainsEntries.size() > 0) {
            if (((RbVoiceDomainsEntry)((Object)rbVoiceDomainsEntries.get(0))).getRbVoiceDomainIdx() != 1L) {
                return 1L;
            }
            for (int i = 1; i < rbVoiceDomainsEntries.size(); ++i) {
                if (((RbVoiceDomainsEntry)((Object)rbVoiceDomainsEntries.get(i))).getRbVoiceDomainIdx() - ((RbVoiceDomainsEntry)((Object)rbVoiceDomainsEntries.get(i - 1))).getRbVoiceDomainIdx() <= 1L) continue;
                return ((RbVoiceDomainsEntry)((Object)rbVoiceDomainsEntries.get(i - 1))).getRbVoiceDomainIdx() + 1L;
            }
        }
        return rbVoiceDomainsEntries.size() + 1;
    }

    private static boolean serviceTypesCompatible(int type1, int type2) {
        if (type1 == 1 || type1 == 3 || type1 == 6) {
            return type2 == 1 || type2 == 3 || type2 == 6;
        }
        return type1 == type2;
    }

    private static final boolean isObjectEqual(Object a, Object b) {
        return null == a ? null == b : a.equals(b);
    }

    private static RbServiceProfiles getRbServiceProfiles(RbBaseStationEquipment eq) {
        NetworkResourceConfiguration nrConfig = eq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        return new RbServiceProfiles(nrConfig);
    }
}

