/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.backend.startup.ServerStartupExecutor;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.model.fault.EventTemplateFilter;
import com.bwanms.model.fault.EvtTmplFilterEventCategory;
import com.bwanms.model.fault.EvtTmplFilterEvtOID;
import com.bwanms.model.fault.EvtTmplFilterMOType;
import com.bwanms.model.fault.EvtTmplFilterNEType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.MOType;
import com.bwanms.model.fault.constants.NEType;
import com.bwanms.model.fault.constants.NMSTrap;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.DatastoreDecoratorUtil;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RbServerStartupExecutor
implements ServerStartupExecutor {
    private static Logger log = Logger.getLogger(RbServerStartupExecutor.class);

    public void execute() {
        try {
            DatastoreDecoratorUtil.run((Runnable)new Runnable(){
                static final String DEFAULT_NAME = "SU Unreachable/Down Cleared";
                static final String DEFAULT_DESC = "Default Template for SU Unreachable/Down alarms";
                static final String DEFAULT_OWNER = "SYSTEM";

                public void run() {
                    Integer count = (Integer)Datastore.session().createCriteria(EventTemplate.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_NAME)).add((Criterion)Restrictions.eq((String)"owner", (Object)DEFAULT_OWNER)).setProjection(Projections.rowCount()).uniqueResult();
                    if (count == null || count == 0) {
                        Datastore.session().save((Object)this.generateTemplateForSU());
                    }
                }

                private EventTemplate generateTemplateForSU() {
                    EventTemplate templ = new EventTemplate();
                    templ.setName(DEFAULT_NAME);
                    templ.setDescription(DEFAULT_DESC);
                    templ.setOwner(DEFAULT_OWNER);
                    templ.setPriority(Long.valueOf(1L));
                    templ.setCreationDate(System.currentTimeMillis());
                    EventTemplateFilter filter = new EventTemplateFilter();
                    filter.addEventCategory(new EvtTmplFilterEventCategory(filter, EventCategory.Alarm.byteValue()));
                    filter.addNeType(new EvtTmplFilterNEType(filter, NEType.NMS.byteValue()));
                    filter.addMoType(new EvtTmplFilterMOType(filter, MOType.CPE.byteValue()));
                    filter.addEventOID(new EvtTmplFilterEvtOID(filter, NMSTrap.nmsEquipmentUnreachable.oid()));
                    filter.addEventOID(new EvtTmplFilterEvtOID(filter, NMSTrap.nmsEquipmentDown.oid()));
                    templ.setFilter(filter);
                    EventTemplateBehavior behavior = new EventTemplateBehavior();
                    behavior.setAckRequired(false);
                    behavior.setAutoSendEmail(false);
                    behavior.setAlarmSeverity(Severity.Cleared.byteValue());
                    behavior.setUserClassifier("None");
                    templ.setBehavior(behavior);
                    return templ;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Failed to create SU Unreachable/Down Cleared template at startup", (Throwable)e);
        }
    }
}

