/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.meta.mo.MOChangeProcessorUtil;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.Event;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.mo.RbSuSubDevicesEntry;
import com.bwanms.rb.model.RbSU;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSUSynchronizationStrategy
implements EquipmentSynchronizationStrategy {
    private static Logger logger = Logger.getLogger(RbSUSynchronizationStrategy.class);
    private static Map<Class<? extends ManagedObject>, Method> moChangeProcessors = MOChangeProcessorUtil.getProcessors(RbSUSynchronizationStrategy.class);
    private RbSU su;
    private DDCallbackInterface ddCallback;

    public RbSUSynchronizationStrategy(RbSU su, DDCallbackInterface ddCallback) {
        this.su = su;
        this.ddCallback = ddCallback;
    }

    public void synchronizeState() {
    }

    public List<ConfigurationChangedEvent> configurationChanged(ConfigurationChangedEvent evt) throws ConfigurationNotSynchronizedException {
        EquipmentConfiguration config = this.su.findCurrentConfiguration();
        Method processor = moChangeProcessors.get(evt.getMoClass());
        if (processor == null) {
            logger.debug((Object)("No MOChangeProcessorFound for [" + evt.getMoClass().getName() + "]"));
            return null;
        }
        NetworkResourceConfiguration nrConfig = config.findNetworkResourceConfiguration(evt.getNetworkResourceName());
        Map moMap = nrConfig.retrieveManagedObjects(evt.getMoClass(), evt.getInstances());
        for (String moInstance : evt.getInstances()) {
            Object mo = moMap.get(moInstance);
            if (mo != null && MOUtils.hasNullAnnotatedAttributes((Equipment)this.su, (ManagedObject)((ManagedObject)mo), (Class[])RbBaseStationSynchronizationStrategy.RB_STATE_ANNOTATIONS)) {
                logger.debug((Object)("Ignoring " + mo.getClass().getName() + "#" + moInstance));
                continue;
            }
            try {
                logger.debug((Object)("[" + this.su.getMacAddress() + "] " + evt.getMoClass().getName() + " changed [" + moInstance + "]"));
                processor.invoke((Object)this, moInstance, mo);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e, (Throwable)e);
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e, (Throwable)e);
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.debug((Object)e.getCause(), e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return null;
    }

    public void downloadConfiguration() throws MediationException {
    }

    public void setUnreachable(Event generatedBy) {
    }

    public boolean emitNmsEvent(AgentEvent agentEvent) {
        return false;
    }

    public void processAgentEvent(AgentEvent agentEvent) throws MediationException {
    }

    @MOChangeProcessor(moClass=RbSuSubDevicesEntry.class)
    public void processRbSuSubDevicesEntryChange(String instanceID, RbSuSubDevicesEntry entry) {
        if (entry != null) {
            if (entry.isVgPresent()) {
                this.su.setVGpresent(true);
            }
            if (entry.isNgPresent()) {
                this.su.setNGpresent(true);
            }
        } else {
            NetworkResourceConfiguration suNRConfig = this.su.findCurrentConfiguration().findNetworkResourceConfiguration("SU");
            List subDeviceEntries = suNRConfig.retrieveManagedObjects(RbSuSubDevicesEntry.class, "*");
            boolean vgPresent = false;
            boolean ngPresent = false;
            for (RbSuSubDevicesEntry subDevsEntry : subDeviceEntries) {
                vgPresent |= subDevsEntry.isVgPresent();
                ngPresent |= subDevsEntry.isNgPresent();
            }
            this.su.setVGpresent(vgPresent);
            this.su.setNGpresent(ngPresent);
        }
    }
}

