/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.AgentEventProcessor;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.model.RbBaseStationEquipment;
import org.hibernate.Query;

public class RbSNMPTrapV1AgentEventProcessor
implements AgentEventProcessor {
    public static final String RB_BS_ENTERPRISE_OID = "1.3.6.1.4.1.12394.1.2";
    public static final String RB_MBS_ENTERPRISE_OID = "1.3.6.1.4.1.12394.1.2";
    private static final String RB_VB_PREFIX = "1.3.6.1.4.1.12394.1.2.6.";

    public String getAgentEventClassName() {
        return SNMPTrapV1AgentEvent.class.getName();
    }

    public Equipment accept(AgentEvent event) {
        SNMPTrapV1AgentEvent trapV1 = (SNMPTrapV1AgentEvent)event;
        if (this.isRainbowTrap(trapV1)) {
            return this.findBaseStationByIp(trapV1.getAgentIPAddress());
        }
        return null;
    }

    private RbBaseStationEquipment findBaseStationByIp(String ipAddress) {
        Query query = Datastore.session().createQuery("from " + RbBaseStationEquipment.class.getName() + " where IPAddress = :ipAddress").setString("ipAddress", ipAddress);
        return (RbBaseStationEquipment)((Object)query.uniqueResult());
    }

    private boolean isRainbowTrap(SNMPTrapV1AgentEvent trapV1) {
        return trapV1.getVarBindList().size() > 0 && trapV1.getVarBindList().get(0).getOID().startsWith(RB_VB_PREFIX);
    }
}

