/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.fault.Event;
import com.bwanms.model.license.Licensable;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbSuSynchronizationHelper;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.ServiceException;
import com.bwanms.util.MacAddress;
import com.bwanms.util.PlatformConfiguration;
import org.apache.log4j.Logger;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbRegisteredSuEntryAssemblerFactory
implements AssemblerFactory<RbRegisteredSuEntry> {
    private static Logger log = Logger.getLogger(RbRegisteredSuEntryAssemblerFactory.class);

    public Assembler<RbRegisteredSuEntry> createAssembler(Class<? extends RbRegisteredSuEntry> baseClass, String assembler) {
        return new Assembler<RbRegisteredSuEntry>(){

            public Assembly<RbRegisteredSuEntry> getAssembly(RbRegisteredSuEntry suEntry) throws ServiceException {
                try {
                    RbBaseStationEquipment bsEq = (RbBaseStationEquipment)suEntry.getNRConfiguration().getConfiguration().getEquipment();
                    RbSuSynchronizationHelper suHelper = new RbSuSynchronizationHelper(bsEq);
                    String macAddress = MacAddress.fromOctetString((String)suEntry.getRbSuMacAddr()).toSimpleString();
                    RbSU su = suHelper.findSU(macAddress);
                    if (su == null) {
                        RbSuSynchronizationHelper.getRbSUsMgmtDBGiantLock();
                        su = suHelper.findSU(macAddress);
                        if (su == null) {
                            Event event2;
                            su = suHelper.createSU(suEntry);
                            ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)su);
                            suHelper.updateSU(su, suEntry);
                            suHelper.connectSU(su, suEntry.getRbAuId());
                            LicenseHelper.licenseEntity((Licensable)su);
                            Event event = Helpers.getDDCallback().equipmentCreate(null, (Equipment)su);
                            if (event != null) {
                                EventFacade.emitEvent((Event)event);
                            }
                            if ((event2 = Helpers.getDDCallback().setEquipmentState(null, (Equipment)su, suEntry.isConnected() ? 0 : 1)) != null) {
                                EventFacade.emitEvent((Event)event2);
                            }
                        }
                    } else if (PlatformConfiguration.isLocalPlatform()) {
                        suHelper.updateSU(su, suEntry);
                        suHelper.connectSU(su, suEntry.getRbAuId());
                    }
                    su.findCurrentConfiguration().findPrimaryNetworkResourceConfiguration();
                    su.getManagerBS();
                    return new RbRegisteredSuAssembly(suEntry, su);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                    throw new ServiceException((Throwable)e);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RbRegisteredSuAssembly
    implements Assembly<RbRegisteredSuEntry> {
        private static final long serialVersionUID = 4069813018556168278L;
        private RbRegisteredSuEntry entity;
        private RbSU su;

        public RbRegisteredSuAssembly(RbRegisteredSuEntry entity, RbSU su) {
            this.entity = entity;
            this.su = su;
        }

        public RbRegisteredSuEntry getEntity() {
            return this.entity;
        }

        public RbSU getSu() {
            return this.su;
        }
    }
}

