/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbNPU;
import org.apache.log4j.Logger;
import org.hibernate.Query;

public class RbNpuSynchronizationHelper {
    private static final Logger logger = Logger.getLogger(RbNpuSynchronizationHelper.class);
    private RbBS bs;

    public RbNpuSynchronizationHelper(RbBS bs) {
        this.bs = bs;
    }

    RbNPU createNPU(RbNpuConfigEntry npuInstance) {
        RbNPU npu = new RbNPU();
        npu.setName("NPU." + npuInstance.getRbSlotNumber());
        npu.setEUID(npuInstance.getRbNpuSerialNo());
        npu.setSlotNumber(npuInstance.getRbSlotNumber());
        logger.debug((Object)("Created NPU: " + npu.getEUID()));
        return npu;
    }

    void disconnectNPU(RbNPU managedNPU) {
        if (managedNPU.getManagerBS() != null) {
            managedNPU.setManagerBS(null, 0);
        }
    }

    void connectNPU(RbNPU npu, int slotNumber) {
        this.disconnectNPU(npu);
        npu.setManagerBS(this.bs, slotNumber);
        npu.setLocation(this.bs.getLocation());
    }

    RbNPU findNPU(String npuSerialNo) {
        Query query = Datastore.session().createQuery("select npu from com.bwanms.rb.model.RbNPU as npu where npu.EUID = :euid");
        query.setString("euid", npuSerialNo);
        RbNPU npu = (RbNPU)((Object)query.uniqueResult());
        return npu;
    }

    void updateNPU(RbNPU npu, RbNpuConfigEntry npuInstance) {
        npu.setName("NPU." + npuInstance.getRbSlotNumber());
        npu.setSerialNumber(npuInstance.getRbNpuSerialNo());
        npu.setRedundancyStatus(npuInstance.getRbNpuRedundancyStatus());
        npu.setFaultStatus(npuInstance.getRbNpuFaultStatus());
        npu.setShadowSoftwareVersion(npuInstance.getRbNpuShadowSwVersion());
        npu.setRunningSoftwareVersion(npuInstance.getRuningSwVersion());
        npu.setOperationalSoftwareVersion(npuInstance.getRbNpuOperSwVersion());
    }
}

