/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.services.impl.MORefreshRunnable;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbL2FilteringRuleEntry;
import com.bwanms.rb.mo.RbL3L4FilteringRuleEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.MacAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbMORefreshRunnable
extends MORefreshRunnable {
    private static final Logger logger = Logger.getLogger(RbMORefreshRunnable.class);
    public static final byte TYPE_NONE = 0;
    public static final byte TYPE_DELAY_1_SEC = 1;
    public static final byte TYPE_WO_ACCESS_SESSION = 2;
    public static final byte TYPE_SERVICES = 3;
    public static final byte TYPE_SERVICE_TEMPLATES = 4;
    public static final byte TYPE_FORWARDING_RULES = 5;
    public static final byte TYPE_FILTERS_L2 = 6;
    public static final byte TYPE_FILTERS_L3L4 = 7;
    private String nrConfigName;
    private Class<? extends ManagedObject> moClass;
    private String instanceQuery;
    private byte type;
    private String svcParam1;
    private String svcParam2;
    private String svcParam3;
    private byte retries = (byte)20;

    public RbMORefreshRunnable(long equipmentId, String nrConfigName, Class<? extends ManagedObject> moClass, String instanceQuery, byte type, String svcParam1, String svcParam2, String svcParam3) {
        super(equipmentId);
        this.nrConfigName = nrConfigName;
        this.moClass = moClass;
        this.instanceQuery = instanceQuery;
        this.type = type;
        this.svcParam1 = svcParam1;
        this.svcParam2 = svcParam2;
        this.svcParam3 = svcParam3;
    }

    public void run() {
        RbBaseStationEquipment bsEq = this.retrieveBaseStation();
        if (bsEq == null) {
            return;
        }
        try {
            switch (this.type) {
                case 0: {
                    RbMORefreshRunnable.refreshNoneMO(bsEq, this.nrConfigName, this.moClass, this.instanceQuery);
                    break;
                }
                case 1: {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    RbMORefreshRunnable.refreshNoneMO(bsEq, this.nrConfigName, this.moClass, this.instanceQuery);
                    break;
                }
                case 2: {
                    RbMORefreshRunnable.refreshMOWOAccessSession(bsEq, this.nrConfigName, this.moClass, this.instanceQuery);
                    break;
                }
                case 3: {
                    RbMORefreshRunnable.refreshServiceMO(bsEq, this.instanceQuery, this.svcParam1, this.svcParam2, this.svcParam3);
                    break;
                }
                case 4: {
                    RbMORefreshRunnable.refreshServiceTemplateMO(bsEq, this.instanceQuery);
                    break;
                }
                case 5: {
                    RbMORefreshRunnable.refreshForwardingRuleMO(bsEq, this.instanceQuery);
                    break;
                }
                case 6: {
                    RbMORefreshRunnable.refreshL2FilteringRuleMO(bsEq, this.instanceQuery);
                    break;
                }
                case 7: {
                    RbMORefreshRunnable.refreshL3L4FilteringRuleMO(bsEq, this.instanceQuery);
                }
            }
        }
        catch (MediationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ManagedObject> void refreshNoneMO(RbBaseStationEquipment bsEq, String nrConfigName, Class<T> moClass, String instanceQuery) throws MediationException {
        logger.debug((Object)("[" + bsEq.getIPAddress() + "] Fetching [" + moClass.getName() + "] with instance [" + instanceQuery + "]"));
        ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration(nrConfigName);
        MOAccessSession access = null;
        try {
            access = RbMORefreshRunnable.createMOAccessSession(bsEq);
            configHelper.retrieveCurrentConfiguration(access, nrConfig, moClass, instanceQuery, true);
        }
        catch (AgentException e) {
            logger.warn((Object)("[" + bsEq.getIPAddress() + "] Not fetched " + moClass + " [" + instanceQuery + "] - will assume deleted"));
            configHelper.removeFromCurrentConfiguration(nrConfig, moClass, instanceQuery);
        }
        finally {
            if (access != null) {
                RbMORefreshRunnable.closeMOAccessSession(access);
            }
        }
    }

    private static <T extends ManagedObject> List<T> refreshMOWOAccessSession(RbBaseStationEquipment bsEq, String nrConfigName, Class<T> moClass, String instanceQuery) throws MediationException {
        ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
        try {
            return configHelper.retrieveCurrentConfiguration(bsEq.getId(), nrConfigName, moClass, instanceQuery, true);
        }
        catch (AgentException e) {
            logger.warn((Object)("[" + bsEq.getIPAddress() + "] Not fetched " + moClass + " [" + instanceQuery + "] - will assume deleted"));
            NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration(nrConfigName);
            configHelper.removeFromCurrentConfiguration(nrConfig, moClass, instanceQuery);
            return new ArrayList();
        }
    }

    private static void refreshServiceMO(RbBaseStationEquipment bsEq, String rbServiceIdx, String serviceName, String rbSubscriberIdx, String rbSuMacAddr) throws MediationException {
        String instanceQuery = "*";
        if (bsEq.isTDDDuplexMode()) {
            RbServiceConfigEntry serviceEntry;
            if (null != serviceName && serviceName.indexOf("#") >= 0 && null != (serviceEntry = RbMORefreshRunnable.findServiceConfigEntryByName(bsEq, serviceName)) && !rbServiceIdx.equals(serviceEntry.getRbServiceIdx().toString())) {
                String otherSuInstance = MacAddress.fromString((String)serviceEntry.getRbServiceSuMacAddress().replace(':', '-')).toInstanceString();
                String otherInstanceQuery = otherSuInstance + "." + rbServiceIdx;
                logger.debug((Object)("[" + bsEq.getIPAddress() + "] Refresh other service entry with name [" + serviceName + "] instance [" + otherInstanceQuery + "]"));
                RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbServiceConfigEntry.class, otherInstanceQuery);
            }
            if (null != rbSuMacAddr) {
                String suInstanceString = MacAddress.fromOctetString((String)rbSuMacAddr).toInstanceString();
                instanceQuery = suInstanceString + "." + rbServiceIdx;
            } else {
                serviceEntry = RbMORefreshRunnable.findServiceConfigEntryByIdx(bsEq, rbServiceIdx);
                if (null != serviceEntry) {
                    String suInstanceString = MacAddress.fromString((String)serviceEntry.getRbServiceSuMacAddress().replace(':', '-')).toInstanceString();
                    instanceQuery = suInstanceString + "." + rbServiceIdx;
                }
            }
        } else if (null != rbSubscriberIdx) {
            instanceQuery = rbSubscriberIdx + "." + rbServiceIdx;
        } else {
            RbServiceConfigEntry serviceEntry = RbMORefreshRunnable.findServiceConfigEntryByIdx(bsEq, rbServiceIdx);
            if (null != serviceEntry) {
                instanceQuery = serviceEntry.getRbSubscriberIdx().toString() + "." + rbServiceIdx;
            }
        }
        RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbServiceConfigEntry.class, instanceQuery);
    }

    private static RbServiceConfigEntry findServiceConfigEntryByIdx(RbBaseStationEquipment bsEq, String serviceIdx) {
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List services = nrConfig.retrieveManagedObjects(RbServiceConfigEntry.class, "*");
        for (RbServiceConfigEntry entry : services) {
            if (!serviceIdx.equals(entry.getRbServiceIdx().toString())) continue;
            return entry;
        }
        return null;
    }

    private static RbServiceConfigEntry findServiceConfigEntryByName(RbBaseStationEquipment bsEq, String serviceName) {
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List services = nrConfig.retrieveManagedObjects(RbServiceConfigEntry.class, "*");
        for (RbServiceConfigEntry entry : services) {
            if (!serviceName.equals(entry.getRbServiceName())) continue;
            return entry;
        }
        return null;
    }

    private static void refreshServiceTemplateMO(RbBaseStationEquipment bsEq, String instanceID) throws MediationException {
        String serviceTemplateInstanceID = "*";
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List serviceTemplates = nrConfig.retrieveManagedObjects(RbServiceTemplateConfigEntry.class, "*");
        for (RbServiceTemplateConfigEntry entry : serviceTemplates) {
            if (!instanceID.equals(String.valueOf(entry.getRbServiceTemplateIdx()))) continue;
            logger.debug((Object)("[" + bsEq.getIPAddress() + "] Found Service Template entry with index [" + instanceID + "]"));
            serviceTemplateInstanceID = entry.getRbServiceTemplateType() + "." + entry.getRbServiceTemplateIdx();
            break;
        }
        RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbServiceTemplateConfigEntry.class, serviceTemplateInstanceID);
    }

    private static void refreshForwardingRuleMO(RbBaseStationEquipment bsEq, String instanceID) throws MediationException {
        String forwardingRuleID = "*";
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List forwardingRules = nrConfig.retrieveManagedObjects(RbForwardingRuleConfigEntry.class, "*");
        for (RbForwardingRuleConfigEntry entry : forwardingRules) {
            if (!instanceID.equals(String.valueOf(entry.getRbForwardingRuleIdx()))) continue;
            logger.debug((Object)("[" + bsEq.getIPAddress() + "] Found Forwarding Rule entry with index [" + instanceID + "]"));
            forwardingRuleID = entry.getRbForwardingRuleType() + "." + entry.getRbForwardingRuleIdx();
            break;
        }
        RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbForwardingRuleConfigEntry.class, forwardingRuleID);
    }

    private static void refreshL2FilteringRuleMO(RbBaseStationEquipment bsEq, String instanceID) throws MediationException {
        String l2FilteringInstanceID = "*";
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List filterEntries = nrConfig.retrieveManagedObjects(RbL2FilteringRuleEntry.class, "*");
        for (RbL2FilteringRuleEntry entry : filterEntries) {
            if (!instanceID.equals(String.valueOf(entry.getRbL2FilteringRuleIdx()))) continue;
            logger.debug((Object)("[" + bsEq.getIPAddress() + "] Found filtering Rule entry with index [" + instanceID + "]"));
            l2FilteringInstanceID = entry.getRbL2FilteringRuleEthType() + "." + entry.getRbL2FilteringRuleIdx();
            break;
        }
        RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbL2FilteringRuleEntry.class, l2FilteringInstanceID);
    }

    private static void refreshL3L4FilteringRuleMO(RbBaseStationEquipment bsEq, String instanceID) throws MediationException {
        String l3l4FilteringInstanceID = "*";
        NetworkResourceConfiguration nrConfig = bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List filterEntries = nrConfig.retrieveManagedObjects(RbL3L4FilteringRuleEntry.class, "*");
        for (RbL3L4FilteringRuleEntry entry : filterEntries) {
            if (!instanceID.equals(String.valueOf(entry.getRbL34FilteringRuleIdx()))) continue;
            l3l4FilteringInstanceID = "" + entry.getRbL34FilteringRuleIdx();
            break;
        }
        RbMORefreshRunnable.refreshNoneMO(bsEq, "BS", RbL3L4FilteringRuleEntry.class, l3l4FilteringInstanceID);
    }

    public boolean equals(Object obj) {
        RbMORefreshRunnable o = (RbMORefreshRunnable)((Object)obj);
        return RbMORefreshRunnable.isObjectEqual(o.moClass, this.moClass) && RbMORefreshRunnable.isObjectEqual(o.nrConfigName, this.nrConfigName) && RbMORefreshRunnable.isObjectEqual(o.instanceQuery, this.instanceQuery) && RbMORefreshRunnable.isObjectEqual(o.svcParam1, this.svcParam1) && RbMORefreshRunnable.isObjectEqual(o.svcParam2, this.svcParam2) && RbMORefreshRunnable.isObjectEqual(o.svcParam3, this.svcParam3) && o.type == this.type && super.equals((Object)o);
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.moClass);
        sb.append(this.nrConfigName);
        sb.append(this.instanceQuery);
        sb.append(this.svcParam1);
        sb.append(this.svcParam2);
        sb.append(this.svcParam3);
        sb.append(this.type);
        return sb.toString().hashCode() + super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.moClass);
        sb.append(":");
        sb.append(this.instanceQuery);
        sb.append(":");
        sb.append(this.nrConfigName);
        sb.append(":");
        sb.append(this.svcParam1);
        sb.append(":");
        sb.append(this.svcParam2);
        sb.append(":");
        sb.append(this.svcParam3);
        sb.append(":");
        sb.append(this.type);
        sb.append("] retries: ");
        sb.append(this.retries);
        return sb.toString();
    }

    private static MOAccessSession createMOAccessSession(RbBaseStationEquipment bsEq) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)bsEq.getManagementInterface(), null);
    }

    private static void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    protected final RbBaseStationEquipment retrieveBaseStation() {
        return (RbBaseStationEquipment)((Object)Datastore.session().get(RbBaseStationEquipment.class, (Serializable)Long.valueOf(this.equipmentId)));
    }

    private static final boolean isObjectEqual(Object a, Object b) {
        return null == a ? null == b : a.equals(b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean retryOnError() {
        if (RbRegisteredSuEntry.class.equals(this.moClass)) return true;
        if (RbServiceConfigEntry.class.equals(this.moClass)) return true;
        if (RbSubscriberEntry.class.equals(this.moClass)) return true;
        byte by = this.retries;
        this.retries = (byte)(by - 1);
        if (by <= 0) return false;
        return true;
    }
}

