/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.snmp.SNMPTrapV1Processor;
import com.bwanms.meta.snmp.SNMPTrapV1ProcessorUtil;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.rb.ddi.RbBSTrapProcessor;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbBaseStationTrapProcessor;
import com.bwanms.rb.ddi.RbEntityEvents;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.mo.RbMBSTBridgingParameters;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMbstATPCParametersGroup;
import com.bwanms.rb.mo.RbMbstEthIfConfigEntry;
import com.bwanms.rb.mo.RbMbstIpIfConfigEntry;
import com.bwanms.rb.mo.RbMbstMacParametersGroup;
import com.bwanms.rb.mo.RbMbstMultirateParametersGroup;
import com.bwanms.rb.mo.RbMbstPhyParametersGroup;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.mo.RbSystemGroup;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbServiceGeneralConfig;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.util.RbVersions;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RbMBSTrapProcessor
extends RbBaseStationTrapProcessor {
    private static final String TRAP_SOURCE_MICRO_BST = "MicroBST";
    private static final Logger log = Logger.getLogger(RbBSTrapProcessor.class);
    private static TreeMap<Integer, Method> genericProcessors = SNMPTrapV1ProcessorUtil.getGenericProcessors(RbMBSTrapProcessor.class);
    private static TreeMap<Integer, Method> specificProcessors = SNMPTrapV1ProcessorUtil.getSpecificProcessors(RbMBSTrapProcessor.class);
    protected RbBaseStationSynchronizationStrategy bsSynch;

    public RbMBSTrapProcessor(RbBaseStationSynchronizationStrategy bsSynch) {
        super(bsSynch, genericProcessors, specificProcessors);
        this.bsSynch = bsSynch;
    }

    @SNMPTrapV1Processor(generic=0)
    public void processColdStart(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processWarmStart(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(generic=1)
    public void processWarmStart(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_MICRO_BST)) {
            this.bsSynch.refreshMO("BS", RbSysMicroBSTConfig.class, "0");
        }
    }

    @SNMPTrapV1Processor(generic=2)
    public void processLinkDown(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processLinkDown(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(generic=3)
    public void processLinkUp(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processLinkUp(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=1)
    public void processRbResetOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbResetOn"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_MICRO_BST)) {
            this.bsSynch.setUnreachable(null);
            Thread.sleep(10000L);
        } else {
            super.processRbResetOn(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(specific=5)
    public void processRbMonitorAccessOff(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        log.debug((Object)("[" + this.bsSynch.bsEq.getEUID() + "]: rbAuMonitorAccessOff"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processRbMonitorAccessOff(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=41)
    public void processRbConfigurationChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbConfigurationChanged"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processRbConfigurationChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=42)
    public void processRbParameterSetFailure(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbParameterSetFailure"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
    }

    @SNMPTrapV1Processor(specific=63)
    public void processRbODUStatusOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        this.processRbODUStatus(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=64)
    public void processRbODUStatusOff(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        this.processRbODUStatus(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=83)
    public void processRbSuNetworkEntryStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbSuNetworkEntryStatus(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=102)
    public void processRbSwDownloadEnd(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_MICRO_BST)) {
            this.bsSynch.refreshMO("BS", RbSysMicroBSTConfig.class, "0");
        } else {
            super.processRbSwDownloadEnd(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(specific=103)
    public void processRbSwDownloadError(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=104)
    public void processRbSwSwitchFailed(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=105)
    public void processRbSwSwitchSucceded(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=111)
    public void processRbServiceStateChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceStateChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=112)
    public void processRbServiceUp(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceStateChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=113)
    public void processRbServiceChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceChanged(trapV1, rbTrap);
    }

    protected void refreshMOs(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_MICRO_BST)) {
            if (new Integer(33).equals(rbTrap.getRbTrapAdditionalInfo())) {
                this.bsSynch.refreshMO("BS", RbMbstEthIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbMbstIpIfConfigEntry.class, "*");
            } else {
                this.bsSynch.refreshMO("BS", RbMbstEthIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbMbstIpIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbSystemGroup.class, "*");
                this.bsSynch.refreshMO("BS", RbServiceGeneralConfig.class, "*");
                this.bsSynch.refreshMO("BS", RbSysMicroBSTConfig.class, "0");
                this.bsSynch.refreshMO("BS", RbMbstATPCParametersGroup.class, "0");
                this.bsSynch.refreshMO("BS", RbMbstPhyParametersGroup.class, "0");
                this.bsSynch.refreshMO("BS", RbMbstMacParametersGroup.class, "0");
                this.bsSynch.refreshMO("BS", RbMbstMultirateParametersGroup.class, "0");
                this.bsSynch.refreshMO("BS", RbBsRadioParameters.class, "0");
                this.bsSynch.refreshMO("BS", RbMBSTBridgingParameters.class, "0");
                this.bsSynch.refreshMO("BS", RbBSClockConfigParameters.class, "0");
                if (this.bsSynch.bsEq.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_2)) {
                    this.bsSynch.refreshMO("BS", RbChainConfig.class, "0");
                    this.bsSynch.refreshMO("BS", RbGPSInfo.class, "0");
                }
                if (!this.bsSynch.bsEq.isIPCSSwitchingMode()) {
                    this.bsSynch.refreshMO("BS", RbSwUpgrade.class, "0");
                    this.bsSynch.refreshMO("BS", RbDfltServiceTemplateEntry.class, "*");
                    this.bsSynch.refreshMO("BS", RbServiceTemplateConfigEntry.class, "*");
                }
            }
        } else {
            super.refreshMOs(trapV1, rbTrap);
        }
    }

    protected void refreshChannel(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbMBSTChannelConfigEntry.class, RbMBSTrapProcessor.getIdFromSharp(rbTrapSource));
    }

    public void processRbODUStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_MICRO_BST)) {
            this.bsSynch.refreshMOWithDelay("BS", RbOduConfigEntry.class, "0");
        } else {
            super.processRbODUStatus(trapV1, rbTrap);
        }
    }
}

