/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.meta.mo.MOChangeProcessorUtil;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.Event;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbEntityEvents;
import com.bwanms.rb.ddi.RbMBSCreateBackupFileCommand;
import com.bwanms.rb.ddi.RbMBSTrapProcessor;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.version.impl.DefaultVersion;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbMBSSynchronizationStrategy
extends RbBaseStationSynchronizationStrategy {
    private static final Logger logger = Logger.getLogger(RbMBSSynchronizationStrategy.class);
    private static Map<Class<? extends ManagedObject>, Method> moChangeProcessors = MOChangeProcessorUtil.getProcessors(RbMBSSynchronizationStrategy.class);
    RbMBS mbs;
    private RbMBSTrapProcessor trapProcessor;

    public RbMBSSynchronizationStrategy(RbMBS mbs, DDCallbackInterface ddCallback) {
        super(mbs, ddCallback);
        this.mbs = mbs;
        this.trapProcessor = new RbMBSTrapProcessor(this);
    }

    @Override
    public void processAgentEventInternal(SNMPTrapV1AgentEvent snmpTrap, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.trapProcessor.processAgentEvent(snmpTrap, rbTrap);
    }

    @Override
    public void signalBaseStationDelete() {
        Event mbsDeleteEvent = this.ddCallback.equipmentRemove(null, (Equipment)this.mbs);
        this.disconnectAllSUs(mbsDeleteEvent);
        this.disconnectAllServices();
        RbEntityEvents.clearBsTrapSendingInfo(this.bsEq);
    }

    @MOChangeProcessor(moClass=RbSysMicroBSTConfig.class)
    public void processStateMBS(String instanceID, RbSysMicroBSTConfig mbsState) {
        if (mbsState == null) {
            return;
        }
        RbMBS mbs = (RbMBS)this.bsEq;
        mbs.setOperationalSoftwareVersion(mbsState.getRbMBSTOperSwVersion());
        mbs.setShadowSoftwareVersion(mbsState.getRbMBSTShadowSwVersion());
        mbs.setRunningSoftwareVersion(mbsState.getRuningSwVersion());
        mbs.setHardwareRevision(mbsState.getRbMBSTIduHwRevision());
        mbs.setSerialNumber(mbsState.getRbMBSTSerialNo());
    }

    @Override
    public void disconnectAllEquipment(Event cause) {
        this.disconnectAllSUs(cause);
    }

    @Override
    protected boolean isValidSysObjectID(String sysObjectID) {
        return "1.3.6.1.4.1.12394.1.4".equals(sysObjectID) || "1.3.6.1.4.1.12394.1.8".equals(sysObjectID);
    }

    @Override
    protected void createBackupSuSyncFile() throws MediationException {
        this.sendCommand(7);
    }

    @Override
    protected void createBackupFile() throws MediationException {
        this.sendCommand(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(int cmdValue) throws MediationException {
        MOAccessSession snmpAccess = null;
        try {
            snmpAccess = this.createMOAccessSessionForConfigFileCreation();
            RbMBSCreateBackupFileCommand command = new RbMBSCreateBackupFileCommand();
            command.setRbMBSTCreateBackupConfigFile(cmdValue);
            snmpAccess.commitObject(null, (Object)command);
        }
        finally {
            this.closeMOAccessSession(snmpAccess);
        }
    }

    @Override
    protected void syncStepRetrieveVersionInformationImpl(MOAccessSession access) throws MediationException {
        RbSysMicroBSTConfig config = (RbSysMicroBSTConfig)((Object)access.fetchObject(null, RbSysMicroBSTConfig.class, new String[]{"rbMBSTOperSwVersion", "rbMBSTShadowSwVersion", "rbMBSTRunningSoftware"}, "*").get(0));
        this.bsEq.setOperationalSoftwareVersion(config.getRbMBSTOperSwVersion());
        this.bsEq.setShadowSoftwareVersion(config.getRbMBSTShadowSwVersion());
        this.bsEq.setRunningSoftwareVersion(config.getRuningSwVersion());
        if (new DefaultVersion("4.1.1").compareTo(this.bsEq.getSoftwareVersion()) < 0) {
            RbBSSwitchingModeParameters provisioning = (RbBSSwitchingModeParameters)((Object)access.fetchObject(null, RbBSSwitchingModeParameters.class, new String[]{"rbCrtServiceSwitchingMode"}, "*").get(0));
            this.bsEq.setSwitchingMode(provisioning.getRbCrtServiceSwitchingMode());
        } else {
            this.bsEq.setSwitchingMode(null);
        }
        RbIfInfoEntry ifInfo = (RbIfInfoEntry)((Object)access.fetchObject(null, RbIfInfoEntry.class, new String[]{"ifPhysAddress"}, "2").get(0));
        this.bsEq.setMngmntIfMAC(ifInfo.getIfPhysAddress());
        if (new DefaultVersion("3.5.1.4").isOlderOrEqualWith(this.bsEq.getSoftwareVersion()) && RbVersions.V_4_0.isNewerThan(this.bsEq.getSoftwareVersion()) && this.bsEq instanceof RbMBS) {
            RbSysMicroBSTConfig iduType = (RbSysMicroBSTConfig)((Object)access.fetchObject(null, RbSysMicroBSTConfig.class, new String[]{"rbMBSTIduType"}, "*").get(0));
            ((RbMBS)this.bsEq).setRbMBSTIduType(iduType.getRbMBSTIduType());
            this.setRbBaseStationTime(access);
        }
    }

    @Override
    protected Map<Class<? extends ManagedObject>, Method> getMOChangeProcessors() {
        return moChangeProcessors;
    }
}

