/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGPSChain;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MultipleStringList;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class RbGPSChainSynchronizationHelper {
    private static final Logger logger = Logger.getLogger(RbGPSChainSynchronizationHelper.class);
    private RbBaseStationEquipment bs;

    public RbGPSChainSynchronizationHelper(RbBaseStationEquipment bs) {
        this.bs = bs;
    }

    public void processRbChainConfig(RbChainConfig chainConfigInstance) {
        if (RbGPSChainSynchronizationHelper.isGPSChainApplicable(this.bs)) {
            RbGPSChain olGPSChain;
            boolean newChain;
            if (null == chainConfigInstance || null == chainConfigInstance.getRbConfiguredChainNumber()) {
                return;
            }
            Long oldGpsChainNumber = this.bs.getGpsChainNumber();
            Long newGpsChainNumber = chainConfigInstance.getRbConfiguredChainNumber();
            this.bs.setGpsChainNumber(newGpsChainNumber);
            this.bs.setGpsChainComplexKey(RbGPSChainSynchronizationHelper.computeComplexKey(chainConfigInstance));
            Datastore.session().saveOrUpdate((Object)this.bs);
            RbGPSChain gpsChain = (RbGPSChain)Datastore.session().get(RbGPSChain.class, (Serializable)newGpsChainNumber);
            boolean bl = newChain = null == gpsChain;
            if (newChain) {
                gpsChain = new RbGPSChain();
                gpsChain.setGpsChainNumber(newGpsChainNumber);
                logger.debug((Object)("Created Global GPS Chain: " + gpsChain.getGpsChainNumber()));
            }
            if (newChain || Integer.valueOf(1).equals(this.bs.getGpsClockMode())) {
                RbGPSChainSynchronizationHelper.updateChainParameters(gpsChain, chainConfigInstance);
            }
            Datastore.session().saveOrUpdate((Object)gpsChain);
            if (oldGpsChainNumber != null && !oldGpsChainNumber.equals(newGpsChainNumber) && (olGPSChain = (RbGPSChain)Datastore.session().get(RbGPSChain.class, (Serializable)oldGpsChainNumber)) != null) {
                olGPSChain.getEquipmentList().remove((Object)this.bs);
                if (Integer.valueOf(1).equals(this.bs.getGpsClockMode())) {
                    for (RbBaseStationEquipment rbBaseStationEquipment : olGPSChain.getEquipmentList()) {
                        NetworkResourceConfiguration bsNRConfig;
                        RbChainConfig chainConfigParams;
                        if (!Integer.valueOf(1).equals(rbBaseStationEquipment.getGpsClockMode()) || null == (chainConfigParams = (RbChainConfig)((Object)(bsNRConfig = rbBaseStationEquipment.findCurrentConfiguration().findNetworkResourceConfiguration("BS")).retrieveManagedObjects(RbChainConfig.class, "*").get(0))) || null == chainConfigParams.getRbConfiguredChainNumber()) continue;
                        RbGPSChainSynchronizationHelper.updateChainParameters(olGPSChain, chainConfigParams);
                        break;
                    }
                }
                Datastore.session().saveOrUpdate((Object)olGPSChain);
            }
        } else {
            this.bs.setGpsChainNumber(null);
            Datastore.session().saveOrUpdate((Object)this.bs);
        }
    }

    private static String computeComplexKey(RbChainConfig chainConfig) {
        MultipleStringList stringList = new MultipleStringList();
        stringList.addToList(chainConfig.getRbConfiguredChainNumber());
        stringList.addToList(chainConfig.getRbGPSConfiguredType());
        stringList.addToList(chainConfig.getRbTimeZoneOffsetFromUTC());
        stringList.addToList(chainConfig.getRbStopTxAfterHoldOverTimeout());
        stringList.addToList(chainConfig.getRbHoldOverPassedTimeout());
        stringList.addToList(chainConfig.getRbDaylightSavingStatus());
        if (new Integer(1).equals(chainConfig.getRbDaylightSavingStatus())) {
            stringList.addToList(chainConfig.getRbDaylightSavingDateStart());
            stringList.addToList(chainConfig.getRbDaylightSavingDateStop());
            stringList.addToList(chainConfig.getRbDaylightSavingAdvFactor());
        } else {
            stringList.addNullToList();
            stringList.addNullToList();
            stringList.addNullToList();
        }
        return stringList.getAsString();
    }

    public void processRbBSClockConfigParameters(RbBSClockConfigParameters bsClockParameters) {
        if (RbGPSChainSynchronizationHelper.isGPSChainApplicable(this.bs)) {
            if (null == bsClockParameters || null == bsClockParameters.getRbBSConfiguredClockMode()) {
                return;
            }
            Integer oldClockMode = this.bs.getGpsClockMode();
            this.bs.setGpsClockMode(bsClockParameters.getRbBSConfiguredClockMode());
            Datastore.session().saveOrUpdate((Object)this.bs);
            if (Integer.valueOf(1).equals(this.bs.getGpsClockMode())) {
                NetworkResourceConfiguration bsNRConfig = this.bs.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
                RbChainConfig chainConfigParams = (RbChainConfig)((Object)bsNRConfig.retrieveManagedObjects(RbChainConfig.class, "*").get(0));
                if (null == chainConfigParams || null == chainConfigParams.getRbConfiguredChainNumber()) {
                    return;
                }
                RbGPSChain gpsChain = (RbGPSChain)Datastore.session().get(RbGPSChain.class, (Serializable)chainConfigParams.getRbConfiguredChainNumber());
                if (null == gpsChain) {
                    gpsChain = new RbGPSChain();
                    gpsChain.setGpsChainNumber(chainConfigParams.getRbConfiguredChainNumber());
                    logger.debug((Object)("Created Global GPS Chain: " + gpsChain.getGpsChainNumber()));
                }
                RbGPSChainSynchronizationHelper.updateChainParameters(gpsChain, chainConfigParams);
                Datastore.session().saveOrUpdate((Object)gpsChain);
            } else if (Integer.valueOf(1).equals(oldClockMode)) {
                RbGPSChain gpsChain = (RbGPSChain)Datastore.session().get(RbGPSChain.class, (Serializable)this.bs.getGpsChainNumber());
                for (RbBaseStationEquipment otherBS : gpsChain.getEquipmentList()) {
                    if (this.bs.equals((Object)otherBS) || !new Integer(1).equals(otherBS.getGpsClockMode())) continue;
                    try {
                        NetworkResourceConfiguration otherBSNRConfig = otherBS.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
                        RbChainConfig otherBSChainParams = (RbChainConfig)((Object)otherBSNRConfig.retrieveManagedObjects(RbChainConfig.class, "*").get(0));
                        RbGPSChainSynchronizationHelper.updateChainParameters(gpsChain, otherBSChainParams);
                        Datastore.session().saveOrUpdate((Object)gpsChain);
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
        } else {
            this.bs.setGpsChainNumber(null);
            Datastore.session().saveOrUpdate((Object)this.bs);
        }
    }

    public void processRbGPSInfo(RbGPSInfo gpsInfo) {
        if (RbGPSChainSynchronizationHelper.isGPSChainApplicable(this.bs)) {
            this.bs.setGpsAltitude(gpsInfo.getRbGPSAltitude());
            this.bs.setGpsLatitude(gpsInfo.getRbGPSLatitude());
            this.bs.setGpsLongitude(gpsInfo.getRbGPSLongitude());
        } else {
            this.bs.setGpsChainNumber(null);
            Datastore.session().saveOrUpdate((Object)this.bs);
        }
    }

    private static void updateChainParameters(RbGPSChain gpsChain, RbChainConfig chainConfigParams) {
        gpsChain.setDaylightSavingAdvFactor(chainConfigParams.getRbDaylightSavingAdvFactor());
        gpsChain.setDaylightSavingDateStart(chainConfigParams.getRbDaylightSavingDateStart());
        gpsChain.setDaylightSavingDateStop(chainConfigParams.getRbDaylightSavingDateStop());
        gpsChain.setDaylightSavingStatus(chainConfigParams.getRbDaylightSavingStatus());
        gpsChain.setGpsType(chainConfigParams.getRbGPSConfiguredType());
        gpsChain.setHoldOverPassedTimeout(chainConfigParams.getRbHoldOverPassedTimeout());
        gpsChain.setStopTxAfterHoldOverTimeout(chainConfigParams.getRbStopTxAfterHoldOverTimeout());
        gpsChain.setTimeZoneOffsetFromUTC(chainConfigParams.getRbTimeZoneOffsetFromUTC());
    }

    public static boolean isGPSChainApplicable(RbBaseStationEquipment rbBaseStationEquipment) {
        return rbBaseStationEquipment instanceof RbMBS && rbBaseStationEquipment.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_2);
    }
}

