/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentPropertiesHandler;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.ServiceRegistry;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbEquipmentPropertiesHandler
implements EquipmentPropertiesHandler {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbEquipmentPropertiesHandler.class);
    private static final Logger logger = Logger.getLogger(RbEquipmentPropertiesHandler.class);

    public HashMap<Integer, Object> getEqupipmentProperties(Equipment equipment) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        if (equipment instanceof RbBaseStationEquipment) {
            RbBaseStationEquipment bs = (RbBaseStationEquipment)equipment;
            map.put(0, bs.getSoftwareVersion());
            map.put(1, bs.getSwitchingMode());
            RbEquipmentPropertiesHandler.putAuFirmwareVersions(bs, map);
        }
        return map;
    }

    public String getMessageSelectorValue(Equipment equipment) {
        if (equipment instanceof RbBaseStationEquipment) {
            return equipment.getEUID();
        }
        return null;
    }

    public String getPropertyTranslation(int key) {
        if (key < 0) {
            return i18n.translateString("AuSoftwareVersion", new Object[]{-key});
        }
        switch (key) {
            case 0: {
                return i18n.translateString("BSSoftwareVersion");
            }
            case 1: {
                return i18n.translateString("SwitchingMode");
            }
        }
        logger.debug((Object)("No translation found for tree changing key " + key));
        return null;
    }

    private static void putAuFirmwareVersions(final RbBaseStationEquipment equipment, HashMap<Integer, Object> map) {
        if (equipment instanceof RbBS) {
            try {
                LightQuery<RbAuConfigEntry> q = new LightQuery<RbAuConfigEntry>(RbAuConfigEntry.class){

                    public List<RbAuConfigEntry> execute() {
                        String qry = "SELECT auConfigEntry FROM " + RbAuConfigEntry.class.getName() + " AS auConfigEntry" + " WHERE auConfigEntry.NRConfiguration.configuration.equipment.EUID = :euid";
                        List ret = Datastore.session().createQuery(qry).setParameter("euid", (Object)equipment.getEUID()).list();
                        return ret;
                    }
                };
                List pFServerList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
                if (pFServerList != null && pFServerList.size() > 0) {
                    for (RbAuConfigEntry rbAuConfigEntry : pFServerList) {
                        map.put(-rbAuConfigEntry.getRbSlotNumber().intValue(), rbAuConfigEntry.getRuningSwVersion());
                    }
                }
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
            }
        }
    }
}

