/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.Location;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.EventProtocol;
import com.bwanms.model.fault.constants.GenericTrap;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.persistence.Datastore;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.model.constants.RbAdditionalInfo;
import com.bwanms.rb.model.constants.RbMOType;
import com.bwanms.rb.model.constants.RbNEType;
import com.bwanms.rb.model.constants.RbTrapType;
import com.bwanms.rb.model.constants.RbVarBind;
import com.bwanms.util.MacAddress;
import com.bwanms.util.fault.EventUtil;
import com.bwanms.util.fault.TrapInternationalizer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.Query;

public class RbEntityEvents {
    private static final Logger logger = Logger.getLogger(RbEntityEvents.class);
    private static Hashtable<Long, Hashtable<String, Boolean>> trapStatusMap = new Hashtable();
    private static Properties correlationRules = new Properties();
    private static Properties eventDefinition = new Properties();
    private static Map<Integer, Integer> clearingMap = new HashMap<Integer, Integer>();
    private static Map<Integer, Integer> alarmMap = new HashMap<Integer, Integer>();
    private static Map<String, String> vbNameMap = new HashMap<String, String>();

    public static Event emitEntityEventFromTrap(RbBaseStationEquipment bs, SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap, byte category) {
        return null;
    }

    public static final boolean shouldEmitEvent(RbBaseStationEquipment bs, SNMPTrapV1AgentEvent trapV1) {
        if (bs.isSendingTraps()) {
            String stringInstance;
            Boolean trapEnabled;
            Hashtable<String, Boolean> equipmentHashtable = trapStatusMap.get(bs.getId());
            if (equipmentHashtable == null) {
                equipmentHashtable = new Hashtable();
                List list = bs.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbTrapConfigEntry.class, "*");
                if (list != null) {
                    for (RbTrapConfigEntry entry : list) {
                        equipmentHashtable.put(entry.getTrapEnterprizeId() + "." + entry.getTrapId(), Integer.valueOf(1).equals(entry.getTrapEnable()));
                    }
                }
                trapStatusMap.put(bs.getId(), equipmentHashtable);
                logger.debug((Object)("Added traps disabled info for " + bs.getEUID()));
                logger.info((Object)("trapStatusMap size = " + trapStatusMap.size()));
            }
            if (null == (trapEnabled = equipmentHashtable.get(stringInstance = trapV1.getGeneric() == 6 ? "2." + trapV1.getSpecific() : "1." + trapV1.getSpecific()))) {
                logger.warn((Object)("[" + bs.getIPAddress() + "]  Trap sending information not found for: " + stringInstance));
            }
            return trapEnabled == null || trapEnabled != false;
        }
        return false;
    }

    public static void clearBsTrapSendingInfo(RbBaseStationEquipment bs) {
        trapStatusMap.remove(bs.getId());
        logger.debug((Object)("Deleted traps disabled info for " + bs.getEUID()));
        logger.info((Object)("trapStatusMap size = " + trapStatusMap.size()));
    }

    public static void updateBsTrapSendingInfo(RbBaseStationEquipment bs, RbTrapConfigEntry entry) {
        Hashtable<String, Boolean> equipmentHashtable = trapStatusMap.get(bs.getId());
        if (equipmentHashtable != null) {
            equipmentHashtable.put(entry.getTrapEnterprizeId() + "." + entry.getTrapId(), Integer.valueOf(1).equals(entry.getTrapEnable()));
        }
    }

    private static RbSU getSUFromMoInstance(String moInstance) {
        try {
            StringBuffer buffer = new StringBuffer("FROM " + RbSU.class.getName());
            buffer.append(" WHERE ");
            buffer.append("macAddress").append(" = :").append("macAddress");
            Query query = Datastore.session().createQuery(buffer.toString());
            query.setString("macAddress", MacAddress.fromDashedString((String)moInstance).toSimpleString());
            List sus = query.list();
            if (sus != null && sus.size() > 0) {
                return (RbSU)((Object)sus.get(0));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static Event createEvent(RbBaseStationEquipment bs, SNMPTrapV1AgentEvent snmpTrap, RbSNMPTrapV1 rbTrap) {
        String temp;
        RbTrapType trap;
        Event event = new Event();
        event.setSourceIPAddress(snmpTrap.getAgentIPAddress());
        String trapSource = rbTrap.getRbTrapSource();
        RbMOType moType = RbEntityEvents.getMoType(trapSource);
        event.setMoType(moType.byteValue());
        event.setMoInstance(RbEntityEvents.getMoInstance(moType, trapSource));
        event.setManagedObject(RbMOType.SU.equals((Object)moType) ? trapSource.toUpperCase() : trapSource);
        if (RbMOType.SU.equals((Object)moType)) {
            if (rbTrap.getRbSuSysName() != null && rbTrap.getRbSuSysName().length() > 0) {
                event.setMoAlias(rbTrap.getRbSuSysName());
            } else {
                RbSU su = RbEntityEvents.getSUFromMoInstance(event.getMoInstance());
                if (su != null) {
                    event.setMoAlias(su.getName());
                }
            }
        } else {
            event.setMoAlias(bs.getName());
        }
        VarBindList vbList = snmpTrap.getVarBindList();
        if (snmpTrap.getGeneric() == 6) {
            trap = RbTrapType.fromValue(snmpTrap.getSpecific());
            temp = TrapInternationalizer.translateEventTitle((String)trap.name(), (VarBindList)vbList);
            event.setEventName(EventUtil.truncateString((String)temp));
            temp = TrapInternationalizer.translateEventDescription((String)trap.name(), (VarBindList)vbList);
            event.setEventDescription(EventUtil.truncateString((String)temp));
            temp = TrapInternationalizer.translateEventAdvisor((String)trap.name(), (VarBindList)vbList);
            event.setEventAdvisor(EventUtil.truncateString((String)temp));
            event.setEventOID(trap.oid());
        } else {
            trap = GenericTrap.fromValue((int)snmpTrap.getGeneric());
            temp = TrapInternationalizer.translateEventTitle((String)trap.name(), (VarBindList)vbList);
            event.setEventName(EventUtil.truncateString((String)temp));
            temp = TrapInternationalizer.translateEventDescription((String)trap.name(), (VarBindList)vbList);
            event.setEventDescription(EventUtil.truncateString((String)temp));
            temp = TrapInternationalizer.translateEventAdvisor((String)trap.name(), (VarBindList)vbList);
            event.setEventAdvisor(EventUtil.truncateString((String)temp));
            event.setEventOID(trap.oid());
        }
        Integer severity = rbTrap.getRbTrapSeverity();
        Integer eventCateg = EventCategory.Alarm.value();
        Integer eventType = AlarmType.other.value();
        if (severity != null) {
            switch (severity) {
                case 0: {
                    eventCateg = EventCategory.SysEvent.value();
                    eventType = SysEventType.sysEvent.value();
                    severity = Severity.Other.value();
                    break;
                }
                case 1: {
                    severity = Severity.Critical.value();
                    break;
                }
                case 2: {
                    severity = Severity.Major.value();
                    break;
                }
                case 3: {
                    severity = Severity.Minor.value();
                    break;
                }
                case 4: {
                    severity = Severity.Warning.value();
                    break;
                }
                case 5: {
                    if (alarmMap.containsKey(snmpTrap.getSpecific()) || clearingMap.containsKey(snmpTrap.getSpecific())) {
                        eventCateg = EventCategory.Alarm.value();
                        eventType = AlarmType.other.value();
                        severity = Severity.Minor.value();
                        break;
                    }
                    eventCateg = EventCategory.SysEvent.value();
                    eventType = SysEventType.sysEvent.value();
                    severity = Severity.Other.value();
                }
            }
            Integer trapInfo = rbTrap.getRbTrapAdditionalInfo();
            RbAdditionalInfo additionalInfo = RbAdditionalInfo.fromValue(trapInfo != null ? trapInfo : 0);
            if (snmpTrap.getSpecific() == RbTrapType.rbConfigurationChanged.value() && trapInfo != null) {
                eventCateg = EventCategory.ConfigChange.value();
                switch (additionalInfo) {
                    case configElementAdded: {
                        eventType = ConfigChangeType.entityAdded.value();
                        break;
                    }
                    case configElementDeleted: {
                        eventType = ConfigChangeType.entityRemoved.value();
                        break;
                    }
                    case configElementUpdated: {
                        eventType = ConfigChangeType.entityChanged.value();
                        break;
                    }
                    case managementPortConfig: {
                        eventType = ConfigChangeType.entityChanged.value();
                    }
                }
                severity = Severity.Other.value();
            }
            if (clearingMap.containsKey(snmpTrap.getSpecific())) {
                eventCateg = EventCategory.Alarm.value();
                severity = Severity.Cleared.value();
            } else if (!alarmMap.containsKey(snmpTrap.getSpecific()) && eventCateg.intValue() != EventCategory.ConfigChange.value()) {
                eventCateg = EventCategory.SysEvent.value();
                eventType = SysEventType.sysEvent.value();
                severity = Severity.Other.value();
            }
            if (RbMOType.AU.equals((Object)moType) || RbMOType.NPU.equals((Object)moType) && RbAdditionalInfo.mainBackbonePort.equals((Object)additionalInfo)) {
                if (GenericTrap.LinkDown.value() == snmpTrap.getGeneric()) {
                    eventCateg = EventCategory.Alarm.value();
                    eventType = AlarmType.communicationsAlarm.value();
                    severity = Severity.Major.value();
                } else if (GenericTrap.LinkUp.value() == snmpTrap.getGeneric()) {
                    eventCateg = EventCategory.Alarm.value();
                    eventType = AlarmType.communicationsAlarm.value();
                    severity = Severity.Cleared.value();
                }
            }
            if (eventCateg.intValue() == EventCategory.Alarm.value()) {
                switch (rbTrap.getRbTrapCategory()) {
                    case 0: {
                        eventType = AlarmType.other.value();
                        break;
                    }
                    case 1: {
                        eventType = AlarmType.communicationsAlarm.value();
                        break;
                    }
                    case 2: {
                        eventType = AlarmType.qualityOfServiceAlarm.value();
                        break;
                    }
                    case 3: {
                        eventType = AlarmType.processingErrorAlarm.value();
                        break;
                    }
                    case 4: {
                        eventType = AlarmType.equipmentAlarm.value();
                        break;
                    }
                    case 5: {
                        eventType = AlarmType.environmentalAlarm.value();
                        break;
                    }
                    default: {
                        eventType = AlarmType.other.value();
                    }
                }
            }
        } else {
            eventCateg = EventCategory.SysEvent.value();
            eventType = SysEventType.sysEvent.value();
            severity = Severity.Other.value();
        }
        event.setEventCategory(eventCateg.byteValue());
        event.setEventType(eventType.byteValue());
        if (eventCateg.intValue() == EventCategory.Alarm.value()) {
            event.setEventSeverity(severity.byteValue());
            event.setObjectSeverity((byte)127);
            event.setProbableCause(Integer.MAX_VALUE);
            event.setAckRequired(false);
        } else {
            event.setEventSeverity(severity.byteValue());
            event.setObjectSeverity(event.getEventSeverity());
            event.setObjectSeverity((byte)127);
            event.setProbableCause(Integer.MAX_VALUE);
            event.setAckRequired(false);
        }
        long eventTime = snmpTrap.getReceivedTime();
        if (snmpTrap.getTimestamp() < 0L) {
            eventTime = -snmpTrap.getTimestamp();
            snmpTrap.setTimestamp(0L);
        } else if (bs.getTimeDiffBetweenNmsAndBs() != null) {
            eventTime -= bs.getTimeDiffBetweenNmsAndBs().longValue();
        }
        event.setEventTime(eventTime);
        event.setReceiveTime(snmpTrap.getReceivedTime());
        event.setLastUpdateTime(event.getReceiveTime());
        for (VarBind vb : snmpTrap.getVarBindList().getVariableBindings()) {
            vb.setName(eventDefinition.getProperty(vb.getOID()));
        }
        event.setEventCause((Serializable)snmpTrap);
        event.setEquipmentName(bs.getName());
        event.setEquipmentId(bs.getId());
        if (bs instanceof RbBS) {
            event.setEquipmentType(RbNEType.BMAX_BS.value());
        } else if (bs instanceof RbMBS) {
            event.setEquipmentType(RbNEType.BMAX_MBS.value());
        }
        Location location = bs.getLocation();
        if (location != null) {
            event.setLocationName(location.getName());
            event.setLocationId(location.getId());
        }
        event.setProtocol(EventProtocol.snmp.byteValue());
        return event;
    }

    private static RbMOType getMoType(String trapSource) {
        if (trapSource == null) {
            return RbMOType.unexpectedValue;
        }
        if (trapSource.startsWith("MicroBST")) {
            return RbMOType.MicroBST;
        }
        if (trapSource.startsWith("NPU")) {
            return RbMOType.NPU;
        }
        if (trapSource.startsWith("AUTH-MNG")) {
            return RbMOType.AUTH_MNG;
        }
        if (trapSource.startsWith("AUTH-SERV")) {
            return RbMOType.AUTH_SERV;
        }
        if (trapSource.startsWith("AU")) {
            return RbMOType.AU;
        }
        if (trapSource.startsWith("SU")) {
            return RbMOType.SU;
        }
        if (trapSource.startsWith("BS")) {
            return RbMOType.BS;
        }
        if (trapSource.startsWith("PSU")) {
            return RbMOType.PSU;
        }
        if (trapSource.startsWith("PIU")) {
            return RbMOType.PIU;
        }
        if (trapSource.startsWith("ACU-FAN")) {
            return RbMOType.ACU_FAN;
        }
        if (trapSource.startsWith("ACU")) {
            return RbMOType.ACU;
        }
        if (trapSource.startsWith("RC")) {
            return RbMOType.RC;
        }
        if (trapSource.startsWith("ODU")) {
            return RbMOType.ODU;
        }
        if (trapSource.startsWith("CHNL")) {
            return RbMOType.CHNL;
        }
        if (trapSource.startsWith("SBSCR")) {
            return RbMOType.SBSCR;
        }
        if (trapSource.startsWith("SRVC")) {
            return RbMOType.SRVC;
        }
        if (trapSource.startsWith("POLICY")) {
            return RbMOType.POLICY;
        }
        if (trapSource.startsWith("QOS")) {
            return RbMOType.QOS;
        }
        if (trapSource.startsWith("FRWRD")) {
            return RbMOType.FRWRD;
        }
        if (trapSource.startsWith("TMPL")) {
            return RbMOType.TMPL;
        }
        if (trapSource.startsWith("FLTR2")) {
            return RbMOType.FLTR2;
        }
        if (trapSource.startsWith("FLTR3")) {
            return RbMOType.FLTR3;
        }
        if (trapSource.startsWith("FLTRIFC")) {
            return RbMOType.FLTRIFC;
        }
        if (trapSource.startsWith("FLTR")) {
            return RbMOType.FLTR;
        }
        if (trapSource.startsWith("DENY")) {
            return RbMOType.DENY;
        }
        if (trapSource.startsWith("ACCT-SERV")) {
            return RbMOType.ACCT_SERV;
        }
        if (trapSource.startsWith("TRAP")) {
            return RbMOType.TRAP;
        }
        if (trapSource.startsWith("QINQ")) {
            return RbMOType.QINQ;
        }
        if (trapSource.startsWith("VOICE-DOMAIN")) {
            return RbMOType.VOICE_DOMAIN;
        }
        if (trapSource.startsWith("PF-SERV")) {
            return RbMOType.PF_SERV;
        }
        if (trapSource.startsWith("PF-CONFIG")) {
            return RbMOType.PF_CONFIG;
        }
        if (trapSource.startsWith("SERVICE-GROUP")) {
            return RbMOType.SERVICE_GROUP;
        }
        if (trapSource.startsWith("PMTM")) {
            return RbMOType.PMTM;
        }
        return RbMOType.unexpectedValue;
    }

    private static String getMoInstance(RbMOType moType, String trapSource) {
        try {
            switch (moType) {
                case NPU: {
                    int npuIndex = trapSource.indexOf("#");
                    return trapSource.substring(npuIndex + 1);
                }
                case AU: {
                    int auIndex = trapSource.indexOf("#");
                    return trapSource.substring(auIndex + 1);
                }
                case SU: {
                    int suIndex = trapSource.indexOf(".");
                    return trapSource.substring(suIndex + 1).toUpperCase();
                }
                case BS: {
                    if (trapSource.length() > 2) {
                        int bsIndex = trapSource.indexOf(".");
                        return trapSource.substring(bsIndex + 1);
                    }
                }
                case PSU: {
                    int psuIndex = trapSource.indexOf("#");
                    return trapSource.substring(psuIndex + 1);
                }
                case PIU: {
                    int piuIndex = trapSource.indexOf("#");
                    return trapSource.substring(piuIndex + 1);
                }
                case ACU_FAN: {
                    int acuFanIndex = trapSource.indexOf("#");
                    return trapSource.substring(acuFanIndex + 1);
                }
                case ACU: {
                    int acuIndex = trapSource.indexOf("#");
                    return trapSource.substring(acuIndex + 1);
                }
                case RC: {
                    int rcIndex = trapSource.indexOf("#");
                    return trapSource.substring(rcIndex + 1);
                }
                case ODU: {
                    int oduIndex = trapSource.indexOf("#");
                    return trapSource.substring(oduIndex + 1);
                }
                case CHNL: {
                    int auSlotIndex = trapSource.indexOf("#");
                    String tmp = trapSource.substring(auSlotIndex + 1);
                    int index = tmp.indexOf(".");
                    int chnlIdIndex = tmp.indexOf("#");
                    return tmp.substring(0, index) + "." + tmp.substring(chnlIdIndex + 1);
                }
                case SBSCR: {
                    int sbscrIndex = trapSource.indexOf("#");
                    return trapSource.substring(sbscrIndex + 1);
                }
                case SRVC: {
                    int srvcIndex = trapSource.indexOf("#");
                    return trapSource.substring(srvcIndex + 1);
                }
                case POLICY: {
                    int policyIndex = trapSource.indexOf("#");
                    return trapSource.substring(policyIndex + 1);
                }
                case QOS: {
                    int qosIndex = trapSource.indexOf("#");
                    return trapSource.substring(qosIndex + 1);
                }
                case FRWRD: {
                    int frwrdIndex = trapSource.indexOf("#");
                    return trapSource.substring(frwrdIndex + 1);
                }
                case TMPL: {
                    int tmplIndex = trapSource.indexOf("#");
                    return trapSource.substring(tmplIndex + 1);
                }
                case FLTR2: {
                    int fltr2Index = trapSource.indexOf("#");
                    return trapSource.substring(fltr2Index + 1);
                }
                case FLTR3: {
                    int fltr3Index = trapSource.indexOf("#");
                    return trapSource.substring(fltr3Index + 1);
                }
                case FLTRIFC: {
                    int fltrifcIndex = trapSource.indexOf("#");
                    return trapSource.substring(fltrifcIndex + 1);
                }
                case FLTR: {
                    int fltrIndex = trapSource.indexOf("#");
                    return trapSource.substring(fltrIndex + 1);
                }
                case DENY: {
                    int denyIndex = trapSource.indexOf(".");
                    return trapSource.substring(denyIndex + 1);
                }
                case AUTH_MNG: {
                    int authMngIndex = trapSource.indexOf(".");
                    return trapSource.substring(authMngIndex + 1);
                }
                case TRAP: {
                    int trapIndex = trapSource.indexOf("#");
                    return trapSource.substring(trapIndex + 1);
                }
                case AUTH_SERV: {
                    int authServIndex = trapSource.indexOf(".");
                    return trapSource.substring(authServIndex + 1);
                }
                case ACCT_SERV: {
                    int acctServIndex = trapSource.indexOf(".");
                    return trapSource.substring(acctServIndex + 1);
                }
                case QINQ: {
                    int qinqIndex = trapSource.indexOf("#");
                    return trapSource.substring(qinqIndex + 1);
                }
                case VOICE_DOMAIN: {
                    int voiceDomainIndex = trapSource.indexOf("#");
                    return trapSource.substring(voiceDomainIndex + 1);
                }
                case PF_SERV: {
                    int pfServIndex = trapSource.indexOf(".");
                    return trapSource.substring(pfServIndex + 1);
                }
                case PF_CONFIG: {
                    int pfConfigIndex = trapSource.indexOf("#");
                    return trapSource.substring(pfConfigIndex + 1);
                }
                case SERVICE_GROUP: {
                    int serviceGroupIndex = trapSource.indexOf("#");
                    return trapSource.substring(serviceGroupIndex + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static {
        try {
            correlationRules.load(RbEntityEvents.class.getResourceAsStream("CorrelationRules.properties"));
            for (Map.Entry<Object, Object> entry : correlationRules.entrySet()) {
                Integer clearingTrap = Integer.parseInt(entry.getKey().toString());
                Integer alarmTrap = Integer.parseInt(entry.getValue().toString());
                alarmMap.put(alarmTrap, clearingTrap);
                clearingMap.put(clearingTrap, alarmTrap);
            }
            eventDefinition.load(RbEntityEvents.class.getResourceAsStream("RbEventDefinition.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (RbVarBind vb : RbVarBind.values()) {
            vbNameMap.put(vb.oid(), vb.name());
            vbNameMap.put(vb.oid0(), vb.name());
        }
    }
}

