/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.fault.correlation.CorrelationRuleProvider;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.GenericTrap;
import com.bwanms.rb.model.constants.RbNEType;
import com.bwanms.services.impl.EntityEventFilter;
import com.bwanms.util.fault.PropertyCorrelationUtil;

public class RbEntityEventCorrelationRuleProvider
implements CorrelationRuleProvider {
    private PropertyCorrelationUtil correlationUtil;

    public RbEntityEventCorrelationRuleProvider() {
        try {
            this.correlationUtil = new PropertyCorrelationUtil(this.getClass().getResourceAsStream("CorrelationRules.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean accept(Event event) {
        return event.getEquipmentType() == RbNEType.BMAX_BS.value() || event.getEquipmentType() == RbNEType.BMAX_MBS.value();
    }

    public EntityEventFilter getEntityEventFilter(final Event event) {
        return new EntityEventFilter(){

            public boolean accept(Event candidate) {
                if (event.getManagedObject() == null ? candidate.getManagedObject() != null : !event.getManagedObject().equals(candidate.getManagedObject())) {
                    return false;
                }
                SNMPTrapV1AgentEvent candidateTrap = (SNMPTrapV1AgentEvent)candidate.getEventCause();
                SNMPTrapV1AgentEvent clearingTrap = (SNMPTrapV1AgentEvent)event.getEventCause();
                if (RbEntityEventCorrelationRuleProvider.this.isEnterpriseSpecific(candidateTrap) && RbEntityEventCorrelationRuleProvider.this.isEnterpriseSpecific(clearingTrap)) {
                    return RbEntityEventCorrelationRuleProvider.this.correlationUtil.filterAccept(event, candidate);
                }
                return candidateTrap.getGeneric() == GenericTrap.LinkDown.value() && clearingTrap.getGeneric() == GenericTrap.LinkUp.value();
            }
        };
    }

    private boolean isEnterpriseSpecific(SNMPTrapV1AgentEvent trap) {
        if (trap == null) {
            return false;
        }
        return trap.getGeneric() == GenericTrap.EnterpriseSpecific.value();
    }
}

