/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.AgentEventProcessor;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.ddi.ServiceManagementStrategy;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.gui.UIException;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.fault.Event;
import com.bwanms.model.license.Licensable;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.rb.ddi.RbAUSynchronizationStrategy;
import com.bwanms.rb.ddi.RbBSSynchStrategyLocal;
import com.bwanms.rb.ddi.RbBSSynchronizationStrategy;
import com.bwanms.rb.ddi.RbBaseStationSynchStrategyLocal;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbMBSSynchStrategyLocal;
import com.bwanms.rb.ddi.RbMBSSynchronizationStrategy;
import com.bwanms.rb.ddi.RbSNMPTrapV1AgentEventProcessor;
import com.bwanms.rb.ddi.RbSUSynchronizationStrategy;
import com.bwanms.rb.ddi.RbServiceManagementStrategy;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBSEquipmentConfiguration;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbMBSEquipmentConfiguration;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.ServiceException;
import com.bwanms.services.impl.EntityEventFilter;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbDeviceDriver
implements DDInterface {
    private static Class[] MO_CLASSES_FOR_ASYNCH_PROCESSING = new Class[]{RbRegisteredSuEntry.class, RbSubscriberEntry.class, RbServiceTemplateConfigEntry.class, RbForwardingRuleConfigEntry.class, RbPolicyRuleConfigEntry.class, RbQoSProfileConfigEntry.class, RbVoiceDomainsEntry.class, RbBSPFServersEntry.class, RbServiceGroupEntry.class};
    static List<Class<? extends ManagedObject>> MO_CLASSES_FOR_ASYNCH_PROCESSING_LIST = Arrays.asList(MO_CLASSES_FOR_ASYNCH_PROCESSING);
    static List<List<Class<? extends ManagedObject>>> MO_CLASSES_FOR_INDIVIDUAL_PROCESSING_LIST = new ArrayList<List<Class<? extends ManagedObject>>>();

    public Equipment createEquipment(ManagementInterface managementInterface, String name, Class equipmentClass) throws Exception {
        if (!(managementInterface instanceof SNMPManagementInterface)) {
            throw new ServiceException("Unsupported equipment type");
        }
        SNMPManagementInterface agentInfo = (SNMPManagementInterface)managementInterface;
        if (RbBaseStationEquipment.class.isAssignableFrom(equipmentClass)) {
            RbBaseStationEquipment ret = null;
            if (equipmentClass.isAssignableFrom(RbBS.class)) {
                ret = new RbBS();
                ret.setIPAddress(agentInfo.getIp());
                ret.setEUID(agentInfo.getIp());
                ret.setModel("BreezeMAX_BS");
                ret.setManagementInterface(agentInfo);
                RbBSEquipmentConfiguration configuration = new RbBSEquipmentConfiguration();
                configuration.setEquipment(ret);
                ret.setCurrentConfiguration(configuration);
                configuration.createBSNrConfiguration();
            } else if (equipmentClass.isAssignableFrom(RbMBS.class)) {
                ret = new RbMBS();
                ret.setEUID(agentInfo.getIp());
                ret.setManagementInterface(agentInfo);
                ret.setIPAddress(agentInfo.getIp());
                ret.setModel("BreezeMAX_MBS");
                RbMBSEquipmentConfiguration configuration = new RbMBSEquipmentConfiguration();
                configuration.setEquipment(ret);
                ret.setCurrentConfiguration(configuration);
                configuration.createBSNrConfiguration();
            }
            ret.setName(name);
            return ret;
        }
        throw new UnsupportedOperationException("Can only create base stations");
    }

    public void deleteEquipment(Equipment equipment, DDCallbackInterface observer) throws Exception {
        if (equipment instanceof RbBaseStationEquipment) {
            if (PlatformConfiguration.isLocalPlatform()) {
                RbBaseStationSynchStrategyLocal bsSynch = (RbBaseStationSynchStrategyLocal)this.getSynchronizationStrategy(equipment, observer);
                bsSynch.baseStationDelete();
            } else {
                RbBaseStationSynchronizationStrategy bsSynch = (RbBaseStationSynchronizationStrategy)this.getSynchronizationStrategy(equipment, observer);
                bsSynch.baseStationDelete();
            }
            LicenseHelper.unlicenseEntity((Licensable)((RbBaseStationEquipment)equipment));
        } else {
            RbSU su = (RbSU)equipment;
            if (su.getState() != 0) {
                LicenseHelper.unlicenseEntity((Licensable)su);
            } else {
                throw new UIException("com.bwanms.gui.equipmentmanager.EquipmentManagerConfigBase", "CannotDeleteEquimentUP", (Serializable[])new String[]{"SU"});
            }
        }
    }

    public EquipmentSynchronizationStrategy getSynchronizationStrategy(Equipment equipment, DDCallbackInterface observer) {
        if (!PlatformConfiguration.isLocalPlatform()) {
            if (equipment instanceof RbBS) {
                return new RbBSSynchronizationStrategy((RbBS)equipment, observer);
            }
            if (equipment instanceof RbMBS) {
                return new RbMBSSynchronizationStrategy((RbMBS)equipment, observer);
            }
            if (equipment instanceof RbAU) {
                return new RbAUSynchronizationStrategy((RbAU)equipment, observer);
            }
            if (equipment instanceof RbSU) {
                return new RbSUSynchronizationStrategy((RbSU)equipment, observer);
            }
        } else {
            if (equipment instanceof RbBS) {
                return new RbBSSynchStrategyLocal((RbBS)equipment, observer);
            }
            if (equipment instanceof RbMBS) {
                return new RbMBSSynchStrategyLocal((RbMBS)equipment, observer);
            }
            if (equipment instanceof RbAU) {
                return new RbAUSynchronizationStrategy((RbAU)equipment, observer);
            }
            if (equipment instanceof RbSU) {
                return new RbSUSynchronizationStrategy((RbSU)equipment, observer);
            }
        }
        throw new RuntimeException("No synchronization strategy found for: " + equipment.getClass().getName());
    }

    public ServiceManagementStrategy getServiceManagementStrategy(DDCallbackInterface observer) {
        return new RbServiceManagementStrategy();
    }

    public List<AgentEventProcessor> getAgentEventProcessors() {
        ArrayList<AgentEventProcessor> ret = new ArrayList<AgentEventProcessor>();
        ret.add(new RbSNMPTrapV1AgentEventProcessor());
        return ret;
    }

    public List<List<Class<? extends ManagedObject>>> getMOClassesForIndividualProcessing() {
        return MO_CLASSES_FOR_INDIVIDUAL_PROCESSING_LIST;
    }

    public List<Class<? extends ManagedObject>> getMOClassesForAsyncChangeProcessing() {
        return MO_CLASSES_FOR_ASYNCH_PROCESSING_LIST;
    }

    public List<Class<? extends Equipment>> getEquipmentWithAsyncConfig() {
        ArrayList<Class<? extends Equipment>> ret = new ArrayList<Class<? extends Equipment>>();
        ret.add(RbBS.class);
        ret.add(RbMBS.class);
        return ret;
    }

    public EntityEventFilter getNMSEquipmentResetDetectedFilter(Event nmsEqResetDetectedEvent) {
        VarBind varBind;
        VarBindList varBinds;
        Long tempSeqNo = null;
        SNMPTrapAgentEvent clearingCause = (SNMPTrapAgentEvent)nmsEqResetDetectedEvent.getEventCause();
        if (clearingCause != null && (varBinds = clearingCause.getVarBindList()) != null && (varBind = varBinds.findVarBindByOID("1.3.6.1.4.1.12394.1.260.3.1.4")) != null) {
            tempSeqNo = (Long)varBind.getVariable();
        }
        final Long internalSeqNo = tempSeqNo;
        return new EntityEventFilter(){

            public boolean accept(Event candidate) {
                Long seqNo;
                VarBind varBind;
                VarBindList varBinds;
                if (internalSeqNo == null) {
                    return false;
                }
                SNMPTrapAgentEvent candidateCause = (SNMPTrapAgentEvent)candidate.getEventCause();
                if (candidateCause != null && (varBinds = candidateCause.getVarBindList()) != null && (varBind = varBinds.findVarBindwithInstanceByOID("1.3.6.1.4.1.12394.1.2.6.4")) != null && (seqNo = (Long)varBind.getVariable()) != null) {
                    return internalSeqNo > seqNo;
                }
                return false;
            }
        };
    }

    static {
        MO_CLASSES_FOR_INDIVIDUAL_PROCESSING_LIST.add(Arrays.asList(RbRegisteredSuEntry.class));
        MO_CLASSES_FOR_INDIVIDUAL_PROCESSING_LIST.add(Arrays.asList(RbSubscriberEntry.class));
        MO_CLASSES_FOR_INDIVIDUAL_PROCESSING_LIST.add(Arrays.asList(RbServiceTemplateConfigEntry.class, RbForwardingRuleConfigEntry.class, RbPolicyRuleConfigEntry.class, RbQoSProfileConfigEntry.class, RbVoiceDomainsEntry.class, RbBSPFServersEntry.class, RbServiceGroupEntry.class));
    }
}

