/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigLauncher;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.model.Equipment;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import javax.swing.JFrame;

public class RbConfigLauncher
implements ConfigLauncher {
    public void launch(Equipment equipment, int moType, String moInstance) {
        this.launch(equipment);
    }

    public void launch(Equipment equipment) {
        if (equipment.isReachable()) {
            RbNPU npu;
            RbBS bs;
            String EUID = null;
            String name = null;
            String url = null;
            if (equipment instanceof RbBS || equipment instanceof RbMBS || equipment instanceof RbSU) {
                EUID = equipment.getEUID();
                name = equipment.getName();
            } else if (equipment instanceof RbAU) {
                RbAU au = (RbAU)equipment;
                RbBS bs2 = au.getManagerBS();
                if (bs2 != null && bs2.isReachable()) {
                    EUID = bs2.getEUID();
                    name = bs2.getName();
                    equipment = bs2;
                    url = "bwanms://config/" + EUID + "/AU." + au.getSlotNumber() + "/";
                }
            } else if (equipment instanceof RbNPU && (bs = (npu = (RbNPU)equipment).getManagerBS()) != null && bs.isReachable()) {
                EUID = bs.getEUID();
                name = bs.getName();
                equipment = bs;
                url = "bwanms://config/" + EUID + "/NPU/";
            }
            if (EUID != null) {
                if (!LicenseClient.getInstance().isLicensed((Object)equipment)) {
                    MessageBox.Error.quickShow("The selected equipment is unlicensed");
                    return;
                }
                ConfigApplicationView appView = new ConfigApplicationView(equipment);
                FrameUtil.runFrame((JFrame)FrameUtil.createFrame(), (String)name, (View)appView, (int)800, (int)600, (boolean)true);
                if (url != null) {
                    appView.fireAction(url);
                }
            }
        } else {
            MessageBox.Alert.quickShow("Equipment is not reachable!");
        }
    }
}

