/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbInterfaceFilteringEntry;
import com.bwanms.rb.mo.RbL2FilteringRuleEntry;
import com.bwanms.rb.mo.RbL3L4FilteringRuleEntry;
import com.bwanms.rb.mo.RbMACAddressDenyListEntry;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbPFGeneralParameters;
import com.bwanms.rb.mo.RbQinQEntry;
import com.bwanms.rb.mo.RbRadioClusterEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.MacAddress;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbBaseStationTrapProcessor {
    private static final Logger logger = Logger.getLogger(RbBaseStationTrapProcessor.class);
    private static final String TRAP_SOURCE_SU = "SU.";
    private static final String TRAP_SOURCE_SERVICE_TEMPLATE = "TMPL.";
    private static final String TRAP_SOURCE_FORWARDING_RULE = "FRWRD.";
    private static final String TRAP_SOURCE_QOS_PROFILE = "QOS.";
    private static final String TRAP_SOURCE_POLICY_RULE = "POLICY.";
    private static final String TRAP_SOURCE_SERVICE = "SRVC.";
    private static final String TRAP_SOURCE_SUBSCRIBER = "SBSCR.";
    private static final String TRAP_SOURCE_CHANNEL = "CHNL.";
    private static final String TRAP_SOURCE_RADIO_CLUSTER = "RC.";
    private static final String TRAP_SOURCE_ODU = "ODU.";
    private static final String TRAP_SOURCE_FLTR = "FLTR.";
    private static final String TRAP_SOURCE_FLTR2 = "FLTR2.";
    private static final String TRAP_SOURCE_FLTR3 = "FLTR3.";
    private static final String TRAP_SOURCE_FLTRIFC = "FLTRIFC.";
    private static final String TRAP_SOURCE_DENY = "DENY.";
    private static final String TRAP_SOURCE_AUTH_MNG = "AUTH-MNG.";
    private static final String TRAP_SOURCE_TRAP = "TRAP.";
    private static final String TRAP_SOURCE_AUTH = "AUTH-SERV.";
    private static final String TRAP_SOURCE_ACCT = "ACCT-SERV.";
    private static final String TRAP_SOURCE_QINQ = "QINQ.";
    private static final String TRAP_SOURCE_PF_SERV = "PF-SERV.";
    private static final String TRAP_SOURCE_VOICE_DOMAINS = "VOICE-DOMAIN.";
    private static final String TRAP_SOURCE_SERVICE_GROUPS = "SERVICE-GROUP.";
    private static final String TRAP_SOURCE_PF_CONFIG = "PF-CONFIG.";
    private Method defaultProcessor;
    private RbBaseStationSynchronizationStrategy bsSynch;
    private TreeMap<Integer, Method> genericProcessors;
    private TreeMap<Integer, Method> specificProcessors;

    public RbBaseStationTrapProcessor(RbBaseStationSynchronizationStrategy bsSynch, TreeMap<Integer, Method> genericProcessors, TreeMap<Integer, Method> specificProcessors) {
        this.bsSynch = bsSynch;
        this.genericProcessors = genericProcessors;
        this.specificProcessors = specificProcessors;
        try {
            this.defaultProcessor = this.getClass().getMethod("defaultProcessor", SNMPTrapV1AgentEvent.class, RbSNMPTrapV1.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processAgentEvent(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        long time = System.currentTimeMillis();
        Method processor = null;
        Method method = processor = trapV1.getGeneric() != 6 ? this.genericProcessors.get(trapV1.getGeneric()) : this.specificProcessors.get(trapV1.getSpecific());
        if (processor == null) {
            logger.debug((Object)("No processor found for: " + trapV1.getGeneric() + ":" + trapV1.getSpecific()));
            processor = this.defaultProcessor;
        }
        try {
            processor.invoke((Object)this, trapV1, rbTrap);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MediationException) {
                throw (MediationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        time = System.currentTimeMillis() - time;
        if (time > 0L && logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsSynch.bsEq.getIPAddress() + "] processedAgentEvent " + trapV1.getGeneric() + ":" + trapV1.getSpecific() + " in: " + time + " ms."));
        }
    }

    public void defaultProcessor(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) {
    }

    public void processLinkDown(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_SU)) {
            this.refreshSu(trapSource, 0L);
        }
    }

    public void processLinkUp(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_SU)) {
            this.refreshSu(trapSource, 0L);
        }
    }

    public void processRbResetOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_SU)) {
            this.refreshSu(trapSource, 0L);
        }
    }

    public void processRbSuNetworkEntryStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        this.refreshSu(rbTrap.getRbTrapSource(), 200L);
    }

    public void processRbODUStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        this.refreshOdu(rbTrap.getRbTrapSource());
    }

    public void processRbODUStatusFromBS(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        this.refreshOdu(RbBaseStationTrapProcessor.getIdFromSharp(rbTrap.getRbTrapSource()));
    }

    public void processRbSwDownloadEnd(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_SU)) {
            this.refreshSu(trapSource, 0L);
        }
    }

    public void processRbServiceStateChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.bsSynch.refreshServiceMO(rbTrap.getRbServiceIdx().toString(), rbTrap.getRbServiceName(), rbTrap.getRbSubscriberIdx().toString(), rbTrap.getRbSuMacAddress());
    }

    public void processRbServiceChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.bsSynch.refreshServiceMO(rbTrap.getRbServiceIdx().toString(), null, rbTrap.getRbSubscriberIdx().toString(), rbTrap.getRbSuMacAddress());
    }

    public void processRbMonitorAccessOff(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
    }

    public void processRbConfigurationChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        this.refreshMOs(trapV1, rbTrap);
    }

    protected void refreshMOs(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_SU)) {
            this.refreshSu(trapSource, 0L);
        } else if (trapSource.startsWith(TRAP_SOURCE_RADIO_CLUSTER)) {
            this.refreshRadioCluster(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_ODU)) {
            this.refreshOdu(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_CHANNEL)) {
            this.refreshChannel(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_SUBSCRIBER)) {
            this.refreshSubscriber(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_SERVICE)) {
            this.refreshService(trapSource, rbTrap);
        } else if (trapSource.startsWith(TRAP_SOURCE_POLICY_RULE)) {
            this.refreshPolicy(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_QOS_PROFILE)) {
            this.refreshQoSProfile(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_FORWARDING_RULE)) {
            this.refreshForwardingRule(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_SERVICE_TEMPLATE)) {
            this.refreshServiceTemplate(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_FLTR2)) {
            this.refreshL2FilteringRule(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_FLTR3)) {
            this.refreshL3FilteringRule(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_FLTRIFC) || trapSource.startsWith(TRAP_SOURCE_FLTR)) {
            this.refreshFilterInterface(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_DENY)) {
            this.refreshMacAddressDeny(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_AUTH_MNG)) {
            this.refreshAuthMng(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_TRAP)) {
            this.refreshTrap(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_AUTH)) {
            this.refreshAuthServer(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_ACCT)) {
            this.refreshAcctServer(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_QINQ)) {
            this.refreshQinQ(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_PF_SERV) || trapSource.startsWith(TRAP_SOURCE_PF_CONFIG)) {
            this.refreshPfServer(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_VOICE_DOMAINS)) {
            this.refreshVoiceDomain(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_SERVICE_GROUPS)) {
            this.refreshServiceGroup(trapSource);
        } else {
            logger.warn((Object)("[" + this.bsSynch.bsEq.getIPAddress() + "]  Unknown trap source: " + trapSource));
        }
    }

    private void refreshFilterInterface(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbInterfaceFilteringEntry.class, "*");
        this.bsSynch.refreshMO("BS", RbL2FilteringRuleEntry.class, "*");
        this.bsSynch.refreshMO("BS", RbL3L4FilteringRuleEntry.class, "*");
    }

    private void refreshAcctServer(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbRadiusAccountServerEntry.class, "*");
    }

    private void refreshAuthServer(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbRadiusAuthServerEntry.class, "*");
    }

    private void refreshMacAddressDeny(String trapSource) throws MediationException {
        String macAddress = RbBaseStationTrapProcessor.getMacAddressFromTrapSource(trapSource);
        this.bsSynch.refreshMO("BS", RbMACAddressDenyListEntry.class, MacAddress.fromSimpleString((String)macAddress).toInstanceString());
    }

    private void refreshL2FilteringRule(String trapSource) throws MediationException {
        this.bsSynch.refreshL2FilteringRuleMO(RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshL3FilteringRule(String trapSource) throws MediationException {
        this.bsSynch.refreshL3L4FilteringRuleMO(RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshServiceTemplate(String trapSource) throws MediationException {
        this.bsSynch.refreshServiceTemplateMO(RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshForwardingRule(String trapSource) throws MediationException {
        this.bsSynch.refreshForwardingRuleMO(RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshPolicy(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbPolicyRuleConfigEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshQoSProfile(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbQoSProfileConfigEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshVoiceDomain(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbVoiceDomainsEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshServiceGroup(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbServiceGroupEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
    }

    private void refreshPfServer(String trapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbBSPFServersEntry.class, "*");
        this.bsSynch.refreshMO("BS", RbPFGeneralParameters.class, "*");
    }

    private void refreshService(String trapSource, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.bsSynch.refreshServiceMO(RbBaseStationTrapProcessor.getIdFromSharp(trapSource), null, null != rbTrap.getRbSubscriberIdx() ? rbTrap.getRbSubscriberIdx().toString() : null, rbTrap.getRbSuMacAddress());
    }

    private void refreshSubscriber(String trapSource) throws MediationException {
        if (this.bsSynch.bsEq.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            this.bsSynch.refreshMO("BS", RbSubscriberEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(trapSource));
        }
    }

    private void refreshSu(String rbTrapSource, long delay) throws MediationException {
        String suMacAddress = RbBaseStationTrapProcessor.getMacAddressFromTrapSource(rbTrapSource);
        if (delay > 0L) {
            this.bsSynch.refreshMOWithDelay("BS", RbRegisteredSuEntry.class, MacAddress.fromSimpleString((String)suMacAddress).toOctetString());
        } else {
            this.bsSynch.refreshMO("BS", RbRegisteredSuEntry.class, MacAddress.fromSimpleString((String)suMacAddress).toOctetString());
        }
    }

    private void refreshRadioCluster(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbRadioClusterEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(rbTrapSource));
    }

    private void refreshOdu(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMOWithDelay("BS", RbOduConfigEntry.class, "*");
    }

    private void refreshTrap(String rbTrapSource) throws MediationException {
        try {
            int trapId = Integer.parseInt(RbBaseStationTrapProcessor.getIdFromSharp(rbTrapSource));
            String trapIdString = trapId < 128 || trapId > 132 ? "2." + trapId : "1." + (trapId - 128);
            this.bsSynch.refreshMO("BS", RbTrapConfigEntry.class, trapIdString);
        }
        catch (NumberFormatException nfe) {
            logger.debug((Object)("Wrong trap source " + rbTrapSource));
        }
    }

    private void refreshQinQ(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbQinQEntry.class, RbBaseStationTrapProcessor.getIdFromSharp(rbTrapSource));
    }

    private void refreshAuthMng(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbAuthorizedManagersEntry.class, RbBaseStationTrapProcessor.getIdFromDot(rbTrapSource));
    }

    protected abstract void refreshChannel(String var1) throws MediationException;

    protected static String getIdFromSharp(String trapSource) {
        return trapSource.substring(trapSource.indexOf("#") + 1);
    }

    protected static String getIdFromDot(String trapSource) {
        return trapSource.substring(trapSource.indexOf(".") + 1);
    }

    protected static String getAuChannelId(String trapSource) {
        String[] splitByDot = trapSource.split("\\.");
        return RbBaseStationTrapProcessor.getIdFromSharp(splitByDot[1]) + "." + RbBaseStationTrapProcessor.getIdFromSharp(splitByDot[2]);
    }

    protected static String getMacAddressFromTrapSource(String trapSource) {
        String[] splitByDot = trapSource.split("\\.");
        return MacAddress.fromString((String)splitByDot[1]).toSimpleString();
    }
}

