/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.mediation.services.AgentEventProcessorManager;
import com.bwanms.mediation.services.EventNotificationServiceIntf;
import com.bwanms.mediation.services.impl.MORefreshRunnable;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentNotifyerEventTypes;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.fault.Event;
import com.bwanms.model.license.Licensable;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.rb.configfile.ConfigFile;
import com.bwanms.rb.configfile.RbConfigFileMOAccessSession;
import com.bwanms.rb.ddi.RbBSIdentity;
import com.bwanms.rb.ddi.RbDeviceDriver;
import com.bwanms.rb.ddi.RbEntityEvents;
import com.bwanms.rb.ddi.RbGPSChainSynchronizationHelper;
import com.bwanms.rb.ddi.RbMORefreshRunnable;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.ddi.RbServiceSynchronizationHelper;
import com.bwanms.rb.ddi.RbSuSynchronizationHelper;
import com.bwanms.rb.ddi.RbTrapEventLogEntry;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbSuSubDevicesEntry;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbBaseStationEquipmentConfiguration;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.impl.ManagedEntityStateManager;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MacAddress;
import com.bwanms.util.OctetString;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbBaseStationSynchronizationStrategy
implements EquipmentSynchronizationStrategy {
    private static final String RB_TRAP_SEQNO_OID = "1.3.6.1.4.1.12394.1.2.6.4.0";
    private static final Logger logger = Logger.getLogger(RbBaseStationSynchronizationStrategy.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbBaseStationSynchronizationStrategy.class);
    private static Map<Long, Map<Long, SNMPTrapV1AgentEvent>> delayedTrapsMap = new TreeMap<Long, Map<Long, SNMPTrapV1AgentEvent>>();
    private static Map<Long, Long> seqTrapsMap = new HashMap<Long, Long>();
    private List<RbSU> newSUs;
    protected static final Class[] RB_STATE_ANNOTATIONS = new Class[]{StateAttribute.class, InventoryAttribute.class};
    private static final int MAX_TRAP_TREEMAP_SIZE = 100;
    private static final long RB_TRAP_LOG_SIZE = 1000L;
    private static final long CREATE_BACKUP_FILE_TIMEOUT = 20000L;
    private static final int CREATE_BACKUP_FILE_RETRIES = 1;
    private static final int tftpConfiFileDefaultTimeout = Integer.getInteger("com.bwanms.rb.ddi.downloadConfigurationFile.tftpDefaultTimeout", 5000);
    private static final int tftpConfigFileDefaultRetries = Integer.getInteger("com.bwanms.rb.ddi.downloadConfigurationFile.tftpDefaultRetries", 3);
    private static AgentEventProcessorManager agentEventProcessorManager = (AgentEventProcessorManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/AgentEventProcessorManager");
    private static EventNotificationServiceIntf notifEngine = (EventNotificationServiceIntf)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/mediation/EventNotificationService");
    private static ManagedEntityStateManager managedEntityStateManager = (ManagedEntityStateManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/EquipmentStateManager");
    RbBaseStationEquipment bsEq;
    DDCallbackInterface ddCallback;
    RbSuSynchronizationHelper suHelper;
    RbGPSChainSynchronizationHelper gpsChainHelper;
    private static int IN_QUERY_MAX_SIZE = 100;
    public final int RBREGISTEREDSUENTRY_BATCH_SIZE = 200;
    private static long[] simulatedEquipmentRange;

    private static List<String> getSystemIPAddresses() {
        ArrayList<String> systemIPAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            while (ifs.hasMoreElements()) {
                NetworkInterface intf = ifs.nextElement();
                Enumeration<InetAddress> addresses = intf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ia = addresses.nextElement();
                    if (ia.isLoopbackAddress()) continue;
                    systemIPAddresses.add(ia.getHostAddress());
                }
            }
        }
        catch (SocketException se) {
            logger.error((Object)se);
        }
        return systemIPAddresses;
    }

    public RbBaseStationSynchronizationStrategy(RbBaseStationEquipment baseStationEquipment, DDCallbackInterface ddCallback) {
        this.bsEq = baseStationEquipment;
        this.ddCallback = ddCallback;
        this.suHelper = new RbSuSynchronizationHelper(this.bsEq);
        this.gpsChainHelper = new RbGPSChainSynchronizationHelper(this.bsEq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeState() {
        int unemitted = RbBaseStationSynchronizationStrategy.checkUnemittedTraps(this.bsEq);
        if (unemitted > 500 || 0 < unemitted && !RbBaseStationSynchronizationStrategy.cantDelayTraps(this.bsEq)) {
            logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Sync state SKIPPED.  unemitted traps: " + unemitted));
            return;
        }
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Sync state.  unemitted traps: " + unemitted));
        long synchTime = System.currentTimeMillis();
        MOAccessSession access = null;
        try {
            boolean previouslyUp;
            access = this.createMOAccessSession();
            RbBSIdentity identity = null;
            try {
                identity = (RbBSIdentity)access.fetchObject(null, RbBSIdentity.class, null, "*").get(0);
            }
            catch (AgentException e) {
                identity = (RbBSIdentity)access.fetchObject(null, RbBSIdentity.class, new String[]{"systemObjectID"}, "*").get(0);
            }
            if (!this.isValidSysObjectID(identity.getSystemObjectID())) {
                throw new CommunicationException("Invalid sysObjectID found: " + identity.getSystemObjectID());
            }
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] SysObjectID Valid"));
            int bsStateInt = this.bsEq.getState();
            boolean bl = previouslyUp = bsStateInt != -3 && bsStateInt != -1;
            if (identity.getRbSysLastTrapSeqNumber() == null) {
                if (!previouslyUp) {
                    this.syncStepRetrieveVersionInformation(access);
                    this.syncStepEquipmentResetDetected(0L);
                    this.syncStepSetEquipmentUp();
                }
                return;
            }
            if (!previouslyUp) {
                HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
                equipmentProperties.put(EquipmentNotifyerEventTypes.LABEL_CRITICAL_MESSAGE_CHANGED, "");
                this.notifyClient(equipmentProperties);
            }
            long lastTrapBeforeReset = identity.getRbSysLastTrapSeqNumber();
            long rbTrapSeqNo = identity.getRbTrapSeqNumber() - 1L;
            if (lastTrapBeforeReset != this.bsEq.getTrapSeqNoBeforeReset()) {
                this.syncStepRetrieveVersionInformation(access);
                this.syncStepDownloadConfig();
                this.syncStepEquipmentResetDetected(lastTrapBeforeReset);
                this.syncStepSetEquipmentUp();
                seqTrapsMap.put(this.bsEq.getId(), lastTrapBeforeReset - 1L);
                this.bsEq.setTrapSeqNoBeforeReset(lastTrapBeforeReset);
                this.bsEq.setLastReceivedTrapSeqNo(lastTrapBeforeReset - 1L);
                this.saveOrUpdateEquipment(this.bsEq);
                boolean dlStateViaSnmp = true;
                if (this.syncStepCanProcessMissingTraps(lastTrapBeforeReset, rbTrapSeqNo)) {
                    logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Reset detected @ event " + lastTrapBeforeReset + " Found " + (rbTrapSeqNo - lastTrapBeforeReset + 1L) + " missed traps. Will process missing."));
                    boolean bl2 = dlStateViaSnmp = !this.syncStepProcessMissingTraps(access, lastTrapBeforeReset, rbTrapSeqNo);
                }
                if (dlStateViaSnmp) {
                    Map<Long, SNMPTrapV1AgentEvent> mp = delayedTrapsMap.get(this.bsEq.getId());
                    if (mp != null) {
                        mp.clear();
                    }
                    logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Reset detected @ event " + lastTrapBeforeReset + " Found " + (rbTrapSeqNo - lastTrapBeforeReset + 1L) + " missed traps. Will synchronize."));
                    this.syncStepDownloadStateViaSnmp(access);
                    seqTrapsMap.put(this.bsEq.getId(), rbTrapSeqNo);
                    this.bsEq.setLastReceivedTrapSeqNo(rbTrapSeqNo);
                    this.saveOrUpdateEquipment(this.bsEq);
                }
            } else {
                Long bsTrapSeqNo = this.retrieveBsLastTrapSeqNo();
                long startTrapNo = bsTrapSeqNo + 1L;
                if (rbTrapSeqNo >= startTrapNo) {
                    boolean dlStateViaSnmp = true;
                    if (this.syncStepCanProcessMissingTraps(startTrapNo, rbTrapSeqNo)) {
                        logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Found " + (rbTrapSeqNo - startTrapNo + 1L) + " missed traps. Will process missing."));
                        if (!previouslyUp) {
                            this.syncStepRestoreState();
                        }
                        boolean bl3 = dlStateViaSnmp = !this.syncStepProcessMissingTraps(access, startTrapNo, rbTrapSeqNo);
                    }
                    if (dlStateViaSnmp) {
                        Map<Long, SNMPTrapV1AgentEvent> mp = delayedTrapsMap.get(this.bsEq.getId());
                        if (mp != null) {
                            mp.clear();
                        }
                        logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Found " + (rbTrapSeqNo - startTrapNo + 1L) + " missed traps. Will synchronize."));
                        this.syncStepSetEquipmentUp();
                        this.syncStepDownloadStateViaSnmp(access);
                        seqTrapsMap.put(this.bsEq.getId(), rbTrapSeqNo);
                        this.bsEq.setLastReceivedTrapSeqNo(rbTrapSeqNo);
                        this.saveOrUpdateEquipment(this.bsEq);
                    }
                } else {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] No missed traps."));
                    if (!previouslyUp) {
                        this.syncStepRestoreState();
                    }
                }
            }
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Sync State finished in " + (System.currentTimeMillis() - synchTime) + " millis"));
        }
        catch (CommunicationException e) {
            this.ddCallback.communicationError((Equipment)this.bsEq);
            throw new RuntimeException(e);
        }
        catch (MediationException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (access != null) {
                this.closeMOAccessSession(access);
            }
        }
    }

    private static int checkUnemittedTraps(RbBaseStationEquipment bs) {
        Integer agentEventsCount = agentEventProcessorManager.retrieveAgentEventCount(bs.getIPAddress());
        if (agentEventsCount != null && agentEventsCount > 0) {
            return agentEventsCount;
        }
        return 0;
    }

    private static boolean hasDelayedTraps(RbBaseStationEquipment bs) {
        Map<Long, SNMPTrapV1AgentEvent> mp = delayedTrapsMap.get(bs.getId());
        if (null != mp && !mp.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + bs.getEUID() + "] Has delayed traps: " + mp.size()));
            }
            return true;
        }
        return false;
    }

    private static boolean cantDelayTraps(RbBaseStationEquipment bs) {
        Map<Long, SNMPTrapV1AgentEvent> mp = delayedTrapsMap.get(bs.getId());
        if (null != mp && mp.size() >= 100) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + bs.getEUID() + "] Cant delay traps: size is " + mp.size()));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + bs.getEUID() + "] Can delay traps: " + (100 - mp.size())));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncStepProcessMissingTraps(MOAccessSession access, long startTrapSeqNo, long lastTrapSeqNo) throws MediationException {
        block15: {
            try {
                long seqNo;
                Map<Long, SNMPTrapV1AgentEvent> mp = delayedTrapsMap.get(this.bsEq.getId());
                if (mp == null) {
                    mp = new TreeMap<Long, SNMPTrapV1AgentEvent>();
                }
                int crtProcessingAgentEventCount = agentEventProcessorManager.retrieveProcessingAgentEventCount(this.bsEq.getIPAddress());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Current events in processing queue: " + crtProcessingAgentEventCount));
                }
                int maxProcessingAgentEvents = agentEventProcessorManager.retrieveMaxEventQueueSize() - crtProcessingAgentEventCount;
                for (seqNo = startTrapSeqNo; seqNo <= lastTrapSeqNo && maxProcessingAgentEvents > 0; --maxProcessingAgentEvents, ++seqNo) {
                    Long bsLastTrapSeqNo = this.retrieveBsLastTrapSeqNo();
                    if (bsLastTrapSeqNo >= seqNo) {
                        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Skip recovery of " + (bsLastTrapSeqNo - seqNo + 1L) + " traps to #" + (bsLastTrapSeqNo + 1L)));
                        seqNo = bsLastTrapSeqNo + 1L;
                    }
                    if (seqNo > lastTrapSeqNo) {
                        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Skip remaining traps. last emitted trap is: " + seqNo));
                        break;
                    }
                    SNMPTrapV1AgentEvent snmpTrap = mp.remove(seqNo);
                    if (snmpTrap == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Getting missing trap #" + seqNo));
                        }
                        RbTrapEventLogEntry missingTrap = (RbTrapEventLogEntry)access.fetchObject(null, RbTrapEventLogEntry.class, null, Long.toString(seqNo)).get(0);
                        Version bsVersion = this.bsEq.getSoftwareVersion();
                        snmpTrap = missingTrap.toAgentEvent(this.bsEq.getIPAddress(), "1.3.6.1.4.1.12394.1.2", bsVersion.isNewerOrEqualWith(RbVersions.V_3_5) && bsVersion.isOlderThan(RbVersions.V_4_0));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Adding missing trap #" + seqNo));
                    }
                    agentEventProcessorManager.add((AgentEvent)snmpTrap);
                }
                if (seqNo <= lastTrapSeqNo) break block15;
                Map<Long, SNMPTrapV1AgentEvent> map = mp;
                synchronized (map) {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Flushing " + mp.size() + " traps to queue"));
                    for (Map.Entry<Long, SNMPTrapV1AgentEvent> entry : mp.entrySet()) {
                        if (maxProcessingAgentEvents <= 0) break;
                        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Flushing trap #" + entry.getValue().getVarBindList().get(0).getVariable() + " to queue"));
                        agentEventProcessorManager.add((AgentEvent)entry.getValue());
                        --maxProcessingAgentEvents;
                    }
                    if (maxProcessingAgentEvents >= 0) {
                        mp.clear();
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public synchronized boolean emitNmsEvent(AgentEvent agentEvent) {
        if (!LicenseHelper.isLicensed((Object)((Object)this.bsEq))) {
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Not licensed"));
            return false;
        }
        try {
            long bsTrapSeqNo;
            if (this.bsEq.getState() == -3 || this.bsEq.getState() == -1) {
                logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Not up: sync and ignore trap"));
                RbBaseStationSynchronizationStrategy.callSynchronizeNow(this.bsEq);
                return false;
            }
            SNMPTrapV1AgentEvent snmpTrap = (SNMPTrapV1AgentEvent)agentEvent;
            long trapSeqNo = (Long)snmpTrap.getVarBindList().findVarBindByOID(RB_TRAP_SEQNO_OID).getVariable();
            if (trapSeqNo == (bsTrapSeqNo = this.retrieveBsLastTrapSeqNo()) + 1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Trap in sequence #" + trapSeqNo));
                }
                if (!RbBaseStationSynchronizationStrategy.canProcessMoreEvents(this.bsEq, 1.0)) {
                    logger.warn((Object)("[" + this.bsEq.getIPAddress() + "] Processing list is full. Dropping #" + trapSeqNo));
                    this.addToDelayedTraps(snmpTrap);
                    return false;
                }
                if (RbEntityEvents.shouldEmitEvent(this.bsEq, snmpTrap)) {
                    RbSNMPTrapV1 rbTrap = (RbSNMPTrapV1)snmpTrap.createDataObject(RbSNMPTrapV1.class);
                    this.doEmitNmsEvent(snmpTrap, rbTrap);
                }
                seqTrapsMap.put(this.bsEq.getId(), trapSeqNo);
                this.bsEq.setLastReceivedTrapSeqNo(trapSeqNo);
                Datastore.session().saveOrUpdate((Object)this.bsEq);
                return true;
            }
            if (trapSeqNo < bsTrapSeqNo + 1L) {
                logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Trap from the past. Ingoring #" + trapSeqNo));
                return false;
            }
            logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Trap NOT in sequence #" + trapSeqNo + " missed " + (trapSeqNo - bsTrapSeqNo - 1L) + " traps from #" + bsTrapSeqNo));
            this.addToDelayedTraps(snmpTrap);
            if (RbBaseStationSynchronizationStrategy.canProcessMoreEvents(this.bsEq, 0.5)) {
                RbBaseStationSynchronizationStrategy.callSynchronizeNow(this.bsEq);
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    private long retrieveBsLastTrapSeqNo() {
        Long bsLastTrapSeqNo = seqTrapsMap.get(this.bsEq.getId());
        if (bsLastTrapSeqNo == null) {
            bsLastTrapSeqNo = this.bsEq.getLastReceivedTrapSeqNo();
        }
        return bsLastTrapSeqNo;
    }

    private static boolean canProcessMoreEvents(RbBaseStationEquipment bs, double threshold) {
        int crtProcessingAgentEventCount = agentEventProcessorManager.retrieveProcessingAgentEventCount(bs.getIPAddress());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + bs.getIPAddress() + "] Current events in processing queue: " + crtProcessingAgentEventCount));
        }
        return (double)crtProcessingAgentEventCount < (double)agentEventProcessorManager.retrieveMaxEventQueueSize().intValue() * threshold;
    }

    private boolean addToDelayedTraps(SNMPTrapV1AgentEvent snmpTrap) {
        Map<Long, Object> reqTrapsMap = delayedTrapsMap.get(this.bsEq.getId());
        if (reqTrapsMap == null) {
            reqTrapsMap = Collections.synchronizedMap(new TreeMap());
            delayedTrapsMap.put(this.bsEq.getId(), reqTrapsMap);
        }
        if (100 > reqTrapsMap.size()) {
            Long seqNo = (Long)snmpTrap.getVarBindList().findVarBindByOID(RB_TRAP_SEQNO_OID).getVariable();
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Add to delayed: " + seqNo));
            reqTrapsMap.put(seqNo, snmpTrap);
            return true;
        }
        if (logger.isDebugEnabled()) {
            Long seqNo = (Long)snmpTrap.getVarBindList().findVarBindByOID(RB_TRAP_SEQNO_OID).getVariable();
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Delayed traps list full. Dropping #" + seqNo));
        }
        return false;
    }

    private void doEmitNmsEvent(SNMPTrapV1AgentEvent snmpTrap, RbSNMPTrapV1 rbTrap) {
        try {
            RbSNMPTrapV1.processDisplayStrings(snmpTrap);
            Event evt = RbEntityEvents.createEvent(this.bsEq, snmpTrap, rbTrap);
            notifEngine.submitEvent(evt);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void processAgentEvent(AgentEvent agentEvent) {
        SNMPTrapV1AgentEvent snmpTrap = (SNMPTrapV1AgentEvent)agentEvent;
        RbSNMPTrapV1 rbTrap = (RbSNMPTrapV1)snmpTrap.createDataObject(RbSNMPTrapV1.class);
        try {
            this.processAgentEventInternal(snmpTrap, rbTrap);
        }
        catch (MediationException e) {
            // empty catch block
        }
    }

    public abstract void processAgentEventInternal(SNMPTrapV1AgentEvent var1, RbSNMPTrapV1 var2) throws MediationException;

    static void callSynchronizeNow(RbBaseStationEquipment bs) {
        managedEntityStateManager.syncNow((Equipment)bs);
    }

    public void downloadConfiguration() {
        try {
            this.refreshBaseStation();
            HashMap data = new HashMap();
            this.createBackupFile();
            this.processConfigFile(this.downloadConfigurationFile("backup", ".res"));
            if (new DefaultVersion("4.1.1").compareTo(this.bsEq.getSoftwareVersion()) < 0) {
                this.createBackupSuSyncFile();
                this.processConfigFile(this.downloadConfigurationFile("SU_Sync", ".res"));
            }
            this.ddCallback.communicationOK((Equipment)this.bsEq);
        }
        catch (CommunicationException e) {
            this.ddCallback.communicationError((Equipment)this.bsEq);
            throw new RuntimeException(e);
        }
        catch (MediationException e) {
            logger.debug((Object)"", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<ConfigurationChangedEvent> configurationChanged(ConfigurationChangedEvent evt) throws ConfigurationNotSynchronizedException {
        logger.debug((Object)("[" + this.bsEq.getEUID() + "] Configuration changed"));
        EquipmentConfiguration config = this.bsEq.findCurrentConfiguration();
        Method processor = this.getMOChangeProcessors().get(evt.getMoClass());
        if (processor == null) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] No MOChangeProcessorFound for [" + evt.getMoClass().getName() + "]"));
            return null;
        }
        NetworkResourceConfiguration nrConfig = config.findNetworkResourceConfiguration(evt.getNetworkResourceName());
        if (!evt.isAsyncProcess()) {
            if (RbServiceProfiles.isHandlingNPMOClass(evt.getMoClass()) && !this.processServiceProfilesConfigurationChanged(evt, nrConfig)) {
                return null;
            }
            if (RbSubscriberEntry.class.equals((Object)evt.getMoClass())) {
                this.processSubscribersConfigurationChanged(evt, nrConfig);
            }
            if (RbDeviceDriver.MO_CLASSES_FOR_ASYNCH_PROCESSING_LIST.contains(evt.getMoClass())) {
                ArrayList<ConfigurationChangedEvent> ret = new ArrayList<ConfigurationChangedEvent>(1);
                if (!RbRegisteredSuEntry.class.equals((Object)evt.getMoClass())) {
                    String instance = (String)evt.getInstances().iterator().next();
                    evt.getInstances().clear();
                    evt.getInstances().add(instance);
                    ret.add(new ConfigurationChangedEvent(evt.getEquipmentId(), evt.getNetworkResourceName(), evt.getMoClass(), evt.getInstances(), true));
                } else {
                    ArrayList batchInstances = new ArrayList(Math.min(evt.getInstances().size(), 200));
                    Iterator it = evt.getInstances().iterator();
                    while (it.hasNext()) {
                        batchInstances.add(it.next());
                        if (batchInstances.size() != 200 && (it.hasNext() || batchInstances.isEmpty())) continue;
                        ret.add(new ConfigurationChangedEvent(evt.getEquipmentId(), evt.getNetworkResourceName(), evt.getMoClass(), batchInstances, true));
                        batchInstances = new ArrayList(200);
                    }
                }
                return ret;
            }
        }
        if (RbRegisteredSuEntry.class.equals((Object)evt.getMoClass())) {
            this.processSUConfigurationChanged(evt, nrConfig);
            return null;
        }
        Map moMap = nrConfig.retrieveManagedObjects(evt.getMoClass(), evt.getInstances());
        for (String moInstance : evt.getInstances()) {
            Object mo = moMap.get(moInstance);
            if (mo != null && MOUtils.hasNullAnnotatedAttributes((Equipment)this.bsEq, (ManagedObject)((ManagedObject)mo), (Class[])RB_STATE_ANNOTATIONS)) {
                logger.debug((Object)("Ignoring " + mo.getClass().getName() + "#" + moInstance));
                continue;
            }
            try {
                logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] " + evt.getMoClass().getName() + " changed [" + moInstance + "]"));
                processor.invoke((Object)this, moInstance, mo);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e, (Throwable)e);
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e, (Throwable)e);
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.debug((Object)e.getCause(), e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return null;
    }

    public void setUnreachable(Event generatedBy) {
        if (this.bsEq.getState() == -1) {
            return;
        }
        logger.debug((Object)("setUnreachable[ " + this.bsEq.getId() + "]"));
        Event bsDownEvent = this.ddCallback.setEquipmentState(generatedBy, (Equipment)this.bsEq, -1);
        if (bsDownEvent != null) {
            EventFacade.emitEvent((Event)bsDownEvent);
        }
        HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
        equipmentProperties.put(EquipmentNotifyerEventTypes.LABEL_CRITICAL_MESSAGE_CHANGED, i18n.translateString("BSIsUnreachable"));
        this.notifyClient(equipmentProperties);
        RbSuSynchronizationHelper.getRbSUsMgmtDBGiantLock();
        for (ManagedEquipment me : this.bsEq.findManagedEquipment()) {
            this.ddCallback.setEquipmentState(bsDownEvent, (Equipment)me, -1);
        }
    }

    protected abstract void createBackupFile() throws MediationException;

    protected abstract void createBackupSuSyncFile() throws MediationException;

    private ConfigFile downloadConfigurationFile(String fileName, String fileExtension) throws MediationException {
        long time = System.currentTimeMillis();
        TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
        SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
        SNMPManagementInterface smi = this.bsEq.getManagementInterface();
        TftpFileTransferRequest req = new TftpFileTransferRequest(this.bsEq.getIPAddress(), tftpConfigFileDefaultRetries, tftpConfiFileDefaultTimeout, null, RbBaseStationSynchronizationStrategy.getBackupFileName(this.bsEq.getIPAddress(), fileName, fileExtension), 1, (Serializable)((Object)"me"));
        FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
        if (res == null) {
            throw new MediationException("Could not retrieve " + fileName + fileExtension + " TFTP file");
        }
        if (res.getEventType() == 2) {
            throw res.getError();
        }
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] " + fileName + fileExtension + " backup file downloaded " + (System.currentTimeMillis() - time) + " millis."));
        time = System.currentTimeMillis();
        byte[] configFileData = res.getFileData();
        try {
            return ConfigFile.parse(new ByteArrayInputStream(configFileData));
        }
        catch (Exception e) {
            throw new MediationException((Throwable)e);
        }
    }

    private void syncStepEquipmentResetDetected(final long lastTrapBeforeReset) {
        try {
            new CallableDatastoreDecorator((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    Event event = RbBaseStationSynchronizationStrategy.this.ddCallback.equipmentResetDetected(null, (Equipment)RbBaseStationSynchronizationStrategy.this.bsEq, lastTrapBeforeReset);
                    if (event != null) {
                        EventFacade.emitEvent((Event)event);
                    }
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private void syncStepRetrieveVersionInformation(final MOAccessSession access) throws MediationException {
        try {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                    try {
                        RbBaseStationSynchronizationStrategy.this.syncStepRetrieveVersionInformationImpl(access);
                    }
                    catch (MediationException e) {
                        logger.debug((Object)e, (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    logger.debug((Object)("[" + RbBaseStationSynchronizationStrategy.this.bsEq.getIPAddress() + "] Firmware version: " + RbBaseStationSynchronizationStrategy.this.bsEq.getFirmwareVersion()));
                    Datastore.session().save((Object)RbBaseStationSynchronizationStrategy.this.bsEq);
                }
            }).run();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MediationException) {
                throw (MediationException)e.getCause();
            }
            throw e;
        }
    }

    protected abstract void syncStepRetrieveVersionInformationImpl(MOAccessSession var1) throws MediationException;

    protected void syncStepDownloadConfig() throws MediationException {
        long t = System.currentTimeMillis();
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Config Files processing started"));
        this.createBackupFile();
        this.processConfigFile(this.downloadConfigurationFile("backup", ".res"));
        if (new DefaultVersion("4.1.1").compareTo(this.bsEq.getSoftwareVersion()) <= 0) {
            this.createBackupSuSyncFile();
            this.processConfigFile(this.downloadConfigurationFile("SU_Sync", ".res"));
        }
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Config Files processed in " + (System.currentTimeMillis() - t) + " millis"));
    }

    protected void syncStepDownloadStateViaSnmp(MOAccessSession access) throws MediationException {
        final HashMap classesMap = new HashMap();
        try {
            ArrayList suInstances = new ArrayList();
            new CallableDatastoreDecorator((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                    for (NetworkResourceConfiguration nrConfig : RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().getNetworkResources().values()) {
                        ArrayList<Class> moClassesToRefresh = new ArrayList<Class>();
                        for (Class moClass : nrConfig.getManagedObjectClasses()) {
                            if (!MOUtils.hasAnnotatedAttributes((Class)moClass, (Class[])RB_STATE_ANNOTATIONS)) continue;
                            moClassesToRefresh.add(moClass);
                        }
                        classesMap.put(nrConfig.getName(), moClassesToRefresh);
                    }
                    return null;
                }
            }).call();
            for (String suInstance : suInstances) {
                logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Refreshing [" + RbRegisteredSuEntry.class.getName() + "][" + suInstance + "]"));
                this.refreshMO("BS", RbRegisteredSuEntry.class, suInstance);
            }
            for (String nrConfigName : classesMap.keySet()) {
                for (Class moClass : (ArrayList)classesMap.get(nrConfigName)) {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Refreshing [" + moClass.getName() + "][*]"));
                    this.refreshMO(nrConfigName, moClass, "*");
                }
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MediationException) {
                throw (MediationException)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void syncStepRestoreState() {
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Restoring state"));
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                logger.debug((Object)("[" + RbBaseStationSynchronizationStrategy.this.bsEq.getIPAddress() + "] Setting equipment state: UP"));
                Event event = RbBaseStationSynchronizationStrategy.this.ddCallback.setEquipmentState(null, (Equipment)RbBaseStationSynchronizationStrategy.this.bsEq, 0);
                if (event != null) {
                    EventFacade.emitEvent((Event)event);
                }
                RbBaseStationSynchronizationStrategy.this.restoreStateImpl();
            }
        }).run();
    }

    protected void restoreStateImpl() {
        RbSuSynchronizationHelper.getRbSUsMgmtDBGiantLock();
        NetworkResourceConfiguration nrConfig = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List mos = nrConfig.retrieveManagedObjects(RbRegisteredSuEntry.class, "*");
        List<RbSU> sus = this.bsEq.getManagedSUs();
        block0: for (RbRegisteredSuEntry suInstance : mos) {
            if (null == suInstance.getRbSuRegistrationState()) continue;
            String instanceMacAddress = MacAddress.fromOctetString((String)suInstance.getRbSuMacAddr()).toSimpleString();
            for (RbSU su : sus) {
                if (su.getState() != -1 || !su.getMacAddress().equals(instanceMacAddress)) continue;
                this.ddCallback.setEquipmentState(null, (Equipment)su, suInstance.isConnected() ? 0 : 1);
                continue block0;
            }
        }
    }

    protected final <M extends ManagedObject> void reprocessMOs(String nrConfigName, Class<M> moClass) {
        NetworkResourceConfiguration nrConfig = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration(nrConfigName);
        ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
        List mos = nrConfig.retrieveManagedObjects(moClass, "*");
        ArrayList<String> instances = new ArrayList<String>(mos.size());
        for (ManagedObject mo : mos) {
            instances.add(mo.getRowKey());
        }
        if (!instances.isEmpty()) {
            configHelper.processConfigurationChanges(nrConfig, moClass, instances);
        }
    }

    protected void syncStepSetEquipmentUp() {
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                Event event = RbBaseStationSynchronizationStrategy.this.ddCallback.setEquipmentState(null, (Equipment)RbBaseStationSynchronizationStrategy.this.bsEq, 0);
                if (event != null) {
                    EventFacade.emitEvent((Event)event);
                }
                HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
                HashMap<Integer, Integer> treeChangingProperties = new HashMap<Integer, Integer>();
                treeChangingProperties.put(1, RbBaseStationSynchronizationStrategy.this.bsEq.getSwitchingMode());
                treeChangingProperties.put(0, (Integer)RbBaseStationSynchronizationStrategy.this.bsEq.getSoftwareVersion());
                equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_STRUCTURE_CHANGED, treeChangingProperties);
                equipmentProperties.put(EquipmentNotifyerEventTypes.LABEL_CRITICAL_MESSAGE_CHANGED, "");
                RbBaseStationSynchronizationStrategy.this.notifyClient(equipmentProperties);
                logger.debug((Object)("[" + RbBaseStationSynchronizationStrategy.this.bsEq.getIPAddress() + "] Setting equipment state: UP"));
            }
        }).run();
    }

    void notifyClient(HashMap<EquipmentNotifyerEventTypes, Object> messageObject) {
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("listener_discriminator", this.bsEq.getEUID());
        PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/EquipmentObserverTopic", messageObject, messageProperties);
    }

    private boolean syncStepCanProcessMissingTraps(long startTrapSeqNo, long lastTrapSeqNo) {
        return lastTrapSeqNo - startTrapSeqNo < 1000L;
    }

    private void saveOrUpdateEquipment(final Equipment bsEquipment) {
        try {
            new CallableDatastoreDecorator((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    Datastore.session().saveOrUpdate((Object)bsEquipment);
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private RbBaseStationEquipment refreshBsEquipment(final long bsId) {
        try {
            return (RbBaseStationEquipment)((Object)new CallableDatastoreDecorator((Callable)new Callable<RbBaseStationEquipment>(){

                @Override
                public RbBaseStationEquipment call() {
                    return (RbBaseStationEquipment)((Object)Datastore.session().get(RbBaseStationEquipment.class, (Serializable)new Long(bsId)));
                }
            }).call());
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    protected abstract Map<Class<? extends ManagedObject>, Method> getMOChangeProcessors();

    public void processSUConfigurationChanged(ConfigurationChangedEvent evt, NetworkResourceConfiguration nrConfig) {
        long time = System.currentTimeMillis();
        long time0 = System.currentTimeMillis();
        RbSuSynchronizationHelper.getRbSUsMgmtDBGiantLock();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] processSUConfigChanged - acquired LOCK  time: " + (System.currentTimeMillis() - time0) + " millis"));
        }
        long time1 = System.currentTimeMillis();
        List<RbSU> sus = this.retrieveSUsToDisconnect();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] processSUConfigChanged - retrieveSUsToDisconnect() " + sus.size() + "  time: " + (System.currentTimeMillis() - time1) + " millis"));
        }
        for (RbSU su : sus) {
            this.suHelper.disconnectSU(su);
            Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, -1);
            if (event == null) continue;
            EventFacade.emitEvent((Event)event);
        }
        long time2 = System.currentTimeMillis();
        Map moMap = nrConfig.retrieveManagedObjects(evt.getMoClass(), evt.getInstances());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] processSUConfigChanged - retrieveSuEntryMap() " + moMap.size() + "  time: " + (System.currentTimeMillis() - time2) + " millis"));
        }
        long time3 = System.currentTimeMillis();
        Map<String, RbSU> globalSUs = RbBaseStationSynchronizationStrategy.findGlobalSUs(moMap, this.bsEq.getEUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] processSUConfigChanged - findGlobalSUs()  time: " + (System.currentTimeMillis() - time3) + " millis"));
        }
        for (String instance : moMap.keySet()) {
            RbRegisteredSuEntry entry = (RbRegisteredSuEntry)((Object)moMap.get(instance));
            RbSU su = globalSUs.get(MacAddress.fromOctetString((String)instance).toSimpleString());
            if (null != entry && MOUtils.hasNullAnnotatedAttributes((Equipment)this.bsEq, (ManagedObject)entry, (Class[])RB_STATE_ANNOTATIONS)) {
                logger.debug((Object)("Processing unknown state su #" + instance));
                this.processRbRegisteredSuEntryChangeUnknownState(instance, entry, su);
                continue;
            }
            this.processRbRegisteredSuEntryChange(instance, entry, su);
        }
        this.commitNewEquipment();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] processSUConfigChanged - finished in: " + (System.currentTimeMillis() - time) + " millis"));
        }
    }

    private List<RbSU> retrieveSUsToDisconnect() {
        StringBuffer suQueryStr = new StringBuffer("select su from " + RbSU.class.getName() + " as su");
        suQueryStr.append(" where su.managerBS.id = :managerBS");
        suQueryStr.append(" and not exists (select entry from " + RbRegisteredSuEntry.class.getName() + " as entry" + " where entry.NRConfiguration.id = :nrConfigId" + " and su.macAddress = entry.rbSuSimpleMacAddr)");
        Long nrConfigId = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").getId();
        Query suQuery = Datastore.session().createQuery(suQueryStr.toString()).setLong("managerBS", this.bsEq.getId()).setLong("nrConfigId", nrConfigId.longValue());
        return suQuery.list();
    }

    private Map<String, RbRegisteredSuEntry> retrieveSuEntryMap(Collection<String> suInstances) {
        HashMap<String, RbRegisteredSuEntry> ret = new HashMap<String, RbRegisteredSuEntry>();
        Long nrConfigId = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").getId();
        ArrayList<String> macAddresses = new ArrayList<String>(IN_QUERY_MAX_SIZE);
        Iterator<String> it = suInstances.iterator();
        while (it.hasNext()) {
            String instance = it.next();
            if (null != instance) {
                macAddresses.add(instance);
            }
            if (IN_QUERY_MAX_SIZE != macAddresses.size() && (it.hasNext() || macAddresses.isEmpty())) continue;
            StringBuffer queryStr = new StringBuffer("from " + RbRegisteredSuEntry.class.getName() + " as entry" + " where entry.NRConfiguration.id = :nrConfigId and entry.rbSuMacAddr in ('");
            Iterator macIt = macAddresses.iterator();
            queryStr.append((String)macIt.next());
            queryStr.append("'");
            while (macIt.hasNext()) {
                queryStr.append(",'");
                queryStr.append((String)macIt.next());
                queryStr.append("'");
            }
            queryStr.append(')');
            long t = System.currentTimeMillis();
            Query query = Datastore.session().createQuery(queryStr.toString()).setLong("nrConfigId", nrConfigId.longValue());
            List suEntries = query.list();
            for (RbRegisteredSuEntry suEntry : suEntries) {
                ret.put(suEntry.getRowKey(), suEntry);
            }
            macAddresses.clear();
        }
        return ret;
    }

    private static Map<String, RbSU> findGlobalSUs(Map<String, RbRegisteredSuEntry> suEntries, String bsIp) {
        HashMap<String, RbSU> ret = new HashMap<String, RbSU>();
        ArrayList<String> macAddresses = new ArrayList<String>(IN_QUERY_MAX_SIZE);
        Iterator<RbRegisteredSuEntry> it = suEntries.values().iterator();
        while (it.hasNext()) {
            RbRegisteredSuEntry entry = it.next();
            if (null != entry) {
                macAddresses.add(entry.getRbSuSimpleMacAddr());
            }
            if (IN_QUERY_MAX_SIZE != macAddresses.size() && (it.hasNext() || macAddresses.isEmpty())) continue;
            Iterator macIt = macAddresses.iterator();
            StringBuffer queryStr = new StringBuffer("from " + RbSU.class.getName() + " where macAddress in ('");
            queryStr.append((String)macIt.next());
            queryStr.append("'");
            while (macIt.hasNext()) {
                queryStr.append(",'");
                queryStr.append((String)macIt.next());
                queryStr.append("'");
            }
            queryStr.append(')');
            long t = System.currentTimeMillis();
            Query query = Datastore.session().createQuery(queryStr.toString());
            List sus = query.list();
            for (RbSU su : sus) {
                ret.put(su.getMacAddress(), su);
            }
            macAddresses.clear();
        }
        return ret;
    }

    public boolean processServiceProfilesConfigurationChanged(final ConfigurationChangedEvent evt, NetworkResourceConfiguration nrConfig) {
        if (null == Datastore.getFromTransactionContext((String)"RbServiceProfilesConfigurationChanged")) {
            Datastore.addOperationBeforeTransaction((Runnable)new Runnable(){

                public void run() {
                    long time = System.currentTimeMillis();
                    RbServiceProfiles serviceProfiles = new RbServiceProfiles(RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS"));
                    RbServiceSynchronizationHelper.updateServiceProfilesComplexKeys(serviceProfiles);
                    List serviceConfigEntries = RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbServiceConfigEntry.class, "*");
                    List serviceTemplateConfigEntries = serviceProfiles.getServiceTemplateConfigTable().getEntries();
                    RbServiceSynchronizationHelper.updateServiceProfileName(serviceConfigEntries, serviceTemplateConfigEntries, evt.getInstances());
                    logger.debug((Object)("SynchronizationProcess - syncServiceProfiles: retrieve mos and update keys in: " + (System.currentTimeMillis() - time) + " millis"));
                }
            });
            Datastore.addToTransactionContext((String)"RbServiceProfilesConfigurationChanged", (Object)Boolean.TRUE);
            return true;
        }
        return false;
    }

    public void processSubscribersConfigurationChanged(final ConfigurationChangedEvent evt, NetworkResourceConfiguration nrConfig) {
        if (this.bsEq.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS && null == Datastore.getFromTransactionContext((String)"RbSubscribersConfigurationChanged")) {
            Datastore.addOperationBeforeTransaction((Runnable)new Runnable(){

                public void run() {
                    long time = System.currentTimeMillis();
                    List subscriberEntries = RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbSubscriberEntry.class, "*");
                    RbServiceSynchronizationHelper.updateComplexKeysAndAdminStatus(subscriberEntries);
                    List serviceConfigEntries = RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbServiceConfigEntry.class, "*");
                    RbServiceSynchronizationHelper.updateSubscriberNames(serviceConfigEntries, subscriberEntries, evt.getInstances());
                    logger.info((Object)("SynchronizationProcess - syncSubscribers: retrieved mos and compute keys in: " + (System.currentTimeMillis() - time) + " millis"));
                }
            });
            Datastore.addToTransactionContext((String)"RbSubscribersConfigurationChanged", (Object)Boolean.TRUE);
        }
    }

    private void processConfigFile(final ConfigFile configFile) {
        long totalTime = System.currentTimeMillis();
        try {
            final RbConfigFileMOAccessSession cfgFileAccess = new RbConfigFileMOAccessSession(configFile);
            final ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
            final ArrayList moClasses = new ArrayList();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                    RbBaseStationEquipmentConfiguration currentConfig = (RbBaseStationEquipmentConfiguration)RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration();
                    NetworkResourceConfiguration primaryNRConfig = currentConfig.findPrimaryNetworkResourceConfiguration();
                    if (configFile.getResource("SU_Sync.res") != null) {
                        moClasses.add(RbRegisteredSuEntry.class);
                    } else {
                        moClasses.addAll(primaryNRConfig.getManagedObjectClasses());
                    }
                    for (Class moClazz : moClasses) {
                        RbBaseStationSynchronizationStrategy.this.refreshBaseStation();
                        Class moClass = moClazz;
                        NetworkResourceConfiguration nrConfig = RbBaseStationSynchronizationStrategy.this.bsEq.findCurrentConfiguration().findPrimaryNetworkResourceConfiguration();
                        try {
                            configHelper.retrieveCurrentConfiguration((MOAccessSession)cfgFileAccess, nrConfig, moClass, "*", true);
                            RbBaseStationSynchronizationStrategy.this.afterResetState();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    configHelper.reprocessConfiguration((Equipment)RbBaseStationSynchronizationStrategy.this.bsEq);
                }
            }).run();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] SynchronizationProcess - processConfigFile total time: " + (System.currentTimeMillis() - totalTime) + " millis."));
    }

    protected static void resetState(Equipment eq) {
        for (NetworkResourceConfiguration nrConfig : eq.findCurrentConfiguration().getNetworkResources().values()) {
            RbBaseStationSynchronizationStrategy.resetState(nrConfig);
        }
    }

    protected static void resetState(Equipment eq, String nrConfigName) {
        NetworkResourceConfiguration nrConfig = (NetworkResourceConfiguration)eq.findCurrentConfiguration().getNetworkResources().get(nrConfigName);
        if (null != nrConfig) {
            RbBaseStationSynchronizationStrategy.resetState(nrConfig);
        }
    }

    protected static void resetState(NetworkResourceConfiguration nrConfig) {
        for (Class moClass : nrConfig.getManagedObjectClasses()) {
            List mos = nrConfig.retrieveManagedObjects(moClass, "*");
            for (ManagedObject mo : mos) {
                MOUtils.resetMO((ManagedObject)mo, (int)6);
            }
            nrConfig.persistManagedObjects(moClass, "*", mos, 6, null);
        }
    }

    private void afterResetState() {
        List serviceMOs = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbServiceConfigEntry.class, "*");
        for (RbServiceConfigEntry serviceEntry : serviceMOs) {
            serviceEntry.setRbServiceOperStatus(2);
        }
    }

    public void baseStationDelete() {
        if (PlatformConfiguration.isLocalPlatform()) {
            for (RbSU su : this.bsEq.getManagedSUs()) {
                Datastore.session().delete((Object)su);
            }
        }
        delayedTrapsMap.remove(this.bsEq.getId());
        this.signalBaseStationDelete();
    }

    protected abstract boolean isValidSysObjectID(String var1);

    protected abstract void signalBaseStationDelete();

    public abstract void disconnectAllEquipment(Event var1);

    public void disconnectAllSUs(Event generatedBy) {
        List<RbSU> sus = this.bsEq.getManagedSUs();
        for (RbSU su : new ArrayList<RbSU>(sus)) {
            this.suHelper.disconnectSU(su);
            Event event = this.ddCallback.setEquipmentState(generatedBy, (Equipment)su, -1);
            if (event == null) continue;
            EventFacade.emitEvent((Event)event);
        }
    }

    public void disconnectAllServices() {
    }

    MOAccessSession createMOAccessSession() throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)this.bsEq.getManagementInterface(), null);
    }

    MOAccessSession createMOAccessSessionForConfigFileCreation() throws MediationException {
        SNMPManagementInterface smi = this.bsEq.getManagementInterface();
        SNMPManagementInterface constantSmi = new SNMPManagementInterface(smi.getIp(), smi.getPort(), smi.getReadCommunity(), smi.getWriteCommunity(), 1, 20000L);
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)constantSmi, null);
    }

    void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    protected final void refreshBaseStation() {
        this.bsEq = (RbBaseStationEquipment)((Object)Datastore.session().get(RbBaseStationEquipment.class, (Serializable)new Long(this.bsEq.getId())));
    }

    void refreshServiceTemplateMO(String instanceID) {
        this.refreshMOAsynch(null, null, instanceID, (byte)4, null, null, null);
    }

    void refreshForwardingRuleMO(String instanceID) {
        this.refreshMOAsynch(null, null, instanceID, (byte)5, null, null, null);
    }

    void refreshL2FilteringRuleMO(String instanceID) {
        this.refreshMOAsynch(null, null, instanceID, (byte)6, null, null, null);
    }

    void refreshL3L4FilteringRuleMO(String instanceID) {
        this.refreshMOAsynch(null, null, instanceID, (byte)7, null, null, null);
    }

    void refreshServiceMO(String rbServiceIdx, String serviceName, String rbSubscriberIdx, String rbSuMacAddr) {
        this.refreshMOAsynch(null, null, rbServiceIdx, (byte)3, serviceName, rbSubscriberIdx, rbSuMacAddr);
    }

    <T extends ManagedObject> void refreshMO(String nrConfigName, Class<T> moClass, String instanceQuery) {
        this.refreshMOAsynch(nrConfigName, moClass, instanceQuery, (byte)0, null, null, null);
    }

    <T extends ManagedObject> void refreshMOWithDelay(String nrConfigName, Class<T> moClass, String instanceQuery) throws MediationException {
        this.refreshMOAsynch(nrConfigName, moClass, instanceQuery, (byte)1, null, null, null);
    }

    <T extends ManagedObject> void refreshMOWOAccessSession(String nrConfigName, Class<T> moClass, String instanceQuery) throws MediationException {
        this.refreshMOAsynch(nrConfigName, moClass, instanceQuery, (byte)2, null, null, null);
    }

    public <T extends ManagedObject> void refreshMOAsynch(String nrConfigName, Class<T> moClass, String instanceQuery, byte type, String svcParam1, String svcParam2, String svcParam3) {
        RbMORefreshRunnable runnable = new RbMORefreshRunnable(this.bsEq.getId(), nrConfigName, moClass, instanceQuery, type, svcParam1, svcParam2, svcParam3);
        agentEventProcessorManager.addMORefresh((MORefreshRunnable)runnable);
    }

    @MOChangeProcessor(moClass=RbRegisteredSuEntry.class)
    public void processRbRegisteredSuEntryChangeUnknownState(String instanceID, RbRegisteredSuEntry suInstance, RbSU su) {
        if (su == null) {
            su = this.suHelper.createUnknownStateSU(suInstance);
            ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)su);
            this.newSUCreated(su);
            this.suHelper.connectSU(su, 0);
            Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, 1);
            if (event != null) {
                EventFacade.emitEvent((Event)event);
            }
            su.setVGpresent(false);
            su.setNGpresent(false);
        } else if (su.getManagerBS() == null || this.suHelper.isConnected(su)) {
            this.suHelper.connectSU(su, 0);
            Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, 1);
            if (event != null) {
                EventFacade.emitEvent((Event)event);
            }
        }
    }

    public void processRbRegisteredSuEntryChange(String instanceID, RbRegisteredSuEntry suInstance, RbSU su) {
        if (suInstance == null) {
            if (su != null && this.suHelper.isConnected(su)) {
                this.suHelper.disconnectSU(su);
                Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, -1);
                if (null != event) {
                    EventFacade.emitEvent((Event)event);
                }
                su.setVGpresent(false);
                su.setNGpresent(false);
            }
            return;
        }
        if (su != null) {
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] Found su: " + su.getId()));
        }
        if (su == null) {
            Event event2;
            su = this.suHelper.createSU(suInstance);
            ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)su);
            this.newSUCreated(su);
            this.suHelper.updateSU(su, suInstance);
            this.suHelper.connectSU(su, suInstance.getRbAuId());
            Event event = this.ddCallback.equipmentCreate(null, (Equipment)su);
            if (event != null) {
                EventFacade.emitEvent((Event)event);
            }
            if ((event2 = this.ddCallback.setEquipmentState(null, (Equipment)su, suInstance.isConnected() ? 0 : 1)) != null) {
                EventFacade.emitEvent((Event)event2);
            }
            if (suInstance.isConnected()) {
                this.syncSUStateAfterRegistration(su);
            }
        } else if (suInstance.isConnected()) {
            this.suHelper.updateSU(su, suInstance);
            boolean suNewlyRegistered = false;
            if (!this.suHelper.isConnected(su)) {
                this.suHelper.connectSU(su, suInstance.getRbAuId());
            } else {
                suNewlyRegistered = true;
            }
            suNewlyRegistered |= su.getState() != 0;
            Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, 0);
            if (event != null) {
                EventFacade.emitEvent((Event)event);
            }
            if (suNewlyRegistered) {
                this.syncSUStateAfterRegistration(su);
            }
        } else {
            this.suHelper.updateSU(su, suInstance);
            Event event = this.ddCallback.setEquipmentState(null, (Equipment)su, 1);
            if (event != null) {
                EventFacade.emitEvent((Event)event);
            }
        }
    }

    private void syncSUStateAfterRegistration(RbSU su) {
        RbMORefreshRunnable runnable = new RbMORefreshRunnable(su.getId(), "SU", RbSuSubDevicesEntry.class, "*", 0, null, null, null);
        agentEventProcessorManager.addMORefresh((MORefreshRunnable)runnable);
    }

    private void newSUCreated(RbSU su) {
        if (this.newSUs == null) {
            this.newSUs = new ArrayList<RbSU>();
        }
        su.setLicenseID(Licensable.UNLICENSED);
        this.newSUs.add(su);
    }

    private void commitNewEquipment() {
        if (this.newSUs != null) {
            LicenseHelper.licenseEntities(this.newSUs, (String)RbSU.class.getName());
            this.newSUs = null;
        }
    }

    @MOChangeProcessor(moClass=RbQoSProfileConfigEntry.class)
    public void processRbQosProfileConfigEntryChange(String instanceID, RbQoSProfileConfigEntry qosProfile) {
        if (qosProfile == null) {
            return;
        }
        RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
        try {
            helper.synchronizeServiceProfilesFull();
        }
        catch (ConfigurationNotSynchronizedException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    @MOChangeProcessor(moClass=RbPolicyRuleConfigEntry.class)
    public void procesRbPolicyRuleConfigEntryChange(String instanceID, RbPolicyRuleConfigEntry policyRule) {
        if (policyRule == null) {
            return;
        }
        RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
        try {
            helper.synchronizeServiceProfilesFull();
        }
        catch (ConfigurationNotSynchronizedException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    @MOChangeProcessor(moClass=RbBSPFServersEntry.class)
    public void procesRbPFServerConfigEntryChange(String instanceID, RbBSPFServersEntry pfServer) {
        if (pfServer != null) {
            RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
            try {
                helper.synchronizeServiceProfilesFull();
            }
            catch (ConfigurationNotSynchronizedException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    @MOChangeProcessor(moClass=RbForwardingRuleConfigEntry.class)
    public void processRbForwardingRuleConfigEntryChange(String instanceID, RbForwardingRuleConfigEntry forwardingRule) {
        if (forwardingRule == null) {
            return;
        }
        RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
        try {
            helper.synchronizeServiceProfilesFull();
        }
        catch (ConfigurationNotSynchronizedException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    @MOChangeProcessor(moClass=RbServiceTemplateConfigEntry.class)
    public void processRbServiceTemplateConfigEntryChange(String instanceID, RbServiceTemplateConfigEntry serviceTemplate) {
        if (serviceTemplate == null) {
            return;
        }
        RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
        try {
            helper.synchronizeServiceProfilesFull();
        }
        catch (ConfigurationNotSynchronizedException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    @MOChangeProcessor(moClass=RbVoiceDomainsEntry.class)
    public void procesRbVoiceDomainConfigEntryChange(String instanceID, RbVoiceDomainsEntry voiceDomain) {
        if (voiceDomain != null) {
            RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
            try {
                helper.synchronizeServiceProfilesFull();
            }
            catch (ConfigurationNotSynchronizedException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    @MOChangeProcessor(moClass=RbServiceGroupEntry.class)
    public void procesRbServiceGroupConfigEntryChange(String instanceID, RbServiceGroupEntry serviceGroup) {
        if (serviceGroup != null) {
            RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
            try {
                helper.synchronizeServiceProfilesFull();
            }
            catch (ConfigurationNotSynchronizedException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    @MOChangeProcessor(moClass=RbSubscriberEntry.class)
    public void processRbSubscriberEntryChange(String instanceID, RbSubscriberEntry subscriberInstance) {
        if (this.bsEq.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS && subscriberInstance != null) {
            RbServiceSynchronizationHelper helper = new RbServiceSynchronizationHelper(this.bsEq);
            helper.synchronizeSubscribersFull();
        }
    }

    @MOChangeProcessor(moClass=RbServiceConfigEntry.class)
    public void processRbServiceEntryChange(String instanceID, RbServiceConfigEntry serviceInstance) {
        List subscriberEntries;
        Long subscriberIdx;
        if (serviceInstance != null && null != (subscriberIdx = serviceInstance.getRbSubscriberIdx()) && subscriberIdx > 0L && !(subscriberEntries = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbSubscriberEntry.class, String.valueOf(subscriberIdx))).isEmpty()) {
            serviceInstance.setRbSubscriberID(((RbSubscriberEntry)((Object)subscriberEntries.get(0))).getRbSubscriberID());
        }
    }

    @MOChangeProcessor(moClass=RbBsRadioParameters.class)
    public void procesRbBsRadioParametersConfigEntryChange(String instanceID, RbBsRadioParameters radioParameters) {
        if (radioParameters != null) {
            this.bsEq.setCellID(OctetString.toDottedDecimalForm((String)radioParameters.getRbBSConfiguredCellId()));
            this.bsEq.setOperatorID(OctetString.toDottedDecimalForm((String)radioParameters.getRbBSConfiguredOperatorId()));
            String rbLocalClockDateAndTime = radioParameters.getRbLocalClockDateAndTime();
            if (new DefaultVersion("3.5.1.4").isOlderOrEqualWith(this.bsEq.getSoftwareVersion()) && RbVersions.V_4_0.isNewerThan(this.bsEq.getSoftwareVersion())) {
                if (rbLocalClockDateAndTime != null && rbLocalClockDateAndTime.trim().length() > 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    try {
                        Date deviceDate = formatter.parse(rbLocalClockDateAndTime);
                        this.bsEq.setTimeDiffBetweenNmsAndBs(new Date().getTime() - deviceDate.getTime());
                    }
                    catch (ParseException parseEx) {
                        this.bsEq.setTimeDiffBetweenNmsAndBs(null);
                        logger.debug((Object)parseEx, (Throwable)parseEx);
                    }
                } else {
                    this.bsEq.setTimeDiffBetweenNmsAndBs(null);
                }
            }
        }
    }

    @MOChangeProcessor(moClass=RbBSSwitchingModeParameters.class)
    public void procesRbBSProvisioningModeParameters(String instanceID, RbBSSwitchingModeParameters provisioningModeParameters) {
        if (provisioningModeParameters == null) {
            this.bsEq.setSwitchingMode(null);
        } else {
            this.bsEq.setSwitchingMode(provisioningModeParameters.getRbCrtServiceSwitchingMode());
        }
    }

    @MOChangeProcessor(moClass=RbChainConfig.class)
    public void processRbChainConfig(String instanceID, RbChainConfig chainConfigInstance) {
        this.gpsChainHelper.processRbChainConfig(chainConfigInstance);
    }

    @MOChangeProcessor(moClass=RbGPSInfo.class)
    public void processRbGPSInfo(String instanceID, RbGPSInfo gpsInfo) {
        this.gpsChainHelper.processRbGPSInfo(gpsInfo);
    }

    @MOChangeProcessor(moClass=RbBSClockConfigParameters.class)
    public void processRbBSClockConfigParameters(String instanceID, RbBSClockConfigParameters bsClockParameters) {
        this.gpsChainHelper.processRbBSClockConfigParameters(bsClockParameters);
    }

    @MOChangeProcessor(moClass=RbSuSubDevicesEntry.class)
    public void processRbSuSubDevicesEntryChange(String instanceID, RbSuSubDevicesEntry entry) {
        logger.debug((Object)"SynchronizationProcess - @MOChangeProcessor( moClass = RbSuSubDevicesEntry.class )");
        String suMacAddress = MacAddress.fromOctetString((String)instanceID).toSimpleString();
        RbSU su = this.suHelper.findSU(suMacAddress);
        if (entry == null) {
            return;
        }
        if (entry.getRbSubDeviceType() == 4 || entry.getRbSubDeviceType() == 6 || entry.getRbSubDeviceType() == 7 || entry.getRbSubDeviceType() == 12 || entry.getRbSubDeviceType() == 13 || entry.getRbSubDeviceType() == 14 || entry.getRbSubDeviceType() == 15 || entry.getRbSubDeviceType() == 16 || entry.getRbSubDeviceType() == 17 || entry.getRbSubDeviceType() == 18) {
            su.setVGpresent(true);
        } else {
            su.setVGpresent(false);
        }
        if (entry.getRbSubDeviceType() == 11) {
            su.setNGpresent(true);
        } else {
            su.setNGpresent(false);
        }
    }

    @MOChangeProcessor(moClass=RbIfInfoEntry.class)
    public void processRbIfInfoEntryChange(String instanceID, RbIfInfoEntry entry) {
        logger.debug((Object)"SynchronizationProcess - @MOChangeProcessor( moClass = RbIfInfoEntry.class )");
        if (entry == null) {
            return;
        }
        if (entry.getIfIndex().equals(2)) {
            this.bsEq.setMngmntIfMAC(entry.getIfPhysAddress());
        }
    }

    @MOChangeProcessor(moClass=RbAuthorizedManagersEntry.class)
    public void processRbAuthorizedManagersEntry(String instanceID, RbAuthorizedManagersEntry entry) {
        logger.debug((Object)"SynchronizationProcess - @MOChangeProcessor( moClass = RbAuthorizedManagersEntry.class )");
        List authorizedManagersEntries = this.bsEq.findCurrentConfiguration().findNetworkResourceConfiguration("BS").retrieveManagedObjects(RbAuthorizedManagersEntry.class, "*");
        List<String> systemIPAddresses = RbBaseStationSynchronizationStrategy.getSystemIPAddresses();
        try {
            for (RbAuthorizedManagersEntry authorizedManagersEntry : authorizedManagersEntries) {
                if (authorizedManagersEntry.getAuthMngrIpAddr().equals(entry.getAuthMngrIpAddr())) {
                    authorizedManagersEntry.setAuthMngrTrapEnable(entry.getAuthMngrTrapEnable());
                }
                for (String ipAddress : systemIPAddresses) {
                    boolean sendsTraps;
                    if (!ipAddress.equals(authorizedManagersEntry.getAuthMngrIpAddr()) || !(sendsTraps = Integer.valueOf(1).equals(authorizedManagersEntry.getAuthMngrTrapEnable()))) continue;
                    this.bsEq.setSendsTraps(true);
                    return;
                }
            }
            this.bsEq.setSendsTraps(false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    @MOChangeProcessor(moClass=RbTrapConfigEntry.class)
    public void processRbTrapConfigEntry(String instanceID, RbTrapConfigEntry entry) {
        logger.debug((Object)"SynchronizationProcess - @MOChangeProcessor( moClass = RbTrapConfigEntry.class )");
        if (null != entry) {
            RbEntityEvents.updateBsTrapSendingInfo(this.bsEq, entry);
        } else {
            RbEntityEvents.clearBsTrapSendingInfo(this.bsEq);
        }
    }

    void setRbBaseStationTime(MOAccessSession access) throws MediationException {
        RbBsRadioParameters radioParams = (RbBsRadioParameters)((Object)access.fetchObject(null, RbBsRadioParameters.class, new String[]{"rbLocalClockDateAndTime"}, "*").get(0));
        if (radioParams != null) {
            String rbLocalClockDateAndTime = radioParams.getRbLocalClockDateAndTime();
            if (rbLocalClockDateAndTime != null && rbLocalClockDateAndTime.trim().length() > 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                try {
                    Date deviceDate = formatter.parse(rbLocalClockDateAndTime);
                    this.bsEq.setTimeDiffBetweenNmsAndBs(new Date().getTime() - deviceDate.getTime());
                }
                catch (ParseException parseEx) {
                    this.bsEq.setTimeDiffBetweenNmsAndBs(null);
                    logger.debug((Object)parseEx, (Throwable)parseEx);
                }
            } else {
                this.bsEq.setTimeDiffBetweenNmsAndBs(null);
            }
        }
    }

    private static String getBackupFileName(String ipAddress, String fileName, String fileExtension) {
        StringBuffer file = new StringBuffer(fileName);
        if (null != simulatedEquipmentRange) {
            try {
                long ipAddrLong = new IpAddress(ipAddress).getIpAddress();
                if (ipAddrLong >= simulatedEquipmentRange[0] && ipAddrLong <= simulatedEquipmentRange[1]) {
                    file.append(ipAddress);
                }
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
            }
        }
        file.append(fileExtension);
        return file.toString();
    }

    static {
        try {
            String simulatedEquipmentRangeStr = System.getProperty("com.bwanms.rb.ddi.simulatedEquipmentRange");
            if (null != simulatedEquipmentRangeStr) {
                String[] tokens = simulatedEquipmentRangeStr.split("-");
                if (2 == tokens.length) {
                    IpAddress ipAddrStart = new IpAddress(tokens[0].trim());
                    IpAddress ipAddrEnd = new IpAddress(tokens[1].trim());
                    simulatedEquipmentRange = new long[]{ipAddrStart.getIpAddress(), ipAddrEnd.getIpAddress()};
                    logger.debug((Object)("--- Simulation range is " + ipAddrStart + " - " + ipAddrEnd));
                } else {
                    logger.debug((Object)"--- Simulation range is invalid");
                }
            } else {
                logger.debug((Object)"--- Simulation range not defined");
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
    }
}

