/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentNotifyerEventTypes;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.TreeChangingLabel;
import com.bwanms.model.fault.Event;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.rb.configuration.info.RbConfigSectionFactory;
import com.bwanms.rb.ddi.RbBSIdentity;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbBaseStationSynchStrategyLocal
implements EquipmentSynchronizationStrategy {
    private static final Logger logger = Logger.getLogger(RbBaseStationSynchStrategyLocal.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbBaseStationSynchStrategyLocal.class);
    RbBaseStationEquipment bsEq;
    DDCallbackInterface ddCallback;

    public RbBaseStationSynchStrategyLocal(RbBaseStationEquipment baseStationEquipment, DDCallbackInterface ddCallback) {
        this.bsEq = baseStationEquipment;
        this.ddCallback = ddCallback;
    }

    public void setUnreachable(Event generatedBy) {
        logger.debug((Object)("setUnreachable[ " + this.bsEq.getId() + "]"));
        this.ddCallback.setEquipmentState(generatedBy, (Equipment)this.bsEq, -1);
        HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
        equipmentProperties.put(EquipmentNotifyerEventTypes.LABEL_CRITICAL_MESSAGE_CHANGED, i18n.translateString("BSIsUnreachable"));
        this.notifyClient(equipmentProperties);
    }

    public void processAgentEvent(AgentEvent agentEvent) throws MediationException {
    }

    public void downloadConfiguration() throws MediationException {
        this.retrieveFullConfiguration();
    }

    public boolean emitNmsEvent(AgentEvent agentEvent) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeState() {
        long synchTime = System.currentTimeMillis();
        MOAccessSession access = null;
        try {
            boolean previouslyUp;
            access = this.createMOAccessSession();
            RbBSIdentity identity = null;
            try {
                identity = (RbBSIdentity)access.fetchObject(null, RbBSIdentity.class, null, "*").get(0);
            }
            catch (AgentException e) {
                identity = (RbBSIdentity)access.fetchObject(null, RbBSIdentity.class, new String[]{"systemObjectID"}, "*").get(0);
            }
            if (!this.isValidSysObjectID(identity.getSystemObjectID())) {
                throw new CommunicationException("Invalid sysObjectID found: " + identity.getSystemObjectID());
            }
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] SysObjectID Valid"));
            int bsStateInt = this.bsEq.getState();
            boolean bl = previouslyUp = bsStateInt != -3 && bsStateInt != -1;
            if (identity.getRbSysLastTrapSeqNumber() == null) {
                if (!previouslyUp) {
                    this.syncStepRetrieveVersionInformation(access);
                    this.syncStepSetEquipmentUp();
                }
                return;
            }
            long lastTrapBeforeReset = identity.getRbSysLastTrapSeqNumber();
            long rbTrapSeqNo = identity.getRbTrapSeqNumber() - 1L;
            if (lastTrapBeforeReset != this.bsEq.getTrapSeqNoBeforeReset()) {
                logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Reset detected @ event " + lastTrapBeforeReset + " Found " + (rbTrapSeqNo - lastTrapBeforeReset + 1L) + " missed traps."));
                this.syncStepRetrieveVersionInformation(access);
                this.retrieveFullConfiguration();
                this.bsEq.setTrapSeqNoBeforeReset(lastTrapBeforeReset);
                this.bsEq.setLastReceivedTrapSeqNo(rbTrapSeqNo);
                RbBaseStationSynchStrategyLocal.saveOrUpdateEquipment(this.bsEq);
            } else {
                long startTrapNo = this.bsEq.getLastReceivedTrapSeqNo() + 1L;
                if (rbTrapSeqNo >= startTrapNo) {
                    logger.info((Object)("[" + this.bsEq.getIPAddress() + "] Found " + (rbTrapSeqNo - startTrapNo + 1L) + " missed traps."));
                    this.syncStepRetrieveVersionInformation(access);
                    this.retrieveFullConfiguration();
                    this.bsEq.setLastReceivedTrapSeqNo(rbTrapSeqNo);
                    RbBaseStationSynchStrategyLocal.saveOrUpdateEquipment(this.bsEq);
                } else {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] No missed traps."));
                }
            }
            if (!previouslyUp) {
                this.syncStepSetEquipmentUp();
            }
            logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Sync State finished in " + (System.currentTimeMillis() - synchTime) + " millis"));
        }
        catch (CommunicationException e) {
            this.ddCallback.communicationError((Equipment)this.bsEq);
            throw new RuntimeException(e);
        }
        catch (MediationException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (access != null) {
                this.closeMOAccessSession(access);
            }
        }
    }

    public List<ConfigurationChangedEvent> configurationChanged(ConfigurationChangedEvent evt) throws ConfigurationNotSynchronizedException {
        logger.debug((Object)("Configuration Changed for RbBS " + this.bsEq.getEUID()));
        EquipmentConfiguration config = this.bsEq.findCurrentConfiguration();
        NetworkResourceConfiguration nrConfig = config.findNetworkResourceConfiguration(evt.getNetworkResourceName());
        Method processor = this.getMOChangeProcessors().get(evt.getMoClass());
        if (processor == null) {
            logger.debug((Object)("No Local MOChangeProcessorFound for [" + evt.getMoClass().getName() + "]"));
            if (!RbAuConfigEntry.class.equals((Object)evt.getMoClass())) {
                return null;
            }
        }
        Map moMap = nrConfig.retrieveManagedObjects(evt.getMoClass(), evt.getInstances());
        for (String moInstance : evt.getInstances()) {
            Object mo = moMap.get(moInstance);
            if (null != processor) {
                try {
                    logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] " + evt.getMoClass().getName() + " changed [" + moInstance + "]"));
                    processor.invoke((Object)this, moInstance, mo);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e, (Throwable)e);
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e, (Throwable)e);
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    logger.debug((Object)e.getCause(), e.getCause());
                    throw new RuntimeException(e.getCause());
                }
            }
            if (!(mo instanceof RbAuConfigEntry)) continue;
            RbAuConfigEntry rbAuConfigEntry = (RbAuConfigEntry)((Object)mo);
            HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
            equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_LABEL_CHANGED, new TreeChangingLabel(new String[]{"AU." + moInstance}, RbConfigSectionFactory.getAuLabel(rbAuConfigEntry, rbAuConfigEntry.getRbSlotNumber())));
            if (rbAuConfigEntry.isConnected()) {
                HashMap<Integer, String> treeChangingProperties = new HashMap<Integer, String>();
                treeChangingProperties.put(-rbAuConfigEntry.getRbSlotNumber().intValue(), rbAuConfigEntry.getRuningSwVersion());
                equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_STRUCTURE_CHANGED, treeChangingProperties);
            }
            this.notifyClient(equipmentProperties);
        }
        return null;
    }

    private void retrieveFullConfiguration() throws MediationException {
        long totalTime = System.currentTimeMillis();
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Retrieve configuraion initiated"));
        final List<Class<? extends ManagedObject>> moClasses = this.getFullConfigManagedObjectClasses();
        final ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
        final MOAccessSession access = this.createMOAccessSession();
        try {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbBaseStationSynchStrategyLocal.this.refreshBaseStation();
                    for (Class moClazz : moClasses) {
                        RbBaseStationSynchStrategyLocal.this.refreshBaseStation();
                        Class moClass = moClazz;
                        NetworkResourceConfiguration nrConfig = RbBaseStationSynchStrategyLocal.this.bsEq.findCurrentConfiguration().findPrimaryNetworkResourceConfiguration();
                        try {
                            configHelper.retrieveCurrentConfiguration(access, nrConfig, moClass, "*", true);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }).run();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (null != access) {
                this.closeMOAccessSession(access);
            }
        }
        logger.debug((Object)("[" + this.bsEq.getIPAddress() + "] Configuration retrieved in " + (System.currentTimeMillis() - totalTime) + " millis."));
    }

    public void baseStationDelete() {
        if (PlatformConfiguration.isLocalPlatform()) {
            for (RbSU su : this.bsEq.getManagedSUs()) {
                Datastore.session().delete((Object)su);
            }
        }
        this.signalBaseStationDelete();
    }

    protected abstract List<Class<? extends ManagedObject>> getFullConfigManagedObjectClasses();

    protected abstract boolean isValidSysObjectID(String var1);

    protected abstract void signalBaseStationDelete();

    protected abstract Map<Class<? extends ManagedObject>, Method> getMOChangeProcessors();

    protected abstract void syncStepRetrieveVersionInformationImpl(MOAccessSession var1) throws MediationException;

    private void syncStepRetrieveVersionInformation(final MOAccessSession access) throws MediationException {
        try {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbBaseStationSynchStrategyLocal.this.refreshBaseStation();
                    try {
                        RbBaseStationSynchStrategyLocal.this.syncStepRetrieveVersionInformationImpl(access);
                    }
                    catch (MediationException e) {
                        logger.debug((Object)e, (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    logger.debug((Object)("[" + RbBaseStationSynchStrategyLocal.this.bsEq.getIPAddress() + "] Firmware version: " + RbBaseStationSynchStrategyLocal.this.bsEq.getFirmwareVersion()));
                    Datastore.session().save((Object)RbBaseStationSynchStrategyLocal.this.bsEq);
                }
            }).run();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MediationException) {
                throw (MediationException)e.getCause();
            }
            throw e;
        }
    }

    MOAccessSession createMOAccessSession() throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)this.bsEq.getManagementInterface(), null);
    }

    void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
    }

    protected final void refreshBaseStation() {
        this.bsEq = (RbBaseStationEquipment)((Object)Datastore.session().get(RbBaseStationEquipment.class, (Serializable)new Long(this.bsEq.getId())));
    }

    void notifyClient(HashMap<EquipmentNotifyerEventTypes, Object> messageObject) {
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("listener_discriminator", this.bsEq.getEUID());
        PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/EquipmentObserverTopic", messageObject, messageProperties);
    }

    protected void syncStepSetEquipmentUp() {
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbBaseStationSynchStrategyLocal.this.refreshBaseStation();
                Event event = RbBaseStationSynchStrategyLocal.this.ddCallback.setEquipmentState(null, (Equipment)RbBaseStationSynchStrategyLocal.this.bsEq, 0);
                if (event != null) {
                    EventFacade.emitEvent((Event)event);
                }
                HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
                HashMap<Integer, Integer> treeChangingProperties = new HashMap<Integer, Integer>();
                treeChangingProperties.put(1, RbBaseStationSynchStrategyLocal.this.bsEq.getSwitchingMode());
                treeChangingProperties.put(0, (Integer)RbBaseStationSynchStrategyLocal.this.bsEq.getSoftwareVersion());
                equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_STRUCTURE_CHANGED, treeChangingProperties);
                equipmentProperties.put(EquipmentNotifyerEventTypes.LABEL_CRITICAL_MESSAGE_CHANGED, "");
                RbBaseStationSynchStrategyLocal.this.notifyClient(equipmentProperties);
                logger.debug((Object)("[" + RbBaseStationSynchStrategyLocal.this.bsEq.getIPAddress() + "] Setting equipment state: UP"));
            }
        }).run();
    }

    private static void saveOrUpdateEquipment(final Equipment bsEquipment) {
        try {
            new CallableDatastoreDecorator((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    Datastore.session().saveOrUpdate((Object)bsEquipment);
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }
}

