/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.CutThroughStrategy;
import com.bwanms.model.Equipment;
import com.bwanms.platform.PlatformRuntime;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.model.RbSU;

public class RbBaseStationCutThroughStrategy
implements CutThroughStrategy {
    public void performCutThrough(Equipment equipment) {
        block13: {
            RbBaseStationEquipment bs;
            String ip = "";
            if (equipment instanceof RbBaseStationEquipment) {
                ip = ((RbBaseStationEquipment)equipment).getIPAddress();
            } else if (equipment instanceof RbAU) {
                bs = ((RbAU)equipment).getManagerBS();
                if (bs != null) {
                    ip = bs.getIPAddress();
                }
            } else if (equipment instanceof RbNPU) {
                bs = ((RbNPU)equipment).getManagerBS();
                if (bs != null) {
                    ip = bs.getIPAddress();
                }
            } else if (equipment instanceof RbSU && (bs = ((RbSU)equipment).getManagerBS()) != null) {
                ip = bs.getIPAddress();
            }
            try {
                PlatformRuntime.OS os = PlatformRuntime.getOS();
                if (os.getID() == PlatformRuntime.OS.WINDOWS.getID()) {
                    os.runShellCmd("start telnet " + ip);
                    break block13;
                }
                if (os.getID() == PlatformRuntime.OS.SOLARIS.getID()) {
                    os.runShellCmd("telnet " + ip);
                    break block13;
                }
                throw new RuntimeException("Unknown operating system - cannot start cut through");
            }
            catch (Exception e) {
                throw new RuntimeException("Cut through failed.", e);
            }
        }
    }

    public void performCutThrough(String ip) {
        block4: {
            try {
                PlatformRuntime.OS os = PlatformRuntime.getOS();
                if (os.getID() == PlatformRuntime.OS.WINDOWS.getID()) {
                    os.runShellCmd("start http://" + ip);
                    break block4;
                }
                if (os.getID() == PlatformRuntime.OS.SOLARIS.getID()) {
                    os.runShellCmd("http:// " + ip);
                    break block4;
                }
                throw new RuntimeException("Unknown operating system - cannot start cut through");
            }
            catch (Exception e) {
                throw new RuntimeException("Cut through failed.", e);
            }
        }
    }
}

