/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.snmp.SNMPTrapV1Processor;
import com.bwanms.meta.snmp.SNMPTrapV1ProcessorUtil;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.persistence.Datastore;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbBaseStationTrapProcessor;
import com.bwanms.rb.ddi.RbEntityEvents;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbAcuConfigurationGroup;
import com.bwanms.rb.mo.RbAuATPCParametersGroup;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuHwComponentsInfoEntry;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbBSPmTmConfigParameters;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbBsEthIfConfigEntry;
import com.bwanms.rb.mo.RbBsIpIfConfigEntry;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbNpuBridgingParameters;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRadiusClientGeneralParameters;
import com.bwanms.rb.mo.RbSlotConfigEntry;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.RbSystemGroup;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbServiceGeneralConfig;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RbBSTrapProcessor
extends RbBaseStationTrapProcessor {
    private static final Logger log = Logger.getLogger(RbBSTrapProcessor.class);
    private static final String TRAP_SOURCE_NPU = "NPU.";
    private static final String TRAP_SOURCE_AU = "AU.";
    private static final String TRAP_SOURCE_ACU = "ACU";
    private static TreeMap<Integer, Method> genericProcessors = SNMPTrapV1ProcessorUtil.getGenericProcessors(RbBSTrapProcessor.class);
    private static TreeMap<Integer, Method> specificProcessors = SNMPTrapV1ProcessorUtil.getSpecificProcessors(RbBSTrapProcessor.class);
    protected RbBaseStationSynchronizationStrategy bsSynch;

    public RbBSTrapProcessor(RbBaseStationSynchronizationStrategy bsSynch) {
        super(bsSynch, genericProcessors, specificProcessors);
        this.bsSynch = bsSynch;
    }

    @SNMPTrapV1Processor(generic=0)
    public void processColdStart(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processWarmStart(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(generic=1)
    public void processWarmStart(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.refreshNPU(trapSource, true);
        } else if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource, true);
        }
    }

    @SNMPTrapV1Processor(generic=2)
    public void processLinkDown(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource, true, true);
        } else {
            super.processLinkDown(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(generic=3)
    public void processLinkUp(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource, true);
        } else {
            super.processLinkUp(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(specific=1)
    public void processRbResetOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbResetOn"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.resetAUState(trapSource);
            this.refreshAU(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.bsSynch.setUnreachable(null);
            Thread.sleep(10000L);
        } else {
            super.processRbResetOn(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(specific=5)
    public void processRbMonitorAccessOff(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        log.debug((Object)("[" + this.bsSynch.bsEq.getEUID() + "]: rbAuMonitorAccessOff"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processRbMonitorAccessOff(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=6)
    public void processRbAuNetworkEntryStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        log.debug((Object)("[" + this.bsSynch.bsEq.getEUID() + "]: rbAuNetworkEntryStatus"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        this.refreshAU(rbTrap.getRbTrapSource(), true, true);
        this.resetAUState(rbTrap.getRbTrapSource());
    }

    @SNMPTrapV1Processor(specific=21)
    public void processRbShelfCardExtractionOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource, true);
        } else if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.refreshNPU(trapSource, true);
        } else if (trapSource.startsWith(TRAP_SOURCE_ACU)) {
            this.refreshACU(trapSource, true);
        }
    }

    @SNMPTrapV1Processor(specific=22)
    public void processRbShelfCardInsertionOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource, true, true);
            this.resetAUState(rbTrap.getRbTrapSource());
        } else if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.refreshNPU(trapSource, true);
        } else if (trapSource.startsWith(TRAP_SOURCE_ACU)) {
            this.refreshACU(trapSource, true);
        }
    }

    @SNMPTrapV1Processor(specific=41)
    public void processRbConfigurationChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbConfigurationChanged"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.Alarm.byteValue());
        super.processRbConfigurationChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=42)
    public void processRbParameterSetFailure(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        log.debug((Object)(this.bsSynch.bsEq.getEUID() + ": rbParameterSetFailure"));
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
    }

    @SNMPTrapV1Processor(specific=63)
    public void processRbODUStatusOn(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbODUStatusFromBS(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=64)
    public void processRbODUStatusOff(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbODUStatusFromBS(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=83)
    public void processRbSuNetworkEntryStatus(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws Exception {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbSuNetworkEntryStatus(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=102)
    public void processRbSwDownloadEnd(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource);
        } else if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.refreshNPU(trapSource);
        } else {
            super.processRbSwDownloadEnd(trapV1, rbTrap);
        }
    }

    @SNMPTrapV1Processor(specific=103)
    public void processRbSwDownloadError(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=104)
    public void processRbSwSwitchFailed(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=105)
    public void processRbSwSwitchSucceded(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.processRbSwDownloadEnd(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=111)
    public void processRbServiceDown(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceStateChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=112)
    public void processRbServiceUp(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceStateChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=113)
    public void processRbServiceChanged(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        RbEntityEvents.emitEntityEventFromTrap(this.bsSynch.bsEq, trapV1, rbTrap, EventCategory.StateChange.byteValue());
        super.processRbServiceChanged(trapV1, rbTrap);
    }

    @SNMPTrapV1Processor(specific=156)
    public void processRbGPSDateAndTime(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String rbUTCClockDateAndTime;
        String TIME_FORMAT = "HH:mm:ss dd/MM/yyyy";
        VarBind utcVarBind = trapV1.getVarBindList().findVarBindByOID("1.3.6.1.4.1.12394.1.2.15.9.0");
        if (utcVarBind != null && (rbUTCClockDateAndTime = (String)utcVarBind.getVariable()) != null && rbUTCClockDateAndTime.trim().length() > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
            try {
                Date deviceDate = formatter.parse(rbUTCClockDateAndTime);
                this.bsSynch.bsEq.setTimeDiffBetweenNmsAndBs(new Date().getTime() - deviceDate.getTime() - trapV1.getTimestamp());
                Datastore.session().saveOrUpdate((Object)this.bsSynch.bsEq);
            }
            catch (ParseException parseEx) {
                log.debug((Object)parseEx, (Throwable)parseEx);
            }
        }
    }

    protected void refreshMOs(SNMPTrapV1AgentEvent trapV1, RbSNMPTrapV1 rbTrap) throws MediationException {
        String trapSource = rbTrap.getRbTrapSource();
        if (trapSource.startsWith(TRAP_SOURCE_AU)) {
            this.refreshAU(trapSource);
            String instanceID = RbBSTrapProcessor.getIdFromSharp(trapSource);
            this.bsSynch.refreshMOWOAccessSession(TRAP_SOURCE_AU + instanceID, RbAuATPCParametersGroup.class, "0");
            this.bsSynch.refreshMOWOAccessSession(TRAP_SOURCE_AU + instanceID, RbAuPhyParametersGroup.class, "0");
            this.bsSynch.refreshMOWOAccessSession(TRAP_SOURCE_AU + instanceID, RbAuMacParametersGroup.class, "0");
            this.bsSynch.refreshMOWOAccessSession(TRAP_SOURCE_AU + instanceID, RbAuMultirateParametersGroup.class, "0");
        } else if (trapSource.startsWith(TRAP_SOURCE_NPU)) {
            this.refreshNPU(trapSource);
            if (new Integer(33).equals(rbTrap.getRbTrapAdditionalInfo())) {
                this.bsSynch.refreshMO("BS", RbBsEthIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbBsIpIfConfigEntry.class, "*");
            } else {
                this.bsSynch.refreshMO("BS", RbBsEthIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbBsIpIfConfigEntry.class, "*");
                this.bsSynch.refreshMO("BS", RbSystemGroup.class, "*");
                this.bsSynch.refreshMO("BS", RbServiceGeneralConfig.class, "*");
                this.bsSynch.refreshMO("BS", RbRadiusClientGeneralParameters.class, "*");
                this.bsSynch.refreshMO("BS", RbBsRadioParameters.class, "0");
                this.bsSynch.refreshMO("BS", RbNpuBridgingParameters.class, "0");
                this.bsSynch.refreshMO("BS", RbDfltServiceTemplateEntry.class, "*");
                if (!this.bsSynch.bsEq.isIPCSSwitchingMode()) {
                    this.bsSynch.refreshMO("BS", RbDfltServiceTemplateEntry.class, "*");
                    this.bsSynch.refreshMO("BS", RbServiceTemplateConfigEntry.class, "*");
                }
            }
        } else if (trapSource.startsWith("AUTH-SERV")) {
            this.bsSynch.refreshMO("BS", RbRadiusAuthServerEntry.class, "*");
        } else if (trapSource.startsWith("ACCT-SERV")) {
            this.bsSynch.refreshMO("BS", RbRadiusAccountServerEntry.class, "*");
        } else {
            super.refreshMOs(trapV1, rbTrap);
        }
    }

    private void refreshAU(String trapSource) throws MediationException {
        this.refreshAU(trapSource, false);
    }

    private void refreshAU(String trapSource, boolean refreshSlot) throws MediationException {
        this.refreshAU(trapSource, refreshSlot, false);
    }

    private void refreshAU(String trapSource, boolean refreshSlot, boolean refreshHWDetails) throws MediationException {
        String instanceID = RbBSTrapProcessor.getIdFromSharp(trapSource);
        this.bsSynch.refreshMO("BS", RbAuConfigEntry.class, instanceID);
        if (refreshSlot) {
            this.bsSynch.refreshMO("BS", RbSlotConfigEntry.class, instanceID);
        }
        if (refreshHWDetails) {
            this.bsSynch.refreshMO("BS", RbAuHwComponentsInfoEntry.class, instanceID);
        }
    }

    private void resetAUState(String trapSource) {
        String auNR = TRAP_SOURCE_AU + RbBSTrapProcessor.getIdFromSharp(trapSource);
        RbBaseStationSynchronizationStrategy.resetState(this.bsSynch.bsEq, auNR);
    }

    private void refreshNPU(String trapSource) throws MediationException {
        this.refreshNPU(trapSource, false);
    }

    private void refreshNPU(String trapSource, boolean refreshSlot) throws MediationException {
        String instanceID = RbBSTrapProcessor.getIdFromSharp(trapSource);
        this.bsSynch.refreshMO("BS", RbNpuConfigEntry.class, instanceID);
        this.bsSynch.refreshMO("BS", RbSwUpgrade.class, "0");
        this.bsSynch.refreshMO("BS", RbBSPmTmConfigParameters.class, "*");
        this.bsSynch.refreshMO("BS", RbBSSwitchingModeParameters.class, "*");
        if (refreshSlot) {
            this.bsSynch.refreshMO("BS", RbSlotConfigEntry.class, instanceID);
        }
    }

    private void refreshACU(String trapSource, boolean refreshSlot) throws MediationException {
        String instanceID = RbBSTrapProcessor.getIdFromSharp(trapSource);
        this.bsSynch.refreshMO("BS", RbAcuConfigurationGroup.class, instanceID);
    }

    protected void refreshChannel(String rbTrapSource) throws MediationException {
        this.bsSynch.refreshMO("BS", RbAuChannelConfigEntry.class, RbBSTrapProcessor.getAuChannelId(rbTrapSource));
    }
}

